/* BAKWORDS.C
 *
 * Back Words
 * Version 2.0
 * Using the DESQview API
 * by Dave Haber
 *
 * 5/23/91
 */
 
#include <stdio.h>
#include <string.h>
#include "dvapi.h"
#include "gfuncts.h"  /* declarations for Greenleaf Functions */

char panel_lib[]="bakwords.plb\x00";  /* name of panel library file */

void main (void)
{
char forwards[75], bakwards[75], exitkey[21], transferkey[30];
int loop, place, found, sent, status, buflng;
uint ver;
ulong panhan, mywin, retwin, retkey;
char *buffer;

ver=api_init();

if(ver<0x200)
    {
    printf("\nThis program requires DESQview version 2.00 or later.\n\n");
    api_exit();
    exit(0);
    }

api_level(0x200);
mywin=win_me();

panhan=pan_new();
status=pan_open(panhan,panel_lib,sizeof panel_lib);

/* open title window */
status=pan_apply(panhan,mywin,"TITLE",5,&retwin,&retkey);
timer(36);

/*open main window */
status=pan_apply(panhan,mywin,"MAIN",4,&retwin,&retkey);

while(1)
	{
    /* initialize string variables */
    memset(forwards, '\0', 75);
    memset(bakwards, '\0', 75);
    memset(exitkey, '\0', 21);
    memset(transferkey, '\0', 30);

    key_read(retkey,&buffer,&buflng);  /* get input from panel */
    status=key_status(retkey);  /* get status from panel */
		
    /* strx() and strxlf() are Greenleaf Functions which perform
       string extraction */

    strxlf(forwards,buffer,74);  /* parse forwards from panel buffer */
    strx(exitkey,buffer,74,12);  /* parse exit key from panel buffer */
    strx(transferkey,buffer,86,28);  /* parse exit key from panel buffer */

    /* click on transfer */
    sent=0;
    if (!strcmp(transferkey,"[F1] Transfer Backwards Text"))
        {
        api_beginc();
        api_pushkey(0x3b00);
        api_endc();
        fld_reset(retwin,4);
        sent=1;
        }
        
    if(!sent)
        {
        /* click on exit or terminate entry with alt-x */
        if (!strcmp(exitkey,"[ALT-X] Exit") || status==0x2d)
            {
            win_free(retwin);
            pan_close(panhan);
            pan_free(panhan);
            api_exit();
            }

        /* copy forwards to bakwards right to left */
        place=0;
        found=0;
        for (loop=73; loop>=0; loop--)
            {
            if((forwards[loop]>'\0' && forwards[loop]!=32) || found)
                {
                bakwards[place]=forwards[loop];
                place++;
                found=1;
                }
            }

        api_sound(600,1);
        api_sound(1200,1);

        fld_swrite(retwin,2,bakwards);  /* write bakwards to output field */
        fld_cursor(retwin,1);  /* reset input field */
        }  /* end if sent */

    }  /* end while 1 */

}
