/*  DVSEARCH.C
 *  by Dave Haber
 *
 *  Parameters: FILENAME to search
 *       (FONES.DAT in current directory is default)
 *
 *  Version 1.0 - 2/8/92
 *       File format header is derived from line 1 of file if line 1
 *       starts with a ?.  The ? is not printed on the screen.
 *
 *  Version 1.1 - 2/11/92
 *       Program rewritten using win swrite(), win_blanks() and win_putc()
 *       instead of direct screen write calls; program no longer needs to
 *       be virtualized.
 *
 *       Program more completely restores window environment if run from
 *       a DOS prompt.
 *
 *  Version 1.2 - 2/12/92
 *       Info Screen function added.  Program now only opens data file
 *       while searching, then closes it again.  Paused search times out
 *       after two minutes, as does paused info display.
 *
 *  Version 1.3 - 3/26/92
 *       Highlights special entries marked with  (02),  (03) or  (04).
 *       Highlights 03 and 04 only show when program started with /h.
 *       Changed ? to  (01).
 *       Will display complete file by entering *.
 *       [F1] accesses HELP.DAT, [F2] through [F9] access F2.DAT through F9.DAT
 *       added default help functions
 *
 *  Version 2.0 - 4/1/92
 *       Added immediate searching
 *       immediate mode startup parameter /i
 *
 *  Version 2.1 - 4/8/92
 *       Added ability to break out of help file with another help key
 *
 *  Version 2.2 - 4/9/92
 *       Added Beep on unsucessful search, /q for quiet
 *       corrected bug in searches containing space
 *       removed default help screens
 *       cleaned up /k keyboard hack parameter
 *
 *  Version 2.3 - 4/14/92
 *       Removed file not found messages
 *       added /x "exit" command parameter
 *
 *  Version 2.4 - 5/19/92
 *       Removed window move restriction
 *       Added TAB abbreviated screen command
 *
 *  Version 2.5 - 5/20/92
 *       Added /s small startup option
 *       added small help screens
 *
 *  Version 2.6 - 5/28/92
 *       fixed bug in search timeout
 *
 *  Version 2.7 - 6/1/92
 *       changed inkey to wait for keystroke rather than poll for it
 *       added api_pause() where polling must occur
 *
 *  Version 3.0 - 6/22/92
 *       added history commands
 *       added [F10] - [F12] info screen ability
 */

 

#include <stdio.h>
#include <ctype.h>
#include "gfuncts.h"  /* declarations for Greenleaf Functions */
#include "string.h"
#include "dvapi.h"

#define REQUIRED 0x200

#define PGMVER "3.0"

/* color definitions*/
#define TEXT 31
#define LOGO 30		/* should have same background as TEXT */
#define DATA 49
#define HILITE1 52
#define HILITE2 63
#define HILITE3 62
#define PROMPT0 79
#define PROMPT1 95
#define HELP 47
#define EMERGENCY 79
#define INFO 113

void clrwin(int);
void inkey(int,int,int);
void info(int);
void qdlogo(void);
void getsmall(void);
void fin(void);

char instr[81];
char savkey0[21], savkey1[21], savkey2[21], savkey3[21], savkey4[21];
char savkey5[21], savkey6[21], savkey7[21], savkey8[21], savkey9[21];
int winattr,frameattr,posrow,poscol,sizerow,sizecol,keyhack,savkey,savpos=0;
int immediate,allowexit,prompt,clear=0,prow,pcol,position=0,small=0;
int tempquiet=0;
ulong me;

main(int argc, char **argv)
{

FILE *infile;
char filename[13], string[81], lcstr[81], fxdstr[81];
char findit[31], headerstr[81];
int loop,apiver,place,key,abort,header,virgin,hilite;
int eatit=0,foundit,quiet,bale;
ulong maintime, interval=12000;

	apiver=api_init();
	if(apiver<REQUIRED)
		{
		printf("\nThis program requires DESQview version %d.%02d or later.\n",
			REQUIRED/256,REQUIRED%256);
		printf("\nIf you don't own DESQview, you don't know what you're missing!");
		printf("\nCall 1-800-354-3222 and say, \"I WANT MY DV!\"\n\n");
		api_exit();
		exit(1);
		}		
	
    hilite=0;
    if(!strcmp(argv[1],"/h") || !strcmp(argv[2],"/h") || !strcmp(argv[3],"/h")
        || !strcmp(argv[4],"/h") || !strcmp(argv[5],"/h"))
        hilite=1;

    keyhack=0;
    if(!strcmp(argv[1],"/k") || !strcmp(argv[2],"/k") || !strcmp(argv[3],"/k")
        || !strcmp(argv[4],"/k") || !strcmp(argv[5],"/k"))
        keyhack=1;

    quiet=0;
    if(!strcmp(argv[1],"/q") || !strcmp(argv[2],"/q") || !strcmp(argv[3],"/q")
        || !strcmp(argv[4],"/q") || !strcmp(argv[5],"/q"))
        quiet=1;

    allowexit=0;
    if(!strcmp(argv[1],"/x") || !strcmp(argv[2],"/x") || !strcmp(argv[3],"/x")
        || !strcmp(argv[4],"/x") || !strcmp(argv[5],"/x"))
        allowexit=1;

    small=0;
    if(!strcmp(argv[1],"/s") || !strcmp(argv[2],"/s") || !strcmp(argv[3],"/s")
        || !strcmp(argv[4],"/s") || !strcmp(argv[5],"/s"))
        small=1;

    immediate=0;
    prompt=PROMPT0;
    if(!strcmp(argv[1],"/i") || !strcmp(argv[2],"/i") || !strcmp(argv[3],"/i")
        || !strcmp(argv[4],"/i") || !strcmp(argv[5],"/i"))
        {
        immediate=1;
        prompt=PROMPT1;
        }

    if(argc<2 || !strcmp(argv[1],"/h") || !strcmp(argv[1],"/k") ||
        !strcmp(argv[1],"/i") || !strcmp(argv[1],"/q") ||
        !strcmp(argv[1],"/x") || !strcmp(argv[1],"/s"))
		strcpy(filename,"FONES.DAT");
	else
		strcpy(filename,argv[1]);
		
    /* fexist() is a Greenleaf Function which checks for the
       existance of a file */

    if(!fexist(filename))
		{
		printf("\n\nCannot find file: %s\n\n",filename);
		api_exit();
		exit(1);
		}

    me=win_me();           /* get win_me() for all future calls */
                           /* that require winhandle */
	maintime=tim_new();
		
	winattr=qry_attr(me);
	frameattr=qry_frattr(me,255);
	qry_size(me,&sizerow,&sizecol);
	qry_position(me,&posrow,&poscol);

	win_resize(me,14,78);
    /* win_move(me,5,1); */
	
    win_disallow(me,ALW_HSIZE);
    win_disallow(me,ALW_VSIZE);
	win_disallow(me,ALW_HSCROLL);
	win_disallow(me,ALW_VSCROLL);
 	app_foreonly(me,0);					/* makes app run in background no */
                                        /* matter what PIF is set to. */
 	win_origin(me,0,0);	
	win_frattr(me,255,TEXT);
	
	key_subfrom(key_me(),KBF_CURSOR);
	
    if(small)
        {
        win_allow(me,ALW_HSIZE);
        win_allow(me,ALW_VSIZE);
        win_resize(me,14,42);
        win_disallow(me,ALW_HSIZE);
        win_disallow(me,ALW_VSIZE);
        win_redraw(me);
        }

    memset(savkey1, '\0',21);
    memset(savkey2, '\0',21);
    memset(savkey3, '\0',21);
    memset(savkey4, '\0',21);
    memset(savkey5, '\0',21);
    memset(savkey6, '\0',21);
    memset(savkey7, '\0',21);
    memset(savkey8, '\0',21);
    memset(savkey9, '\0',21);
    memset(savkey0, '\0',21);

    header=0;
	memset(headerstr,'\0',81);
	infile=fopen(filename,"r");
	fgets(string,80,infile);
    if(string[0]=='')
		{
        /* strxlf() and strxrt() are Greenleaf Functions that
           perform string extraction */
        strxlf(headerstr,string,strlen(string)-1);
		strxrt(headerstr,headerstr,strlen(headerstr)-1);
		header=1;
		}
	else
		{
		strcpy(headerstr,"                       DESQview File Search Utility");
		}
	fclose(infile);
				
    win_attr(me,TEXT);
    win_redraw(me);
	win_erase(me);
	win_cursor(me,0,0);
	win_blanks(me,78);
	win_cursor(me,1,0);
	win_swrite(me,"");
	win_cursor(me,12,0);
	win_swrite(me,"");

	qdlogo();
	
    memset(instr, '\0', 81);
    memset(string,'\0', 81);

    virgin=1;
	while(1)
		{
        if(!immediate || virgin)
            {
            win_attr(me,TEXT);
            win_cursor(me,13,0);
            win_swrite(me," Search for: ");
            win_cursor(me,13,66);
            win_swrite(me,"[F1] Help");
            win_cursor(me,13,13);
            win_attr(me,prompt);
            win_blanks(me,20);
            win_attr(me,TEXT);
            win_blanks(me,32);
            prow=13;
            pcol=13;
            }
		
        inkey(prow,pcol,20);                /* get search string; row,col,max */
		strcpy(findit,instr);
		strlwr(findit);

		if(virgin)									/* print header string on */
			{											/* first go around only */
			win_attr(me,TEXT);
			win_cursor(me,0,1);
			win_swrite(me,headerstr);
			virgin=0;
			}
	
		clrwin(DATA);	

        place=2;
		abort=0;
        bale=0;
		infile=fopen(filename,"r");
		if(header)										/* if file has header */
			fgets(string,80,infile); 				/* eat first line of file */
        foundit=0;
        while(fgets(string,80,infile)!=NULL && !abort)
			{
			strcpy(lcstr,string);
			strlwr(lcstr);
            if((strfind(lcstr,findit)!=-1 || findit[0]=='*') && lcstr[0]!='')
				{
                foundit=1;
                if(place>11)
					{
                    if(!immediate)
                        {
                        win_attr(me,TEXT);
                        win_cursor(me,13,0);
                        win_swrite(me," Hit [PgDn] for More or [ESC]                                                ");
                        tim_addto(maintime,interval);
                        bale=0;
                        while(!bale&&!abort)                          /* loop while no key is pressed */
                            {
                            while(!gfkbhit()&&!abort)
                            /* gfkbhit() is a Greenleaf Function that
                               waits for keyboard activity */
                                {
                                if(!tim_len(maintime))
                                    {
                                    abort=1;
                                    tim_close(maintime);
                                    }
                                api_pause();
                                }
                            if(!abort)
                                key=getkey();
                                /* getkey() is a Greenleaf Function */
                            bale=1;
                            if(key==9)
                                {
                                getsmall();
                                bale=0;
                                }
                            }
                        if(key==27 || clear)
                            {
                            abort=1;
                            position=0;
                            clear=0;
                            }
                        if(key!=27 && !abort)
                            clrwin(DATA);
                        place=2;
                        }
                    else
                        {
                        abort=1;
                        }
                    }
                if(!abort)
					{
                    win_attr(me,DATA);
                    if(string[0]=='')
                        {
                        win_attr(me,HILITE1);
                        eatit=1;
                        }
                    if(string[0]=='')
                        {
                        if(hilite)
                            win_attr(me,HILITE2);
                        eatit=1;
                        }
                    if(string[0]=='')
                        {
                        if(hilite)
                            win_attr(me,HILITE3);
                        eatit=1;
                        }
                    if(eatit)
                        {
                        strxrt(string,string,strlen(string)-1);
                        eatit=0;
                        }
                    win_cursor(me,place,1);
                    win_swrite(me,string);
                    }
				place++;
				}
			}
		
        if(!foundit && !quiet && !tempquiet)
            {
            api_sound(400,2);
            api_sound(200,2);
            }
        if(tempquiet)
            tempquiet=0;
        fclose(infile);
		}                          /* end of main loop */
		
}											/* end of program */



void clrwin(int attrib)
{
int loop,line;

win_attr(me,attrib);
win_cursor(me,2,0);			/* beginning of data window */
win_blanks(me,800);

}


void inkey(int inrow, int incol, int max)
{
int key, wait, finished, escape=0;
char string[81];
int row,col;

if(max>80)
	max=80;

memset(string, '\0', 81);
if(immediate)
    {
    strcpy(string, instr);
    }

win_cursor(me,inrow,incol);
key_addto(key_me(),KBF_CURSOR);

row=inrow;
col=incol;
finished=0;
while(!finished)					/* while Enter not pushed */
	{
    if(savkey)
        {
        key=savkey;
        savkey=0;
        }
    else
        {
        key=getkey();
        /* getkey() is a Greenleaf Function */
        }

    if (keyhack)
        {
        win_cursor(me,0,2);
        win_swrite(me,"        ");
        win_cursor(me,0,2);
        win_printf(me,"%d",key);
        win_cursor(me,row,col);
        }

    if(key==11520)                  /* Alt-X */
        fin();
    if(key==13)                     /* Enter Key */
        {
        finished=1;
        savpos=0;
        }
    if(key==5888)                   /* Alt-I */
        {
        if(immediate)
            {
            immediate=0;
            prompt=PROMPT0;
            finished=1;
            tempquiet=1;
            }
        else
            {
            immediate=1;
            prompt=PROMPT1;
            }
        escape=1;
        }
    if(key==9)
        getsmall();
    if(key==27 || escape==1)                     /* Escape Key */
        {
        escape=0;
        savpos=0;
        memset(instr, '\0', 81);
        memset(string,'\0', 81);
        position=0;
        row=13;
        col=13;
        win_attr(me,TEXT);
        win_cursor(me,13,0);
        win_swrite(me," Search for: ");
        win_cursor(me,13,66);
        win_swrite(me,"[F1] Help");
        win_cursor(me,13,13);
        win_attr(me,prompt);
        win_blanks(me,20);
        win_attr(me,TEXT);
        win_blanks(me,32);
        prow=13;
        pcol=13;
        win_cursor(me,row,col);
        win_hcur(me);
        memset(instr, '\0', 81);
        memset(string,'\0', 81);
        position=0;
        }

    if((key==18432 || key==20480) && !immediate)    /* Up, Down Arrows */
        {
        if(key==18432)
            {
            savpos++;
            if(savpos>10)
                {
                api_sound(1000,1);
                savpos=10;
                }
            }
        if(key==20480)
            {
            savpos--;
            if(savpos<1)
                {
                api_sound(1000,1);
                savpos=1;
                }
            }
        if(savpos==1)
            strcpy(string,savkey0);
        if(savpos==2)
            strcpy(string,savkey1);
        if(savpos==3)
            strcpy(string,savkey2);
        if(savpos==4)
            strcpy(string,savkey3);
        if(savpos==5)
            strcpy(string,savkey4);
        if(savpos==6)
            strcpy(string,savkey5);
        if(savpos==7)
            strcpy(string,savkey6);
        if(savpos==8)
            strcpy(string,savkey7);
        if(savpos==9)
            strcpy(string,savkey8);
        if(savpos==10)
            strcpy(string,savkey9);
        position=strlen(string);
        win_cursor(me,row,incol);
        win_attr(me,prompt);
        win_blanks(me,20);
        win_cursor(me,row,incol);
        win_swrite(me,string);
        col=incol+position;
        win_cursor(me,row,col);
        win_hcur(me);
        }
    if(key==8||key==19200)      /* Backspace or Left Arrow */
        if(position>0)      
            {
            string[position-1]='\0';
            col--;
            position--;
            win_attr(me,prompt);
            win_cursor(me,row,col);
            win_swrite(me," ");
            win_cursor(me,row,col);
            win_hcur(me);
            }
    if(key==15104)                  /* [F1] */
        {
        win_cursor(me,13,77);
        win_hcur(me);
        key_subfrom(key_me(),KBF_CURSOR);
        info(1);
        win_attr(me,prompt);
        win_cursor(me,13,13);
        win_swrite(me,string);
        key_addto(key_me(),KBF_CURSOR);
        win_cursor(me,row,col);
        win_hcur(me);
        }
    if(key==15360)                  /* [F2] */
        {
        win_cursor(me,13,77);
        win_hcur(me);
        key_subfrom(key_me(),KBF_CURSOR);
        info(2);
        win_attr(me,prompt);
        win_cursor(me,13,13);
        win_swrite(me,string);
        key_addto(key_me(),KBF_CURSOR);
        win_cursor(me,row,col);
        win_hcur(me);
        }
    if(key==15616)                  /* [F3] */
        {
        win_cursor(me,13,77);
        win_hcur(me);
        key_subfrom(key_me(),KBF_CURSOR);
        info(3);
        win_attr(me,prompt);
        win_cursor(me,13,13);
        win_swrite(me,string);
        key_addto(key_me(),KBF_CURSOR);
        win_cursor(me,row,col);
        win_hcur(me);
        }
    if(key==15872)                  /* [F4] */
        {
        win_cursor(me,13,77);
        win_hcur(me);
        key_subfrom(key_me(),KBF_CURSOR);
        info(4);
        win_attr(me,prompt);
        win_cursor(me,13,13);
        win_swrite(me,string);
        key_addto(key_me(),KBF_CURSOR);
        win_cursor(me,row,col);
        win_hcur(me);
        }
    if(key==16128)                  /* [F5] */
        {
        win_cursor(me,13,77);
        win_hcur(me);
        key_subfrom(key_me(),KBF_CURSOR);
        info(5);
        win_attr(me,prompt);
        win_cursor(me,13,13);
        win_swrite(me,string);
        key_addto(key_me(),KBF_CURSOR);
        win_cursor(me,row,col);
        win_hcur(me);
        }
    if(key==16384)                  /* [F6] */
        {
        win_cursor(me,13,77);
        win_hcur(me);
        key_subfrom(key_me(),KBF_CURSOR);
        info(6);
        win_attr(me,prompt);
        win_cursor(me,13,13);
        win_swrite(me,string);
        key_addto(key_me(),KBF_CURSOR);
        win_cursor(me,row,col);
        win_hcur(me);
        }
    if(key==16640)                  /* [F7] */
        {
        win_cursor(me,13,77);
        win_hcur(me);
        key_subfrom(key_me(),KBF_CURSOR);
        info(7);
        win_attr(me,prompt);
        win_cursor(me,13,13);
        win_swrite(me,string);
        key_addto(key_me(),KBF_CURSOR);
        win_cursor(me,row,col);
        win_hcur(me);
        }
    if(key==16896)                  /* [F8] */
        {
        win_cursor(me,13,77);
        win_hcur(me);
        key_subfrom(key_me(),KBF_CURSOR);
        info(8);
        win_attr(me,prompt);
        win_cursor(me,13,13);
        win_swrite(me,string);
        key_addto(key_me(),KBF_CURSOR);
        win_cursor(me,row,col);
        win_hcur(me);
        }
    if(key==17152)                  /* [F9] */
        {
        win_cursor(me,13,77);
        win_hcur(me);
        key_subfrom(key_me(),KBF_CURSOR);
        info(9);
        win_attr(me,prompt);
        win_cursor(me,13,13);
        win_swrite(me,string);
        key_addto(key_me(),KBF_CURSOR);
        win_cursor(me,row,col);
        win_hcur(me);
        }
    if(key==17408)                  /* [F10] */
        {
        win_cursor(me,13,77);
        win_hcur(me);
        key_subfrom(key_me(),KBF_CURSOR);
        info(10);
        win_attr(me,prompt);
        win_cursor(me,13,13);
        win_swrite(me,string);
        key_addto(key_me(),KBF_CURSOR);
        win_cursor(me,row,col);
        win_hcur(me);
        }
    if(key==-31488)                  /* [F11] */
        {
        win_cursor(me,13,77);
        win_hcur(me);
        key_subfrom(key_me(),KBF_CURSOR);
        info(11);
        win_attr(me,prompt);
        win_cursor(me,13,13);
        win_swrite(me,string);
        key_addto(key_me(),KBF_CURSOR);
        win_cursor(me,row,col);
        win_hcur(me);
        }
    if(key==-31232)                  /* [F12] */
        {
        win_cursor(me,13,77);
        win_hcur(me);
        key_subfrom(key_me(),KBF_CURSOR);
        info(12);
        win_attr(me,prompt);
        win_cursor(me,13,13);
        win_swrite(me,string);
        key_addto(key_me(),KBF_CURSOR);
        win_cursor(me,row,col);
        win_hcur(me);
        }
    if(key==7680)                   /* Alt-A */
        {
        key_subfrom(key_me(),KBF_CURSOR);
        qdlogo();
        key_addto(key_me(),KBF_CURSOR);
        win_cursor(me,row,col);
        win_hcur(me);
        }

    if(key>29 && key<127)
		if(position<max)
			{
			string[position]=key;
			win_cursor(me,row,col);
            win_putc(me,key,prompt);
			col++;
			position++;
			win_cursor(me,row,col);
			win_hcur(me);
			}

    if(immediate==1 && position>1)
        finished=1;
    }

if(strlen(string)>0)
    {
    strcpy(savkey9, savkey8);
    strcpy(savkey8, savkey7);
    strcpy(savkey7, savkey6);
    strcpy(savkey6, savkey5);
    strcpy(savkey5, savkey4);
    strcpy(savkey4, savkey3);
    strcpy(savkey3, savkey2);
    strcpy(savkey2, savkey1);
    strcpy(savkey1, savkey0);
    strcpy(savkey0, string);
    }

memset(instr,'\0', 81);
strcpy(instr,string);
if(!immediate)
    {
    memset(string,'\0', 81);
    position=0;
    }

if(!strcmp(instr,"exit") && allowexit)
    fin();

prow=row;
pcol=col;
win_cursor(me,11,77);
win_hcur(me);
key_subfrom(key_me(),KBF_CURSOR);


}	


void info(int keyno)
{
    FILE *helpfile;
	char string[81];
    int key=0,place,abort,color;
	ulong infotime, interval=12000;
    char fname[20];

    infotime=tim_new();
    savkey=0;

    if(keyno==1)
        {
        if(small && fexist("help.sml"))  /* fexist() is a Greenleaf Function */
            strcpy(fname,"help.sml");    /*    that checks for the existance */
        else                             /*    of a file */
            {
            if(small && fexist("help.dat"))
                getsmall();
            strcpy(fname,"help.dat");
            }
        color=HELP;
        }
    if(keyno==2)
        {
        if(small && fexist("f2.sml"))
            strcpy(fname,"f2.sml");
        else
            {
            if(small && fexist("f2.dat"))
                getsmall();
            strcpy(fname,"f2.dat");
            }
        color=INFO;
        }
    if(keyno==3)
        {
        if(small && fexist("f3.sml"))
            strcpy(fname,"f3.sml");
        else
            {
            if(small && fexist("f3.dat"))
                getsmall();
            strcpy(fname,"f3.dat");
            }
        color=INFO;
        }
    if(keyno==4)
        {
        if(small && fexist("f4.sml"))
            strcpy(fname,"f4.sml");
        else
            {
            if(small && fexist("f4.dat"))
                getsmall();
            strcpy(fname,"f4.dat");
            }
        color=INFO;
        }
    if(keyno==5)
        {
        if(small && fexist("f5.sml"))
            strcpy(fname,"f5.sml");
        else
            {
            if(small && fexist("f5.dat"))
                getsmall();
            strcpy(fname,"f5.dat");
            }
        color=INFO;
        }
    if(keyno==6)
        {
        if(small && fexist("f6.sml"))
            strcpy(fname,"f6.sml");
        else
            {
            if(small && fexist("f6.dat"))
                getsmall();
            strcpy(fname,"f6.dat");
            }
        color=INFO;
        }
    if(keyno==7)
        {
        if(small && fexist("f7.sml"))
            strcpy(fname,"f7.sml");
        else
            {
            if(small && fexist("f7.dat"))
                getsmall();
            strcpy(fname,"f7.dat");
            }
        color=INFO;
        }
    if(keyno==8)
        {
        if(small && fexist("f8.sml"))
            strcpy(fname,"f8.sml");
        else
            {
            if(small && fexist("f8.dat"))
                getsmall();
            strcpy(fname,"f8.dat");
            }
        color=INFO;
        }
    if(keyno==9)
        {
        if(small && fexist("f9.sml"))
            strcpy(fname,"f9.sml");
        else
            {
            if(small && fexist("f9.dat"))
                getsmall();
            strcpy(fname,"f9.dat");
            }
        color=EMERGENCY;
        }
    if(keyno==10)
        {
        if(small && fexist("f10.sml"))
            strcpy(fname,"f10.sml");
        else
            {
            if(small && fexist("f10.dat"))
                getsmall();
            strcpy(fname,"f10.dat");
            }
        color=INFO;
        }
    if(keyno==11)
        {
        if(small && fexist("f11.sml"))
            strcpy(fname,"f11.sml");
        else
            {
            if(small && fexist("f11.dat"))
                getsmall();
            strcpy(fname,"f11.dat");
            }
        color=INFO;
        }
    if(keyno==12)
        {
        if(small && fexist("f12.sml"))
            strcpy(fname,"f12.sml");
        else
            {
            if(small && fexist("f12.dat"))
                getsmall();
            strcpy(fname,"f12.dat");
            }
        color=INFO;
        }

    if(fexist(fname))
		{
        helpfile=fopen(fname,"r");

        clrwin(color);
    
        place=2;
		abort=0;
		while(fgets(string,80,helpfile)!=NULL && !abort)
			{
			if(place>11)
				{
				win_attr(me,TEXT);
				win_cursor(me,13,0);
                win_swrite(me," Hit [PgDn] for More or [ESC]                                                 ");
				win_attr(me,HELP);
				tim_addto(infotime,interval);
				while(!gfkbhit() && !abort)	  /* loop while no key is pressed */
                    {
                    if(!tim_len(infotime))
                        {
                        abort=1;
                        tim_close(infotime);
                        }
                    api_pause();
                    }
				if(!abort)
					key=getkey();
                    /* getkey() is a Greenleaf Function */
                if(key==27)
					abort=1;
                if(key==15104 || key==15360 || key==15616 || key==15872
                    || key==16128 || key==16384 || key==16640 || key==16896
                    || key==17152 || key==17408 || key==-31488 || key==-31282)
                    {
                    abort=1;
                    savkey=key;
                    }
                if(key!=27 && !abort)
                    clrwin(color);
				place=2;
				}
			if(!abort)
				{
				win_cursor(me,place,1);
				win_swrite(me,string);
				}
			place++;
			}
			
    fclose(helpfile);

    if(immediate && position>1 && !abort)
            {
            win_attr(me,TEXT);
            win_cursor(me,13,0);
            win_swrite(me," Hit any key to continue...                                                 ");
            tim_addto(infotime,interval);
            while(!gfkbhit() && !abort)   /* loop while no key is pressed */
                {
                if(!tim_len(infotime))
                    abort=1;
                api_pause();
                }
            key=getkey();
            /* getkey() is a Greenleaf Function */
            if(key==15104 || key==15360 || key==15616 || key==15872
                || key==16128 || key==16384 || key==16640 || key==16896
                || key==17152 || key==17408 || key==-31488 || key==-31232)
                {
                savkey=key;
                }
            abort=1;
            }

        win_attr(me,TEXT);
		win_cursor(me,13,0);
        win_swrite(me," Search for: ");
        win_cursor(me,13,66);
        win_swrite(me,"[F1] Help");
        win_cursor(me,13,13);
        win_attr(me,prompt);
        win_blanks(me,20);
		win_attr(me,TEXT);
        win_blanks(me,32);
        }

    tim_free(infotime);

}


void qdlogo(void)
{
    int key;

    clrwin(LOGO);
	
	win_attr(me,LOGO);
    if(!small)
        {
        win_cursor(me,3,12); win_swrite(me,"Ŀ ");
        win_cursor(me,4,12); win_swrite(me," DESQview File Search Utility  ");
        win_cursor(me,5,12); win_swrite(me,"         Version               ");
        win_cursor(me,6,12); win_swrite(me,"        by Dave Haber          ");
        win_cursor(me,7,12); win_swrite(me," ");
        win_cursor(me,8,12); win_swrite(me,"       Copyright (C) 1992        ");
        win_cursor(me,9,12); win_swrite(me,"   Quarterdeck Office Systems    ");
        win_cursor(me,5,30); win_swrite(me,PGMVER);
        }
    else
        {
        win_cursor(me,3,5); win_swrite(me,"Ŀ");
        win_cursor(me,4,5); win_swrite(me," DESQview File Search Utility ");
        win_cursor(me,5,5); win_swrite(me,"         Version              ");
        win_cursor(me,6,5); win_swrite(me,"        by Dave Haber         ");
        win_cursor(me,7,5); win_swrite(me,"");
        win_cursor(me,8,5); win_swrite(me,"       Copyright (C) 1992       ");
        win_cursor(me,9,5); win_swrite(me,"   Quarterdeck Office Systems   ");
        win_cursor(me,5,23); win_swrite(me,PGMVER);
        }
    if(immediate)
        clear=1;
}


void getsmall(void)
{
if(!small)
    {
    win_allow(me,ALW_HSIZE);
    win_allow(me,ALW_VSIZE);
    win_resize(me,14,42);
    win_disallow(me,ALW_HSIZE);
    win_disallow(me,ALW_VSIZE);
    win_redraw(me);
    }

if(small)
    {
    win_allow(me,ALW_HSIZE);
    win_allow(me,ALW_VSIZE);
    win_resize(me,14,78);
    win_disallow(me,ALW_HSIZE);
    win_disallow(me,ALW_VSIZE);
    win_redraw(me);
    }

if(!small)
    small=1;
else
    small=0;

}


void fin(void)
{

	win_allow(me,ALW_HSIZE);
	win_allow(me,ALW_VSIZE);
    win_allow(me,ALW_HSCROLL);
	win_allow(me,ALW_VSCROLL);
	
	win_attr(me,winattr);
	win_frattr(me,255,frameattr);

	win_resize(me,sizerow,sizecol);
	win_move(me,posrow,poscol);
	
	win_cursor(me,0,0);
	win_redraw(me);
	
	cls();
	
	api_exit();
	exit(0);

}
