DECLARE SUB ProgramBody ()
'***************************************************************************
'*
'*  Name:               Send
'*
'*  Function:           Send Mailbox
'*
'***************************************************************************

' $INCLUDE: 'dvapi.bi'

' minimum API version required and actual API version
CONST required = &H201

DIM version AS INTEGER
' Object handles
DIM SHARED win&, kbd&, malhan&

' Variables used when reading the menu keyboard
DIM SHARED kbuf$, selfield%


'***************************************************************************
' Main Module - check for DESQview present and enable required extensions
'***************************************************************************

' Initialize DESQview interface and get API version number
version = ApiInit%

' If DESQview is not running or version is too low, display a message
IF version < required THEN
	OPEN "CONS:" FOR OUTPUT AS 1
	PRINT #1, USING "This program requires DESQview version #.##"; required \ 256 + (required MOD 256) / 100
	CLOSE 1
ELSE
' Tell DESQview what extensions to enable and start application
	CALL ApiLevel(required)
	CALL ProgramBody
END IF

' Disable DESQview interface and return from program
CALL ApiExit

SUB ProgramBody
'***************************************************************************
' ProgramBody - build menu and display message when item selected
'***************************************************************************
	Attempt! = 0
	OPEN "Cons:" FOR OUTPUT AS #1
'
' First, get our Mailbox Handle
'
	malhan& = MalMe&
'
' Assign global name "Send"
'
	CALL MalName(malhan&, "Send")
'
' Look for the Receive mailbox; loop until found
'
Find:   RecHan& = MalFind&("Receive")
	IF RecHan& = 0 THEN
		PRINT #1, "<SERVER NOT FOUND>";
		GOTO Find
	END IF
'
' At this point, RecHan& is mailbox of receiver
'
Talk:   msg$ = STR$(Attempt)
	PRINT #1, "<SEND>";
	errstat% = MalWrite%(RecHan&, msg$)
	IF errstat > 0 THEN
' Error handling would go here
	END IF
'
' Get the message from receive module
'
	Message$ = MalRead$(malhan&)
	PRINT #1, "<RECEIVE RECEIPT -" + Message$ + ">"
	Attempt = Attempt + 1
	GOTO Talk






END SUB

