{$G+,X+,F+}

{Conditional defines that may affect this unit}
{$I AWDEFINE.INC}

{*********************************************************}
{*                   BAUDFRM.PAS 1.00                    *}
{*        Copyright (c) TurboPower Software 1995         *}
{*                 All rights reserved.                  *}
{*********************************************************}

unit Baudfrm;

interface

uses SysUtils, WinTypes, WinProcs, Classes, Graphics, Forms, Controls,
  Buttons, StdCtrls, AdMisc, AdModDB;

type
  TBaudForm = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    HelpBtn: TBitBtn;
    Label1: TLabel;
    BPSEdit: TEdit;
    LockDTECheck: TCheckBox;
    GroupBox1: TGroupBox;

    procedure OKBtnClick(Sender: TObject);
  public
    EditData : PModemInfo;
    constructor Create(AOwner : TComponent; var Data : TModemInfo);
  end;

var
  BaudForm: TBaudForm;

implementation

{$R *.DFM}

constructor TBaudForm.Create(AOwner : TComponent; var Data : TModemInfo);
begin
  inherited Create(AOwner);

  EditData := @Data;

  {set initial edit values}
  if (EditData^.DefBaud <> 0) then
    BPSEdit.Text := IntToStr(EditData^.DefBaud);
  LockDTECheck.Checked := EditData^.LockDTE;
end;

procedure TBaudForm.OKBtnClick(Sender: TObject);
var
  E : Integer;
  L : LongInt;

begin
  {make sure that a baud rate was entered}
  if (BPSEdit.Text = '') then begin
    BPSEdit.SetFocus;
    ModalResult := mrNone;
    raise Exception.Create('Please enter a BPS rate');
  end;

  {make sure that the baud rate entered was, in fact, a number}
  Val(BPSEdit.Text, L, E);
  if (E <> 0) then begin
    BPSEdit.SetFocus;
    ModalResult := mrNone;
    raise Exception.Create('Invalid BPS rate');
  end;

  {make sure that the baud rate entered was in range}
  if (L < 300) or (L > 57600) then begin
    BPSEdit.SetFocus;
    ModalResult := mrNone;
    raise Exception.Create('Valid values are between 300 and 57600');
  end;

  EditData^.DefBaud := L;
  EditData^.LockDTE := LockDTECheck.Checked;
  ModalResult := mrOK;
end;

end.
