unit APDMain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, IniFiles, AdMisc, AdExcept, AdTerm, AdProtcl, AdPStat,
  AdPort, ExtCtrls, StdCtrls, AdXPort, AdXProt, AdXUp, AdXDown, AdDial,
  AdModem, AdXDial;

type
  TMain = class(TForm)
    ComPort1: TComPort;
    Protocol1: TProtocol;
    ProtocolStatus1: TProtocolStatus;
    ProtocolLog1: TProtocolLog;
    Terminal1: TTerminal;
    Upload: TButton;
    Download: TButton;
    Quit: TButton;
    PortConfig: TButton;
    ProtConfig: TButton;
    Emulator1: TEmulator;
    Modem1: TModem;
    ModemDialer1: TModemDialer;
    Dial: TButton;
    procedure FormActivate(Sender: TObject);
    procedure UploadClick(Sender: TObject);
    procedure DownloadClick(Sender: TObject);
    procedure Protocol1ProtocolFinish(CP: TObject; ErrorCode: Integer);
    procedure QuitClick(Sender: TObject);
    procedure PortConfigClick(Sender: TObject);
    procedure ProtConfigClick(Sender: TObject);
    procedure DialClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Main: TMain;

implementation

{$R *.DFM}

function MinMax(Value, Low, High : Integer) : Integer;
begin
  if Value < Low then
    Result := Low
  else if Value > High then
    Result := High
  else
    Result := Value;
end;

function StUpcase(const S : String) : String;
var
  I : Integer;
begin
  for I := 1 to Length(S) do
    Result[I] := Upcase(S[I]);
  Result[0] := Char(Length(S));
end;

procedure TMain.FormActivate(Sender: TObject);
const
  Loaded : Boolean = False;
var
  I      : Integer;
  B      : Boolean;
  B2     : Boolean;
  Parity : TParity;
  APDIni : TIniFile;
  HWOpts : THWFlowOptionSet;
  SWOpts : TSWFlowOptions;
  ProtType : TProtocolType;
  ZOpt   : TZmodemFileOptions;
  S      : String;

  function AsciiTrans(S : String) : TAsciiEOLTranslation;
  begin
    S := StUpcase(S);
    S[0] := #5;
    if S = 'STRIP' then
      Result := etStrip
    else if S = 'ADDCR' then
      Result := etAddCRBefore
    else if S = 'ADDLF' then
      Result := etAddLFAfter
    else
      Result := AdMisc.etNone;
  end;

begin
  Terminal1.Active := True;

  if not Loaded then begin
    {Do this only once}
    Loaded := True;
    try
      APDIni := TIniFile.Create('APDDEMO.INI');

      {Load port config values}
      ComPort1.ComNumber := APDIni.ReadInteger('ComPort', 'Port', 2);
      ComPort1.Baud      := APDIni.ReadInteger('ComPort', 'Baud', 19200);
      S := APDIni.ReadString('ComPort', 'Parity', 'none');
      case Upcase(S[1]) of
        'E' : Parity := pEven;
        'O' : Parity := pOdd;
        'M' : Parity := pMark;
        'S' : Parity := pSpace;
        else  Parity := pNone;
      end;
      I := APDIni.ReadInteger('ComPort', 'Databits', 8);
      ComPort1.Databits := MinMax(I, 5, 8);
      I := APDIni.ReadInteger('ComPort', 'Stopbits', 1);
      ComPort1.Stopbits := MinMax(I, 1, 2);

      {HWFlow stuff}
      B := APDIni.ReadBool('ComPort', 'DTRFlow', False);
      HWOpts := [];
      if B then begin
        Include(HWOpts, hwfUseDTR);
        Include(HWOpts, hwfRequireDSR);
      end;
      B := APDIni.ReadBool('ComPort', 'RTSFlow', False);
      if B then begin
        Include(HWOpts, hwfUseRTS);
        Include(HWOpts, hwfRequireCTS);
      end;
      ComPort1.HWFlowOptions := HWOpts;

      {SWFlow stuff}
      B := APDIni.ReadBool('ComPort', 'SoftwareReceiveFlow', False);
      B2 := APDIni.ReadBool('ComPort', 'SoftwareTransmitFlow', False);
      if B and B2 then
        SWOpts := swfBoth
      else if B then
        SWOpts := swfReceive
      else if B2 then
        SWOpts := swfTransmit
      else
        SWOpts := swfNone;
      ComPort1.SWFlowOptions := SWOpts;
      I := APDIni.ReadInteger('ComPort', 'XonChar', 17);
      ComPort1.XonChar := Char(I);
      I := APDIni.ReadInteger('ComPort', 'XoffChar', 19);
      ComPort1.XoffChar := Char(I);

      {Protocol stuff}
      Protocol1.HonorDirectory :=
        APDIni.ReadBool('Protocols', 'HonorDirectory', False);
      Protocol1.IncludeDirectory :=
        APDIni.ReadBool('Protocols', 'IncludeDirectory', False);
      Protocol1.RTSLowForWrite :=
        APDIni.ReadBool('Protocols', 'RTSLowForWrite', False);
      Protocol1.AbortNoCarrier :=
        APDIni.ReadBool('Protocols', 'AbortNoCarrier', False);
      S := StUpcase(APDIni.ReadString('Protocols', 'Protocol', 'Zmodem'));
      if S = 'XMODEM' then
        ProtType := ptXmodem
      else if S = 'XMODEMCRC' then
        ProtType := ptXmodemCrc
      else if S = 'XMODEM1K' then
        ProtType := ptXmodem1K
      else if S = 'XMODEM1K-G' then
        ProtType := ptXmodem1KG
      else if S = 'YMODEM' then
        ProtType := ptYmodem
      else if S = 'YMODEM-G' then
        ProtType := ptYmodemG
      else
        ProtType := ptZmodem;
      Protocol1.ProtocolType := ProtType;
      Protocol1.DestinationDirectory :=
        APDIni.ReadString('Protocols', 'DestinationDir', '');
      S := StUpcase(APDIni.ReadString('Protocols', 'WriteFail', 'rename'));
      if S = 'OVERWRITE' then
        Protocol1.WriteFailAction := wfWriteAnyway
      else if S = 'FAIL' then
        Protocol1.WriteFailAction := wfWriteFail
      else
        Protocol1.WriteFailAction := wfWriteRename;

      {Zmodem stuff}
      Protocol1.ZmodemSkipNoFile :=
        APDIni.ReadBool('Zmodem', 'SkipNoFile', False);
      Protocol1.ZmodemRecover :=
        APDIni.ReadBool('Zmodem', 'CrashRecover', False);
      Protocol1.ZmodemOptionOverride :=
        APDIni.ReadBool('Zmodem', 'OptionOverride', False);
      Protocol1.Zmodem8K :=
        APDIni.ReadBool('Zmodem', '8KMode', False);
      S := StUpcase(APDIni.ReadString('Zmodem', 'FileOption', 'reject'));
      if S = 'CLOBBER' then
        ZOpt := zfoWriteClobber
      else if S = 'NEWERLONGER' then
        ZOpt := zfoWriteNewerLonger
      else if S = 'DIFFERENT' then
        ZOpt := zfoWriteDifferent
      else if S = 'APPEND' then
        ZOpt := zfoWriteAppend
      else if S = 'NEWER' then
        ZOpt := zfoWriteNewer
      else
        ZOpt := zfoWriteProtect;
      Protocol1.ZmodemFileOption := ZOpt;

      {Kermit stuff}
      Protocol1.KermitMaxLen :=
        APDIni.ReadInteger('Kermit', 'BlockLen', 80);
      Protocol1.KermitMaxLongLen :=
        APDIni.ReadInteger('Kermit', 'LongBlockLen', 0);
      Protocol1.KermitMaxWindows :=
        APDIni.ReadInteger('Kermit', 'Windows', 0);
      Protocol1.KermitTimeoutSecs :=
        APDIni.ReadInteger('Kermit', 'Timeout', 5);

      {ASCII stuff}
      Protocol1.AsciiCharDelay :=
        APDIni.ReadInteger('ASCII', 'InterCharDelay', 0);
      Protocol1.AsciiLineDelay :=
        APDIni.ReadInteger('ASCII', 'InterLineDelay', 0);
      S := APDIni.ReadString('ASCII', 'CRTrans', 'none');
      Protocol1.AsciiCRTranslation := AsciiTrans(S);
      S := APDIni.ReadString('ASCII', 'CRTrans', 'none');
      Protocol1.AsciiLFTranslation := AsciiTrans(S);
      Protocol1.AsciiEOFTimeout :=
        APDIni.ReadInteger('ASCII', 'EOFTimeout', 364);

    finally
      {Ignore errors}
      APDIni.Free;
    end;
  end;
end;

procedure TMain.UploadClick(Sender: TObject);
begin
  {Stuff current options into dialog}
  UploadDialog.Mask := Protocol1.FileMask;
  UploadDialog.Protocol := Protocol1.ProtocolType;

  {Process the dialog and upload the file(s)}
  UploadDialog.ShowModal;
  if UploadDialog.ModalResult = idOK then begin
    Protocol1.FileMask := UploadDialog.Mask;
    Protocol1.ProtocolType := UploadDialog.Protocol;
    Protocol1.StartTransmit;
  end else
    Terminal1.SetFocus;
end;

procedure TMain.DownloadClick(Sender: TObject);
begin
  {Stuff the current option into the dialog}
  DownloadDialog.Protocol := Protocol1.ProtocolType;
  DownloadDialog.DestDirectory := Protocol1.DestinationDirectory;

  {Process the dialog and download the files}
  DownloadDialog.ShowModal;
  if DownloadDialog.ModalResult = idOk then begin
    Protocol1.ProtocolType := DownloadDialog.Protocol;
    Protocol1.DestinationDirectory := DownloadDialog.DestDirectory;
    case Protocol1.ProtocolType of
      ptXmodem..ptXmodem1KG,
      ptASCII : Protocol1.FileName := DownloadDialog.ReceiveName;
    end;
    Protocol1.StartReceive;
  end else
    Terminal1.SetFocus;
end;

procedure TMain.Protocol1ProtocolFinish(CP: TObject; ErrorCode: Integer);
var
  Msg : array[0..80] of Char;
begin
  if ErrorCode = 0 then
    Application.MessageBox('Transfer complete', 'Information', mb_ok)
  else begin
    StrPCopy(Msg, ErrorMsg(ErrorCode));
    Application.MessageBox(Msg, '', mb_ok);
  end;
  Terminal1.SetFocus;
end;

procedure TMain.QuitClick(Sender: TObject);
begin
  Close;
end;

procedure TMain.PortConfigClick(Sender: TObject);
const
  ParityStr : array[TParity] of String[5] =
    ('none', 'odd', 'even', 'mark', 'space');
var
  APDIni : TIniFile;
begin
  ComPortOptions.ComPort := ComPort1;

  if ComPortOptions.Execute then begin
    {Close current port, if open}
    if Assigned(ComPort1) then
      ComPort1.Open := False;

    {Assign new comport values and open the port}
    ComPort1.Assign(ComPortOptions.ComPort);
    ComPort1.Open := True;

    {Update the ini file}
    try
      APDIni := TIniFile.Create('APDDEMO.INI');

      {Store port config values}
      APDIni.WriteInteger('ComPort', 'Port', ComPort1.ComNumber);
      APDIni.WriteInteger('ComPort', 'Baud', ComPort1.Baud);
      APDIni.WriteString('ComPort', 'Parity', ParityStr[ComPort1.Parity]);
      APDIni.WriteInteger('ComPort', 'Databits', ComPort1.Databits);
      APDIni.WriteInteger('ComPort', 'Stopbits', ComPort1.Stopbits);

      {HWFlow stuff}
      APDIni.WriteBool('ComPort', 'DTRFlow',
        hwfUseDTR in ComPort1.HWFlowOptions);
      APDIni.WriteBool('ComPort', 'RTSFlow',
        hwfUseRTS in ComPort1.HWFlowOptions);

      {SWFlow stuff}
      APDIni.WriteBool('ComPort', 'SoftwareReceiveFlow',
        (ComPort1.SWFlowOptions = swfBoth) or
        (ComPort1.SWFlowOptions = swfReceive));
      APDIni.WriteBool('ComPort', 'SoftwareTransmitFlow',
        (ComPort1.SWFlowOptions = swfBoth) or
        (ComPort1.SWFlowOptions = swfTransmit));
      APDIni.WriteInteger('ComPort', 'XonChar', Ord(ComPort1.XOnChar));
      APDIni.WriteInteger('ComPort', 'XoffChar', Ord(ComPort1.XOffChar));

      finally
        {Ignore errors}
        APDIni.Free;
    end;
  end;

  {Give focus back to terminal window}
  Terminal1.SetFocus;
end;

procedure TMain.ProtConfigClick(Sender: TObject);
  {-Get new protocol options}
const
  ProtStr : array[TProtocolType] of String[10] = (
    'NoProtocol', 'Xmodem', 'XmodemCRC', 'Xmodem1K', 'Xmodem1KG',
    'Ymodem', 'YmodemG', 'Zmodem', 'Kermit', 'ASCII', 'B+');
  WriteFailStr : array[TWriteFailAction] of String[9] = (
    'none', 'fail', 'rename', 'overwrite', 'resume');
  FileOptionStr : array[TZmodemFileOptions] of String[11] = (
    'none', 'newerlonger', 'crc', 'append', 'clobber',
    'newer', 'different', 'reject');
  TransStr : array[TAsciiEOLTranslation] of String[11] = (
    'none', 'strip', 'AddCRBefore', 'AddLFAfter');
var
  APDIni : TIniFile;
begin
  if Assigned(Protocol1) then
    ProtocolOptions.Protocol := Protocol1;

  if ProtocolOptions.Execute then begin
    Protocol1.Assign(ProtocolOptions.Protocol);

    {Update the ini file}
    try
      APDIni := TIniFile.Create('APDDEMO.INI');

      {Protocol stuff}
      APDIni.WriteBool('Protocols', 'HonorDirectory',
        Protocol1.HonorDirectory);
      APDIni.WriteBool('Protocols', 'IncludeDirectory',
        Protocol1.IncludeDirectory);
      APDIni.WriteBool('Protocols', 'RTSLowForWrite',
        Protocol1.RTSLowForWrite);
      APDIni.WriteBool('Protocols', 'AbortNoCarrier',
        Protocol1.AbortNoCarrier);
      APDIni.WriteString('Protocols', 'Protocol',
        ProtStr[Protocol1.ProtocolType]);
      APDIni.WriteString('Protocols', 'DestinationDir',
        Protocol1.DestinationDirectory);
      APDIni.WriteString('Protocols', 'WriteFail',
        WriteFailStr[Protocol1.WriteFailAction]);

      {Zmodem stuff}
      APDIni.WriteBool('Zmodem', 'SkipNoFile', Protocol1.ZmodemSkipNoFile);
      APDIni.WriteBool('Zmodem', 'CrashRecover', Protocol1.ZmodemRecover);
      APDIni.WriteBool('Zmodem', 'OptionOverride',
        Protocol1.ZmodemOptionOverride);
      APDIni.WriteBool('Zmodem', '8KMode', Protocol1.Zmodem8K);
      APDIni.WriteString('Zmodem', 'FileOption',
        FileOptionStr[Protocol1.ZmodemFileOption]);

      {Kermit stuff}
      APDIni.WriteInteger('Kermit', 'BlockLen', Protocol1.KermitMaxLen);
      APDIni.WriteInteger('Kermit', 'LongBlockLen', Protocol1.KermitMaxLongLen);
      APDIni.WriteInteger('Kermit', 'Windows', Protocol1.KermitMaxWindows);
      APDIni.WriteInteger('Kermit', 'Timeout', Protocol1.KermitTimeoutSecs);

      {ASCII stuff}
      APDIni.WriteInteger('ASCII', 'InterCharDelay', Protocol1.AsciiCharDelay);
      APDIni.WriteInteger('ASCII', 'InterLineDelay', Protocol1.AsciiLineDelay);
      APDIni.WriteString('ASCII', 'CRTrans',
        TransStr[Protocol1.AsciiCRTranslation]);
      APDIni.WriteString('ASCII', 'LFTrans',
        TransStr[Protocol1.AsciiLFTranslation]);
      APDIni.WriteInteger('ASCII', 'EOFTimeout', Protocol1.AsciiEOFTimeout);

    finally
      APDIni.Free;
    end;
  end;

  Terminal1.SetFocus;
end;

procedure TMain.DialClick(Sender: TObject);
begin
  DialDialog.Number.Text := '1-719-260-9726';
  DialDialog.ShowModal;
  if DialDialog.ModalResult = idOK then begin
    ModemDialer1.PhoneNumber := DialDialog.Number.Text;
    ModemDialer1.Execute;
  end;
  Terminal1.SetFocus;
end;

end.
