
/*-
 * Copyright (c) 1995 The Apache Group. All rights reserved.
 * 
 *
 * Apache httpd license
 * ====================
 * 
 *
 * This is the license for the Apache Server. It covers all the
 * files which come in this distribution, and should never be removed.
 * 
 * The "Apache Group" has based this server, called "Apache", on
 * public domain code distributed under the name "NCSA httpd 1.3".
 * 
 * NCSA httpd 1.3 was placed in the public domain by the National Center 
 * for Supercomputing Applications at the University of Illinois 
 * at Urbana-Champaign.
 * 
 * As requested by NCSA we acknowledge,
 * 
 *  "Portions developed at the National Center for Supercomputing
 *   Applications at the University of Illinois at Urbana-Champaign."
 *
 * Copyright on the sections of code added by the "Apache Group" belong
 * to the "Apache Group" and/or the original authors. The "Apache Group" and
 * authors hereby grant permission for their code, along with the
 * public domain NCSA code, to be distributed under the "Apache" name.
 * 
 * Reuse of "Apache Group" code outside of the Apache distribution should
 * be acknowledged with the following quoted text, to be included with any new
 * work;
 * 
 * "Portions developed by the "Apache Group", taken with permission 
 *  from the Apache Server   http://www.apache.org/apache/   "
 *
 *
 * Permission is hereby granted to anyone to redistribute Apache under
 * the "Apache" name. We do not grant permission for the resale of Apache, but
 * we do grant permission for vendors to bundle Apache free with other software,
 * or to charge a reasonable price for redistribution, provided it is made
 * clear that Apache is free. Permission is also granted for vendors to 
 * sell support for for Apache. We explicitly forbid the redistribution of 
 * Apache under any other name.
 * 
 * The "Apache Group" makes no promises to support "Apache". Users and
 * sellers of Apache support, and users of "Apache Group" code, should be 
 * aware that they use "Apache" or portions of the "Apache Group" code at 
 * their own risk. While every effort has been made to ensure that "Apache"
 * is robust and safe to use, we will not accept responsibility for any
 * damage caused, or loss of data or income which results from its use.
 * 
 */



/*
 * http_request.c: functions to get and process requests
 * 
 * Rob McCool 3/21/93
 * 
 */


#include "httpd.h"

int assbackwards;
char *remote_host;
char *remote_ip;
char *remote_name;

/* If RFC931 identity check is on, the remote user name */
char *remote_logname;
static void (*exit_callback)();

void send_fd_timed_out() {
    char errstr[MAX_STRING_LEN];

    if(exit_callback) (*exit_callback)();
    sprintf(errstr,"httpd: send timed out for %s",remote_name);
    log_error(errstr);
    log_transaction(1);
    fclose(stdin);
    fclose(stdout);
    exit(0);
}

/*
void send_fd(FILE *f, FILE *fd, void (*onexit)())
  Patch B18 - we'll make it return the number of bytes sent
  so that we know if we need to send a body by default
*/
long send_fd(FILE *f, FILE *fd, void (*onexit)())
{
    char buf[IOBUFSIZE];
    long total_bytes_sent;          /* Patch B18 */
    register int n,o,w;

    exit_callback = onexit;
    signal(SIGALRM,(void (*)())send_fd_timed_out);
    signal(SIGPIPE,(void (*)())send_fd_timed_out);

    total_bytes_sent = 0;          /* Patch B18 */
    while (1) {
        alarm(timeout);
        if((n=fread(buf,sizeof(char),IOBUFSIZE,f)) < 1) {
            break;
        }
        o=0;
        if(bytes_sent != -1)
            bytes_sent += n;
        while(n) {
            w=fwrite(&buf[o],sizeof(char),n,fd);
            n-=w;
            o+=w;
            total_bytes_sent += w;     /* Patch B18 */
        }
    }
    fflush(fd);
    return total_bytes_sent;           /* Patch B18 */
}

int find_script(char *req, char *name, char *args, int in, FILE *out) {
    struct stat finfo;
    char pa[MAX_STRING_LEN];
    char ct_backup[MAX_STRING_LEN];
    int need_multi;

    get_path_info (name, pa, &need_multi, &finfo);
    evaluate_access(name,&finfo,M_GET,&allow,&allow_options, out);
    if(!allow) {
        log_reason("client denied by server configuration",name);
        unmunge_name(name);
        die(FORBIDDEN,name,out);
    }

    if (need_multi
	&& !handle_multi (name, MAX_STRING_LEN, 1,
			  allow_options, &finfo, out))
    {
	/* Should be a 406 No Such Variant error */
	
	log_reason ("No file(s) found to satisfy this request", name);
	unmunge_name(name);
	die (NOT_FOUND, name, out);
    }
    
    strcpy(ct_backup,content_type); /* oop ack */
    probe_content_type(name);
    if(!strcmp(content_type,CGI_MAGIC_TYPE)) {
        strcpy(content_type,ct_backup);
        send_cgi(req,name,pa,args,&finfo,in,out);
        return 1;
    }
    return 0;
}

#ifdef LOGUSER
	/* B00042
	 * Keep a copy of the first 'user' id provided for .htaccess
	 */
	char log_user[MAX_STRING_LEN];
#endif

void process_request(int in, FILE *out) {
    char m[HUGE_STRING_LEN];
    char w[HUGE_STRING_LEN];
    char l[HUGE_STRING_LEN];
    char url[HUGE_STRING_LEN];
    char args[HUGE_STRING_LEN];
    int s,n;

#ifdef LOGUSER
	/* B00042
	 * Keep a copy of the first 'user' id provided for .htaccess
	 */
	log_user[0] = '\0';
#endif

#ifdef VIRTUAL_HOST
    use_virtual_host_config(get_local_addr(in,out), out);
#endif /* VIRTUAL_HOST */
    get_remote_host(in);
    exit_callback = NULL;
    signal(SIGPIPE,(void (*)())send_fd_timed_out);

    getlineinit(in);
    l[0] = '\0';
    if(getline(l,HUGE_STRING_LEN,in,timeout))
        return;
    if(!l[0]) 
        return;

    record_request(l);
    getword(m,l,' ');
    getword(args,l,' ');
    getword(url,args,'?');
/*    plustospace(url); */
    unescape_url(url);
    
      /* Apache custom error response. Each new request means we need to
            remember the 'url' and 'args', in case we redirect after an
            error/problem. We use the first byte of original_url[] as a flag.
            original_url[0] == '\0' means we haven't (yet) redirected.
      */
    original_url[0] = '\0';
    strcpy(&original_url[1], url);    /* Keep a copy of the URL in case of */
    strcpy(&original_args[0], args);  /* a failure, we can use the URL 
                                      in custom error logging */
    original_status = 0;              /* Changed if we hit error/problem */
    strcpy(original_method, m);       /* Oh boy, lets keep that too */ 
  
    getword(w,l,'\0');
    init_header_vars();
    if(w[0] != '\0') {
        assbackwards = 0;
        get_mime_headers(in,out);
    }
    else
        assbackwards = 1;
        
    if(!strcmp(m,"HEAD")) {
        header_only=1;
        process_get(in,out,m,url,args);
    }
    else if(!strcmp(m,"GET")) {
        header_only=0;
        process_get(in,out,m,url,args);
    }
    else if(!strcmp(m,"POST")) {
        header_only = 0;
        post_node(url,args,in,out);
    }
    else if(!strcmp(m,"PUT")) {
        header_only = 0;
        put_node(url,args,in,out);
    }
    else if(!strcmp(m,"DELETE")) {
        header_only = 0;
        delete_node(url,args,in,out);
    }
    else 
        die(BAD_REQUEST,"Invalid or unsupported method.",out);

}
