
/*-
 * Copyright (c) 1995 The Apache Group. All rights reserved.
 * 
 *
 * Apache httpd license
 * ====================
 * 
 *
 * This is the license for the Apache Server. It covers all the
 * files which come in this distribution, and should never be removed.
 * 
 * The "Apache Group" has based this server, called "Apache", on
 * public domain code distributed under the name "NCSA httpd 1.3".
 * 
 * NCSA httpd 1.3 was placed in the public domain by the National Center 
 * for Supercomputing Applications at the University of Illinois 
 * at Urbana-Champaign.
 * 
 * As requested by NCSA we acknowledge,
 * 
 *  "Portions developed at the National Center for Supercomputing
 *   Applications at the University of Illinois at Urbana-Champaign."
 *
 * Copyright on the sections of code added by the "Apache Group" belong
 * to the "Apache Group" and/or the original authors. The "Apache Group" and
 * authors hereby grant permission for their code, along with the
 * public domain NCSA code, to be distributed under the "Apache" name.
 * 
 * Reuse of "Apache Group" code outside of the Apache distribution should
 * be acknowledged with the following quoted text, to be included with any new
 * work;
 * 
 * "Portions developed by the "Apache Group", taken with permission 
 *  from the Apache Server   http://www.apache.org/apache/   "
 *
 *
 * Permission is hereby granted to anyone to redistribute Apache under
 * the "Apache" name. We do not grant permission for the resale of Apache, but
 * we do grant permission for vendors to bundle Apache free with other software,
 * or to charge a reasonable price for redistribution, provided it is made
 * clear that Apache is free. Permission is also granted for vendors to 
 * sell support for for Apache. We explicitly forbid the redistribution of 
 * Apache under any other name.
 * 
 * The "Apache Group" makes no promises to support "Apache". Users and
 * sellers of Apache support, and users of "Apache Group" code, should be 
 * aware that they use "Apache" or portions of the "Apache Group" code at 
 * their own risk. While every effort has been made to ensure that "Apache"
 * is robust and safe to use, we will not accept responsibility for any
 * damage caused, or loss of data or income which results from its use.
 * 
 */



/*
 * http_auth: authentication
 * 
 * Rob McCool
 * 
 */


#include "httpd.h"

char user[MAX_STRING_LEN];

void auth_bong(char *s, FILE *out) {
    char errstr[MAX_STRING_LEN];

/* debugging */
    if(s) {
        sprintf(errstr,"%s authorization: %s",remote_name,s);
        log_error(errstr);
    }
    if(!strcasecmp(auth_type,"Basic")) {
        sprintf(errstr,"Basic realm=\"%s\"",auth_name);
        die(AUTH_REQUIRED,errstr,out);
    }
#ifdef DBM_AUTH
    if(!strcasecmp(auth_type,"DBM")) {
              sprintf(errstr,"DBM authorization: %s",auth_name);
	              die(AUTH_REQUIRED,errstr,out);
    }
#endif
    else {
        sprintf(errstr,"Unknown authorization method %s",auth_type);
        die(SERVER_ERROR,errstr,out);
    }
}


#ifdef LOGUSER
	/* B00042
	 * Keep a copy of the first 'user' id provided for .htaccess
	 */
	extern char log_user[MAX_STRING_LEN];
#endif

void check_auth(security_data *sec, int m, FILE *out) {
    char at[MAX_STRING_LEN];
    char ad[MAX_STRING_LEN];
    char sent_pw[MAX_STRING_LEN];
    char real_pw[MAX_STRING_LEN];
    char t[MAX_STRING_LEN];
    char w[MAX_STRING_LEN];
    char errstr[MAX_STRING_LEN];
    register int x,y;
    int grpstatus;

    if(!auth_type) {
        sprintf(errstr,
"httpd: authorization required for %s but not configured",sec->d);
        die(SERVER_ERROR,errstr,out);
    }

    if(!strcasecmp(auth_type,"Basic")) {
        if(!auth_name) {
            sprintf(errstr,"httpd: need AuthName for %s",sec->d);
            die(SERVER_ERROR,errstr,out);
        }
        if(!auth_line[0])
            auth_bong(NULL,out);
#ifdef DBM_AUTH
        if(!auth_pwfile && !auth_dbmpwfile) {
            sprintf(errstr,"httpd: need AuthUserFile or AuthDBMUserFilefor %s",sec->d);
#else
        if(!auth_pwfile) {
            sprintf(errstr,"httpd: need AuthUserFile for %s",sec->d);
#endif  
            die(SERVER_ERROR,errstr,out);
        }
        sscanf(auth_line,"%s %s",at,t);
        if(strcmp(at,auth_type))
            auth_bong("type mismatch",out);
        uudecode(t,(unsigned char *)ad,MAX_STRING_LEN);
        getword(user,ad,':');
#ifdef LOGUSER
	/* B00042
	 * Keep a copy of the first 'user' id provided for .htaccess
	 */
	if ( log_user[0] == '\0' ) {
		strcpy( log_user, user );
	};
#endif
        strcpy(sent_pw,ad);

#ifdef DBM_AUTH
	if(auth_dbmpwfile) {
	  if(!get_dbm_pw(user,real_pw,out)) {
	    sprintf(errstr,"DBM user %s not found",user);
	    auth_bong(errstr,out);
	  }    
	} else 
#endif
	if(!get_pw(user,real_pw,out)) {
            sprintf(errstr,"user %s not found",user);
            auth_bong(errstr,out);
        }
        /* anyone know where the prototype for crypt is? */
        if(strcmp(real_pw,(char *)crypt(sent_pw,real_pw))) {
            sprintf(errstr,"user %s: password mismatch",user);
            auth_bong(errstr,out);
        }
    }
    else {
        sprintf(errstr,"unknown authorization type %s for %s",auth_type,
                sec->d);
        auth_bong(errstr,out);
    }

    /* Common stuff: Check for valid user */
    if(auth_grpfile)
        grpstatus = init_group(auth_grpfile,out);
    else
        grpstatus = 0;

    for(x=0;x<sec->num_auth[m];x++) {
        strcpy(t,sec->auth[m][x]);
        getword(w,t,' ');
        if(!strcmp(w,"valid-user"))
            goto found;
        if(!strcmp(w,"user")) {
            while(t[0]) {
                if(t[0] == '\"') {
                    getword(w,&t[1],'\"');
                    for(y=0;t[y];y++)
                        t[y] = t[y+1];
                }
                getword(w,t,' ');
                if(!strcmp(user,w))
                    goto found;
            }
        }
#ifdef DBM_AUTH
       else if(!strcmp(w,"group") && auth_dbmgrpfile) {
           char groups[MAX_STRING_LEN],v[MAX_STRING_LEN];

           if (!get_dbm_grp(user,&groups,out)) {
               sprintf(errstr,"could not open group DBM file %s",auth_dbmgrpfile);
               auth_bong(errstr,out);
           }
           while(t[0]) {
               getword(w,t,' ');
               while(groups[0]) {
                   getword(v,groups,',');
                   if(!strcmp(v,w))
                       goto found;
               }
           }
           sprintf(errstr,"user %s not in right group",user);
           auth_bong(errstr,out);
       }
#endif
        else if(!strcmp(w,"group")) {
            if(!grpstatus) {
                sprintf(errstr,"group required for %s, bad groupfile",
                        sec->d);
                auth_bong(errstr,out);
            }
            while(t[0]) {
                getword(w,t,' ');
                if(in_group(user,w))
                    goto found;
            }
        }
        else
            auth_bong("require not followed by user or group",out);
    }
    if(grpstatus) kill_group();
    sprintf(errstr,"user %s denied",user);
    auth_bong(errstr,out);
  found:
    if(grpstatus)
        kill_group();
}

