
/*-
 * Copyright (c) 1995 The Apache Group. All rights reserved.
 * 
 *
 * Apache httpd license
 * ====================
 * 
 *
 * This is the license for the Apache Server. It covers all the
 * files which come in this distribution, and should never be removed.
 * 
 * The "Apache Group" has based this server, called "Apache", on
 * public domain code distributed under the name "NCSA httpd 1.3".
 * 
 * NCSA httpd 1.3 was placed in the public domain by the National Center 
 * for Supercomputing Applications at the University of Illinois 
 * at Urbana-Champaign.
 * 
 * As requested by NCSA we acknowledge,
 * 
 *  "Portions developed at the National Center for Supercomputing
 *   Applications at the University of Illinois at Urbana-Champaign."
 *
 * Copyright on the sections of code added by the "Apache Group" belong
 * to the "Apache Group" and/or the original authors. The "Apache Group" and
 * authors hereby grant permission for their code, along with the
 * public domain NCSA code, to be distributed under the "Apache" name.
 * 
 * Reuse of "Apache Group" code outside of the Apache distribution should
 * be acknowledged with the following quoted text, to be included with any new
 * work;
 * 
 * "Portions developed by the "Apache Group", taken with permission 
 *  from the Apache Server   http://www.apache.org/apache/   "
 *
 *
 * Permission is hereby granted to anyone to redistribute Apache under
 * the "Apache" name. We do not grant permission for the resale of Apache, but
 * we do grant permission for vendors to bundle Apache free with other software,
 * or to charge a reasonable price for redistribution, provided it is made
 * clear that Apache is free. Permission is also granted for vendors to 
 * sell support for for Apache. We explicitly forbid the redistribution of 
 * Apache under any other name.
 * 
 * The "Apache Group" makes no promises to support "Apache". Users and
 * sellers of Apache support, and users of "Apache Group" code, should be 
 * aware that they use "Apache" or portions of the "Apache Group" code at 
 * their own risk. While every effort has been made to ensure that "Apache"
 * is robust and safe to use, we will not accept responsibility for any
 * damage caused, or loss of data or income which results from its use.
 * 
 */



/*
 * http_alias.c: Stuff for dealing with directory aliases
 * 
 * Rob McCool
 * 
 */


#include "httpd.h"

typedef struct salias alias;
    
struct salias {
    char *fake, *real;  /* malloced single string pointed at by fake */
    int script;  /* for aliases */
    alias *next;  /* next one, or NULL if last */
};

static alias *a=NULL, **last_a=&a;
static alias *v=NULL, **last_v=&v;

/* To send stat() information to http_script.c */
int dirs_in_alias;

/*
 * Delete previously allocated alias list
 */
static void
free_aliases(alias *p)
{
    alias *next;
    while (p != NULL)
    {
	free(p->fake);
	next= p->next;
	free(p);
	p = next;
    };
}

/*
 * Allocates a new alias
 */
alias *
mk_alias(const char *fake, const char *real, int is_script)
{
    int fakelen, reallen;
    alias *p;

/* allocate memory */
    p = malloc(sizeof(alias));
    if (p == NULL) return NULL;
    fakelen = strlen(fake);
    reallen = strlen(real);
    p->fake = malloc(fakelen + reallen + 2);
    if (p->fake == NULL)
    {
	free(p);
	return NULL;
    }
/* copy in the data */
    strcpy(p->fake, fake);
    p->real = p->fake + fakelen + 1;
    strcpy(p->real, real);
    p->script = is_script;
    p->next = NULL;
    return p;
}

void
reset_aliases() {
    free_aliases(a);
    free_aliases(v);
    last_a = &a;
    last_v = &v;
}

int
add_alias(char *f, char *r, int is_script) {
    alias *p;

    if(r[0] != '/') 
    {
	char real[MAX_STRING_LEN];
        make_full_path((is_script ? server_root : document_root), r, real);
	p = mk_alias(f, real, is_script);
    }
    else
	p = mk_alias(f, r, is_script);
    if (p == NULL) return 0;
    *last_a = p;
    last_a = &p->next;
    return 1;
}

int
add_redirect(char *f, char *url) {
    alias *p;

    p = mk_alias(f, url, 0);
    if (p == NULL) return 0;
    *last_v = p;
    last_v = &p->next;
    return 1;
}

/*
 * Can return
 *   BAD_URL         Malformed URL
 *   REDIRECT_URL    URL matched a Redirect.
 *   SCRIPT_CGI      URL matches a ScriptAlias path
 *   SCRIPT_NCSA     URL matches an OldScriptAlias path
 *   STD_DOCUMENT    any other URL
 */
int
translate_name(char *name, FILE *fd) {
    alias *p;
    register int l;
    char w[MAX_STRING_LEN];
    struct passwd *pw;

    getparents(name);

    if (name[0] != '/' && name[0] != '\0')
	return BAD_URL;

    for (p=v; p != NULL; p=p->next)
    {
        l = strlen(p->fake);
        if(!strncmp(name, p->fake, l) && (p->fake[l-1] == '/' || l == strlen(name) || name[l] == '/')) {
            strsubfirst(l, name, p->real);
            return REDIRECT_URL;
        }
    }

    for (p=a; p != NULL; p=p->next)
    {
        l=strlen(p->fake);
        if(!strncmp(name, p->fake, l) && (p->fake[l-1] == '/' || l == strlen(name) || name[l] == '/')) {
            strsubfirst(l, name, p->real);
            dirs_in_alias = count_dirs(p->real);
            return p->script;
        }
    }

    if((user_dir[0]) && (name[0] == '/') && (name[1] == '~')) {
        char fake[MAX_STRING_LEN],real[MAX_STRING_LEN],dname[MAX_STRING_LEN];

        strcpy(dname,&name[2]);
        getword(w,dname,'/');
        if(!(pw=getpwnam(w)))
            die(NOT_FOUND,name,fd);
        fake[0] = '/';
        fake[1] = '~';
        strcpy(&fake[2],w);
        make_full_path(pw->pw_dir,user_dir,real);
        if (!add_alias(fake, real, STD_DOCUMENT))
	    die(NO_MEMORY,"translate_name", fd);
        strsubfirst(strlen(w) + 2,name,real);
        return STD_DOCUMENT;
    }
    /* no alias, add document root */
    strsubfirst(0,name,document_root);
    return STD_DOCUMENT;
}

void
unmunge_name(char *name) {
    register int l;
    alias *p;

    l=strlen(document_root);
    if(!strncmp(name,document_root,l)) {
        strsubfirst(l,name,"");
        if(!name[0]) {
            name[0] = '/';
            name[1] = '\0';
        }
        return;
    }
    
     for (p=a; p != NULL; p = p->next)
     {
         l = strlen(p->real);
         if(!strncmp(name, p->real, l)) {
             strsubfirst(l, name, p->fake);
             if(!name[0]) {
                 name[0] = '/';
                 name[1] = '\0';
             }
             return;
         }
     }
}
