
/* ====================================================================
 * Copyright (c) 1995 The Apache Group.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the Apache Group
 *    for use in the Apache HTTP server project (http://www.apache.org/)."
 *
 * 4. The names "Apache Server" and "Apache Group" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the Apache Group
 *    for use in the Apache HTTP server project (http://www.apache.org/)."
 *
 * THIS SOFTWARE IS PROVIDED BY THE APACHE GROUP ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE APACHE GROUP OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Group and was originally based
 * on public domain software written at the National Center for
 * Supercomputing Applications, University of Illinois, Urbana-Champaign.
 * For more information on the Apache Group and the Apache HTTP server
 * project, please see <http://www.apache.org/>.
 *
 */


/*
 * rfc931() speaks a common subset of the RFC 931, AUTH, TAP and IDENT
 * protocols. The code queries an RFC 931 etc. compatible daemon on a remote
 * host to look up the owner of a connection. The information should not be
 * used for authentication purposes. This routine intercepts alarm signals.
 * 
 * Diagnostics are reported through syslog(3).
 * 
 * Author: Wietse Venema, Eindhoven University of Technology,
 * The Netherlands.
 */

/* Some small additions for Shambhala --- ditch the "sccsid" var if
 * compiling with gcc (it *has* changed), include conf.h for the
 * prototypes it defines on at least one system (SunlOSs) which has
 * them missing from the standard header files, and one minor change
 * below (extra parens around assign "if (foo = bar) ..." to shut up
 * gcc -Wall).
 */

#include "conf.h"

#ifdef NOTDEF            /* Has changed slightly... */
static char sccsid[] = "@(#) rfc931.c 1.8 93/12/13 22:23:20";
#endif

#ifndef _HPUX_SOURCE
#define _HPUX_SOURCE
#endif

/* System libraries. */

#include <stdio.h>
#if !defined(QNX) && !defined(UW2) && !defined(__EMX__)
#include <syslog.h>
#endif
#include <sys/types.h>
#ifndef ULTRIX_BRAIN_DEATH
#include <sys/socket.h>
#endif
#ifdef __bsdi__
#if _BSDI_VERSION > 199312
#include <netinet/in.h>
#endif
#else
#include <netinet/in.h>
#endif
#include <setjmp.h>
#include <signal.h>
#ifndef NEXT
#include <unistd.h>
#endif

#ifndef SCO
extern char *strchr();
extern char *inet_ntoa();
#endif

/* Local stuff. */

/* #include "log_tcp.h" */

#define RFC931_TIMEOUT    500
#define    RFC931_PORT    113        /* Semi-well-known port */
#define    ANY_PORT    0        /* Any old port will do */
#define FROM_UNKNOWN  "unknown"

int     rfc931_timeout = RFC931_TIMEOUT;/* Global so it can be changed */

static jmp_buf timebuf;

#if defined(QNX) || defined(UW2) || defined(__EMX__)

/*
Gasp! QNX doesn't support syslog() (out of the box). Replace with output to
stderr. Really, this module should use Apache error logging, but then it would
need considerable hacking.

9 Oct 95
Ben Laurie <ben@algroup.co.uk>

Same goes for UnixWare 2.x. Sigh.

12 Dec 95
Chuck Murcko <chuck@telebase.com>
*/
#include <assert.h>

#define LOG_ERR 0

void syslog(int err,const char *str)
{
  char logbuf[200];
  int n=ind(str,'%');

  assert(n >= 0);
  memcpy(logbuf,str,n);
  logbuf[n]='\0';
  
  fprintf(stderr,"%ssystem error %d",logbuf,errno);
}

#endif /* defined(QNX) || defined(UW2) */

/* fsocket - open stdio stream on top of socket */

static FILE *fsocket(domain, type, protocol)
int     domain;
int     type;
int     protocol;
{
    int     s;
    FILE   *fp;

    if ((s = socket(domain, type, protocol)) < 0) {
    syslog(LOG_ERR, "socket: %m");
    return (0);
    } else {
    if ((fp = fdopen(s, "r+")) == 0) {
        syslog(LOG_ERR, "fdopen: %m");
        close(s);
    }
    return (fp);
    }
}

/* bind_connect - bind both ends of a socket */

int     bind_connect(s, local, remote, length)
int     s;
struct sockaddr *local;
struct sockaddr *remote;
int     length;
{
    if (bind(s, local, length) < 0) {
    syslog(LOG_ERR, "bind: %m");
    return (-1);
    } else {
    return (connect(s, remote, length));
    }
}

/* timeout - handle timeouts */

static void timeout(sig)
int     sig;
{
    longjmp(timebuf, sig);
}

/* rfc931 - return remote user name, given socket structures */

char   *rfc931(rmt_sin, our_sin)
struct sockaddr_in *rmt_sin;
struct sockaddr_in *our_sin;
{
    unsigned rmt_port;
    unsigned our_port;
    struct sockaddr_in rmt_query_sin;
    struct sockaddr_in our_query_sin;
    static char user[256];        /* XXX */
    char    buffer[512];        /* XXX */
    char   *cp;
    static char *result;    /* XXX */
    FILE   *fp;

    result = FROM_UNKNOWN;
    /*
     * Use one unbuffered stdio stream for writing to and for reading from
     * the RFC931 etc. server. This is done because of a bug in the SunOS
     * 4.1.x stdio library. The bug may live in other stdio implementations,
     * too. When we use a single, buffered, bidirectional stdio stream ("r+"
     * or "w+" mode) we read our own output. Such behaviour would make sense
     * with resources that support random-access operations, but not with
     * sockets.
     */

    if ((fp = fsocket(AF_INET, SOCK_STREAM, 0)) != 0) {
    setbuf(fp, (char *) 0);

    /*
     * Set up a timer so we won't get stuck while waiting for the server.
     */

    if (setjmp(timebuf) == 0) {
        signal(SIGALRM, timeout);
        alarm(rfc931_timeout);

        /*
         * Bind the local and remote ends of the query socket to the same
         * IP addresses as the connection under investigation. We go
         * through all this trouble because the local or remote system
         * might have more than one network address. The RFC931 etc.
         * client sends only port numbers; the server takes the IP
         * addresses from the query socket.
         */

        our_query_sin = *our_sin;
        our_query_sin.sin_port = htons(ANY_PORT);
        rmt_query_sin = *rmt_sin;
        rmt_query_sin.sin_port = htons(RFC931_PORT);

        if (bind_connect(fileno(fp),
                 (struct sockaddr *) & our_query_sin,
                 (struct sockaddr *) & rmt_query_sin,
                 sizeof(our_query_sin)) >= 0) {

        /*
         * Send query to server. Neglect the risk that a 13-byte
         * write would have to be fragmented by the local system and
         * cause trouble with buggy System V stdio libraries.
         */

        fprintf(fp, "%u,%u\r\n",
            ntohs(rmt_sin->sin_port),
            ntohs(our_sin->sin_port));
        fflush(fp);

        /*
         * Read response from server. Use fgets()/sscanf() so we can
         * work around System V stdio libraries that incorrectly
         * assume EOF when a read from a socket returns less than
         * requested.
         */

        if (fgets(buffer, sizeof(buffer), fp) != 0
            && ferror(fp) == 0 && feof(fp) == 0
            && sscanf(buffer, "%u , %u : USERID :%*[^:]:%255s",
                  &rmt_port, &our_port, user) == 3
            && ntohs(rmt_sin->sin_port) == rmt_port
            && ntohs(our_sin->sin_port) == our_port) {

            /*
             * Strip trailing carriage return. It is part of the
             * protocol, not part of the data.
             */

            if ((cp = strchr(user, '\r')))
            *cp = 0;
            result = user;
        }
        }
        alarm(0);
    }
    fclose(fp);
    }
    return (result);
}
