/* virtppp.cmd */

/*
Version:     1.0b
Date:        Jan 21, 1996
By:          Jack Snodgrass - jack@cyberloans.com

The following Rexx .cmd file will set up a number of PPP ports ( default is
1... max is 10 because of a OS/2 PPP Limitation ) ( The warp server GA
code should increase this max of 10 to 32. )There are a couple of
assumptions.

   1). You have have a loopback port defined and it's IP Address is
       127.0.0.1. Do an 'ifconfig lo' to make sure you've got this
       set up. If you don't make sure and do a 'ifconfig lo 127.0.0.1'
       and then route your own ip address to the loopback port... i.e.
       'route add host my-ipaddress 127.0.0.1 0' Both of these lines are in
       my '\mptn\bin\setup.cmd' file.

    2). You have a dedicated IP Address for each Virtual Host for your Web
       Server. If you don't have an IP Address for each virtual host, you
       can't use a Virtual Host. Your lan ( or ISP ) needs to know to route
       all of your Virtual Host IP Addresses to your system. You 'may' be
       able to do an 'ARP PUB' ( arp publish ) for each IP Address, but I
       haven't tried that. All of my IP Addresses are routed to my main
       OS/2 box.

    3). You find the lines:

        yourbase   = 'xxx.xxx.xxx'
        youroffset = 'x'
        comport    = 'comx'

        in this file and put your info in in the quotes. The quotes
        ARE required. See the comments prior to the lines for an
        explanation.
	
	NOTE: You can use an SIO virtual port instead of a real COM port.
	I use the line:
        DEVICE=C:\SIO.SYS (4, INTERNET, NONE)
        to define COM4 as a virtual COM port. I use COM4 to define all of
        my Virtual PPP ports.


    4). You already have the Virtual Host stuff in the httpd.conf file
       configured.

    5). Guess that about covers it. To test this ( the routing of the
       virtual PPP Ports out, you need to do a ping on each IP Address
       both locally and from a remote system. If the ping does not come
       back to you, then your are NOT going to get the httpd virtual
       host stuff to work. Figure out why ping doesn't work first.

    6). If you get an error from httpd about running out of file handles,
        OR httpd traps in DOSCALLS.DLL when you start... you need to
        issue the command SET EMXOPT=-h25 to add 25 file handles to your
        httpd session. If you want to add more, then use a bigger
        number than 25.

    7). Now... that is it I think. Let me know if you have any updates to
        these instructions. Jack - jack@cyberloans.com
*/

parse arg inargs
parse var inargs . '-c' cnt .
parse var inargs . '-s' start .

if cnt = "" & start = "" then signal helpme
if cnt \= "" then
   if datatype(cnt) \= 'NUM' then signal helpme
if start \= "" then
   if datatype(start) \= 'NUM' then signal helpme

if cnt = "" then cnt = 1
if cnt > 10 then cnt = 10

if start = "" then start = 0;

/* Load the REXXUTIL Function package. */
   call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   call SysLoadFuncs

/*************************************************************************\
 yourbase is the first 3 octects of your IP Address. ex 111.222.111
 youroffset is the start of the last octect where your PPP ports will
 start. So.... if your going to use 111.222.111.1 - 111.222.111.4, then
 you need:
 yourbase   = '111.222.111'
 youroffset = '1';
 below.

 comport is the com port that you want to use for this.

\*************************************************************************/
yourbase   = 'xxx.xxx.xxx'
youroffset = 'x'
comport    = 'comx'

if yourbase = 'xxx.xxx.xxx' then do
   Say 'You must edit this file and customize it for your site!'
   Say 'yourbase was not changed correctly.'
   exit
end

if youroffset = 'x' then do
   Say 'You must edit this file and customize it for your site!'
   Say 'youroffset was not changed correctly.'
   exit
end

if comport = 'comx' then do
   Say 'You must edit this file and customize it for your site!'
   Say 'comport was not changed correctly.'
   exit
end

do x = start to (cnt + start - 1)
   ppp = 'ppp' || x
   'start "'|| ppp || '" ppp' comport 'silent'
   rc = syssleep(1)
   'ifconfig' ppp yourbase || '.' || youroffset + x '131.131.131.'|| x + 1
   rc = syssleep(1)
   'route add' yourbase || '.' || youroffset + x '127.0.0.1 0'
   rc = syssleep(1)
end
exit

HelpMe:
   Say 'There is not much help... Sorry. There are two arguments than can'
   say 'be passed to the program. You must supply one or both of them.'
   say''
   say '"-c count" where count is the number of ppp sessions you want'
   say 'to start.'
   say ''
   say '"-s start" where start is the nuber of ppp sessions you have'
   say 'currently running. i.e. if you don''t use PPP, then start will be'
   say '0.'
   say ''
   say 'So... if you want to have 4 PPP sessions going and you already have'
   say 'ppp0 active with a PPP Link, you need to do:'
   say 'virtppp -c 4 -s 1'
   say ''
   say 'Check the .cmd comments or Send e-mail to jack@cyberloans.com if you'
   say 'need more help.'
   say ''
   say 'Thanks - Jack Snodgrass - jack@cyberloans.com'
exit
