/* An OS/2 REXX script to terminate the currently running Apache for OS/2. */
/* The one paramter is the location of the HTTPD.PID file as specified by  */
/* the 'PidFile' command in HTTPD.CONF file. If the parameter is not       */     
/* specified it assumes '..\logs\httpd.pid'                                */

/* NOTE: This program must be run from the computer currently running      */
/*       Apache for OS/2. It can not be run accros a LAN                   */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* Handle paramters or set default. */
if arg() = 1 then 
    if ( (translate(arg(1)) = "HELP") | (left(translate(arg(1)),2) = "-H") | (arg(1) = "?") ) then
        signal USAGE
    else
        pidfile = arg(1)
if arg() > 1 then
    signal USAGE
if ((arg() = 0) | (strip(pidfile) = "")) then
    pidfile = "..\logs\httpd.pid"

/* Test for existance of PID file */
result = SysFileTree(pidfile, filefound, "F")
if result>0 then
    signal ERROR
if filefound.0 \= 1 then
    signal NOTFOUND

/* Get the PID for the PIDFILE. */
pid = strip(linein(pidfile))

/* Reinit Apache. */
'@emxkill 1' pid

RETURN

USAGE:
SAY
SAY "Usage: REINIT <httpd.pid path>"
SAY
EXIT

ERROR:
SAY
SAY "An ERROR has occured."
SAY
EXIT

NOTFOUND:
SAY
SAY "PID file '"pidfile"' not found."
SAY
EXIT

