/*
YDINSTL.CMD v 0.9 (beta) by Jerry Levy 	20 Jul 96
Comments appreciated: send to jlevy@ibm.net
(Jerry Levy, Marblehead, MA)
*/
version = '0.9(beta)'
/*
================WHAT DO WE DO?================================
YDINSTL.CMD v. 0.9(beta) is distributed as part of .ZIP archive YRNDL13.ZIP.

YDINSTL.CMD is a Rexx program to install YARNDIAL.

YARNDIAL is a program to automate the use of YARN and SOUPER
It serves as a front end for C.T. Huang's OS/2 Souper and Yarn programs. 

YD.DOC is documentation for both the installer and YARNDIAL.

README.1ST is YD.DOC boiled down to essentials.
 
This installer goes out and fetches parameters required by
YARNDIAL.  Installations can be done for every yarn user you
have set up.  Read YD.DOC to learn more about setting up for
multiple users (A different "user" could be a different ID,
an installation for a different internet provider, or a
different internet connection mode for a given ID).

Each different user for which you set up YARN has been assigned
its own home directory and you can (should) do an install with
YDINSTL.CMD for each.  For each installation, separate Desktop
objects are created which are named to uniquely tie them to a
particular installation.  For each installation, a unique
parameter file (YD_PARMS.DAT) is created and stored in the
home directory.

YDINSTL.CMD also creates a suite of useful Rexx .CMD utilities
which are placed in the home directory also.

This YDINSTL.CMD is distributed with YARNDIAL v1.3.  It will not
work with previous versions of YARNDIAL (v. 1.0 and 1.1).

===========History============
20 Jul 96 v. 0.9 (first beta)
==============================

==========COPYRIGHT NOTICE AND DISCLAIMER=============
YDINSTL.CMD is Copyright 1996 by Jerry Levy (all rights reserved)
YARNDIAL.CMD is Copyright 1995 and 1996 by Jerry Levy (all rights reserved)

These are provided as-is and without charge, with no warranty expressed
or implied as to merchantability or fitness for any particular purpose.  All
responsibility for any and all incidental and consequential damages is
disclaimed.  These programs and associated text files are freeware.  They
may be distributed without restriction providing: (1) this notice and
disclaimer remain intact, (2) all programs and files are included and
unchanged, and (3) they are distributed either in the original .zip archive
or the archive after being unzipped into a folder or onto a disk or other
medium.  Use of either or both of these programs constitutes acceptance
of these terms by all users.
======================================================
*/

bs = d2c(8)
tab = d2c(9)			/* Backspace */
cr = d2c(13)			/* enter key, as well as carriage return */
crlf = d2c(13) || d2c(10)	/* carriage return + linefeed */
escape = d2c(27)		/* escape character */
X1 = d2c(0)			/* Extended key */
X2 = d2c(224)			/* Extended key */

/* Load RexxUtil if not already loaded */
if RxFuncQuery('SysLoadFuncs') \= 0 then
   do
      call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
      call SysLoadFuncs
   end

candidate = ''
encrypt = 0
parse arg instr candidate
if translate(instr) = 'ENCRYPT' then
   do
      call SysCls
      say ''
      encrypt = 1
      call encry
      exit
   end

/* Initialize these (except yarnshell_ico).  These are files
used by or created during installation */
yd_doc = 'YD.DOC'			/* documentation file */
readme_1st = 'README.1ST'		/* shorter one */
ydparms_dat = 'YD_PARMS.DAT'	/* where we will store parameters */
yd_cmd = 'YARNDIAL.CMD'		/* this is the YarnDial file we are installing for */
ydinstl_cmd = 'YDINSTL.CMD'		/* and this is us, the installer */
yarn_ico = 'YARN.ICO'			/* the Yarn icon (courtesy of C.T. Huang) */
yarnshell_ico = yarn_ico		/* ...which we use more than once */
yarndial_ico = 'YARNDIAL.ICO'	/* the YarnDial icon */
ydfold1_ico = 'YDFOLD1.ICO'		/* for our desktop folder: icon for when it is closed */
ydfold2_ico = 'YDFOLD2.ICO'		/* for our desktop folder: animated icon, folder when open */ 
yarnutil_ico = 'YRNUTIL.ICO'		/* for yarnutil_cmd */ 
logoff_ico = 'LOGOFF.ICO'		/* for logoff_cmd */ 
renewzip_ico = 'RENEWZIP.ICO'	/* for renewzip_cmd */ 
ydinstl_ico = 'YDINSTL.ICO'		/* for ydinstl_cmd */

signal on failure
signal on halt
signal on syntax
signal on notready
signal on error

Trace 'N'

call time 'R'
yd_cmd_v = '2.0'

/*
============================
We use Abandon=1 returned by a subroutine
as a signal to abort.  We abort by making a
conditional call to exit in the caller routine,
example:     if Abandon then signal goodbye()
============================
*/
   Abandon = 0

/* Completed flag will be set to 1 when we are done */
   completed = 0

/* We count file-search errors */
   findfile_ErrNum = 0

Upcase = xrange('A', 'Z')	/* Translation tables we use for going */
Lowcase = xrange('a', 'z')	/* from upper to lower case or vice-versa */

parse source with this_pgm
/* This program including path is last word.  Extract its
path, stripping out a final \ */

this_pgm = word(this_pgm, words(this_pgm))
source_drive = filespec('drive', this_pgm)
source_subdir = filespec('path', this_pgm)
source_path = source_drive || source_subdir
source_path = strip(source_path, 'T', '\')
source_path = translate(source_path)
x = SetLocal()

'@echo off'			/* do not echo OS/2 commands */
call welcome_to_this_installer	/* big welcome message */
call initialize_variables

/* do we use the IAK Dialer, the Dial-Other-
Internet-Providers utility, or a dialup string? */
call get_connection_type
call get_ini_paths		/* for dialer.ini and tcpos2.ini */
call find_yarn_home_dir		/* set as an os/2 environment variable? or we can specify it */ 
call find_yarn_dir		/* YARN, set as an os/2 environment variable */

/* get tcpos2ini_app, name in SLIPPM setup for the provider we use */
if pos(connection_type, 'x234') \=0 then
    tcpos2ini_app = get_dial_other_providers_app(tcpos2_ini)

/* If connection_type = 5 we need to get some information */
if connection_type = 5 then
   do
      call get_userID_and_domain
      call are_we_SLIP_or_PPP
   end

/* read in some assignments from the Yarn CONFIG file */
call get_parms_from_yarn_config

/* dialer.ini stores the IAK Dialer parameters... */
if connection_type = 1 then
do
   call get_parms_from_advantis_dialerini
   call get_adv_password
end

/* ...whereas tcpos2.ini stores all of the slippm parameters */
if pos(connection_type, 'x234') \=0 then
   call get_parms_from_tcpos2ini

/* What kind of compression utilities? InfoZip's? PkWare's? others'? */
call whose_zips_are_we_using

/* Do searches for files we need.  Gets full paths */
call search_for_files

/* For connection_type 1, 2 and 4 we construct dialup_string
and store it in YD_PARMS.DAT */

if connection_type = 1 then
   dialup_string ='''start' IAKdialer_exe || ''' account user password'

if connection_type = 2 then
   dialup_string ='''start' slippm_exe || ''' tcpos2ini_app'

if connection_type = 4 then
   dialup_string = 'do;',
                   '''' || injoy_drive || ''';',
                   '''cd' injoy_dir || ''';',
                   '''start /c' injoy_exe || ''' tcpos2ini_app;',
                   'end'

/* Tailor how you want souper to run: can modify some command-line options */
call souper_options

/* How many seconds before dialer times out (for connection_type 1, 2, and 3) */
call get_dialer_timeout_wait

/* Up to this point, no changes have been made.  A chance
to exit the install at this point without making any changes */
call chance_to_quit

/* Create the YD_PARMS.DAT file where all our parameters go.
YARNDIAL.CMD uses this file as a setup file */
call output_dat

/* Copy files over from installation directory to home dir */
call copy_ydfiles

/*
==============
We create a suite of five customized REXX utilities on the HOME directory.

YARNSHELL.CMD:  Runs YARN.EXE from the correct environment for this user

YARNUTIL.CMD:  Run any yarn utility pgm for this user

RENEWZIP.CMD:  Restores the reply_packet .ZIP file (backed up during
   an attempt to export) for a re-try later (RENEWZIP.CMD), again for this user

LOGOFF.CMD:  Provides a convenient way to log off

OBJECTS.CMD:  Restores a folder object and contents (objects for the four
.CMD files above, plus an object for YarnDial.CMD, for this user installation
==============
*/
call create_yarnshell_cmd
call create_yarnutil_cmd
call create_logoff_cmd
call create_renewzip_cmd
call create_yarndial_objects

/* Finally we create a Rexx pgm to recreate objects */
call recreate_objects_cmd
signal goodbye		/* cleanup and exit */
EXIT
/*
==============================================
End of Main Program
==============================================
*/

/*
==============================================
get_connection_type()

Are we installing for a connection to Advantis
via the IAK Dialer
   or
a connection via either SLIP or PPP using the
Dial-Other-Internet-Providers Utility?
==============================================
*/
get_connection_type:
edit_dialup_string_msg =  ''	/* initialize to a blank */
call SysCls
say ''
say 'CONNECTION-TYPE SCREEN'
say 'Must select the type of connection you will be making'
say ''
say 'Choose how you will dial in to connect:'
say '  1 With the IAK Internet Dialer to connect to Advantis (SLIP)'
say '  2 Using SLIPPM=the Dial-Other-Internet-Providers utility'
say '    (whether for a SLIP or PPP connection)'
say '  3 My own slip.exe or ppp.exe dialup string or some dialup'
say '    string that uses ppp.exe or slip.exe (e.g., slppm.exe does)'
say '  4 Using the IN-JOY Dialer'
say '  5 I will try to set up' ydparms_dat 'manually (read' yd_doc || '),'
say '    but help me do a partial setup'
say ''
say ' FOR OPTIONS 2, 3 or 4: Dial-Other-Internet-Providers utility'
say ' (i.e., SLIPPM.EXE) <<MUST>> be configured properly, even if'
say ' you will use your own dial-in string or IN-JOY to dial up.'
say ' Reason: SLIPPM stores parameters that we need where we can'
say ' get at them.'
say ''
do until connection_type = pos(connection_type, '12345')
   say ''
   prompt = 'Select 1-5 or Escape to quit:'
   say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = 0
      call SysCurPos row, col
   connection_type = SysGetKey('NOECHO')
   if connection_type = escape then signal goodbye
end

if connection_type = 1 then
   do
      service = 'SLIP'
      say 'Selected: Advantis (IAK Dialer)                    '
   end
if connection_type = 2 then
   do
      say 'Selected: Dial-Other-Internet-Providers (D-O-I-P)                            '
   end                  
if connection_type = 3 then
   do
      say 'Selected: Dialup with a ppp.exe or slip.exe dialup string'
      edit_dialup_string_msg = crlf ||,
         'Remember to fill in the dialup_string called for in' ydparms_dat
   end     
if connection_type = 4 then
   do
      say 'Selected: IN-JOY dialer                                          '
   end     
if connection_type = 5 then
   do
      say 'Selected: Mostly manual configuraltion of' ydparms_dat
      edit_dialup_string_msg = crlf ||,
         'Remember to manually revise (edit)' ydparms_dat
/* Identify some parameters in YD_PARMS.DAT to be edited */
      dialup_string='**Fill in.  Or leave blank if you will not be dialing up.**'
      DEFAULT_NEWS='**News Server, example:   netnews.worldnet.att.net**'
      MAIL_GW='**Mail Gateway=SMTP Server, example:   mailhost.worldnet.att.net**'
      POPSRVR='**POP3 Server, example:   postoffice.worldnet.att.net**'
      adv_password = '**Run YDINSTL encrypt MyPassword to encrypt for insertion**'
      PWD = '**Run YDINSTL encrypt MyPassword to encrypt MyPassword for insertion**'
      POP_PWD = '**Run YDINSTL encrypt MyPassword to encrypt MyPassword for insertion**'
   end     
say ''
say 'Escape quits.  Press any other key to continue'
if SysGetKey('ECHO') = Escape then signal goodbye
RETURN


/*
==============================================
Determine paths to DIALER.INI and TCPOS2.INI
==============================================
*/
get_ini_paths:
dialerini_exists = 0
tcpos2ini_exists = 0
tcpip_etc_path = value('etc', , 'OS2ENVIRONMENT')
dialer_ini = tcpip_etc_path || '\' || 'dialer.ini'
if stream(dialer_ini, 'c', 'query exists') \= 0 then
   do
      dialerini_exists = 1
   end
tcpos2_ini = tcpip_etc_path || '\' || 'tcpos2.ini'
if stream(tcpos2_ini, 'c', 'query exists') \= 0 then
   do
      tcpos2ini_exists = 1
   end
RETURN

/*
==============================================
Locate the Yarn HOME directory.  It could be set as an
OS/2 environmental variable, but if it isn't, prompt us
for it.  You can install Yarn with separate home directories
for each user.  A lot of other applications set up HOME
as an environmental variable so the home directory in the
OS/2 environment may not be the correct one for this
installation.

To determine if we have the right home directory we look
for Yarn's config file which is located in home's /yarn/
subdirectory.
==============================================
*/
find_yarn_home_dir:
/* Get the Yarn Home Directory */
entry = ''	/* initialize it to a blank */

call SysCls
say ''
say 'YARN''s HOME DIRECTORY Screen'

home = value('home', , 'OS2ENVIRONMENT')
home = translate(home)
yarn_config = home || '\yarn\config'
if home = '' then
   do
      say ''
      say 'Unable to find HOME as an OS/2 environment variable.'
      say 'That means you did not include a SET HOME statement in'
      say 'config.sys or you did not reboot after modifying config.sys.'
      say 'You will be able to enter a HOME directory name.'
      say ''
   end
if stream(yarn_config, 'c', 'query exists') \= '' then
   do
      say ''
      say 'We found' home 'as a possible YARN home directory.'
      say ''
      say 'You may have set up Yarn with more than one user'
      say 'and more than one home directory or this could be'
      say 'another program''s home directory.'
      say ''
      say 'To accept   ' home '   as the home directory press ENTER,'
      say 'or key in the full path of the Yarn HOME directory you wish'
      prompt = 'to do this installation for:'
         say prompt
         parse value SysCurPos() with row col
         row  = row - 1
         col = length(prompt) + 2
         call SysCurPos row, col
      parse upper pull entry
   end 
if entry \= '' then home = entry
home = strip(home, 'B')
yarn_config = home || '\YARN\CONFIG'
do forever
   if stream(yarn_config, 'c', 'query exists') \= '' then
      do
         leave
      end
         say ''
         say 'Unable to find' yarn_config '(HOME dir is in error)'
         say ''
         if home \= '' then
            do
               say translate(home) 'as HOME directory is in error'
            end
         prompt = 'Enter correct Yarn HOME directory path now:'
         say prompt
            parse value SysCurPos() with row col
            row  = row - 1
            col = length(prompt) + 2
        call SysCurPos row, col
        pull entry
        entry = strip(entry, 'T', '\')	/* strip any trailing \ if entered */
        home = entry
        yarn_config = home || '\yarn\CONFIG'
end

yarn_config = home || '\yarn\CONFIG'
yarn_config = translate(yarn_config)
home_drive = filespec('drive', yarn_config)
home_drive = translate(home_drive)
ydparms_dat = home || '\' || ydparms_dat
ydparms_dat = translate(ydparms_dat)

say ''
say 'Installing for' home 'as the Yarn HOME directory.'
say ''
say ''
say 'OK.  Press any key to continue'
call SysGetKey 'NOECHO'
RETURN

/*
==============================================
Where is the Yarn directory?

We look for yarn in the OS/2 environment.  If we don't
find it we exit install.  All of the yarn files should
be there:
   import.exe
   export.exe
   rebuild.exe
   expire.exe
   yarn.exe      and more
but we search for yarn.exe to verify it is (probably)
a valid YARN directory.
==============================================
*/

find_yarn_dir:
/* Get the Yarn Directory */
entry = ''	/* initialize it to a blank */

call SysCls
say ''
say 'YARN DIRECTORY'
say '(Directory where most of the YARN programs are kept)'

yarn = value('yarn', , 'OS2ENVIRONMENT')
yarn = translate(yarn)
yarn_exe = yarn || '\' || yarn_exe
if yarn = '' then
   do
      say 'Unable to find YARN as an OS/2 environment variable.'
      say 'That means you did not include a SET YARN statement in'
      say 'config.sys or you did not reboot after modifying config.sys.'
      say 'You will be able to enter a YARN directory name.'
      say ''
   end
if stream(yarn_exe, 'c', 'query exists') \= '' then
   do
      say ''
      say 'We found' yarn 'as a possible YARN directory.'
      say ''
      say 'You may have set up Yarn with more than one YARN'
      say 'directory or this could be a temporary directory'
      say 'you used to install YARN.'
      say ''
      say 'To accept   ' yarn '   as the YARN directory press ENTER,'
      say 'or key in the full path of the YARN directory you wish'
      prompt = 'to do this installation for:'
         say prompt
         parse value SysCurPos() with row col
         row  = row - 1
         col = length(prompt) + 2
         call SysCurPos row, col
      parse upper pull entry
   end 
if entry \= '' then yarn = entry
yarn = strip(yarn, 'B')
yarn_exe = filespec('name', yarn_exe)	/* get back to name only */
yarn_exe = yarn || '\' || yarn_exe	/* reconstruct fully qualified path */

do forever
   if stream(yarn_exe, 'c', 'query exists') \= '' then
      do
         leave
      end
         say ''
         say 'Unable to find' yarn_exe '(YARN dir is in error)'
         say ''
         if yarn \= '' then
            do
               say translate(yarn) 'as YARN directory is in error'
            end
         prompt = 'Enter correct YARN directory path now:'
         say prompt
            parse value SysCurPos() with row col
            row  = row - 1
            col = length(prompt) + 2
        call SysCurPos row, col
        pull entry
        entry = strip(entry, 'T', '\')	/* strip any trailing \ if entered */
        yarn = entry
        yarn_exe = filespec('name', yarn_exe)	/* get back to name only */
        yarn_exe = yarn || '\' || yarn_exe		/* this is what we look for */
end

yarn_exe = yarn || '\' || yarn_exe		/* this is what we look for */  
yarn_exe = translate(yarn_exe)
yarn_drive = filespec('drive', yarn_exe)
yarn_drive = translate(yarn_drive)
yarn_path = yarn || '\'
home_path = home || '\'
yarn_exe = filespec('name', yarn_exe)  /* OK, again get back to name only */

souper_exe = yarn_path || souper_exe
yarn_exe = yarn_path || yarn_exe
import_exe = yarn_path || import_exe
export_exe = yarn_path || export_exe
expire_exe = yarn_path || expire_exe
rebuild_exe = yarn_path || rebuild_exe
go_exe = home_path || go_exe
yarn_drive = filespec('drive', import_exe)

say ''
say 'Installing for' yarn 'as the YARN directory.'
say ''
say ''
say 'OK.  Press any key to continue'
call SysGetKey 'NOECHO'
if connection_type = 1 then say 'Password module loading...'
RETURN

/*
==============================================
get_dial_other_providers_app()

If you are making a PPP or SLIP connection using the
Dial-Other-Internet-Providers utility, we will have your
"application" (i.e., the setup you did for your provider
in the tcpos2.ini file.  Here you can select which
application you are installing for.  Be careful, there
are "applications" here that are not related to a
specific provider setup.
==============================================
*/
get_dial_other_providers_app:
arg inifile
call SysCls
say ''
say 'DIAL_OTHER_INTERNET_PROVIDERS SCREEN'
say ''
result = SysIni(inifile, 'ALL:', 'apps')
if result \= 'ERROR:' then
   do j = 1 to apps.0
      say j apps.j
   end
say '     Select the item above by number which'
say '     is the Dial-Other-Internet-Provider application for'
say '     this installation.'

do until DataType(DOIP, 'W') & DOIP > 0 & DOIP < j
   prompt = 'Selection:' 
   say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = length(prompt) +2
      call SysCurPos row, col
   parse pull DOIP
   if \DataType(DOIP, 'W') | DOIP <1 | DOIP > j-1 then
   do
      say 'Must be 1-' || j-1
   end
end
say ''
say 'Selected Application:' apps.DOIP
say ''
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'
say 'Please wait while parameters are being loaded...'
RETURN apps.DOIP

/*
==============================================
whose_zips_are_we_using()

You can select which kind of compression and
uncompress utilities you use.  The os/2 InfoZip
ports are recommended.
==============================================
*/
whose_zips_are_we_using:
/* Get path to zip files, also specify which we use */
zip_type = 0
call SysCls
   say ''
   say 'COMPRESSION/UNCOMPRESSION SCREEN'
   say ''
   say 'Select which type of compress and uncompress programs'
   say 'you will use.  You must use them.  Recommended is the OS/2'
   say 'port of InfoZip compression and uncompression programs.  You'
   say 'can also select to use the MS-DOS PkWare programs.'
   say ''
   say 'Select from among:'
   say '1  OS/2 InfoZip series (e.g., from zip201c2.zip and unz512x2.zip'
   say '   archives, or later versions)'
   say '2  MS-DOS PkWare (e.g., from the PKZ204G.ZIP archive)'
   say '3  Any other type, whether OS/2 or MS-DOS based'
   say '(ESC exits install program now)'
do until pos(zip_type, '123') \= 0
   prompt = 'Select 1, 2, or 3:'
   say prompt
   zip_type = SysGetKey('NOECHO')
   select
      when zip_type = Escape then signal goodbye
      when zip_type = 1 then
         do
            say ''
            file_msg1 = 'OS/2 InfoZip' /* This is the default */
            say 'Selected: ' file_msg1
            zip_exe = os2_zip_exe
            zip_options = os2_zip_options
            unzip_exe = os2_unzip_exe
            unzip_options = os2_unzip_options
         end
      when zip_type = 2 then
         do
            say ''
            file_msg1 = 'MS-DOS PkWare'
            say 'Selected: ' file_msg1
            zip_exe = msdos_zip_exe
            zip_options = msdos_zip_options
            unzip_exe = msdos_unzip_exe
            unzip_options = msdos_unzip_options
         end
      when zip_type = 3 then
         do
            zip_exe = ''
            unzip_exe = ''
            say ''
            say 'Selected: (OTHER)'
            say 'You will need to edit the zip_exe and unzip_exe entries'
            say 'in' ydparms_dat 'after installation is complete.'
            say 'Refer to' yd_doc 'for help on how to customize for'
            say 'other compression and uncompression utilities.'
         end
      when pos(zip_type, '123') = 0 then
         do
            say ''
            say ''
            say 'You may only enter 1,2 or 3 (or press ESC to quit)'
            say ''
         end
      otherwise NOP
   end
end
say ''
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'
RETURN

/*
=====================================      
search_for_files()

We search for various files with calls to the
file_locator() routine.  In the case of the zip and
unzip files, we also attach their option strings.
=====================================      
*/

search_for_files:
/* The flag Abandon is returned = 1 if the file_locator() routine encounters a request to abort */

zip_exe = file_locator(zip_exe)
if Abandon then signal goodbye
unzip_exe = file_locator(unzip_exe)
if Abandon then signal goodbye
souper_exe = file_locator(souper_exe)
if Abandon then signal goodbye
if connection_type \= 4 then
   do
      call SysCls
      say ''
      say 'You did not select the IN-JOY dialer, but we will search'
      say 'for IN-JOY''s utility, KILLJOY.EXE, anyway.  That way,'
      say 'if KILLJOY is on your hard-disk, the LOGOFF utility that'
      say 'YDINSTL creates will be as useful as possible.'
      say 'No problem is created if we cannot find KILLJOY.EXE' 
      say ''
      say 'Press any key to continue'
      call SysGetKey 'NOECHO'
   end
killjoy_exe = file_locator(killjoy_exe)
if connection_type = 4 then
   do
      if Abandon then signal goodbye
      injoy_exe = file_locator(injoy_exe)
      if Abandon then signal goodbye

/* get the drive and construct path to in-joy.exe */
      injoy_drive = filespec('drive', injoy_exe)
      injoy_dir = injoy_drive || strip(filespec('path', injoy_exe), 'T', '\')
   end
zip_exe = zip_exe zip_options
unzip_exe = unzip_exe unzip_options
say 'Patience...'  /* sometimes the next step takes a while to start */
RETURN

/*
=====================================================
file_locator()

is a file finder that not only searches all available
local drives for all instances found of that file, but
provides a menu allowing you to select a single instance.
If the filename being searched for has been fed to the
routine with arguments or with a fully qualified path,
the path and all arguments are stripped out so only
the pure filename itself is searched.


Syntax: file_locator(filename)

Returns the fully qualified path of the instance you
select if at least one instance is found, or returns
a blank ('') if none is found.  If only one instance
is found, it is automatically selected (you get no
menu, but you do get a 'found' notice).

The exposed variables in this procedure are
   instances		Number of occurrences found
   file_selected	The single instance we chose
   unfound_file.	Stem in case of an error...
   findfile_ErrNum 	...index for the stem1
(an unfound file is unfound_file.findfile_ErrNum)
   Abandon		a flag. If = 1 the calling program should exit 
=====================================================
*/
file_locator: procedure expose,
          instances,
          file_selected,
          unfound_file.,
          findfile_ErrNum,
          Abandon

parse upper arg filename

escape = d2c(27) 			/* escape character */
file_spec = filespec('name', filename)
call SysCls
say ''
say ''
say ''
say ''
say 'Searching for' file_spec
say ''
say 'Search is restricted to local drives only.'
say 'Remove media from local CD-ROM drives and other'
say 'removable-media drives or we will search them, too.'
say ''

map = SysDriveMap( , 'LOCAL')
drives = words(map)
instances = 0
do i = 1 to drives
   drive.i = word(map, i)
   if SysDriveInfo(drive.i) = '' then iterate
   prompt = 'Searching' drive.i
   say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = 0
      call SysCurPos row, col
   filsp = drive.i || '\' || file_spec	/* filespec with path */
   rc = SysFileTree(filsp, 'file', 'FS')
   do n = 1 to file.0
      instances = instances + 1			/* a counter */
      file_found.instances = file.n
   end
end

/*
==================
If instances=0, that means we found no instance(s)
of the file.  Maybe the file name is changed.  Error
message.  But we continue the install because maybe
the filename can be corrected by editing YD_PARMS.DAT
when we are done
=================
*/

if instances = 0 & connection_type \= 4 then
   do
      findfile_ErrNum = findfile_ErrNum +1
      call  beep 262, 200
      say ''
      say ''
      
      say 'MAJOR ERROR:  we found no instances of' file_spec || '.'
      say 'Maybe the file name has been changed.  We'
      say 'can continue, hoping the error can be corrected'
      say 'by editing the name in the .DAT file that we create'
      say 'in the specific HOME directory we are installing for.'
      say ''
      say 'Or you can Escape and correct now (recommended).'
      say ''
      
/* This next line is for possible use in an error message
identifying this file which we can't find. */

      unfound_file.findfile_ErrNum = file_spec
      
      file_spec.instances = ''
      file_spec.instance_number = 'file_spec'
 
      prompt = 'Escape quits YDINSTL.  Any other key continues'
      say prompt
         parse value SysCurPos() with row col
         row  = row - 1
         col = length(prompt) + 2
         call SysCurPos row, col
      if connection_type \4 then
         if SysGetKey('NOECHO') = escape then Abandon = 1
   end

if instances > 1 | instances = 1 then	/* We list them all */
   do      
      say ''
      prompt = 'Found:  ' instances 'instance(s) of' file_spec
         parse value SysCurPos() with row col
         row  = row -1
         col = 0
         call SysCurPos row, col
      if instances > 1 then say prompt
      do i = 1 to instances
         parse var file_found.i date.i time.i size.i attrib.i file_spec.i
         date.i = right(date.i, 9)
         time.i = right(time.i, 7)
         size.i = right(size.i, 10)
         file_spec.i = strip(file_spec.i, 'B')
         if instances > 1 then say i date.i time.i size.i file_spec.i
         if i \= 0 & i // 15 = 0 & instances > i then
         do
            say '   There are more, press any key to continue'
            say '   If one of these is the right one, remember the number!!!'
            call SysGetKey 'NOECHO'
         end
      end
   end

if instances > 1 then	/* We prompt for which one to select */

   do until DataType(instance_number,'W') & instance_number < instances + 1
      prompt = 'Which is the correct file_spec to use?' 
      say prompt
      parse value SysCurPos() with row col
         row  = row -1
         col = length(prompt) +2
         call SysCurPos row, col
      if instances > 1 then
         do
            pull instance_number
            if \DataType(instance_number, 'W') then
               do
                  say 'Whole number only. Try Again.'
               end
            if instance_number > instances then
               do
                  say 'Cannot exceed' instances || '.  Try again.'
               end
         end
   end

/* If only one instance, we do not need
to prompt or select the menu number because
instance_number is 1.  */

if instances = 1 then
   do
      instance_number = 1
      say 'Found and selected one instance:'
      say date.1 time.1 size.1 file_spec.1
   end

if instances > 1 then say 'Selected:  ' file_spec.instance_number

if instances = 1 | instances > 1 then
   do
      say ''
      say 'Press any key to continue'
      call SysGetKey 'NOECHO'
      say ''
   end
say ''
say ''
file_selected = file_spec.instance_number
RETURN file_selected

/*
==============================================
get_parms_from_yarn_config()

Read the yarn config file.  Reconstitute lines that
have been continued on to the next line using
the \ continuation character, then pick out lines
with an = sign and that don't begin with the #
comment-out character.  Then set up the USER and
REPLY_PACKET variables.
==============================================
*/
get_parms_from_yarn_config:
n = 1
do while lines(yarn_config) > 0
    data_line = linein(yarn_config)
    line.n = data_line
    if pos('=', data_line) > 0 & \abbrev(line.n, '#') then
       do
          line.n = data_line
          if right(line.n, 1) = '\' then
             do until right(line.n, 1) \= '\'
                line_n_with_right_slash_stripped = strip(right(line.n,1), 'T', '\')
                next_data_line = linein(yarn_config)
                line.n = line_n_with_right_slash_stripped || next_data_line
             end
          n = n + 1
          number_of_reconstituted_lines = n
      end
end

j = 1
do until j = number_of_reconstituted_lines
   parse var line.j first.j '=' last.j
   do until first.j = stripped_F.j & last.j = stripped_L.j
      stripped_F.j = strip(first.j, 'B')
      first.j = strip(stripped_F.j, 'B', tab)
      stripped_L.j = strip(last.j, 'B')
      last.j = strip(stripped_L.j, 'B', tab)
   end

   select
      when abbrev(line.j, '#') then NOP
      when translate(first.j) = 'USER' then user = last.j
      when translate(first.j) = 'HOST' then host = last.j
      when translate(first.j) = 'REPLY-PACKET' then reply_packet = last.j
      otherwise NOP
   end
   j = j +1
end
RETURN

/*
==============================================
get_parms_from_advantis_dialerini()

Get selected parameters from dialer.ini (for the
Advantis IAK Dialer) for the application "user_user".
Example, my user ID is jlevy so for me user_user
is user_jlevy (all lower case) 
==============================================
*/
get_parms_from_advantis_dialerini:
/* Get parms from dialer.ini file.  The strip is of a final null character that for some reason gets fetched along with the parm */
user_user = 'user_' || user
   Upcase = xrange('A', 'Z')
   Lowcase = xrange('a', 'z')
   user_user = translate(user_user, Lowcase, Upcase) /* dialer.ini expects user_user to be all-lowercase */
adv_account = strip(SysIni(dialer_ini, user_user, 'act'), 'T', X1)
adv_newsserver = strip(SysIni(dialer_ini, user_user, 'ns'), 'T', X1)
adv_popserver = strip(SysIni(dialer_ini, user_user, 'ps'), 'T', X1)
adv_smtpserver = strip(SysIni(dialer_ini, user_user, 'sm'), 'T', X1)
connect_logfile = strip(SysIni(dialer_ini, 'AdvLog', 'Cfn'), 'T', X1)
ask = strip(SysIni(dialer_ini, user_user, 'ask'), 'T', X1)
gs = strip(SysIni(dialer_ini, user_user, 'gs'), 'T', X1)
ws = strip(SysIni(dialer_ini, user_user, 'ws'), 'T', X1)
dn1 = strip(SysIni(dialer_ini, user_user, 'dn1'), 'T', X1)
dn2 = strip(SysIni(dialer_ini, user_user, 'dn2'), 'T', X1)
is1 = strip(SysIni(dialer_ini, user_user, 'is1'), 'T', X1)
is2 = strip(SysIni(dialer_ini, user_user, 'is2'), 'T', X1)
rs1 = strip(SysIni(dialer_ini, user_user, 'rs1'), 'T', X1)
rs2 = strip(SysIni(dialer_ini, user_user, 'rs2'), 'T', X1)
fs1 = strip(SysIni(dialer_ini, user_user, 'fs1'), 'T', X1)
fs2 = strip(SysIni(dialer_ini, user_user, 'fs2'), 'T', X1)
md = strip(SysIni(dialer_ini, user_user, 'md'), 'T', X1)
pin = strip(SysIni(dialer_ini, user_user, 'pin'), 'T', X1)
emI = strip(SysIni(dialer_ini, user_user, 'emI'), 'T', X1)
RETURN

/*
==============================================
get_parms_from_tcpos2ini()

Similarly, get the parameters (all of them) for the
Dial-Other-Internet-Providers "application" you had
selected when the GET_DIAL_OTHER_PROVIDERS_APP()
routine was run.

These are located in the TCPOS2.INI file.  Xi is the
null character.  It is returned with every value and
we strip it out
==============================================
*/
get_parms_from_tcpos2ini:
/* Get parms from tcpos2.ini file in the same way. */
PROVIDER = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'PROVIDER'), 'T', X1)
LOGIN_ID = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'LOGIN_ID'), 'T', X1)
PWD = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'PWD'), 'T', X1)
SAVE_PWD = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'SAVE_PWD'), 'T', X1)
PHONE_NUMBER = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'PHONE_NUMBER'), 'T', X1)
HANGUP = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'HANGUP'), 'T', X1)
SCRIPT = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'SCRIPT'), 'T', X1)
SERVICE = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'SERVICE'), 'T', X1)
YOURIP = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'YOURIP'), 'T', X1)
DESTIP = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'DESTIP'), 'T', X1)
NETMASK = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'NETMASK'), 'T', X1)
MTU_SIZE = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'MTU_SIZE'), 'T', X1)
VJ_COMP = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'VJ_COMP'), 'T', X1)
HOSTNAME = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'HOSTNAME'), 'T', X1)
DOMAIN_NAME = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'DOMAIN_NAME'), 'T', X1)
DNS = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'DNS'), 'T', X1)
DEFAULT_NEWS = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'DEFAULT_NEWS'), 'T', X1)
DEFAULT_WWW = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'DEFAULT_WWW'), 'T', X1)
DEFAULT_GOPHER = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'DEFAULT_GOPHER'), 'T', X1)
MAIL_GW = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'MAIL_GW'), 'T', X1)
POPSRVR = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'POPSRVR'), 'T', X1)
REPLY_DOMAIN = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'REPLY_DOMAIN'), 'T', X1)
REPLY_ID = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'REPLY_ID'), 'T', X1)
POP_ID = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'POP_ID'), 'T', X1)
POP_PWD = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'POP_PWD'), 'T', X1)
MODEM_TYPE = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'MODEM_TYPE'), 'T', X1)
COMPORT = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'COMPORT'), 'T', X1)
BAUD = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'BAUD'), 'T', X1)
DATABITS = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'DATABITS'), 'T', X1)
PARITY = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'PARITY'), 'T', X1)
DIAL_MODE = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'DIAL_MODE'), 'T', X1)
PREFIX = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'PREFIX'), 'T', X1)
PREFIX_ANS = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'PREFIX_ANS'), 'T', X1)
INIT = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'INIT'), 'T', X1)
INIT2 = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'INIT2'), 'T', X1)
DISABLE = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'DISABLE'), 'T', X1)
DISABLE_SEQ = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'DISABLE_SEQ'), 'T', X1)
DIAL_PREFIX = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'DIAL_PREFIX'), 'T', X1)
AUTOSTART = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'AUTOSTART'), 'T', X1)
TOTAL_CONNECT = strip(SysIni(tcpos2_ini, tcpos2ini_app, 'TOTAL_CONNECT'), 'T', X1)
RETURN

/*
==============================================
get_userID_and_domain()

Prompt for this and verify
==============================================
*/

get_userID_and_domain:

call SysCls
say ''
say 'USER ID AND DOMAIN SCREEN'
say ''
say 'Enter UserID and domain in the form'
say '    userID@domain    (example: jlevy@ibm.net)'
say ''
userdomain = ''
match_userdomain = ''
do until match_userdomain = userdomain
   prompt = 'Enter userID with domain:'
   say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = length(prompt) + 2
      call SysCurPos row, col
      parse pull userdomain
   if userdomain = '' then userdomain = '(nothing entered)'
   say ''
   prompt = 'Enter it again:'
   say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = length(prompt) + 2
      call SysCurPos row, col
      parse pull match_userdomain
   if match_userdomain = '' then match_userdomain = '(nothing entered)'
   if match_userdomain \== userdomain then
      do
         say ''
         say match_userdomain 'does not match' userdomain
         say 'Try again'
      end
   if pos('@', userdomain) = 0 then
      do
         say 'Incorrect entry.  No @ symbol found'
         userdomain = 'A'; match_userdomain = 'B'
            /* these two assignments force inequality, and a reprompt */
      end 
   say ''
end
parse var userdomain user '@' domain_name
say 'user@domain_name is' user || '@' || domain_name
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'

RETURN

/*
=========================
are_we_SLIP_or_PPP()

Which are we?
=========================
*/
are_we_SLIP_or_PPP:
do until pos(service, 'SP') \= 0
   call SysCls
   say 'SLIP OR PPP?'
   say ''
   say 'Will this be a SLIP or PPP connection?'
   prompt = 'Enter S or P:'
   say ''
   say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = length(prompt) + 2
      call SysCurPos row, col
   service = translate(SysGetKey('ECHO'))
   say ''
   if service = 'S' then
      do
         say 'Selected:  SLIP'
      end
   if service = 'P' then
      do
         say 'Selected: PPP'
      end
   if pos(service, 'SP') = 0 then say 'Must enter either S or P.  Try again'
   say ''
end
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'
RETURN

/*
==============================================
get_adv_password()

Prompt for the Advantis password.
==============================================
*/

get_adv_password:

call SysCls
say ''
say 'ADVANTIS POP PASSWORD SCREEN'
say ''
say 'If you press enter instead of entering a password, '
say 'password is not stored and you will be prompted for one.'
say 'This is the Advantis pop password (for Advantis, it is the'
say 'Advantis password for everything, actually).'
say ''
say ''
do until match = adv_password
   prompt = 'Enter password:'
   say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = length(prompt) + 2
      call SysCurPos row, col
      call get_pw 'H'
   adv_password = password
   say ''
   prompt = 'Enter it again:'
   say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = length(prompt) + 2
      call SysCurPos row, col
      call get_pw 'H'
      match = password
   if match \== adv_password then say 'The two did not match'
   say ''
end
RETURN

/*
==============================================
get_pw()

The actual keyboard-entry routine is a modification
of one from the IBM Rexx Manual which is copyrighted
by IBM and is used here with permission.

get_pw() accepts the argument H, h, Hide, hide which
will echo * instead of the character.
==============================================
*/
get_pw: procedure expose password 

/* H or h or hide as argument echos chars as *
otherwise chars entered are echoed     */

parse upper arg hide_for_passwording
hide_for_passwording = abbrev(hide_for_passwording, 'H')

bs = d2c(8)
cr = d2c(13)			/* enter key, as well as carriage return */
escape = d2c(27)		/* escape character */
X1 = d2c(0)			/* Extended key */
X2 = d2c(224)			/* Extended key */

Valid = xrange(' ', '~') 
/* same as Valid = ' !"#$%&''()*+,-./0123456789:;',
         '<=>?@''ABCDEFGHIJKLMNOPQRSTUVWXYZ',
         '[\]^_abcdefghijklmnopqrstuvwxyz{|}~'
very nearly every common printable */ 
password = ''
MaxLength = 254

do forever
   ch = SysGetKey('NOECHO')
   select
      when ch = Escape then signal goodbye  /* Escape, so we quit immediately */
      when ch = cr	/* Enter key pressed */
         then do
            say ''	/* Give carriage return */
            leave
         end
      when ch = bs	/* Backspace */
         then if password = ''
            then call  beep 262, 200	/* Tell us no chars to bs over */
         else do	/* Overstrike a blank */
            call charout , bs bs 
            password = left(password, length(password)-1)
         end
 
                        /* All other characters */
      when pos(ch, Valid) > 0
         then if length(password) = MaxLength
            then call beep 262, 200
            else do
               if hide_for_passwording = 1 then call charout , '*'
               else call charout , ch
               password = password || ch
            end
      otherwise do 	/* Swallow next for Extended */
         if ch = X1 | ch = X2
            then call SysGetKey 'NOECHO'
         call  beep 262, 200
      end
   end
end
RETURN password 

/*
==============================================
get_dialer_timeout_wait()

When we dial in, how long before we let our dialer time out?
==============================================
*/
get_dialer_timeout_wait:
call SysCls
say ''
say 'SET DIALER TIMEOUT'
say ''
say 'Wait how many seconds before Advantis dialer times out.'
say 'Default: 120 seconds'
say '(usually allows both main and backup number to be attempted)'
say ''
prompt = 'Press Enter to accept default, or enter wait in seconds:' 
do until DataType(wait,'W')
   say prompt
      parse value SysCurPos() with row col
      row  = row - 1
      col = length(prompt) + 2
      call SysCurPos row, col
      pull wait .
      if wait = '' then
         do
            wait = 120
         end
      if DataType(wait) = 0 then say 'Whole number only. Try Again.'
      else say 'wait =' wait 'seconds'
end
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'
RETURN

/*
==============================================
souper_options()

We set some new default options for souper
==============================================
*/

souper_options:
call SysCls
getnews_xtra_options = '' /* the defaults */
getmail_xtra_options = ''
option1 = ''
option2 = ''
option3 = ''

say ''
say 'SOUPER OPTIONS SCREEN'
say 'You can select some alternate default options when souper runs.'
say 'These can be over-ridden when you run YarnDial.  If you wish to,'
say 'you can set these and more by editing' ydparms_dat
say 'after this install has completed, instead of using this screen.'
do until opts = 5
   say ''
   say 'Press:'
   say '  1 Set maximum news packetsize (default is 2048KB [2.048MB])'
   say '  2 Do not retrieve newsgroup articles containing more than a'
   say '    set number of lines in the body (default is: no limit)'
   say '  3 Check for new newsgroups (default is ''don''t check'')'
   say '  4 Default all three of the above.'
   say '  5 When done, must press 5 to exit this screen'
   do until pos(opts,'12345') \= 0
      say ''
      prompt = 'Select 1, 2, 3, 4, or 5:'
      say prompt
         parse value SysCurPos() with row col
         row  = row - 1
         col = length(prompt) + 2
         call SysCurPos row, col
      opts = SysGetKey('NOECHO')
   end
   
   select
      when opts = 1 then call max_news_packet
      when opts = 2 then call max_news_lines
      when opts = 3 then call check_for_new_newsgrps
      when opts = 4 then
         do
            option1 = ''
            option2 = ''
            option3 = ''
            say ''
            say 'Accepting defaults for all three options'
            say ''
            say ''
            say 'Press any key to continue'
            call SysGetKey 'NOECHO'
         end
      otherwise NOP
   end

   getnews_xtra_options = option1 option2
   getnews_xtra_options = strip(getnews_xtra_options, 'B')
   getnews_xtra_options = getnews_xtra_options option3
   getnews_xtra_options = strip(getnews_xtra_options, 'B')

   getmail_xtra_options = ''			/* We don't set any of these */
end
say ''
say ''
say ''
say 'Done setting options for souper.  Looks like:'
say 'GETMAIL:  souper.exe' souper_getmail_std_options getmail_xtra_options
say 'GETNEWS:  souper.exe' souper_getnews_std_options getnews_xtra_options
say 'SENDING:  souper.exe' souper_send_std_options send_xtra_options
say ''
say ''
say 'Press any key to continue'
call SysGetKey 'NOECHO'
RETURN
 
/*
=========================
max_news_packet()

Default is a packet-size of 2048 kB (2.048 Megs)
=========================
*/
max_news_packet:
     do until datatype(option1, 'W')
         call SysCls
         say ''
         say 'Enter a number in kilobytes for maximum news packet size.'
         say '2048 is typical. 0 sets packet size to unlimited.'
         say ''
         prompt = 'Enter number of kilobytes now:'
         say prompt
         parse value SysCurPos() with row col
         row  = row - 1
         col = length(prompt) + 2
         call SysCurPos row, col
         pull option1
         if \DataType(option1, 'W') then say 'Must be whole number or zero.'
     end
     say ''
     say 'Maximum packet size for news is set to' option1 'kilobytes'
     option1 = '-k' option1
     say ''
     say ''
     say 'Press any key to continue'
     call SysGetKey 'NOECHO'
RETURN

/*
=========================
max_news_lines()

Default is no limit.  Because of spamming of
news articles with attached binaries running
to 10,000 lines or more, you can set a limit.
I use 500, myself.
=========================
*/
max_news_lines:
      call SysCls
      do until datatype(option2, 'W')
         say ''
         say 'Do not retrieve articles with more than this many lines'
         say 'in the body of the article.  Enter 0 for unlimited (the'
         say 'usual default for souper).'
         say ''
         prompt = 'How many lines is the maximum acceptable?'
         say prompt
         parse value SysCurPos() with row col
         row  = row - 1
         col = length(prompt) + 2
         call SysCurPos row, col
         pull option2
         if \DataType(option2, 'W') then say 'Must be whole number or zero.'
     end
     say ''
     say 'News article not retrieved if over' option2 'lines'
     if option2 = 0 then option2 = ''
        else option2 = '-l' option2
     say ''
     say ''
     say 'Press any key to continue'
     call SysGetKey 'NOECHO'
RETURN

/*
=========================
check_for_new_newsgrps()

'Y' adds new ones to your newsrc file but inactivated
until you remove the 'inactivate' character.  Default
is 'N'
=========================
*/
check_for_new_newsgrps:
      do until pos(option3, 'YN') \= 0
      call SysCls
         say ''
         say 'Do you want to check for new news groups and have them added'
         say 'to your newsrc file (but set as inactive until you activate them)?'
         prompt = 'Enter Y or N:'
         say ''
         say prompt
         parse value SysCurPos() with row col
         row  = row - 1
         col = length(prompt) + 2
         call SysCurPos row, col
         parse upper pull option3
      end
   say ''
   if option3 = 'Y' then
      do
         option3 = '-a'
         say 'You elected to add new news groups to your newsrc'
      end
   else
      do
         option3 = ''
         say 'You elected not to add new news groups to your newsrc'
      end
   say ''
   say ''
   say 'Press any key to continue'
   call SysGetKey 'NOECHO'
RETURN

/*
==============================================
Almost done.  No changes to system yet.  Do
we want to quit before copying files?
==============================================
*/

chance_to_quit:
call SysCls
say ''
say 'WE ARE NOW READY TO COPY FILES...'
say ''
say 'Up till now, no changes have been made to your system.'
say ''
say 'We will complete installation by creating' ydparms_dat ||','
say 'by copying other necessary files to your' home 'directory,'
say 'and by creating some ReXX utility files which we save to'
say 'the' home 'directory.'
say ''
say 'We will create'
say '   A sub-directory named INCOMING in the' home
say '   directory (if one already exists, it is left unchanged).'
say ''
say '   A Folder Object on the Desktop containing objects for YARNDIAL'
say '   and for several utilities including one for starting up YARN.'
say ''
say 'No other changes are made to your system.'
say ''
say 'To quit without completing installation, press Escape.'
say ''
say 'Otherwise PRESS ANY OTHER KEY TO COMPLETE INSTALLATION.'
if SysGetKey('NOECHO') = Escape then
   do
      call SysCls
      say ''
      say 'Aborting without copying files to' HOME
      say 'or creating' ydparms_dat 'or creating the'
      say 'sub-directory INCOMING.'
      say ''
      say 'No changes were made to your system.'
      signal goodbye
   end
RETURN
 
/*
==============================================
Write the YD_PARMS.DAT file to the yarn home
directory to which we are installing YarnDial.
This has all the data Yarndial needs to be
able to run from (for) that Yarn user
installation.
==============================================
*/
output_dat:
home_drive
'cd' home

encry:
if encrypt then
   do
      adv_password = candidate
   end
o21 = '! *+"''-/,#$%&().0123456789:;<=>?'
o22 = '@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^'
o23 = '_`abcdefghijklmnopqrstuvwxyz{|}~'
e21 = 'u *+"''-/,MI($kU<HgW[_A5%~2Fh3`LO'
e22 = 't?K^l0jJP{98xBadb1nZimRw=y\Y]4}'
e23 = 'E>;67V@vS:C.sNGz|cefQ&pq)Tor!#XD'
adv_password = translate(adv_password, o21||o22||o23, e21||e22||e23)
if encrypt then
do
   say ''
   our_dir = directory()	/* Where we are executing this pgm from */
   leng = length(adv_password)
   call SysFileDelete our_dir || '\word.$$$'
   DL1 = 'encrypted=' || adv_password,
   || crlf || 'Encrypted text is the' leng 'character string to the',
   || crlf || 'right of the FIRST equals sign in encrypted=' || crlf,
   || crlf || 'Be careful to select only those those' leng 'characters.',
   || crlf || 'for cutting-and-pasting.' || crlf
   DL2 = 'Do not be concerned if there is more than one equals',
   || crlf || 'sign, since characters may have been legitimately',
   || crlf || 'encoded to equals signs.',
   || crlf || '',
   || crlf || 'Remember to Erase' our_dir || '\word.$$$ when done.' 
   say DL1
   say 'That line is also stored as ASCII text in'
   say our_dir || '\word.$$$ for cutting-and-pasting.'
   say ''
   say DL2
   call lineout our_dir || '\word.$$$', DL1
   call lineout our_dir || '\word.$$$', DL2
   call stream our_dir || '\word.$$$', 'c', 'close'
   RETURN
end
PWD = translate(PWD, o21||o22||o23, e21||e22||e23)
POP_PWD = translate(POP_PWD, o21||o22||o23, e21||e22||e23)

parse var ydparms_dat dat '.' ext
if stream(ydparms_dat, 'c', 'query exists') \= '',
   then 'copy' ydparms_dat dat || '.bak'

call SysFileDelete ydparms_dat
 		/* Output everything to file	*/
call data	/* Read in the text to be output */
call lineout ydparms_dat, dataline0
if connection_type = 5 then call lineout ydparms_dat, dataline1
call lineout ydparms_dat, dataline2
call stream ydparms_dat, 'c', 'close'
yd_parms_dat = translate(ydparms_dat)
say ydparms_dat 'created/updated.'
say ''
RETURN

/*
==============================================
A dataline which is output and becomes the
YD_PARMS.DAT data file.

Be very careful editing this.  These are long data
lines being continued with commas.  Make sure
every line but the last has comma at its end for each
of the three dataline statements.
==============================================
*/
DATA:

dataline0 = '#' ydparms_dat 'created/updated' Date() Time(),
|| crlf || '#',
|| crlf || '#    Edit with any ASCII text editor such as the OS/2 System Editor'

dataline1 = '#',
|| crlf || '#    Created by installing YARNDIAL for connection_type = 5',
|| crlf || '#    (Requires Manual Configuration)',
|| crlf || '#    Where right-hand side of an equals sign is bracketed with **''s:',
|| crlf || '#    Replace all of what is to right of equals sign with your info.',
|| crlf || '#    if in doubt about adv_password, PWD and POP_PWD try replacing',
|| crlf || '#    any of the three you are not sure of with the encrypted POP_PWD'

dataline2 = '#    The # sign at the very beginning of a line comments out that line',
|| crlf || '#',
|| crlf || '# These are your Yarn %Home% and %Yarn% directories',
|| crlf || 'HOME=' || home,
|| crlf || 'YARN=' || yarn,
|| crlf || '#',
|| crlf || '# ABOUT THE SEVEN CONNECTION_TYPE CHOICES:',
|| crlf || '#   1 Installed for Advantis via IAK Dialer',
|| crlf || '#   2 Installed for Dial-Other-Internet-Providers (SLIPPM.EXE)',
|| crlf || '#     (connection can be by SLIP or PPP).',
|| crlf || '#   3 Installed for use of a slip.exe or ppp.exe or some other',
|| crlf || '#     dialup string which uses SLIP.EXE or PPP.EXE.',
|| crlf || '#   4 Installed for IN-JOY dialer.',
|| crlf || '#     Requires configuring SLIPPM first (Dial-Other-Internet-Providers)',
|| crlf || '#   5 You chose to manually edit this to complete the configuration',
|| crlf || '#   6 Pot-Luck:  Tries to use any connection that happens to be.',
|| crlf || '#     established.  Connection must be made BEFORE you start YarnDial.',
|| crlf || '#     For connection_type 6, you must run YDINSTL.CMD first for',
|| crlf || '#     connection_type 1,2,3, or 4 and then after installation edit',
|| crlf || '#     connection_type in this file to 6.  See YD.DOC for more',
|| crlf || '#     information.',
|| crlf || '#   7 Like 6, but does not check for a connection, and uses the string',
|| crlf || '#     in dialup_string to dial.',
|| crlf || '#   Anything but 1-7 for connection_type creates an error condition.',
|| crlf || '#',
|| crlf || 'connection_type=' || connection_type,
|| crlf || '#',
|| crlf || '# ABOUT DIALUP_STRING:',
|| crlf || '#   If you plan to use a ppp.exe or slip.exe or other dialup string',
|| crlf || '#   which uses either SLIP.EXE or PPP.EXE to make the connection,',
|| crlf || '#   enter it below if it has not automatically been entered.',
|| crlf || '#   Then change connection_type above to 3. Read' YD_DOC 'for further',
|| crlf || '#   information.',
|| crlf || '#   YARNDIAL executes dialup_string as the evaluated expression:',
|| crlf || '#      interpret dialup_string',
|| crlf || '#   What you enter for dialup_string should consist of ''start'' plus',
|| crlf || '#   the dialer executable such as ppp.exe, slippm.exe, etc., plus any',
|| crlf || '#   arguments.  Omit the word interpret but always include ''start''.',
|| crlf || '#      Example:      ''start slippm.exe MyProvider''',   
|| crlf || '#      or, if you had set tcpos2ini_app=MyProvider in this file',
|| crlf || '#      you can use   ''start'' slippm.exe tcpos2ini_app', 
|| crlf || '#',
|| crlf || 'dialup_string=' || dialup_string,  
|| crlf || '#',
|| crlf || '#',
|| crlf || '# Depending upon what compress and uncompress utilities you use',
|| crlf || '# you may need to edit zip_exe= and unzip_exe=  below (use full paths)',
|| crlf || '#                       Samples:',
|| crlf || '#       OS/2 InfoZip compress/uncompress programs:',
|| crlf || '#          zip_exe=d:\pk_unpk\zip201c2\zip.exe -0m',
|| crlf || '#          unzip_exe=d:\pk_unpk\unz512x2\unzip.exe -o',
|| crlf || '#',
|| crlf || '#       MS-DOS PkWare compress/uncompress programs:',
|| crlf || '#          zip_exe=cmd.exe /c c:\path\pkzip -m -u -o',
|| crlf || '#          unzip_exe=cmd.exe /c c:\path\pkunzip -o',
|| crlf || '# Using another compress/uncompress set?  Refer to' yd_doc || '.',
|| crlf || '# For any MSDOS based ones, you must use  cmd.exe /c  to call them',
|| crlf || '# as shown for the PkWare examples',
|| crlf || '#',
|| crlf || 'zip_exe=' || zip_exe,
|| crlf || 'unzip_exe=' || unzip_exe,
|| crlf || '#',
|| crlf || '# reply_packet is what you have in YARN''s CONFIG file for reply-packet',
|| crlf || 'reply_packet=' || reply_packet,
|| crlf || '# host is the domain in YARN''s CONFIG file',
|| crlf || 'host=' || host,
|| crlf || 'souper_exe=' || souper_exe, 
|| crlf || 'yarn_exe=' || yarn_exe, 
|| crlf || 'import_exe=' || import_exe, 
|| crlf || 'export_exe=' || export_exe, 
|| crlf || 'expire_exe=' || expire_exe, 
|| crlf || 'rebuild_exe=' || rebuild_exe,
|| crlf || 'go_exe=' || go_exe,
|| crlf || 'killjoy_exe=' || killjoy_exe,
|| crlf || '#',
|| crlf || '# You can modify the runtime options for souper.exe by editing these',
|| crlf || '# Read over' yd_doc 'and the souper documentation before doing so.',
|| crlf || '#    DO NOT change the ones indicated as _std_ , especially, DO NOT',
|| crlf || '#    remove the -i''s.  Reason: we read our set up variables from this file',
|| crlf || '#    and not from the TCP-IP settings notebooks when we run the souper',
|| crlf || '#    program.  Keep in mind we got those variables from those sources',
|| crlf || '#    when we ran YDINSTL.CMD to create this parameters file.',
|| crlf || '#',
|| crlf || 'souper_getmail_std_options=' || souper_getmail_std_options,
|| crlf || 'souper_getnews_std_options=' || souper_getnews_std_options,
|| crlf || 'souper_send_std_options=' || souper_send_std_options,
|| crlf || 'getmail_xtra_options=' || getmail_xtra_options,
|| crlf || 'getnews_xtra_options=' || getnews_xtra_options,
|| crlf || 'send_xtra_options=' || send_xtra_options,
|| crlf || '#',
|| crlf || '#',
|| crlf || '# wait is a dialer timeout, in seconds',
|| crlf || 'wait=' || wait, 
|| crlf || '#',
|| crlf || '#    The following is the name of the Dial-Other-Internet-Providers',
|| crlf || '#    app in TCPOS2.INI for connection_type 2 and 3 installations',
|| crlf || 'tcpos2ini_app=' || tcpos2ini_app,
|| crlf || '#',
|| crlf || '#   Parms extracted from the DIALER.INI file',
|| crlf || '#',
|| crlf || 'user=' || user,
|| crlf || 'adv_account=' || adv_account,
|| crlf || 'adv_popserver=' || adv_popserver,
|| crlf || 'adv_newsserver=' || adv_newsserver,
|| crlf || 'adv_password=' || adv_password,
|| crlf || '# The SMTP server (the Gateway):',
|| crlf || 'adv_smtpserver=' || adv_smtpserver,
|| crlf ||'ASK=' ||ASK,
|| crlf ||'GS=' ||GS,
|| crlf ||'WS=' ||WS,
|| crlf ||'DN1=' ||DN1,
|| crlf ||'DN2=' ||DN2,
|| crlf ||'IS1=' ||IS1,
|| crlf ||'IS2=' ||IS2,
|| crlf ||'RS1=' ||RS1,
|| crlf ||'RS2=' ||RS2,
|| crlf ||'FS1=' ||FS1,
|| crlf ||'FS2=' ||FS2,
|| crlf ||'MD=' ||MD,
|| crlf ||'PIN=' ||PIN,
|| crlf ||'EMI=' ||EMI,
|| crlf || '#',
|| crlf || '#   Parms extracted (mostly) from the TCPOS2.INI file',
|| crlf || '#',
|| crlf ||'PROVIDER=' || PROVIDER,
|| crlf ||'LOGIN_ID=' || LOGIN_ID,
|| crlf ||'PWD=' || PWD,
|| crlf ||'SAVE_PWD=' || SAVE_PWD,
|| crlf ||'PHONE_NUMBER=' || PHONE_NUMBER,
|| crlf ||'HANGUP=' || HANGUP,
|| crlf ||'SCRIPT=' || SCRIPT,
|| crlf ||'SERVICE=' || SERVICE,
|| crlf ||'YOURIP=' || YOURIP,
|| crlf ||'DESTIP=' || DESTIP,
|| crlf ||'NETMASK=' || NETMASK,
|| crlf ||'MTU_SIZE=' || MTU_SIZE,
|| crlf ||'VJ_COMP=' || VJ_COMP,
|| crlf ||'HOSTNAME=' || HOSTNAME,
|| crlf ||'DOMAIN_NAME=' || DOMAIN_NAME,
|| crlf ||'DNS=' || DNS,
|| crlf ||'DEFAULT_NEWS=' || DEFAULT_NEWS,
|| crlf ||'DEFAULT_WWW=' || DEFAULT_WWW,
|| crlf ||'DEFAULT_GOPHER=' || DEFAULT_GOPHER,
|| crlf ||'MAIL_GW=' || MAIL_GW,
|| crlf ||'POPSRVR=' || POPSRVR,
|| crlf ||'REPLY_DOMAIN=' || REPLY_DOMAIN,
|| crlf ||'REPLY_ID=' || REPLY_ID,
|| crlf ||'POP_ID=' || POP_ID,
|| crlf ||'POP_PWD=' || POP_PWD,
|| crlf ||'MODEM_TYPE=' || MODEM_TYPE,
|| crlf ||'COMPORT=' || COMPORT,
|| crlf ||'BAUD=' || BAUD,
|| crlf ||'DATABITS=' || DATABITS,
|| crlf ||'PARITY=' || PARITY,
|| crlf ||'DIAL_MODE=' || DIAL_MODE,
|| crlf ||'PREFIX=' || PREFIX,
|| crlf ||'PREFIX_ANS=' || PREFIX_ANS,
|| crlf ||'INIT=' || INIT,
|| crlf ||'INIT2=' || INIT2,
|| crlf ||'DISABLE=' || DISABLE,
|| crlf ||'DISABLE_SEQ=' || DISABLE_SEQ,
|| crlf ||'DIAL_PREFIX=' || DIAL_PREFIX,
|| crlf ||'AUTOSTART=' || AUTOSTART,
|| crlf ||'TOTAL_CONNECT=' || TOTAL_CONNECT,
|| crlf ||'#',
|| crlf || '# End of' ydparms_dat	/* No comma at the end of this line */
RETURN          

/*
==============================================
copy_ydfiles()

Copy over files from the installation
directory to the home directory.  We expect to find the icon
files in a subdirectory (ICONS) but if you happened to use
PkWare unzip without the -d option they will not be
there so we will look for them in the installer's directory
also to avoid an abortable error.
==============================================
*/
copy_ydfiles:

/*
============================
Create an incoming subdirectory in the home directory
if not there already.  This is for use in running souper
and has nothing to do with completing this installation of
YarnDial
============================
*/

call SysMkDir home || '\incoming'

/* But we do need to create an ICONS subdirectory in our target
home directory as part of the installation */

call SysMkDir home || '\icons'

/* get down to filename only, strip and path, arguments */
yd_cmd = filespec('name', yd_cmd)
ydinstl_cmd = filespec('name', ydinstl_cmd)
yarn_ico = filespec('name', yarn_ico)
yd_doc = filespec('name', yd_doc)
readme_1st = filespec('name', readme_1st)
go_exe = filespec('name', go_exe)
yarn_ico = filespec('name', yarn_ico)
yarndial_ico = filespec('name', yarndial_ico)
ydfold1_ico = filespec('name', ydfold1_ico)
ydfold2_ico = filespec('name', ydfold2_ico)
yarnshell_ico = yarn_ico
yarnutil_ico = filespec('name', yarnutil_ico)
ydinstl_ico = filespec('name', ydinstl_ico)
logoff_ico = filespec('name', logoff_ico)
renewzip_ico = filespec('name', renewzip_ico)

/*
============================
First copy over icons. If they are not in an icons subdirectory
we look for them in the source directory.  And if they are only in
an icon subdirectory and the source_path is the same as home, we do
nothing as we can't copy something over onto itself

if we try a wildcard copy (copy *.ico) and there are no files to copy, we get an
error, so we need to have at least one file to copy.  Hence these awful multipart
conditionals
============================
*/

if home \= source_path then
   do
      if stream(source_path || '\icons\' || yarn_ico, 'c', 'query exists') \= '',
       | stream(source_path || '\icons\' || yarndial_ico, 'c', 'query exists') \= '',
       | stream(source_path || '\icons\' || ydfold1_ico, 'c', 'query exists') \= '',
       | stream(source_path || '\icons\' || ydfold2_ico, 'c', 'query exists') \= '',
       | stream(source_path || '\icons\' || yarnutil_ico, 'c', 'query exists') \= '',
       | stream(source_path || '\icons\' || ydinstl_ico, 'c', 'query exists') \= '',
       | stream(source_path || '\icons\' || renewzip_ico, 'c', 'query exists') \= '',
       | stream(source_path || '\icons\' || logoff_ico, 'c', 'query exists') \= '' then
            do
               say 'Copying icon files from' source_path || '\icons to' HOME || '\icons'
               'copy' source_path || '\icons\' || '*.ico' home || '\icons' 
            end
   end

if stream(source_path || '\' || yarn_ico, 'c', 'query exists') \= '',
 | stream(source_path || '\' || yarndial_ico, 'c', 'query exists') \= '',
 | stream(source_path || '\' || ydfold1_ico, 'c', 'query exists') \= '',
 | stream(source_path || '\' || ydfold2_ico, 'c', 'query exists') \= '',
 | stream(source_path || '\' || yarnutil_ico, 'c', 'query exists') \= '',
 | stream(source_path || '\' || ydinstl_ico, 'c', 'query exists') \= '',
 | stream(source_path || '\' || renewzip_ico, 'c', 'query exists') \= '',
 | stream(source_path || '\' || logoff_ico, 'c', 'query exists') \= '' then
   do
      say 'Copying icon files from' source_path 'to' HOME || '\icons'
      'copy' source_path || '\' || '*.ico' home || '\icons' 
   end


  
/*
============================
Then copy remaining files to complete the installation.  Again, if we are already
installing to the home directory and source_path is the home directory instead of
some other (temporary) one, just exit the routine because files are already where we
want them
============================
*/

if home = source_path then
   do
      nop
   end

else
   do
      say 'Copying rest of files from' source_path 'to' HOME
      home_drive
      'cd' home

      if stream(source_path || '\' || yd_cmd, 'c', 'query exists') \= '' then
         do
            'copy' source_path || '\' || yd_cmd
            if \SysSetIcon(yd_cmd, home || '\icons\' || yarndial_ico) then
               say 'unable to set icon for' yd_cmd '(NON-CRITICAL ERROR)'
         end

      if stream(source_path || '\' || ydinstl_cmd, 'c', 'query exists') \= ''  then
         do
            'copy' source_path || '\' || ydinstl_cmd
            if \SysSetIcon(ydinstl_cmd, home || '\icons\' || ydinstl_ico) then
               say 'unable to set icon for' ydinstl_cmd '(NON-CRITICAL ERROR)'         
         end

   if stream(source_path || '\' || yd_doc, 'c', 'query exists') \= '' then
      'copy' source_path || '\' || yd_doc

   if stream(source_path || '\' || readme_1st, 'c', 'query exists') \= '' then
      'copy' source_path || '\' || readme_1st

   if stream(source_path || '\' || go_exe, 'c', 'query exists') \= '' then
      'copy' source_path || '\' || go_exe
end /* of else */

completed = 1
RETURN

/*
=======================================================
We create  a suite of small REXX programs and save them to the HOME
directory we are now installing to.  All of these will run with the OS/2
environment variable, HOME, set using SetLocal() to the unique home
directory chosen for this particular user installation.

First we create a program (YRNSHELL.CMD) which starts
yarn.exe for this particular user installation.
=======================================================
*/ 
create_yarnshell_cmd:
say 'Creating customized .CMD files for the' home 'directory'
home_drive
'cd' home

yarnshell_cmd = filespec('name', yarnshell_cmd)

call SysFileDelete yarnshell_cmd

/* Now create yarnshell_cmd as a .CMD file in the HOME directory */

dataline = '/*' yarnshell_cmd,
|| crlf || 'Program to start' yarn_exe,
|| crlf || 'Created by YARNDIAL''s' ydinstl_cmd date() time(),
|| crlf || 'Sets' HOME 'as the HOME env. variable',
|| crlf || 'and sets' yarn 'as the YARN env. variable.',
|| crlf || 'Sets working directory to' yarn,
|| crlf || 'Sets OS/2 window to 80 chars x 40 lines   */' || crlf,
|| crlf || 'x = SetLocal()',
|| crlf || '''@echo off''',
|| crlf || 'x = value(''home'', ''' || home || ''', ''OS2ENVIRONMENT'')',
|| crlf || 'x = value(''yarn'', ''' || yarn || ''', ''OS2ENVIRONMENT'')',
|| crlf || home_drive,
|| crlf || '''cd' home || '''',
|| crlf || '''mode co80,40''',
|| crlf || '''' || yarn_exe || '''',
|| crlf || 'x = EndLocal()'

call lineout yarnshell_cmd, dataline
call stream yarnshell_cmd, 'c', 'close'
say '  ' yarnshell_cmd 'created/updated.'
if \SysSetIcon(yarnshell_cmd, home || '\icons\' || yarn_ico) then
   say 'unable to set icon for' yarnshell_cmd '(NON-CRITICAL ERROR)'
RETURN


/*
=======================================================
Create a program (YRNUTIL.CMD) to run yarn utilities for
this particular user installation.  It temporarily sets
a variable named home in the the OS/2 environment to the
home directory chosen for this particular user installation,
then prompts for the yarn utility to run, then runs it.
=======================================================
*/ 

create_yarnutil_cmd:
home_drive
'cd' home

yarnutil_cmd = filespec('name', yarnutil_cmd)

call SysFileDelete yarnutil_cmd

/* Now create yarnutil_cmd as a .CMD file in the HOME directory */

dataline = '/* */',
|| crlf || 'say ''' || yarnutil_cmd || '''',
|| crlf || 'say ''Program to start a yarn executable.''',
|| crlf || 'say ''Sets' HOME 'as the HOME env. variable''',
|| crlf || 'say ''and sets' yarn 'as the YARN env. variable.''',
|| crlf || 'say ''Sets working directory to' yarn || '''',
|| crlf || 'say ''Created by YARNDIAL''''s' ydinstl_cmd date() time() || '''',
|| crlf || 'say ''''',
|| crlf || '/* Load RexxUtil if not already loaded */',
|| crlf || 'if RxFuncQuery(''SysLoadFuncs'') \= 0 then',
|| crlf || '   do',
|| crlf || '      call RxFuncAdd ''SysLoadFuncs'', ''REXXUTIL'', ''SysLoadFuncs''',
|| crlf || '      call SysLoadFuncs',
|| crlf || '   end',
|| crlf || 'x = SetLocal()',
|| crlf || '''@echo off''',
|| crlf || 'x = value(''home'', ''' || home || ''', ''OS2ENVIRONMENT'')',
|| crlf || 'x = value(''yarn'', ''' || yarn || ''', ''OS2ENVIRONMENT'')',
|| crlf || yarn_drive,
|| crlf || '''cd' yarn || '''',
|| crlf || 'say ''What yarn utility do you want to run?''',
|| crlf || 'prompt = ''Omit the path. Enter:''',
|| crlf || 'say prompt',
|| crlf || 'parse value SysCurPos() with row col',
|| crlf || 'row  = row - 1',
|| crlf || 'col = length(prompt) + 2',
|| crlf || 'call SysCurPos row, col',
|| crlf || 'parse pull yarn_utility',
|| crlf || 'yarn_utility',
|| crlf || 'x = EndLocal()',
|| crlf || 'say ''''',
|| crlf || 'say ''Done.  Press any key to exit...''',		
|| crlf || 'answer = SysGetKey(''NOECHO'')'

call lineout yarnutil_cmd, dataline
call stream yarnutil_cmd, 'c', 'close'
say '  ' yarnutil_cmd 'created/updated.'
if \SysSetIcon(yarnutil_cmd, home || '\icons\' || yarnutil_ico) then
   say 'unable to set icon for' yarnutil_cmd '(NON-CRITICAL ERROR)'
RETURN

/*
=======================================================
Create a logoff program (LOGOFF.CMD).  It determines if
any of the following are up and running, and if so, closes
them down: SLIP.EXE, PPP.EXE, DIALER.EXE, SLIPPM.EXE.
This will work in any environment but we place a copy
in each home directory we install to (convenient to do so).

I wanted something like this so if for some reason I was
logged on and wanted a sure-fire shut-down freeing up my
phone line, I could do it with one double-click.

This uses go.exe from GO_15.EXE.  go.exe is supplied with
this yarndial/installer package.
=======================================================
*/ 

create_logoff_cmd:
home_drive
'cd' home

logoff_cmd = filespec('name', logoff_cmd)

call SysFileDelete logoff_cmd

/* Now create logoff_cmd as a .CMD file in the HOME directory */

dataline = '/* */',
|| crlf || 'say ''' || logoff_cmd || '''',
|| crlf || 'say ''Shutdown of IAK Dialer, SLIP, PPP, SLATTACH, SLIPPM, IN-JOY''',
|| crlf || 'say ''Created by YARNDIAL''''s' ydinstl_cmd date() time() || '''' || crlf,
|| crlf || 'say ''''',
|| crlf || '/* --------  you can edit these 3 things -------- */',
|| crlf || 'go_exe = ''' || go_exe || '''	/* full path to GO_15''s GO.EXE */',
|| crlf || 'killjoy_exe = ''' || killjoy_exe || '''	/* full path toIN-JOY''s KILLJOY.EXE */',
|| crlf || 'settle_time = 10  /* seconds,  settle down before rechecking */' || crlf || crlf,
|| crlf || '/* Load RexxUtil if not already loaded */',
|| crlf || 'if RxFuncQuery(''SysLoadFuncs'') \= 0 then',
|| crlf || '   do',
|| crlf || '      call RxFuncAdd ''SysLoadFuncs'', ''REXXUTIL'', ''SysLoadFuncs''',
|| crlf || '      call SysLoadFuncs',
|| crlf || '   end',
|| crlf || '''@echo off''',
|| crlf || 'call is_process_running ''dialer''',
|| crlf || 'call is_process_running ''slip''',
|| crlf || 'call is_process_running ''ppp''',
|| crlf || 'call is_process_running ''slattach''',
|| crlf || 'call is_process_running ''slippm''' || crlf,
|| crlf || 'if stream(''' || killjoy_exe || ''', ''c'', ''query exists'') \= '''' then',
|| crlf || '   do',
|| crlf || '      ''' || killjoy_exe || '''',
|| crlf || '      call SysSleep 3 /* settle time */',
|| crlf || '   end',
|| crlf || 'call is_process_running ''in-joy''', 
|| crlf || 'say ''Waiting'' settle_time ''secs. before testing them all again...''',
|| crlf || 'call SysSleep settle_time' || crlf,
|| crlf || 'call is_process_running ''dialer''',
|| crlf || 'call is_process_running ''slip''',
|| crlf || 'call is_process_running ''ppp''',
|| crlf || 'call is_process_running ''slattach''',
|| crlf || 'call is_process_running ''slippm''',
|| crlf || 'if stream(''' || killjoy_exe || ''', ''c'', ''query exists'') \= '''' then',
|| crlf || '   do',
|| crlf || '      ''' || killjoy_exe || '''',
|| crlf || '      call SysSleep 3 /* settle time */',
|| crlf || '   end',
|| crlf || 'call is_process_running ''in-joy''', 
|| crlf || 'say ''''',
|| crlf || 'say ''Press any key to exit...''',		
|| crlf || 'answer = SysGetKey(''NOECHO'')',
|| crlf || 'EXIT' || crlf || crlf,
|| crlf || 'is_process_running:',
|| crlf || 'parse upper arg process			/* Check if it is */',
|| crlf || 'go_exe ''-cp'' process ''> NUL''	/* returns RC=1 if process is running, 0 if not */',
|| crlf || 'If RC then',
|| crlf || '   do',
|| crlf || '      say process ''is running''',
|| crlf || '      if process = ''DIALER'' then',
|| crlf || '         do',
|| crlf || '            process ''-c > nul'', /* hope it''s at least v 1.33 */',
|| crlf || '            call SysSleep 3 /* settle time, IAK Dialer is funny */',
|| crlf || '            say ''   If you lost this window for a few seconds or just heard a beep''',
|| crlf || '            say ''   that is normal for closing down certain versions of IAK Dialer''',
|| crlf || '         end',
|| crlf || '   end',
|| crlf || 'else say process ''is not running''',
|| crlf || 'go ''-ka'' process ''> NUL''  /* do a kill whether running or not */',
|| crlf || 'RETURN'

call lineout logoff_cmd, dataline
call stream logoff_cmd, 'c', 'close'
say '  ' logoff_cmd 'created/updated.'
if \SysSetIcon(logoff_cmd, home || '\icons\' || logoff_ico) then
   say 'unable to attach icon for' logoff_cmd '(NON-CRITICAL ERROR)'
RETURN


/*
=======================================================
Create a program (RENEWZIP.CMD) to rename to a .ZIP file
the reply_packet ZIP file for this user that we had backed
up as a *.BAK file when last we exported posts and mail.
If something went wrong with sending/posting, this
renewzip.cmd restores the .ZIP and allows us a second shot.
=======================================================
*/ 

create_renewzip_cmd:
home_drive
'cd' home
renewzip_cmd = filespec('name', renewzip_cmd)
parse var renewzip_cmd renewzip '.' ext
call SysFileDelete renewzip_cmd

reply_packet = translate(reply_packet)

parse var reply_packet reply '.' ext
reply_bak = reply || '.BAK'
reply_asterisk = reply || '.*'

/* Now create renewzip_cmd as a .CMD file in the HOME directory */

dataline = '/* */',
|| crlf || 'say ''' || renewzip_cmd || '''',
|| crlf || 'say ''Restores' reply_packet 'by renaming the *.BAK to *.ZIP''',
|| crlf || 'say ''Created by YARNDIAL''''s' ydinstl_cmd date() time() || '''',
|| crlf || 'say ''DIR run below should confirm restoration of the *.ZIP''',
|| crlf || 'say ''''',
|| crlf || '/* Load RexxUtil if not already loaded */',
|| crlf || 'if RxFuncQuery(''SysLoadFuncs'') \= 0 then',
|| crlf || '   do',
|| crlf || '      call RxFuncAdd ''SysLoadFuncs'', ''REXXUTIL'', ''SysLoadFuncs''',
|| crlf || '      call SysLoadFuncs',
|| crlf || '   end',
|| crlf || '''@echo off''',
|| crlf || 'if stream(''' || reply_bak || ''', ''c'', ''query exists'') \= '''' then',
|| crlf || '   do',
|| crlf || '      ''copy' reply_bak reply_packet || '''',
|| crlf || '      ''dir' reply_asterisk || '''',
|| crlf || '   end',
|| crlf || 'else say ''no' reply_bak 'to restore''',
|| crlf || 'say ''''',
|| crlf || 'say ''Press any key to exit...''',		
|| crlf || 'answer = SysGetKey(''NOECHO'')'

call lineout renewzip_cmd, dataline
call stream renewzip_cmd, 'c', 'close'
say '  ' renewzip_cmd 'created/updated.'
if \SysSetIcon(renewzip_cmd, home || '\icons\' || renewzip_ico) then
   say 'unable to attach icon for' renewzip_cmd '(NON-CRITICAL ERROR)'
RETURN
 
/*
==============================================
create_yarndial_objects()

Create a folder on the desktop uniquely named for
our user installation.  Into it place our objects also named
to identify them with the specific home directory for which
this installation was done.
==============================================
*/
create_yarndial_objects:

say 'Creating Desktop Folder object and its Program objects'

/* First create a Desktop Folder object for our YARNDIAL objects */

object_creation_error = 0	/* if an error, we set to 1 */

home = translate(home, Lowcase, Upcase)   /* to lower case */

classname = 'WPFolder'
folder_fore_title ='YarnDial Suite for' 
title = folder_fore_title || '^' || home
location = '<WP_DESKTOP>'
desktop_folder_object_id = '<' || title || '>'
iconfile = home || '\icons\' || ydfold1_ico	/* Animated folder icon (closed folder) */
iconnfile = home || '\icons\' || ydfold2_ico	/* Animated folder icon (open folder) */
startupdir = home
setup = 'OBJECTID=' || desktop_folder_object_id ||,
         ';ALWAYSSORT=YES' ||,
         ';ICONFILE=' || iconfile ||,
         ';ICONNFILE=1,' iconnfile

if \SysCreateObject(classname, title, location, setup, 'U') then
   do
      say 'YARNDIAL FOLDER object creation unsuccessful'
      object_creation_error = 1
   end
else
  DO
      say '   YARNDIAL FOLDER object created/updated successfully'

/* Folder created successfully? Then create all the program objects
and place them in the folder */

/* The desktop folder we just created is located at... */
location = desktop_folder_object_id   /* location for the rest is in the folder */

/* Create the object for YarnDial */
   classname = 'WPProgram'
   title = 'YarnDial for^' || home
   exename = home || '\' || yd_cmd
   iconfile = home || '\icons\' || yarndial_ico
   startupdir = home

   setup = 'OBJECTID=<' || title || '>' ||,
            ';ICONFILE=' || iconfile ||,
            ';EXENAME=' || exename ||,
            ';STARTUPDIR=' || startupdir

   if SysCreateObject(classname, title, location, setup, 'U') then
      do
         say '   YARNDIAL object created/updated successfully'
      end
   else
      do
         say 'YARNDIAL object creation unsuccessful'
         object_creation_error = 1
      end

/* and then do all of this until the end of the subroutine... */

/* Create an object for yarnshell_cmd */
   title = 'YARN Program for^' || home 
   exename = home || '\' || yarnshell_cmd
   iconfile = home || '\icons\' || yarn_ico
   startupdir = home

   setup = 'OBJECTID=<' || title || '>' ||,
            ';ICONFILE=' || iconfile ||,
            ';EXENAME=' || exename ||,
            ';STARTUPDIR=' || startupdir

   if SysCreateObject(classname, title, location, setup, 'U') then
      do
         say '  ' YARNSHELL_CMD 'object created/updated successfully'
      end
   else
      do
         say 'YRNSHELL object creation unsuccessful'
         object_creation_error = 1
      end

/* Create an object for yarnutil_cmd */
   title = 'YarnUtil from^' || home
   exename = home || '\' || yarnutil_cmd
   iconfile = home || '\icons\' || yarnutil_ico
   startupdir = home

   setup = 'OBJECTID=<' || title || '>' ||,
            ';ICONFILE=' || iconfile ||,
            ';EXENAME=' || exename ||,
            ';STARTUPDIR=' || startupdir

   if SysCreateObject(classname, title, location, setup, 'U') then
      do
         say '  ' YARNUTIL_CMD 'object created/updated successfully'
      end
   else
      do
         say 'YRNUTIL object creation unsuccessful'
         object_creation_error = 1
      end

/* Create an object for logoff_cmd */
   title = 'Logoff running from^' || home
   exename = home || '\' || logoff_cmd
   iconfile = home || '\icons\' || logoff_ico
   startupdir = home

   setup = 'OBJECTID=<' || title || '>' ||,
            ';ICONFILE=' || iconfile ||,
            ';EXENAME=' || exename ||,
            ';STARTUPDIR=' || startupdir

   if SysCreateObject(classname, title, location, setup, 'U') then
      do
         say '  ' LOGOFF_CMD 'object created/updated successfully'
      end
   else
      do
         say 'LOGOFF object creation unsuccessful'
         object_creation_error = 1
     end

/* Create an object for renewzip_cmd */
   title = 'Reply Zip Restorer for^' || translate(reply_packet, Lowcase, Upcase) /* to lower case */ 
   exename = home || '\' || renewzip_cmd
   iconfile = home || '\icons\' || renewzip_ico
   startupdir = home

   setup = 'OBJECTID=<' || title || '>' ||,
            ';ICONFILE=' || iconfile ||,
            ';EXENAME=' || exename ||,
            ';STARTUPDIR=' || startupdir

   if SysCreateObject(classname, title, location, setup, 'U') then
      do
         say '  ' RENEWZIP_CMD 'object created/updated successfully'
      end
   else
      do
         say 'RENEWZIP object creation unsuccessful'
         object_creation_error = 1
      end
END	/* creating program objects in the Desktop Folder we created */
RETURN

/*
=======================================================
recreate_objects_cmd()
Create a program (OBJECTS.CMD) to to be able to recreate the
YarnDial Desktop folder and objects in it.
=======================================================
*/ 


recreate_objects_cmd:
/* Now create objects_cmd as a .CMD file in the HOME directory */
home_drive
'cd' home
call SysFileDelete objects_cmd
say 'Creating a program to be able to recreate the YarnDial'
say 'desktop folder for this installation, and all of its objects'

dataline = '/*' || objects_cmd || '*/',
|| crlf || 'say ''Created by YARNDIAL''''s' ydinstl_cmd date() time() || '''' || crlf,
|| crlf || 'say ''Re-creates a Desktop Folder object and its Program objects''',
|| crlf || 'say ''for the user whose HOME directory is'' translate(''' || home || ''')',
|| crlf || 'say ''''' || crlf,
|| crlf || '/* Load RexxUtil if not already loaded */',
|| crlf || 'if RxFuncQuery(''SysLoadFuncs'') \= 0 then',
|| crlf || '   do',
|| crlf || '      call RxFuncAdd ''SysLoadFuncs'', ''REXXUTIL'', ''SysLoadFuncs''',
|| crlf || '      call SysLoadFuncs',
|| crlf || '   end' || crlf,
|| crlf || 'say ''Press any key to continue.  CTRL-C quits.''',
|| crlf || 'answer = SysGetKey(''NOECHO'')' || crlf,
|| crlf || 'say ''''' || crlf,
|| crlf || '/* First create a Desktop Folder object for our YARNDIAL objects */' ,
|| crlf || 'object_creation_error = 0	/* if an error, we set to 1 */' || crlf,
|| crlf || 'Upcase = xrange(''A'', ''Z'')',
|| crlf || 'Lowcase = xrange(''a'', ''z'')' || crlf,
|| crlf || 'home = translate(''' || home || ''', Lowcase, Upcase)' || crlf,
|| crlf || 'classname = ''WPFolder''',
|| crlf || 'folder_fore_title =''YarnDial Suite for''', 
|| crlf || 'title = folder_fore_title || ''^'' || home',
|| crlf || 'location = ''<WP_DESKTOP>''',
|| crlf || 'desktop_folder_object_id = ''<'' || title || ''>''',
|| crlf || 'iconfile = home || ''\icons\' || ydfold1_ico || '''	/* Animated folder icon (closed folder) */',
|| crlf || 'iconnfile = home || ''\icons\' || ydfold2_ico || '''	/* Animated folder icon (open folder) */',
|| crlf || 'startupdir = home',
|| crlf || 'setup = ''OBJECTID='' || desktop_folder_object_id ||,',
|| crlf || '         '';ALWAYSSORT=YES'' ||,',
|| crlf || '         '';ICONFILE='' || iconfile ||,',
|| crlf || '         '';ICONNFILE=1,'' iconnfile' || crlf,
|| crlf || 'if \SysCreateObject(classname, title, location, setup, ''U'') then',
|| crlf || '   do',
|| crlf || '      say ''YARNDIAL FOLDER object creation unsuccessful''',
|| crlf || '      object_creation_error = 1',
|| crlf || '   end',
|| crlf || 'else',
|| crlf || '   do',
|| crlf || '      say ''YARNDIAL FOLDER object created/updated successfully''' || crlf,
|| crlf || '/* Folder created successfully? Then create all the program objects',
|| crlf || 'and place them in the folder */' || crlf,
|| crlf || '/* The desktop folder we just created is located at... */',
|| crlf || 'location = desktop_folder_object_id    /* location for the rest is in the folder */' || crlf,
|| crlf || '/* Create the object for YarnDial */',
|| crlf || '   classname = ''WPProgram''',
|| crlf || '   title = ''YarnDial for^'' || home',
|| crlf || '   exename = home || ''\' || yd_cmd || '''',
|| crlf || '   iconfile = home || ''\icons\' || yarndial_ico || '''',
|| crlf || '   startupdir = home' || crlf,
|| crlf || '   setup = ''OBJECTID=<'' || title || ''>'' ||,',
|| crlf || '            '';ICONFILE='' || iconfile ||,',
|| crlf || '            '';EXENAME='' || exename ||,',
|| crlf || '            '';STARTUPDIR='' || startupdir' || crlf,
|| crlf || '   if SysCreateObject(classname, title, location, setup, ''U'') then',
|| crlf || '      do' ,
|| crlf || '         say ''YARNDIAL object created/updated successfully''',
|| crlf || '      end',
|| crlf || '   else',
|| crlf || '      DO',
|| crlf || '         say ''YARNDIAL object creation unsuccessful''',
|| crlf || '         object_creation_error = 1',
|| crlf || '      end' || crlf,
|| crlf || '/* and then do all of this until the end of the subroutine... */' || crlf,
|| crlf || '/* Create an object for yarnshell_cmd */',
|| crlf || '   title = ''YARN Program for^'' || home', 
|| crlf || '   exename = home || ''\' || yarnshell_cmd || '''',
|| crlf || '   iconfile = home || ''\icons\' || yarn_ico || '''',
|| crlf || '   startupdir = home' || crlf,
|| crlf || '   setup = ''OBJECTID=<'' || title || ''>'' ||,',
|| crlf || '            '';ICONFILE='' || iconfile ||,',
|| crlf || '            '';EXENAME='' || exename ||,',
|| crlf || '            '';STARTUPDIR='' || startupdir' || crlf,
|| crlf || '   if SysCreateObject(classname, title, location, setup, ''U'') then',
|| crlf || '      do',
|| crlf || '         say YARNSHELL_CMD ''object created/updated successfully''',
|| crlf || '      end',
|| crlf || '   else',
|| crlf || '      do',
|| crlf || '         say ''YRNSHELL object creation unsuccessful''',
|| crlf || '         object_creation_error = 1',
|| crlf || '      end' || crlf,
|| crlf || '/* Create an object for yarnutil_cmd */',
|| crlf || '   title = ''YarnUtil from^'' || home',
|| crlf || '   exename = home || ''\' || yarnutil_cmd || '''',
|| crlf || '   iconfile = home || ''\icons\' || yarnutil_ico || '''',
|| crlf || '   startupdir = home' || crlf,
|| crlf || '   setup = ''OBJECTID=<'' || title || ''>'' ||,',
|| crlf || '            '';ICONFILE='' || iconfile ||,',
|| crlf || '            '';EXENAME='' || exename ||,',
|| crlf || '            '';STARTUPDIR='' || startupdir' || crlf,
|| crlf || '   if SysCreateObject(classname, title, location, setup, ''U'') then',
|| crlf || '      do',
|| crlf || '         say YARNUTIL_CMD ''object created/updated successfully''',
|| crlf || '      end',
|| crlf || '   else',
|| crlf || '      do',
|| crlf || '         say ''YRNUTIL object creation unsuccessful''',
|| crlf || '         object_creation_error = 1',
|| crlf || '      end' || crlf,
|| crlf || '/* Create an object for logoff_cmd */',
|| crlf || '   title = ''Logoff running from^'' || home',
|| crlf || '   exename = home || ''\' || logoff_cmd || '''',
|| crlf || '   iconfile = home || ''\icons\' || logoff_ico || '''',
|| crlf || '   startupdir = home' || crlf,
|| crlf || '   setup = ''OBJECTID=<'' || title || ''>'' ||,',
|| crlf || '            '';ICONFILE='' || iconfile ||,',
|| crlf || '            '';EXENAME='' || exename ||,',
|| crlf || '            '';STARTUPDIR='' || startupdir' || crlf,
|| crlf || '   if SysCreateObject(classname, title, location, setup, ''U'') then',
|| crlf || '      do',
|| crlf || '         say LOGOFF_CMD ''object created/updated successfully''',
|| crlf || '      end',
|| crlf || '   else',
|| crlf || '      do',
|| crlf || '         say ''LOGOFF object creation unsuccessful''',
|| crlf || '         object_creation_error = 1',
|| crlf || '     end' || crlf,
|| crlf || '/* Create an object for renewzip_cmd */',
|| crlf || '   title = ''Reply Zip Restorer for^'' || translate(''' || reply_packet || ''', Lowcase, Upcase) /* to lower case */', 
|| crlf || '   exename = home || ''\' || renewzip_cmd || '''',
|| crlf || '   iconfile = home || ''\icons\' || renewzip_ico || '''',
|| crlf || '   startupdir = home' || crlf,
|| crlf || '   setup = ''OBJECTID=<'' || title || ''>'' ||,',
|| crlf || '            '';ICONFILE='' || iconfile ||,',
|| crlf || '            '';EXENAME='' || exename ||,',
|| crlf || '            '';STARTUPDIR='' || startupdir' || crlf,
|| crlf || '   if SysCreateObject(classname, title, location, setup, ''U'') then',
|| crlf || '      do',
|| crlf || '         say RENEWZIP_CMD ''object created/updated successfully''',
|| crlf || '      end',
|| crlf || '   else',
|| crlf || '      do',
|| crlf || '         say ''RENEWZIP object creation unsuccessful''',
|| crlf || '         object_creation_error = 1',
|| crlf || '      end',
|| crlf || 'END  /* creating program objects in the Desktop Folder we created */ ' ,
|| crlf || 'say ''''',
|| crlf || 'say ''Press any key to exit...''',		
|| crlf || 'answer = SysGetKey(''NOECHO'')'

call lineout objects_cmd, dataline
call stream objects_cmd, 'c', 'close'
say '  ' objects_cmd 'created/updated successfully.'

RETURN

/*
==============================================
HANDLING OF ERROR TRAPS

ReXX Errors (failure, halt, syntax, novalue, error)
that occur with SIGNAL ON XXXXX (XXXXX = failure,
halt, etc.) are diverted (jump) to one of these
where the error and the offending line are identified.
==============================================
*/

FAILURE:
say 'Rexx FAILURE error' rc 'in line' sigl || ':' errortext(rc) crlf sourceline(sigl)
call beep 300, 500
/*trace ?r; nop*/
signal goodbye
RETURN

HALT:
say 'Rexx HALT' rc 'in line' sigl || ':' errortext(rc) crlf sourceline(sigl)
call beep 300, 500
/*trace ?r; nop*/
signal goodbye
RETURN

SYNTAX:
say 'Rexx SYNTAX error' rc 'in line' sigl || ':' errortext(rc) crlf sourceline(sigl)
call beep 300, 500
/*trace ?r; nop*/
signal goodbye
RETURN

NOTREADY:
say 'Rexx NOTREADY error' rc 'in line' sigl || ':' errortext(rc) crlf sourceline(sigl)
call beep 300, 500
/*trace ?r; nop*/
signal goodbye
RETURN

ERROR:
say 'Rexx ERROR error' rc 'in line' sigl || ':' errortext(rc) crlf sourceline(sigl)
call beep 300, 500
/*trace ?r; nop*/
signal goodbye
RETURN

/*
==============================================
GOODBYE()

Final "we did it" or "we didn't" message, and exit
==============================================
*/
GOODBYE:
say ''
if completed & findfile_ErrNum = 0 then
   do
      say 'Installation completed successfully'
      if object_creation_error then
         do
            say 'EXCEPT for desktop object creation.  All .CMD files'
            say 'are in the' home 'directory, though.'
         end
   end
if completed & findfile_ErrNum > 0 then
   do
      call SysCls
      say 'Installation completed.'
   end
if \completed | findfile_ErrNum > 0 then
   do
      say ''
      say '*************'
      say '   WARNING:'
      say 'An error was encountered during the installation'
      say '   or'
      say 'the installation was aborted before completion'
      say '*************'
      say ''
      call beep 262, 200
   end 
if completed then
   do
      say 'You may want to print out and inspect' ydparms_dat
      say 'Changes to it may be made using an ASCII editor such as the'
      say 'OS/2 System Editor without having to re-run' ydinstl_cmd
      say ''
   end
if findfile_ErrNum > 0 then
   do
      if findfile_ErrNum > 0 then
         do
            say ''
            say 'ERROR(S):'
            do while findfile_ErrNum > 0
               say 'Unable to locate any instance of',  
                 unfound_file.findfile_ErrNum
               findfile_ErrNum = findfile_ErrNum - 1
               say ''
            end
         end
   end
say ''
say edit_dialup_string_msg
say 'YarnDial installation over at' time()
time = time('E')
time = time/60
time = format(time, ,1) 
say 'Elapsed time:' time 'minutes.'
say ''
say 'Press any key to exit...'
answer = SysGetKey('NOECHO')
call SysDropFuncs
x = endLocal()
EXIT
RETURN

/*
==============================================
welcome_to_this_installer()

Long welcome message.  Put here for a neater
program, though we call to it near startup.
==============================================
*/
welcome_to_this_installer:
call SysCls
say ''
say 'Welcome! YARNDIAL installer, v.' version 'of' translate(ydinstl_cmd)
say '(c) 1996 Jerry Levy, Marblehead, MA USA (all rights reserved).'
say ''
say 'ABOUT THIS INSTALLER'
say 'This will install YarnDial on your machine, copying files to the'
say 'Yarn Home directory.  It should be very straightforward to use if'
say 'you have Yarn and Souper already up and running and did a pretty'
say 'much by-the-book installation of them.'
say ''
say 'If you have more than one Yarn home directory (Yarn allows separate'
say 'home directories for separate users or providers), you can select a'
say 'default or specify which one(s) to install to.'
say ''
say 'Each installation creates a unique' translate(ydparms_dat) 'data file'
say 'and a suite of customized Rexx .CMD programs, all of which get'
say 'stored in the particular home directory you are installing to.'
say 'A YarnDial Desktop Folder is created to house program objects.'
say ''
say translate(ydparms_dat) 'can be edited after the installation.'
say ''
say '(Continued -- Press any key)'
call SysGetKey 'NOECHO'
call SysCls
say ''
say 'INSTRUCTIONS (cont''d)'
say 'You will be asked what kind of zip and unzip utilities you are using.'
say 'Read' yd_doc 'if you need help.'
say ''
say 'No changes are made to your system until the very end of the installation,'
say 'so you may run through it without risk and escape out before the end.'
say ''
say ''
say '' 
say 'Press any key to continue the installation (ESC quits)'
if SysGetKey('NOECHO') = Escape then signal goodbye
RETURN

/*
==============================================
initialize_variables():

We make an early call to this to initialize
variables.  A long list so we put the routine
at the end of the program for neatness sake.
==============================================
*/
initialize_variables:
/* Default filenames and other stuff we need.

These are initialized to something because we want default values */
yarn_exe = 'YARN.EXE'
import_exe = 'IMPORT.EXE'
export_exe = 'EXPORT.EXE'
expire_exe = 'EXPIRE.EXE'
rebuild_exe = 'REBUILD.EXE'
filter_exe = 'FILTER.EXE'
souper_exe = 'SOUPER.EXE'
yarnshell_cmd = 'YRNSHELL.CMD'
yarnutil_cmd = 'YRNUTIL.CMD'
renewzip_cmd = 'RENEWZIP.CMD'
objects_cmd = 'OBJECTS.CMD'
logoff_cmd = 'LOGOFF.CMD'
go_exe = 'GO.EXE'
IAKdialer_exe = 'DIALER.EXE'
slippm_exe = 'SLIPPM.EXE'
killjoy_exe = 'KILLJOY.EXE'
injoy_exe = 'IN-JOY.EXE'
os2_zip_exe = 'ZIP.EXE'
os2_unzip_exe = 'UNZIP.EXE'
os2_zip_options = '-0m'
os2_unzip_options = '-o'
msdos_zip_exe = 'PKZIP.EXE'
msdos_unzip_exe = 'PKUNZIP.EXE'
msdos_zip_options = '-m -u -o'
msdos_unzip_options = '-o'
msdos_cmd_interp = 'CMD.EXE /C'
souper_getmail_std_options = '-i -n' 
getmail_xtra_options = '' 
souper_getnews_std_options = '-i -m' 
getnews_xtra_options = '' 
souper_send_std_options = '-i -s'
send_xtra_options = ''


/*
===============
We set these remaining variables initially to a blank.
Some will become set in the course of the installation.
We do not want the yarndial data file we create
(YD_PARMS.DAT) to be all cluttered up with error
indications which is what happens if we don't assign
the blanks.
===============
*/
HOME=''
YARN=''
connection_type=''
user=''
host = ''
adv_account=''
adv_popserver=''
adv_newsserver=''
adv_password=''
adv_smtpserver=''
ASK = ''
GS = ''
WS = ''
DN1 = ''
DN2 = ''
IS1 = ''
IS2 = ''
RS1 = ''
RS2 = ''
FS1 = ''
FS2 = ''
PIN = ''
MD = ''
EMI = ''
wait = '' 
zip_exe = ''
unzip_exe = ''
tcpos2ini_app = ''
dialup_string = ''
Use_dialup_string = 'NO'
PROVIDER = ''
LOGIN_ID = ''
PWD = ''
SAVE_PWD = ''
PHONE_NUMBER = ''
HANGUP =  ''
SCRIPT = ''
SERVICE = ''
YOURIP = ''
DESTIP = ''
NETMASK = ''
MTU_SIZE = ''
VJ_COMP = ''
HOSTNAME = ''
DOMAIN_NAME = ''
DNS = ''
DEFAULT_NEWS = ''
DEFAULT_WWW = ''
DEFAULT_GOPHER = ''
MAIL_GW = ''
POPSRVR = ''
REPLY_DOMAIN = ''
REPLY_ID = ''
POP_ID = ''
POP_PWD = ''
MODEM_TYPE = ''
COMPORT = ''
BAUD = ''
DATABITS = ''
PARITY =  ''
DIAL_MODE = ''
PREFIX = ''
PREFIX_ANS = ''
INIT = ''
INIT2 = ''
DISABLE = ''
DISABLE_SEQ = ''
DIAL_PREFIX = ''
AUTOSTART = ''
TOTAL_CONNECT = ''

RETURN


