/* YARNDIAL.CMD v 1.3 (beta) by Jerry Levy 	20 Jul 1996
Comments appreciated: send to jlevy@ibm.net
(Jerry Levy, Marblehead, MA USA) */

version = '1.3 (beta)'

/*
======================History=========================
20 Jul 96 v. 1.3 (beta)
Numerous additions and major cleanup of the code.
Added a separate installer.
Now can choose between use of
  Advantis IAK Dialer
  SLIPPM.EXE Dial-Other-Internet-Providers utility
  SLIP.EXE or PPP.EXE dialup strings
  IN-JOY Dialer
  other dialup strings (you name it)

11 Jun 95	YRNDIAL1 (v 1.1)
Fixed screwed up backing up of the replies .Zip file

11 Jun 95	YARNDIAL (1.0, original)


==========COPYRIGHT NOTICE AND DISCLAIMER=============
YDINSTL.CMD is Copyright 1996 by Jerry Levy (all rights reserved)
YARNDIAL.CMD is Copyright 1995 and 1996 by Jerry Levy (all rights reserved)

These are provided as-is and without charge, with no warranty expressed
or implied as to merchantability or fitness for any particular purpose.  All
responsibility for any and all incidental and consequential damages is
disclaimed.  These programs and associated text files are freeware.  They
may be distributed without restriction providing: (1) this notice and
disclaimer remain intact, (2) all programs and files are included and
unchanged, and (3) they are distributed either in the original .zip archive
or the archive after being unzipped into a folder or onto a disk or other
medium.  Use of either or both of these programs constitutes acceptance
of these terms by all users.

================INSTALLATION======================
You could read YD.DOC.
Or you could read README.1ST (shorter, recommended).

If YARN and SOUPER are installed and run OK...

...and if you are using the IAK Dialer to connect to Advantis,
or the Dial-Other-Internet_Providers utility (SLIPPM.EXE)...

then just run YDINSTL.CMD.
==================================================
 
*/

arg otherparms		/* for later contingency */

cr = d2c(13)		/* enter key, as well as carriage return */
crlf = d2c(13) || d2c(10)	/* carriage return + linefeed */
escape = d2c(27)	/* escape character */
ctrl_R = d2c(18)
bs = d2c(8)	/* Backspace */
tab = d2c(9)	/* tab */
X1 = d2c(0)	/* Extended key */
X2 = d2c(224)	/* Extended key */

say ''
say 'YRNDIAL.CMD v' || version
say '(c) 1995 & 1996 by Jerry Levy (all rights reserved)'
say 'jlevy@ibm.net	Marblehead, MA USA'
say ''
say 'Dials in, gets or posts news, mail and replies'
say 'and signs off when done.' crlf
time1 = time()
date1 = date('S')
date1 = left(date1,4) || '/' || substr(date1,5,2) || '/' || right(date1,2)
/* format date as yyyy/mm/dd */

/* This program has been tested with various recent YARN and
SOUPER versions through YRN2_091 and SOUPER15 */

signal on failure
signal on halt
signal on syntax
signal on notready
signal on error

trace 'N'

timeout = 0
/* Flag is reset to 1 if dialer times out */

Abandon = 0     /* Initialize*/
replies_zip = 1	/* if we try to export mail and there is none, this is reset to 0 */
do_catchup_on_news = 0	/* initialize the flag to no news catchup */

/* MAIN PROGRAM */

/* Load Rexx Util functions if not already loaded */
if RxFuncQuery('SysLoadFuncs') \= 0 then
   do
      call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
      call SysLoadFuncs
   end

/* Initialize these filenames */
go_exe = 'GO.EXE'
ydinstl_cmd = 'YDINSTL.CMD'
ydparms_dat = 'YD_PARMS.DAT'
injoy_exe = 'IN-JOY.EXE'
slippm_exe = 'SLIPPM.EXE'
IAKdialer_exe = 'DIALER.EXE'

'@echo off'				/* No echoing of any os/2 commands */
home = directory()			/* Where we are executing this pgm from */
home = translate(home)
ydparms_dat = home || '\' || ydparms_dat /* All the parameters we need are here */
/* Abort if can't locate the ydparms_dat.  Means we never ran the installer */
if stream(ydparms_dat, 'c', 'query exists') = '' then
   do
      go_exe = home || '\' || go_exe	/* assume that's where it is */
      call beep 1000, 200
      say 'Cannot find YD_PARMS.DAT file with parameters needed to run.'
      say 'This is normal if you have not run the installer,' YDINSTL_cmd
      say 'or have not run it specifying a valid home directory.'
      say ''
      say 'Aborting.  Press any key to exit.  Then run' YDINSTL_cmd
      call SysGetKey 'NOECHO'
      signal goodbye
   end

say 'Please wait while parameters load and we set up...'
call parms_from_ydparms_dat		/* Read in all the parameters from the datafile */

/*
====================
(Re)set HOME and YARN environmental variables.
Later, in the dialup_server() routine, we will (re)set the NNTPSERVER (newsserver) environmental variable.  In that routine we first decide which parameter from
the yd_parms.dat file has the correct newsserver assignment, then we set
NNTPSERVER to that
====================
*/

x = SetLocal()
x = value('home', home, 'OS2ENVIRONMENT')
x = value('yarn', yarn, 'OS2ENVIRONMENT')

/* We look for some obvious inconsistencies or omissions in YDPARMS_DAT */
call fatal_error_check

call directory_maintenance

/* are we connected? to whom? is it the right connection? */
call get_current_connection

/*
=============================================
This is the main menu.  Point of interest: if we select 7
(souper options) we first dial in to the system and only
after we're connected do we get to select the options.
Then we get another menu asking if we want to get/send
stuff.
=============================================
*/
   say ''
   say 'Press:'
   say '1  Only import Mail'
   say '2  Only import News Articles'
   say '3  Only import, but both Mail AND News'
   say '4  Only export (send Mail, Posts, Replies, and Follow-ups)'
   say '5  Everything: Get mail and news AND send Posts, Replies, and Follow-ups'
   say '6  Complete an interrupted importation of mail/news'
   say '         or rebuild a corrupted YARN history file'
   say '7  Souper options:  one-time-only changes in how souper runs:'
   say '      Catchup on News'
   say '      Maximum News Packet Size'
   say '      Do not retrieve newsgroup articles Longer than set number of lines'
   say '      Read-only for Mail: Don''t empty POP3 Mailbox'
   say 'Pressing Esc key exits now.  Enter Selection:'
 
do until pos(choice, '1234567') \= 0 
   choice = SysGetKey('NOECHO')
   select
      when choice = Escape then signal goodbye
      when pos(choice, '1234567') = 0 then
         do
            say ''
            say 'Selection' choice || '.  Must be 1-7 or Escape key.  Try again...'
            say ''
        end
      otherwise NOP
   end
   say ''
   say 'Selection: ' choice
   say ''
end

/*
====================
A home\replies folder (empty) may be left behind as trash
after execution of mail/news retrieval from some Yarn/Souper
installations. We get rid of it if your setup of Yarn/Souper
leaves one behind.
====================
*/
replies_dir = home || '\replies'
call SysRmDir replies_dir

   /* Fix the interrupted import */
if choice = pos(choice, 'xxxxx6x') then
   do
      call fix_import
      signal goodbye			/* Exit the program when done */
   end
if choice = pos(choice, 'xxxxxx7') then
   do
      call SysCls
      say ''
      say 'You selected to modify souper options.'
      say ''
      say 'We will first dial in.'
      say ''
      say 'After a connection is successfully established you will'
      say 'be asked to select your one-time-only souper options.'
      say ''
      say 'When you are finished with that, another menu will pop'
      say 'up asking if you want to get news or mail, or send posts.'
      say ''
      say 'To quit now, press Escape'
      say 'Any other key starts the dialup connection'
      if SysGetKey('NOECHO') = Escape then signal goodbye
      else NOP
    end
call dialup_server
call time('R')		/* start clock recording time on line */

/*
=================
These next conditionals process selections we made from the main menu.
=================
*/
      if choice = pos(choice, 'xxxxxx7') then
         do
            call souper_options
            choice = menu2() /* reset choice */
         end
      if choice = pos(choice, '1x3x5xx') then call import_mail
      if choice = pos(choice, 'x23x5x7') then call import_news
      if choice = pos(choice, 'xxx45xx') then call exporter

call kill_dialers_slip_ppp_slattach		/* Kill these and slattach, too */

call restore_zip	/* If sending went south on you, you can restore to send again */
call toss_old_news

signal Depart				/* Exit and report times */

/*
=================
End of main program
=================
*/

/*
=======================================
fatal_error_check()

We check for some obvious flaws in the data
returned from YDPARMS_DAT
=======================================
*/

fatal_error_check:
service = translate(service)		/* Upper case */

if pos(connection_type, '1234567') = 0 then
   do
      say 'Fatal error in' ydparms_dat '; the connection_type'
      say 'can only be 1-7'
      say ''
      Abandon = 1
   end

if connection_type = pos(connection_type, '12345x7') & dialup_string = '' then
   do
      say 'Fatal error in' ydparms_dat
      say 'Dialup_string is blank.  Cannot be blank if connection_type is 1-5 or 7.'
      say ''
      Abandon = 1
   end

if service \= 'SLIP' & service \= 'PPP' then
   do
      say 'Fatal error in' ydparms_dat '; service must be either'
      say 'SLIP or PPP.  Edit' ydparms_dat 'to correct'
      say ''
      abandon = 1
   end

if Abandon = 1 then
   do
      say 'Aborting...'
      signal goodbye
   end
RETURN

/*
=================
get_current_connection()

(1)  Check whether slippm.exe, slip.exe, ppp.exe, in-joy.exe,
IAK Dialer, IN-JOY are running.  Are what is running the right
processes for our connection_type and service (SLIP or PPP)?
Of these processes:
	SLIP.EXE
	PPP.EXE
	SLIPPM.EXE
	IN-JOY.EXE
	the IAK Dialer
Close down any that are not consistent with
our connection_type.

Then determine: which ones are (left) running?

(2)  Get full path to tcpos2.ini, using the etc environment
variable.  Then query the CONNECTION app in it as the
CURRENT_CONNECTION key to find out to whom we are
connected (if we are connected).  Note that this may
be not to what we ARE connected to but to what we WERE
connected to the last time we were connected.

(3)  Check for sl0 and ppp0 router interfaces
====================
*/
get_current_connection:
say 'Check for an existing connection, and whether it is correct for us:'
say '   Active dialers? Active SLIP or PPP?...'
if connection_type = 1 then	/* IBM/Advantis IAK Dialer only */
   do
      service = 'SLIP'	/* must be for the IAK Dialer */
      call close_down 'ppp'	/* ...because none of these should be running */
      call close_down 'slippm'
      call close_down 'in-joy'
   end

if service = 'PPP' then call close_down 'slip'
if service = 'SLIP' then call close_down 'ppp'

if pos(connection_type, '23') \=0 then /* SLIPPM or dialup_string */
   do
      call close_down 'in-joy'
      call close_down 'dialer'
   end

if connection_type = 4 then	/* IN-JOY Dialer */
   do
      call close_down 'slip'	/* IN-JOY doesn't use this...*/
      call close_down 'ppp'	/* ...or these...*/
      call close_down 'slippm'	/*...either... */
      call close_down 'dialer'	/*...or IAK Dialer */
   end


/*
===============
See what stuff related to dialers or dialup strings may
be running

and


Poll the routers: is an sl0 or a ppp0 interface up?
Note, however, that what is returned may not be
currently active, and what is returned could represent
the last occurrence not a present connection.
These  routines call to wait_for_ppp() and wait_for_slip(),
which both use NETSTAT.EXE to poll.
===============
*/

/*
==================
These are flags.  They are set to 1 if a process is running
or an interface is up.  Initialize all to zero
==================
*/
slip_is_running = 0
ppp_is_running = 0
slippm_is_running = 0
injoy_is_running = 0
slipexe_or_pppexe_running = 0

IAKdialer_is_running = 0
slip_interf_up = 0
ppp_interf_up = 0
lan_interf_up = 0
ppp_or_slip_or_lan_interf_up = 0

/* are any of these running? */
call is_slip_running	/* If so returns slip_is_running=1 */
call is_ppp_running	/* If so returns ppp_is_running=1 */
call is_slippm_running	/* If so returns slippm_is_running=1 */
call is_IAKdialer_running	/* If so returns dialer_is_running=1 */
call is_injoy_running	/* is it? If so returns injoy_is_running=1 */

if slip_is_running | ppp_is_running then slipexe_or_pppexe_running = 1
   else slipexe_or_pppexe_running = 0

say '   Checking router interfaces...'
/* Check for ppp0 or sl0 or lan0 router interfaces
we may not use this information, but this step is
done here in anticipation of future uses */

call wait_for_slip 3, 1, 1
if found_interface then slip_interf_up = 1 else slip_interf_up = 0

call wait_for_ppp 3, 1, 1 
if found_interface then ppp_interf_up = 1 else ppp_interf_up = 0

/*call wait_for_lan 3, 1, 1 
if found_interface then lan_interf_up = 1 else lan_interf_up = 0  */

if ppp_interf_up | slip_interf_up | lan_interf_up then ppp_or_slip_or_lan_interf_up = 1
   else ppp_or_slip_or_lan_interf_up = 0

/*
==================
Get path to TCPOS2.INI file? Is file there?

Then get current_connection info
to help decide if it is "us"
==================
*/

tcpip_etc_path = value('etc', , 'OS2ENVIRONMENT')
tcpos2_ini = tcpip_etc_path || '\' || 'tcpos2.ini'
if stream(tcpos2_ini, 'c', 'query exists') = 0 then say 'Couldn''t find' tcpos2_ini

current_connection_key = SysIni(tcpos2_ini, 'CONNECTION', 'CURRENT_CONNECTION')

/* strip final null char */
current_connection_key = strip(current_connection_key, 'T', X1)
userID_connected = SysIni(tcpos2_ini, 'CONNECTION', current_connection_key)
userID_connected = strip(userID_connected, 'T', X1)
parse var userID_connected user_ID ',' system_app

/*
====================
Next we will decide if we need to dial or whether we
can use what may already be established as a connection.

When dial = 1 we need to dial.  We will determine
below whether, if we are already on line, we are online
to the provider for this user installation or not.  If
we cannot ID the provider as ours we simply close down
SLIP, PPP, SLIPPM, and the IAK DIALER and redial.  First
we set the dial flag (set dial = 1), then we determine
if we should really dial.  If we are connected to our
provider we zero the dial flag.
====================
*/

dial = 1	/* initialize it */

/*
===================
All dialers we support will have either an
sl0 or ppp0 interface established when connected
===================
*/

if slipexe_or_pppexe_running then	/* not for connection_type 4 */
select
/*
====================
Compare some parms we just got from the CONNECTION
app of TCPOS2.INI to corresponding information in our
YDPARMS_DAT.  Or are we ADVANTIS?  We can make a pretty
good (not perfect) assessment in this simple way whether
we are connected to the right provider.
====================
*/
   when connection_type =  1,
      & IAKdialer_is_running,
      & translate(user_ID) = translate(user),
      & translate(system_app) = 'ADVANTIS' then	/* it's us! */
      do
         say 'Two beeps means' user 'is already connected to ADVANTIS.  Proceed.'
         say ''
         call beep 1000, 200
         call beep 32767, 25  /* Too high pitched, inaudible, an improvised pause. */ 
         call beep 1000, 200
            'start' IAKdialer_exe account user password
         dial = 0	/* unset the flag: we do not need to dial up server */
      end

   when connection_type = 2,
      & slippm_is_running,
      & translate(user_ID) = translate(login_ID) then
      do
         say 'Two beeps means we are already correctly connected as'
         say 'user_ID ' user_ID '(Pop_ID:' pop_id || ').  Proceed.'
         say ''
         call beep 1000, 200
         call beep 32767, 25
         call beep 1000, 200
         dial = 0	/* We do not need to dial up server */
      end
   
   when connection_type = 3,   /* like for connection_type=2 but any dialer string */
      & translate(user_ID) = translate(login_ID) then
      do
         say 'Two beeps means we are already correctly connected as'
         say 'user_ID ' user_ID '(Pop_ID:' pop_id || ').  Proceed.'
         say ''
         call beep 1000, 200
         call beep 32767, 25
         call beep 1000, 200
         dial = 0	/* We do not need to dial up server */
      end
   
   when connection_type = 5 | connection_type = 6 then
      dial = 0	/* Pot Luck: we do not need to dial up server */

   otherwise 
         say 'Connected, but to a provider or for a connection different than'
         say 'the one for which this YARN user installation was configured.'
         say 'We are closing down SLIP, PPP, SLIPPM and IAK Dialer or IN-JOY'
         say '(if any are up) so we can dial up to our provider...'
         say ''
         dial = 1	/* we will dial when we hit dialup_server() */
         call kill_all   /* kill IAK dialer, slippm, slip, ppp, slattach, just in case */
end   /* of select */


if connection_type = 4 then
select
   when ppp_interf_up & injoy_is_running then
      do
         say 'Two beeps means we are already correctly connected.  Probably via'
         say 'IN-JOY.  We will try to use whatever we are connected to.  Proceed.'
         say ''
         call beep 1000, 200
         call beep 32767, 25
         call beep 1000, 200
         dial = 0	/* We do not need to dial up server */
      end

   when \ppp_interf_up | \injoy_is_running then
      do
         dial = 1	/* We need to dial up using in-joy */
      end
end   /* of select */

RETURN

/*
=====================
directory_maintenance()

Some grunt work to get drives, directoriws we need.
=====================
*/

directory_maintenance:
home_drive = filespec('drive', home)
parse var reply_packet rpname '.' ext
yarn_outgoing_drive = filespec('drive', reply_packet)
yarn_outgoing_dir = yarn_outgoing_drive || strip(filespec('path', reply_packet), 'T', '\')

call SysMkDir home || '\incoming'
/* For temp storage of incoming mail and news */

RETURN

/*
================
These four routines ose GO.EXE to let us determine whether
	SLIP.EXE
	PPP.EXE
	SLIPPM.EXE
	IN-JOY.EXE
are running processes
================
*/

is_slip_running:
signal off error
slip_is_running = 0
go_exe '-cp SLIP > NUL'	/* returns 1 if slip is running, 0 if not */
If RC then
   do
      slip_is_running = 1
   end
signal on error
RETURN

is_ppp_running:
signal off error
ppp_is_running = 0
go_exe '-cp PPP > NUL'	/* returns 1 if ppp is running, 0 if not */
If RC then
   do
      ppp_is_running = 1
   end
signal on error
RETURN

is_injoy_running:
signal off error
injoy_is_running = 0
go_exe '-cp IN-JOY > NUL'	/* returns 1 if in-joy is running, 0 if not */
If RC then
   do
      injoy_is_running = 1
   end
signal on error
RETURN

is_slippm_running:
signal off error
slippm_is_running = 0
go_exe '-cp SLIPPM > NUL'	/* returns 1 if slippm is running, 0 if not */
If RC then
   do
      slippm_is_running = 1
   end
signal on error
RETURN

is_IAKdialer_running:
signal off error
IAKdialer_is_running = 0
go_exe '-cp DIALER > NUL'	/* returns 1 if IAK Dialer is running, 0 if not */
If RC then
   do
      IAKdialer_is_running = 1
   end
signal on error
RETURN


/*
=========================================
close_down(process)

Close down a process (such as slip or ppp or slippm) with
GO.EXE using the -ka option kills all instances of 'process'.
No harm done if 'process' not running  and we try to close it down.
=========================================
*/
close_down:
parse upper arg process
signal off error
go_exe '-cp' process '> NUL'	/* returns RC=1 if process is running and 0 if not */
if RC & process = 'DIALER' then
   do
      call is_IAKdialer_running
      if IAKdialer_is_running then 
         do
/* Only try to close this way if IAK duller is confirmed to be running */
            process '-c' /* hope IAK dialer is at least v 1.33 where -c option supported */
            call SysSleep 2 /* settle time, IAK Dialer is funny */
            say '   If you lost this window for a few seconds or just heard a beep'
            say '   that is normal for closing down certain versions of IAK Dialer'
         end
   end
/* try to shut down in-joy with IN-JOY's own killjoy.exe */
if RC & process = 'IN-JOY' then
   do
      if stream(killjoy_exe, 'c', 'query exists') \= '' then killjoy_exe
      call SysSleep 2	/* settle time */
   end
go_exe '-ka' process '> NUL'  /* do a kill whether running or not */
signal on error
RETURN

/*
====================
This is the menu that comes up after we have made
one-time-only (i.e., for this session only) to the
souper command-line options
====================
*/
 
menu2:
   say ''
   say '   Any changed option settings are in force for this session only.'
   say ''
   say 'Press:'
   say '1  Only import Mail'
   say '2  Only import News Articles'
   say '3  Only import, but both Mail AND News'
   say '4  Only export (send Mail, Posts, Replies, and Follow-ups)'
   say '5  Everything: Get mail and news AND send Posts, Replies, and Follow-ups'
   say 'Pressing Esc key exits now.  Enter Selection:'
 
do until pos(choice, '12345') \= 0 
   choice = SysGetKey('NOECHO')
   select
      when choice = Escape then signal goodbye
      when pos(choice, '12345') = 0 then
         do
            say ''
            say 'Selection' choice || '.  Must be 1-5 or Escape key.  Try again...'
            say ''
        end
      otherwise NOP
   end
   say ''
   say 'Selection: ' choice
   say ''
end
RETURN choice

/*
=========================================================
dialup_server()

Starts IAK Dialer object (which starts SLIP), or starts Dial-
Other-Internet-Providers object (SLIPPM.EXE, which in turn
starts SLIP or PPP depending upon how slippm is configured
for the provider).  Alternatively runs a dialup string which
could be ppp.exe or slip.exe with a (horrendously long) string
of arguments, or some other dialup string.

As slip.exe (or ppp.exe) starts to do its respective thing,
wait_for_slip() (or wait_for_ppp()) start a timed wait.
If we connect, or if we ere already connected when SLIP.EXE
or PPP.EXE were started, wait_for_slip() or wait_for_ppp()
will sense that, and this subroutine ends. It also ends if
we time out.

We start by reassigning some variables depending upon the
connection_type, then we start the actual dialup.

The dial variable was assigned 0 or 1 in the get_current_connection()
subroutine.  If dial=1 we must dial, if dial=0 we were connected to
the right provider already.

AN EXCEPTION TO THE ABOVE:  If connection_type is 5 or 6
we don't check anything.  We expect the connection to be
established before we start YarnDial. 
=========================================================
*/
dialup_server:
/*
=============
connection_type 1 is for IAK Dialer only
=============
*/
if connection_type = 1 then				/* IAK Dialer only */
   do
      say 'Connecting to Advantis via the IAK Dialer...'
      user = user
      account = adv_account
      popserver = adv_popserver
      smtpserver = adv_smtpserver
      newsserver = adv_newsserver
      password = adv_password
      LOGON_ID = translate(user)

/* Now set or reset the NNTPSERVER environment variable to newsserver */
      x = value('NNTPSERVER', newsserver, 'OS2ENVIRONMENT')

      if dial then
         do
            say user 'dialing' account '<password> via use of IAK Dialer' 
         end
   end  	/* if connection_type = 1 */

/*
=============
For connection_type 2, 3, and 4 we expect that parameters
fetched from TCPOS2.INI (resulting from SLIPPM setup) will be
found in proper places in YD_PARMS.DAT
=============
*/
if pos(connection_type, '234') \= 0 then
   do
      user = pop_id
      account = provider
      popserver = popsrvr
      smtpserver = mail_gw
      newsserver = default_news
      password = pop_pwd

/* Set or reset the NNTPSERVER environment variable to newsserver */
      x = value('NNTPSERVER', newsserver, 'OS2ENVIRONMENT')

      if dial then
         do
            if connection_type = 2 then
               do
                  say user 'Dialing' tcpos2ini_app 'via use of ' slippm_exe
                  say '(IBM Dial-Other-Internet-Providers Utility)...'
               end
            if connection_type = 3 then
               do
                  say 'Dialing' tcpos2ini_app ' with dialup_string in YD_PARMS.DAT...'
               end 
            if connection_type = 4 then
               do
                  say 'Dialing' tcpos2ini_app 'with the IN-JOY dialer'
               end
         end
   end   	/* if connection_type 2, 3 or 4 */

/*
=============
For connection_type 6 (especially), but also for
5 and 7, we are a bit more flexible about where
some parms we need may be found in YD_PARMS.DAT
=============
*/
if pos(connection_type, '567') then
   do
      if user = "" then user = pop_id
      if adv_account = '' then account = provider
         else account = adv_account
      if adv_account = '' then popserver = popsrvr
         else popserver = adv_popserver
      if adv_account = '' then smtpserver = mail_gw
         else smtpserver = adv_smtpserver
      if adv_account = '' then newsserver = default_news
         else newsserver = adv_newsserver
      if adv_account = '' then password = pop_pwd
         else password = adv_password

/* Set or reset the NNTPSERVER environment variable to newsserver */
      x = value('NNTPSERVER', newsserver, 'OS2ENVIRONMENT')

      if connection_type = 5 then
         do
            say 'YD_PARMS.DAT was manually configured: Dialing with'
            say 'dialup_string in YD_PARMS.DAT...'
         end

      if connection_type = 6 then
         do
            say 'Will not attempt to validate vs. parameters in YD_PARMS.DAT'
            say 'Trying to use any currently established connection...'
         end

      if connection_type = 7 then
         do
            say 'Will not attempt to validate vs. parameters in YD_PARMS.DAT'
            say 'Dialing with dialup_string in YD_PARMS.DAT...'
         end
   end   	/* if connection_type 5, 6 or 7 */

/*
===================
Dial up.
Unless we are connection_type 6, we wait for
sl0 or ppp0 interface before going on to get/send
mail or news.  Or if we time out after 'wait'
seconds, we exit
===================
*/
if pos(connection_type, '123457') \=0 then
   do
      interpret dialup_string  /* dialup_string, as read in from YD_PARMS.DAT */

 /* 'wait' = seconds to wait for a connect */
      if service = 'SLIP' then call wait_for_slip wait, 1, 0
      if service = 'PPP' then call wait_for_ppp wait, 1, 0
      if \found_interface then
         do
            timeout = 1
            say 'Dialer timed out.  Exiting...'
            call time('R')  /* No connection.  We zero the elapsed-time clock */
            signal on error
            signal goodbye
         end
   end
RETURN

/*
============================
import_mail()
import_news()
exporter()

Believe it or not, executing these three subroutines
are the substance of YarnDial.  The other 90% of
this exercise is fluff.
============================
*/

import_mail:
home_drive
'cd' home || '\incoming'	
say 'You are now importing mail from' popserver
souper_exe souper_getmail_std_options getmail_xtra_options popserver user password
zip_exe 'soup.zip areas *.msg'
import_exe 'soup.zip'
say ''
RETURN

import_news:
home_drive
'cd' home || '\incoming'
say 'You are now importing news from' newsserver
souper_exe souper_getnews_std_options getnews_xtra_options newsserver user password
zip_exe 'soup.zip areas *.msg'
import_exe 'soup.zip'
say ''
RETURN

exporter:
say crlf || 'You are now exporting posts, replies, and follow-ups'
say 'to' smtpserver

/* if a reply-packet exists, send mail */
if stream(reply_packet, 'c', 'query exists') \= '' then
   do
      yarn_outgoing_drive	/* Change to outgoing drive and directory */
      'cd' yarn_outgoing_dir
      'copy' reply_packet rpname || '.BAK > nul'
      unzip_exe reply_packet
      souper_exe souper_send_std_options send_xtra_options smtpserver user password
      'erase' reply_packet
   end
else	/* tell us nothing waiting to be sent */
   do
      say ''
      say reply_packet 'not found.'
      say 'Means no replies are waiting to be sent.'
      replies_zip = 0
   end
RETURN

/*
=====================
catch()

For catching up on news.  Sets the Howmany variable.
Howmany is number of unread news articles (max) we
retrieve from each newsgroup (all the older ones
in each newsgroup are marked as read)
=====================
*/
Catch:
HowMany = ''
call SysCls
say 'News catchup was selected'
say ''
say ''
say 'Mark every article not yet downloaded in'
say 'each newsgroup as read except for the last n articles.'
do until DataType(HowMany,'W')
   say 'Enter n (Max number to be transferred to you).'
   prompt = 'It must be a whole number  (Esc exits now):'
   say prompt
   parse value SysCurPos() with row col
   row  = row - 1
   col = length(prompt) + 2
   call SysCurPos row, col
   pull HowMany .
   if HowMany = Escape then
      do
         say 'Esc pressed, Quitting...'
         signal goodbye
      end
   if DataType(HowMany) = 0 then
      say 'Whole number only. Try Again.' 
end
RETURN

fix_import:
/*
===================
if for some reason the imported mail or news files
were not zipped and/or they were not imported into
YARN repositories correctly (for example, if your
machine crashed or if you had yarn running while
SOUPER was fetching them), this option may be able
to zip into soup.zip any that were unzipped at the
time, and will process the soup.zip and import the
messages.  In case YARN's history file might have
become corrupted in the process or has independently
become corrupted, it will also (try to) rebuild it.

Before we do anything, though, we kill slip, ppp,
IAKdialer, etc., so we are doing whatever we do (which
takes a long time) while off-line. 
=================
*/
say 'If on-line, we will get off line.  This may take several seconds...'
call kill_dialers_slip_ppp_slattach		/* Kill these and slattach, too */
						/* and injoy if we are connection_type 4 */

say crlf || 'IMPORTING WAS INTERRUPTED? NEED TO REBUILD YARN History File?'
say 'If either you did not complete the importing of news or mail and/or'
say 'if YARN''s History File has become corrupted, we can now try to complete'
say 'the importing of mail and news and also do a YARN History File rebuild.'
say 'The rebuild may take some time...'
say ''
say 'Don''t bother with this unless you think you have a problem or fetching'
say 'and importing of mail/news was interrupted.' 
say ''
say 'CTRL-C quits now without doing anything.  Any other key continues: '
call SysGetKey 'NOECHO' 
home_drive
'cd' home || '\incoming'	
signal off failure
signal off notready
signal off error
zip_exe 'soup.zip areas *.msg'
if stream('soup.zip', 'c', 'query exists') \= '' then	/* scrub import if no zipfile */
   do
      import_exe 'soup.zip'
   end
signal on failure
signal on notready
signal on error
rebuild_exe '-s'		/*fixes spool file, rebuilds history file */
rebuild_exe '-o'		/* rebuilds history and overview files */
say ''
RETURN

kill_dialers_slip_ppp_slattach:	/* kill these, and tell us about it */
	/* also kill slattach, and if connection_type=4, kill injoy using killjoy.exe */
say ''
say 'Killing IAK DIALER, SLIP, PPP, SLATTACH, SLIPPM, IN-JOY (if up)...'
call kill_all	/* next routine does the contract */
say 'We are off-line now.'
say ''
t = time('E')			/* elapsed time, souper processes only */
RETURN

kill_all:		/* calls to this routine kill everything quietly */
call close_down 'dialer'	/* Kill IAK Dialer if up */
call close_down 'slip'		/* and SLIP connection */
call close_down 'ppp'		/* and ppp */
call close_down 'slattach'	/* and slattach */
call close_down 'slippm'	/* and slippm */
if stream(killjoy_exe, 'c', 'query exists') \= '' then
   do
      killjoy_exe
      call SysSleep 2	/* settle time */
   end
call close_down 'in-joy' 
call SysSleep 2		/* just in case, wait a bit and re-kill */
call close_down 'dialer'
call close_down 'slip'
call close_down 'ppp'
call close_down 'slattach'
call close_down 'slippm'
if stream(killjoy_exe, 'c', 'query exists') \= '' then
   do
      killjoy_exe
      call SysSleep 2	/* settle time */
   end
call close_down 'in-joy' 
RETURN

/*
=====================
restore_zip()

Chance to restore zipfile if sending didn't
seem to go right
=====================
*/

restore_zip:
rpname_bak = rpname || '.BAK'
/* if we were exporting posts and replies and if there was a reply_packet */
if pos(choice, 'xxx45xx') \= 0 & timeout = 0 & replies_zip then
   do
      say '     If you got an error sending posts and replies, press'
      say '     CONTROL-R now to restore' reply_packet
      say '     for re-transmission in a later session, but do this'
      say '     only if you got an error.'
      say '     Otherwise press any other key to continue exiting.'
      if SysGetKey('NOECHO') = ctrl_R then
         if stream(rpname_bak, 'c', 'query exists') \= 0 then  
            do
               say 'Restoring' reply_packet
               'copy' rpname_bak reply_packet '> nul'
           end
      else say 'No' rpname_bak 'to restore'
   end
RETURN

/*
================
toss_old_news()

Chance to remove old news using the expire program
===============
*/
toss_old_news:
   Prompt = 'Remove old (expired) yarn messages (Y/N)?'
   say prompt
   parse value SysCurPos() with row col
   row  = row - 1
   col = length(prompt) + 2
   call SysCurPos row, col
   if translate(SysGetKey('NOECHO')) = 'Y' then
      do
         say ''
         say 'Removing expired news' || crlf
         expire_exe '-o'	/* Remove old messages */
      end
RETURN

/*
===================
connect_stats()

How long were we on line retrieving or sending stuff?
==================
*/
connect_stats:
   say '   Retrieval and sending of news and/or mail took' trunc((t/60), 2) 'mins' 
RETURN

/*
===================
parms_from_ydparms_dat()

Assign parameters based on what is in YDPARMS_DAT
==================
*/
parms_from_ydparms_dat:
/* Get parms from ydparms_dat */
n = find_equate_lines_in_datafile(ydparms_dat)
i = 1

/*
====================
Strip out all leading and trailing blanks and tabs
from parsed left and right sides of the equal sign.
Leave any internal ones alone
====================
*/

do until i = n
   parse var line.i parm.i '=' val.i
   parm.i = translate(parm.i)
   do until parm.i = stripped_parm.i & val.i = stripped_val.i
      stripped_parm.i = strip(parm.i, 'B')
      parm.i = strip(stripped_parm.i, 'B', tab)
      stripped_val.i = strip(val.i, 'B')
      val.i = strip(stripped_val.i, 'B', tab)
  end
   if abbrev(line.i, '#') then NOP
   else
          /* set up our variables */
      select
         when parm.i = 'HOME' then HOME = val.i 
         when parm.i = 'YARN' then YARN = val.i
         when parm.i = 'CONNECTION_TYPE' then connection_type = val.i
         when parm.i = 'TCPOS2INI_APP' then tcpos2ini_app = val.i
         when parm.i = 'DIALUP_STRING' then dialup_string = val.i
         when parm.i = 'USER' then user = val.i
         when parm.i = 'HOST' then host = val.i
         when parm.i = 'ADV_ACCOUNT' then adv_account = val.i
         when parm.i = 'ADV_PASSWORD' then adv_Password = val.i
         when parm.i = 'ADV_POPSERVER' then adv_popserver = val.i
         when parm.i = 'ADV_NEWSSERVER' then adv_newsserver = val.i
         when parm.i = 'ADV_SMTPSERVER' then adv_smtpserver = val.i
         when parm.i = 'ZIP_EXE' then zip_exe = val.i
         when parm.i = 'UNZIP_EXE' then unzip_exe = val.i
         when parm.i = 'REPLY_PACKET' then reply_packet = val.i
         when parm.i = 'SOUPER_EXE' then souper_exe = val.i 
         when parm.i = 'IMPORT_EXE' then import_exe = val.i 
         when parm.i = 'EXPORT_EXE' then export_exe = val.i 
         when parm.i = 'EXPIRE_EXE' then expire_exe = val.i 
         when parm.i = 'REBUILD_EXE' then rebuild_exe = val.i
         when parm.i = 'GO_EXE' then go_exe = val.i
         when parm.i = 'SOUPER_GETMAIL_STD_OPTIONS'
            then souper_getmail_std_options = val.i 
         when parm.i = 'GETMAIL_XTRA_OPTIONS'
            then getmail_xtra_options = val.i 
         when parm.i = 'SOUPER_GETNEWS_STD_OPTIONS'
            then souper_getnews_std_options = val.i 
         when parm.i = 'GETNEWS_XTRA_OPTIONS'
            then getnews_xtra_options = val.i 
         when parm.i = 'SOUPER_SEND_STD_OPTIONS'
            then souper_send_std_options = val.i 
         when parm.i = 'SEND_XTRA_OPTIONS'
            then send_xtra_options = val.i
         when parm.i = 'WAIT' then wait = val.i
         when parm.i = 'TCPOS2INI_APP' then tcpos2ini_app = val.i
         when parm.i = 'ASK' then ASK = val.i
         when parm.i = 'GS' then GS = val.i
         when parm.i = 'WS' then WS = val.i
         when parm.i = 'DN1' then DN1 = val.i
         when parm.i = 'DN2' then DN2 = val.i
         when parm.i = 'IS1' then IS1 = val.i
         when parm.i = 'IS2' then IS2 = val.i
         when parm.i = 'RS1' then RS1 = val.i
         when parm.i = 'RS2' then RS2 = val.i
         when parm.i = 'FS1' then FS1 = val.i
         when parm.i = 'FS2' then FS2 = val.i
         when parm.i = 'MD' then MD = val.i
         when parm.i = 'PIN' then PIN = val.i
         when parm.i = 'EMI' then EMI = val.i
         when parm.i = 'PROVIDER' then PROVIDER = val.i
         when parm.i = 'LOGIN_ID' then LOGIN_ID = val.i
         when parm.i = 'PWD' then PWD = val.i
         when parm.i = 'SAVE_PWD' then SAVE_PWD = val.i
         when parm.i = 'PHONE_NUMBER' then PHONE_NUMBER = val.i
         when parm.i = 'HANGUP' then HANGUP = val.i
         when parm.i = 'SCRIPT' then SCRIPT = val.i
         when parm.i = 'SERVICE' then SERVICE = val.i
         when parm.i = 'YOURIP' then YOURIP = val.i
         when parm.i = 'DESTIP' then DESTIP = val.i
         when parm.i = 'NETMASK' then NETMASK = val.i
         when parm.i = 'MTU_SIZE' then MTU_SIZE = val.i
         when parm.i = 'VJ_COMP' then VJ_COMP = val.i
         when parm.i = 'HOSTNAME' then HOSTNAME = val.i
         when parm.i = 'DOMAIN_NAME' then DOMAIN_NAME = val.i
         when parm.i = 'DNS' then DNS = val.i
         when parm.i = 'DEFAULT_NEWS' then DEFAULT_NEWS = val.i
         when parm.i = 'DEFAULT_WWW' then DEFAULT_WWW = val.i
         when parm.i = 'DEFAULT_GOPHER' then DEFAULT_GOPHER = val.i
         when parm.i = 'MAIL_GW' then MAIL_GW = val.i
         when parm.i = 'POPSRVR' then POPSRVR = val.i
         when parm.i = 'REPLY_DOMAIN' then REPLY_DOMAIN = val.i
         when parm.i = 'REPLY_ID' then REPLY_ID = val.i
         when parm.i = 'POP_ID' then POP_ID = val.i
         when parm.i = 'POP_PWD' then POP_PWD = val.i
         when parm.i = 'MODEM_TYPE' then MODEM_TYPE = val.i
         when parm.i = 'COMPORT' then COMPORT = val.i
         when parm.i = 'BAUD' then BAUD = val.i
         when parm.i = 'DATABITS' then DATABITS = val.i
         when parm.i = 'PARITY' then PARITY = val.i
         when parm.i = 'DIAL_MODE' then DIAL_MODE = val.i
         when parm.i = 'PREFIX' then PREFIX = val.i
         when parm.i = 'PREFIX_ANS' then PREFIX_ANS = val.i
         when parm.i = 'INIT' then INIT = val.i
         when parm.i = 'INIT2' then INIT2 = val.i
         when parm.i = 'DISABLE' then DISABLE = val.i
         when parm.i = 'DISABLE_SEQ' then DISABLE_SEQ = val.i
         when parm.i = 'DIAL_PREFIX' then DIAL_PREFIX = val.i
         when parm.i = 'AUTOSTART' then AUTOSTART = val.i
         when parm.i = 'TOTAL_CONNECT' then TOTAL_CONNECT = val.i
         otherwise NOP
      end
   i = i + 1
end
o21 = '! *+"''-/,#$%&().0123456789:;<=>?'
o22 = '@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^'
o23 = '_`abcdefghijklmnopqrstuvwxyz{|}~'
e21 = 'u *+"''-/,MI($kU<HgW[_A5%~2Fh3`LO'
e22 = 't?K^l0jJP{98xBadb1nZimRw=y\Y]4}'
e23 = 'E>;67V@vS:C.sNGz|cefQ&pq)Tor!#XD'
adv_password = translate(adv_password, e21||e22||e23, o21||o22||o23)
PWD = translate(PWD, e21||e22||e23, o21||o22||o23)
POP_PWD = translate(POP_PWD, e21||e22||e23, o21||o22||o23)
RETURN

/*
======================
find_equate_lines_in_datafile()

 backslash ('\') as the final character in the datafile
means the line is continued on the line following.  First
we reconstitute those lines that have continuations,
then we search through those lines for an '=' sign as
other than the first character.  We eliminate from
consideration any line with a '#' as the first character
as that signifies the line is a comment line.
======================
*/
find_equate_lines_in_datafile: procedure expose line.
arg filename
n = 1
do while lines(filename) > 0
   data_line.n = linein(filename)
   select
      when right(data_line.n, 1) = '\' then	/* concatenating continuations */
         do until right(data_line.n, 1) \= '\'
            data_line_n_with_right_slash_stripped =,
                  strip(right(data_line.n,1), 'T', '\')
            next_data_line = linein(filename)
            data_line.n = data_line_n_with_right_slash_stripped || next_data_line
         end

/* only lines without a leading # and with an = qualify */
      when pos('=', data_line.n) > 0 & \abbrev(data_line.n, '#') then
         do
            line.n = data_line.n
            n = n + 1
         end
      otherwise NOP
   end
end
RETURN n

/*
====================
souper_options()

Chance to modify the souper options on a
one-time-only basis
====================
*/
souper_options:
call SysCls
getnews_xtra_options = '' /* the defaults */
getmail_xtra_options = ''
send_xtra_options = ''
option1 = ''
option2 = ''
option3 = ''
option4 = ''

say ''
say 'SOUPER OPTIONS SCREEN'
say 'You can select these as one-time-only options when souper runs.'
do until opts = 6
   say ''
   say 'Press:'
   say '  1 Set maximum news packetsize (default is 2048KB [2.048MB])'
   say '  2 Do not retrieve newsgroup articles containing more than set'
   say '    number of lines in the body (default is: no limit)'
   say '    You get to set the number of lines.'
   say '  3 Do catchup on news.  Mark all as read except last m unread'
   say '    news articles in each group.  You set m.'
   say '  4 For mail: read-only.  Do not empty POP3 mailbox or update NEWSRC file'
   say '  5 Default all four of the above.'
   say '  6 DONE.  (MUST press 6 to exit this screen)'
   do until pos(opts,'123456') \= 0
      say ''
      prompt = 'Select 1-6:'
      say prompt
         parse value SysCurPos() with row col
         row  = row - 1
         col = length(prompt) + 2
         call SysCurPos row, col
      opts = SysGetKey('NOECHO')
      say ''
   end
   select
      when opts = 1 then call max_news_packet
      when opts = 2 then call max_news_lines
      when opts = 3 then 
         do
            say ''
            say ''
            say ''
            call catch
            do_catchup_on_news = 1
            say 'All but' Howmany 'articles (each group) max. will be marked read.'
         end
      when opts = 4 then call read_only_getmail_mode
      when opts = 5 then
         do
            option1 = ''
            option2 = ''
            option3 = ''
            option4 = ''
            choice = 7	/* go back with same value for choice as we came with */
            say ''
            say 'Accepting defaults for all three options'
            say ''
            say ''
            say 'Press any key to continue'
            call SysGetKey 'NOECHO'
         end
      otherwise NOP
   end
end

getnews_xtra_options = option1 option2
getnews_xtra_options = strip(getnews_xtra_options, 'B')
getnews_xtra_options = getnews_xtra_options option3
getnews_xtra_options = strip(getnews_xtra_options, 'B')

getmail_xtra_options = option4
getmail_xtra_options = strip(getmail_xtra_options, 'B')

if do_catchup_on_news then
  do
      say ''
      say 'Communicating with news server' newsserver
      say 'to update our NEWSRC...'
      souper_exe '-c' Howmany	/* mark as read all but last Howmany you set */
      say 'Each group in NEWSRC file caught up for all but last' Howmany 'articles.'
      say 'Articles not marked as read can be retrieved next.'
   end 
say ''
say 'Final Souper command-line option settings now are:'
say 'GETNEWS souper.exe options:' souper_getnews_std_options getnews_xtra_options
say 'GETMAIL souper.exe options:' souper_getmail_std_options getmail_xtra_options
say 'SENDING souper.exe options:' souper_send_std_options send_xtra_options

RETURN

max_news_packet:
     do until datatype(option1, 'W')
         call SysCls
         say ''
         say 'Enter a number in kilobytes for maximum news packet size.'
         say '2048 is typical. 0 sets packet size to unlimited.'
         say ''
         prompt = 'Enter number of kilobytes now:'
         say prompt
         parse value SysCurPos() with row col
         row  = row - 1
         col = length(prompt) + 2
         call SysCurPos row, col
         pull option1
         if \DataType(option1, 'W') then say 'Must be whole number or zero.'
     end
     say ''
     say 'Maximum packet size for news is set to' option1 'kilobytes'
     option1 = '-k' option1
     say ''
     say ''
     say 'Press any key to continue'
     call SysGetKey 'NOECHO'
RETURN

max_news_lines:
      call SysCls
      do until datatype(option2, 'W')
         say ''
         say 'Do not retrieve articles with more than this many lines'
         say 'in the body of the article.  Enter 0 for unlimited (the'
         say 'usual default for souper).'
         say ''
         prompt = 'Enter maximum lines:'
         say prompt
         parse value SysCurPos() with row col
         row  = row - 1
         col = length(prompt) + 2
         call SysCurPos row, col
         pull option2
         if \DataType(option2, 'W') then say 'Must be whole number or zero.'
     end
     say ''
     say 'Reject newsgroup articles with more than' option2 'lines in body.'
     if option2 = 0 then option2 = ''
        else option2 = '-l' option2
     say ''
     say ''
     say 'Press any key to continue'
     call SysGetKey 'NOECHO'
RETURN

read_only_getmail_mode:
      call SysCls
      do until pos(option4, 'YN') \=0
         say ''
         say 'For mail: You can set to read-only.  Retrieves mail but',
         say 'does not empty POP3 mailbox.'
         say ''
         say 'Set to Read-Only Mode?'
         prompt = 'Y sets Read-Only mode, N (normal default) doesn''t:'
         say prompt
            parse value SysCurPos() with row col
            row  = row - 1
            col = length(prompt) + 2
            call SysCurPos row, col
         parse upper pull option4
     end
     if option4 ='Y' then
         do
            say 'Read-Only mode set'
            option4 = '-r'
         end
     else
         do
            say 'Regular (not Read-Only) mode set'
            option4 = ''
         end 
     say ''
     say ''
     say 'Press any key to continue'
     call SysGetKey 'NOECHO'
RETURN


/*
==============================================

wait_for_ppp(), wait_for_slip(), wait_for_lan()

wait_for_ppp()
Waits for PPP0 interface to become active

wait_for_slip()
Similarly waits for the SL0 interface to become active.
It is a clone of wait_for_ppp().  We use the clone instead
of the slipwait.exe program so that both wait_for_ppp() and
wait_for_slip() can be used in identical syntax.

wait_for_lan()
Again a clone.  Not used in this version.  Guess what's coming?

For either one, we start by clearing found_interface to 0.
If we find one, we reset to 1.  If after a wait of total_delay
seconds no interface is found, we return with found_interface=0 

The routines are slightly modified from a
version of a wait_for_ppp one written by by
Angus John McLeod [amcleod@anjo.hi.net]
(as posted by him on comp.os.os2.networking.tcp-ip
16 Mar 96)

Each take three arguments which are
   total_delay		 of the routine in seconds
   recheck_delay	the recheck interval in seconds
   quiet		quiet mode if 1, verbose mode if 0

each returns the variable found_interface
==============================================
*/
wait_for_ppp:
parse arg total_delay, recheck_delay, quiet
tempfile = 'tempfile'

if \quiet then say 'Waiting for PPP - maximum wait =' total_delay 'seconds'
found_interface = 0		/* cleared to not found */
RC = 0
do index = 1 to total_delay by recheck_delay	  /* Periodically check avail. routes */
      call SysSleep recheck_delay	/* Minor delay, then check for routes */
      'netstat -r > ' || tempfile
      do while lines(tempfile) > 0  /* Look for a PPP0 route in the net status output */
         linedata = linein(tempfile)
         parse var linedata destination router . . . . interface
         interface = translate(interface)
         if interface = 'PPP0' then	/* Check for that PPP0 interface */
            do
               found_interface = 1 /* found interface, we did not time out */ 
               if \quiet then say 'interface' interface 'detected'
               leave index
            end
      end
      call stream tempfile, 'c', 'close'  /* Close result file to allow re-use */
   end
call SysFileDelete tempfile
RETURN found_interface


wait_for_slip:   
parse arg total_delay, recheck_delay, quiet
/* temporary filename is different from tempfile used in wait_for_ppp()
to guard against a file-in-use error */
tempfile = 'tempfil2'	 
if \quiet then say 'Waiting for SLIP - maximum wait =' total_delay 'seconds'
found_interface = 0
RC = 0
   do index = 1 to total_delay by recheck_delay
      call SysSleep recheck_delay
      'netstat -r > ' || tempfile
      do while lines(tempfile) > 0
         linedata = linein(tempfile)
         parse var linedata destination router . . . . interface
         interface = translate(interface)
         if interface = 'SL0' then
            do
               found_interface = 1 /* found interface, we did not time out */ 
               if \quiet then say 'interface' interface 'detected'
               leave index
            end
      end
      call stream tempfile, 'c', 'close'
   end
call SysFileDelete tempfile
RETURN found_interface

wait_for_slip:   
parse arg total_delay, recheck_delay, quiet
/* temporary filename is different from tempfile used in wait_for_ppp()
to guard against a file-in-use error */
tempfile = 'tempfil3'	 
if \quiet then say 'Waiting for SLIP - maximum wait =' total_delay 'seconds'
found_interface = 0
   do index = 1 to total_delay by recheck_delay
      call SysSleep recheck_delay
      'netstat -r > ' || tempfile
      do while lines(tempfile) > 0
         linedata = linein(tempfile)
         parse var linedata destination router . . . . interface
         interface = translate(interface)
         if interface = 'LAN0' then
            do
               found_interface = 1 /* found interface, we did not time out */ 
               if \quiet then say 'interface' interface 'detected'
               leave index
            end
      end
      call stream tempfile, 'c', 'close'
   end
call SysFileDelete tempfile
RETURN found_interface

/*
==============================================
HANDLING OF ERROR TRAPS

ReXX Errors (failure, halt, syntax, novalue, error)
that occur with SIGNAL ON XXXXX (XXXXX = failure,
halt, etc.) are diverted (we jump) to one of these
where the error and the offending line are identified.
==============================================
*/

FAILURE:
say 'Rexx FAILURE error' rc 'in line' sigl || ':' errortext(rc) crlf sourceline(sigl)
call beep 300, 500
/*trace ?r; nop*/
signal goodbye
RETURN

HALT:
say 'Rexx HALT' rc 'in line' sigl || ':' errortext(rc) crlf sourceline(sigl)
call beep 300, 500
/*trace ?r; nop*/
signal goodbye
RETURN

SYNTAX:
say 'Rexx SYNTAX error' rc 'in line' sigl || ':' errortext(rc) crlf sourceline(sigl)
call beep 300, 500
/*trace ?r; nop*/
signal goodbye
RETURN

NOTREADY:
say 'Rexx NOTREADY error' rc 'in line' sigl || ':' errortext(rc) crlf sourceline(sigl)
call beep 300, 500
/*trace ?r; nop*/
signal goodbye
RETURN

ERROR:
say 'ERROR encountered'
say 'Rexx ERROR error' rc 'in line' sigl || ':' errortext(rc) crlf sourceline(sigl)
call beep 300, 500
/*trace ?r; nop*/
signal goodbye
RETURN

/*
=======================
goodbye()
quit()
depart()

Exit routines.  Most exits are jumps to
goodbye()
=======================
*/

goodbye:
call kill_dialers_slip_ppp_slattach	/* Now fall into DEPART() */

Depart:
if timeout then signal Quit
say ''
call connect_stats		/* tell us elapsed time */
x= EndLocal()

	/* Now fall into QUIT() */
Quit:				/* Fall into Quit */
say ''
say 'Done. Press any key to exit...'		
answer = SysGetKey('NOECHO')

EXIT

RETURN