/* YRNDIAL.CMD v 1.1 by Jerry Levy 		11 Jun 95 */
 
/* Comments appreciated: send to jlevy@ibm.net (Jerry Levy, Marblehead, MA) */

/* ====History====			*/
/* 11 Jun 95	YARNDIAL (original)		*/
/* 11 Jun 95	YRNDIAL1 v 1.1		*/
/*   Fixed screwed up backup of the replies .Zip file	*/
/* ====End History===			*/

crlf = d2c(13)||d2c(10)		/* carriage return + linefeed */
escape = d2c(27)			/* escape character */

say 'YRNDIAL.CMD v 1.1   (C) 1995 Jerry Levy'
say 'Dials in, gets or posts news and replies, and signs off.' crlf
say 'It is now' date() time()

/* Acknowledgement to acasals@ibm.net who provided his .BAT file as my prototype */

/* ====COPYRIGHT NOTICE AND DISCLAIMER - PLEASE READ==== */
/* By downloading and using this program all users accept terms of the*/
/* following disclaimer: */
/* YARNDIAL.CMD is Copyright 1995 by Jerry Levy and is provided	*/
/* by him as-is without charge and with no warranty expressed	*/
/* or implied as to merchantability or fitness for a particular purpose,	*/
/* and he disclaims all responsibility for any and all incidental and	*/
/* consequential damages. This program amy be freely distributed.	*/
/*========End Disclaimer========*/

/*====== INSTALL - You Must Customize These ===== 		*/
/* This script has been tested with YARN, SOUPER, and GO from 	*/
/* YRN2_083.ZIP, SOUPER12.ZIP, and GO_15.ZIP archives 		*/
/* and uses InfoZip compression and decompression programs from 	*/
/* UNZ512x2.ZIP and ZIP201c2.ZIP.  All of these should be available */
/* from ftp-os2.nmsu.edu, ftp.cdrom.com, hobbes.nmsu.com, and /or 	*/
/* Pete Norloff's OS/2 Shareware BBS at 1-703-385-4325. 		*/

/* Suggestion: use full paths and names for files and for home_dir 	*/

process_killer = 'e:\go\go.exe -k' 		/* To kill the dialer.  GO is from GO_15.ZIP  */
replies_file = 'f:\jlhome\upload\ioxr.zip'	/* This is what we named the replies file in Yarn's CONFIG. */
/* 	Below, souper -m means I do not get my mail off line (only news) */
/* 	Use -n in place of -m to get only news (not tested) 		*/
/* 	or use souper with no options to get both (not tested) 		*/
souper_get = 'f:\jlyarn\souper.exe -m'
souper_post = 'f:\jlyarn\souper.exe -s' 	/* -s = send replies, etc 	*/
yarn_importer = 'f:\jlyarn\import.exe' 
yarn_expiry_pgm = 'f:\jlyarn\expire.exe -o' 

	/*These next two for InfoZip compression and decompression  pgms */
	/* You may use others, but will need to change command lines */
zip_pgm = 'e:\pk_unpk\zip201c2\zip.exe -0m'
unzip_pgm = 'e:\pk_unpk\unz512x2\unzip.exe -o'

home_dir = 'f:\jlhome'			/* What you called Yarn's home directory */

wait = 50				/* The wait in seconds before slipwait will time out */

	/* On starting up the dialer, these initialize the three IBM Internet Dialer fields */
account = 'usinet'
userid = 'jlevy'
password = ''  	/* Password.  Leave blank (i.e, as a pair of quotes: '')  */
			/* if you want to enter password yourself each time */
/* =========End Customize====== */

ReplyZipDrv = filespec('drive', replies_file)
ReplyZipPath = filespec('path', replies_file)


/* MAIN PROGRAM */
call LOAD_REXX_UTILS		/* Load RexxUtil functions	*/
call CHECK_FILES			/* Check if necessary files are there */
call SELECT_MODE			/* Get or post news?  Returns variable: Choice */
call DIAL_IN				/* Dial up */
call time(R)				/* Reset timer to zero when we've connected */
call SysRmDir home_dir||'\replies'		/* Remove any empty folder named replies created by an earlier operation*/
if Choice \= 2 then call Importer		/* Get News */
if Choice \= 1 then call Exporter 		/* Post replies, followups,  messages*/
call GOODBYE				/* Kills SLIP connection, dialer */
EXIT
/* End of main program */

LOAD_REXX_UTILS:			/* Load the RexxUtil functions*/
call rxfuncadd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call sysloadfuncs
RETURN

SELECT_MODE:			/* Get or Post? */
do until Choice = 1 | Choice = 2 | Choice = 3
say 'Press:'
say '1  Import news from newsgroups'
say '2  Export Posts, Replies, and Follow-ups'
say '3  Do both'
say 'Pressing Esc exits now'
   Choice = SysGetKey(NOECHO)
   if Choice = Escape then call GOODBYE
   if Choice \= 1 & Choice \= 2 & Choice \= 3 then
      say crlf  'You pressed' Choice '-- Try again...' crlf
end
RETURN

CHECK_FILES:				/* Are all files we need there? */
RetCode =0
call Is_File_There process_killer
call Is_File_There zip_pgm
call Is_File_There unzip_pgm
call Is_File_There yarn_importer
call Is_File_There souper_get
call Is_File_There souper_post
call Is_File_There yarn_expiry_pgm
if RetCode = 1 then call GOODBYE
RETURN

IS_FILE_THERE:			/* Check... */
arg file options
if stream(file, 'c', 'query exists') = '' then
   do
      say file 'not found.  Closing phone connection if up...'
      RetCode = 1
   end
RETURN

DIAL_IN:
/* Starts Dialer object.  While Dialer starts to do its thing, slipwait starts a timed wait.  When we */
/* connect or if we were already connected when Dialer was started, slipwait  */
/* will sense that and this subroutine is completed */
say userid 'dialing' account '<password>' 
'@start dialer' account userid password

'@slipwait' wait				/* Wait up to 'wait' seconds for a connect */
if RC=1 then
   do
      say 'Dialer timed out.  Exiting...'
      call time(R)				/* no connection, zero elapsed-time clock */
      call GOODBYE			/* Kill dialer if it is up */
   end
RETURN

IMPORTER:
say 'You are now importing news from newsgroups.' crlf
'@cd' home_dir
'@'||souper_get
'@'||zip_pgm 'soup.zip areas *.msg'
'@'||yarn_importer 'soup.zip'
RETURN

EXPORTER:
say crlf||'You are now exporting posts, replies, and followups.'
call Is_File_There replies_file		/* Do we have any replies to send */
if RetCode = 1 then
   do
      say "Means there are no replies waiting to be sent."
      RETURN
   end
'@cd' home_dir
/* Make a backup of the replies zip file */
'@copy' replies_file ReplyZipDrv||ReplyZipPath||'*.BAK >nul'
'@'||unzip_pgm replies_file
'@'||souper_post
'@erase' replies_file
RETURN

KILLIT:
say crlf||'Killing SLIP connection...'
'@slipkill >nul'			/* Kill SLIP connection */
say 'Killing the Dialer...'
'@'||process_killer 'dialer >nul'	/* Kill the dialer */
call SysSleep 3		/* Sleep three seconds */
'@'||process_killer 'dialer >nul'	/* Close down any other Dialer instance */

time = time(E)
say 'Since starting YRNDIAL.CMD, elapsed on-line time =' trunc((time/60),2) 'mins'
RETURN

GOODBYE:
call KILLIT
say 'We are off-line now.  Do you want to delete old messages (Y/N)?'
if translate(SysGetKey(NOECHO))='Y' then '@'||yarn_expiry_pgm  /* Remove old messages */
say crlf||'Done. Press any key to exit...'		
answer = SysGetKey(NOECHO)
EXIT
RETURN


/* These not used */
signal on failure name KILLIT
signal on halt name KILLIT
signal on syntax name KILLIT
signal on error name KILLIT
signal on notready name KILLIT






