

#include "toolbox.h"
#include "ui/ui.h"

#include "ids.h"
#include "app.h"
#include "canvas.h"

extern UI_ViewDescriptor  FAR DLG_ToolBox_Item []; // In desc.cxx
extern UI_RectangleStruct FAR DLG_ToolBox_Shape;   // In desc.cxx

struct {
    GR_ShapeEnum type;
    char* name;
} Shapes [] = {
    {GR_Line,       "Line"},
    {GR_LeftArrow,  "Left arrow"},
    {GR_RightArrow, "Right arrow"},
    {GR_DoubleArrow,"Double arrow"},
    {GR_Ellipse,    "Ellipse"},
    {GR_Rectangle,  "Rectangle"},
    {GR_Circle,     "Circle"},
    {GR_PolyLine,   "PolyLine"},
    {GR_Text,       "Text"},
    {GR_None,       0}
};

ToolBox::ToolBox (UI_CompositeVObject* parent)
: UI_CompositeVObject (parent, DLG_ToolBox_Item, FALSE, UI_Rectangle
                       (100, 100, DLG_ToolBox_Shape.w, DLG_ToolBox_Shape.h))
{
    _title = "Tool Box";
    _font->PointSize(10);
    UI_StringSequence& list = *(UI_StringSequence*)
        (*this)[ID_LIST].Model();
    for (short i = 0; Shapes[i].name != 0; i++)
        list.Add (Shapes[i].name);
    *((*this)[ID_CREATE_BTN].Model()) = CL_Integer (1);
    ((GraphicEditorApp*) _Application)->AppCanvas().SetMode (Mode_Create);    
}

bool ToolBox::HandleChildEvent (UI_Event* e)
{
    if (e->Type() != Event_Select)
        return FALSE;
    switch (e->Origin()->ViewID()) {
    case ID_LIST:
        // Must be in create mode, otherwise the list would be disabled
        SetSelection ();
        break;

    case ID_EDIT_BTN:
    case ID_CREATE_BTN:
        SetMode();
        break;

    case ID_FILL:
        SetFill ();
        break;

    default:
        return FALSE;
    }
    return TRUE;
}


void ToolBox::SetSelection ()
{
    UI_StringView& list = (UI_StringView&) (*this)[ID_LIST];
    CL_IntegerSet choice = *(CL_IntegerSet*) list.Selection();
    if (choice.Size() > 0) {
        ((GraphicEditorApp*) _Application)->AppCanvas().SetCurrentShape
            (Shapes[choice.ItemWithRank(0)].type);
    }
}

void ToolBox::SetMode ()
{
    long value = ((CL_Integer*) ((*this)[ID_EDIT_BTN].Model()))->Value();
    UI_StringView& list = (UI_StringView&) (*this)[ID_LIST];
    if (value > 0L)
        list.Disable();
    else
        list.Enable();
}


void ToolBox::SetFill ()
{
    long value = ((CL_Integer*) ((*this)[ID_FILL].Model()))->Value();
    ((GraphicEditorApp*) _Application)->AppCanvas().SetFill
        (value > 0 ? TRUE : FALSE);
}
