




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */






#include "ui/toglbtn.h"
#include "ui/cntroler.h"

#include "base/integer.h"


//------------------------------------------------------------------
//                     CLASS TOGGLEBUTTON
//------------------------------------------------------------------

#if defined(__MS_WINDOWS__)
#include <windows.h>
#define TOGGLE_BUTTON_STYLE \
    BS_AUTOCHECKBOX | WS_CHILD | WS_VISIBLE | WS_TABSTOP

#elif defined(__X_MOTIF__)
#include <Xm/ToggleB.h>

#endif


UI_ToggleButton::UI_ToggleButton
    (UI_CompositeVObject* parent, const UI_Rectangle& shape,
     UI_ViewID id, long btn_style)
: UI_Button(parent, shape, id,
#if defined(__MS_WINDOWS__)
             btn_style == -1 ? TOGGLE_BUTTON_STYLE : btn_style
#else
             btn_style
#endif
             )
{
    _model = new CL_Integer; 
}

UI_ToggleButton::UI_ToggleButton (UI_CompositeVObject* parent, UI_ViewID
                                  id, UI_ViewHandle h) 
: UI_Button (parent, id, h)
{
     _model = new CL_Integer; 
}



CL_Object* UI_ToggleButton::Model ()
{
#if defined (__MS_WINDOWS__)
    if (_handle > 0)
        SetModelValue (CL_Integer (SendMessage (_handle,
                                                BM_GETCHECK, 0, 0L)));
#elif defined (__X_MOTIF__)
    if (_xwidget)
        SetModelValue (CL_Integer (XmToggleButtonGetState (_xwidget)));
#endif
    return _model;
}





#include <iostream.h> // DEBUG
bool UI_ToggleButton::ModelChanged (CL_Object&, long)
{
#if defined (__MS_WINDOWS__)
    if (_handle > 0) {
        SendMessage (_handle, BM_SETCHECK,
                     ((CL_Integer*) _model)->Value() > 0 ? 1 : 0, 0L);
    }
#elif defined (__X_MOTIF__)
    if (_xwidget)
        XmToggleButtonSetState (_xwidget, ((CL_Integer*) _model)->Value(),
                                FALSE);
#endif
    return TRUE;
}



bool UI_ToggleButton::MakeVisualElement ()
{
    bool b = UI_SimpleVObject::MakeVisualElement ();
    ModelChanged (*this, 1); // Dummy call to force initial setting
#if defined(__X_MOTIF__)
    XtAddCallback (_xwidget, XmNvalueChangedCallback, 
                   &UI_ToggleButton::SelectionCallback, (XtPointer) this);
#endif
    return b;
}


char* UI_ToggleButton::MSWindowsName() const
{
#ifdef __BORLANDC__
    // return "borcheck";
    return "button";
#else
    return "button";
#endif
}


#if defined (__X_MOTIF__)

struct _WidgetClassRec* UI_ToggleButton::XName () const
{
    return xmToggleButtonWidgetClass;
}

void UI_ToggleButton::SelectionCallback (Widget w, void* client, void* call)
{
    UI_ToggleButton* btn = (UI_ToggleButton *) client;
    int value = ((XmToggleButtonCallbackStruct*) call)->set;
    btn->SetModelValue (CL_Integer(value));
    _Controller->AddEvent (new UI_Event (Event_Select, btn, btn));
}
#endif



