



/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */


#if defined(__MS_WINDOWS__)
#include <windows.h>
#elif defined(__X_MOTIF__)
#include <Xm/Text.h>
#endif


#include "ui/textedit.h"



UI_TextEditor::UI_TextEditor
    (UI_CompositeVObject* parent, const UI_Rectangle& shape, UI_ViewID id)
: UI_StringEditor (parent, shape, id, -1)
{
#if defined(__MS_WINDOWS__)
    _style |= ES_MULTILINE | WS_VSCROLL;
#endif
}


UI_TextEditor::UI_TextEditor (UI_CompositeVObject* parent, UI_ViewID id,
               UI_ViewHandle h)
: UI_StringEditor (parent, id, h)
{
}


#if defined(__X_MOTIF__)
void UI_TextEditor::_SetupStyle (void* p, short& argn)
{
    Arg* arg = (Arg*) p;
    UI_SimpleVObject::_SetupStyle (arg, argn);
    XtSetArg (arg[argn], XmNeditMode, XmMULTI_LINE_EDIT); argn++;
}
    
#endif
    


