
#ifndef _stringseqview_h_
#define _stringseqview_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#include "ui/pictview.h"
#include "ui/strseq.h"
#include "base/intset.h"



//  This class provides a pictorial representation of a string sequence. One
//  or more strings in the sequence may be selected by either an explicit
//  call to the method Select() or by the {\small\tt Event_LButtonPress}.
//  A mouse click 
//  on an unselected string selects it while that on a selected string
//  unselects it.




class UI_StringView: public UI_PictureView {


public:

     UI_StringView (UI_CompositeVObject* parent, UI_StringSequence* model,
                    const UI_Rectangle& shape,
                    bool multiple_select = FALSE,
                    UI_ViewID id = -1, long style = -1);
    // Model not owned

    UI_StringView (UI_CompositeVObject* parent,  
                   const UI_Rectangle& shape, bool multiple_select = FALSE,
                   UI_ViewID id = -1, long style = -1);
    // Model owned

    UI_StringView (UI_CompositeVObject* parent, UI_ViewID id,
                   UI_ViewHandle h);
    // Resource-based construction

    bool VerticalView () const;

    CL_Object* Selection () {return selections;};
    // Returns a set of indices in the underlying sequence that
    // have been selected. Selection can be one or more depending on wether or
    // not multiple selection is ON. Return Type is reference to IntegerSet.

    short PictureHeight () const;
    // Return the height of the underlying font.
    
    short PictureWidth () const;
    // Return the length of the longest string.

    bool Select (long n);
    // Select nth string if unselected. Parent notified via Event_Select.

    bool UnSelect (long n);
    // Unselect nth string if slected. Parent notified via Event_UnSelect.
    
    bool UnSelect ();
    // Unselect the current selection. Is effective if and only if multiple
    // selection is NOT allowed.Parent notified via Event_UnSelect.

    bool MultipleSelect ();
    // Return TRUE if multiple selection is allowed

    void PictureInserted (long pos);
    //  Called by the model to notify this view that the model just added
    //  a new picture immediately  after the given position.

    void PictureRemoved (long);

    void PictureChanged (long);

    // ---------------- Overridden VisualObject methods --------------

    void Initialize ();

    void Finalize ();


    // ---------------- Overridden SimpleVObject methods -------------
    char* MSWindowsName () const { return "listbox";} ;

#if defined (__X_MOTIF__)

    static void Callback (struct _WidgetRec*, void *, void *);

    struct _WidgetClassRec *XName () const;

    virtual void _SetupStyle (void* arg, short& argn);
    // [YACL internal use only] X-windows-specific.

#endif

    // ---------------- Overridden basic methods ---------------------
    
    const char* ClassName () const { return "UI_StringView";};

protected:



    //
    // StringView Events:
    //

    ~UI_StringView ();

    bool MakeVisualElement ();
    // Override the inherited method.
    
    bool Select ();


    CL_IntegerSet* selections;
    bool           _multiple;
};
#endif
