




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#if defined(__MS_WINDOWS__)
#include <windows.h>

#elif defined(__X_MOTIF__)
#include <Xm/List.h>

#endif

#include "ui/strview.h"
#include "ui/cntroler.h"
#include "ui/event.h"
#include "ui/applic.h"

#include "base/intset.h"



#if defined(__MS_WINDOWS__)
#define LISTBOX_STYLE LBS_NOTIFY | LBS_USETABSTOPS | WS_CHILD | WS_VISIBLE \
        | WS_BORDER | WS_VSCROLL | WS_TABSTOP
#endif


UI_StringView::UI_StringView
    (UI_CompositeVObject* p, UI_StringSequence* md,
     const UI_Rectangle& sh, bool mult, UI_ViewID id, long s
    )
: UI_PictureView (p, md, sh, id, s)
{   
    _multiple = mult;
    selections = new CL_IntegerSet;

#if defined(__MS_WINDOWS__)
    if (_style == -1)
        _style = LISTBOX_STYLE;
    if (_multiple)
        _style |= LBS_MULTIPLESEL;
#endif
}



UI_StringView::UI_StringView
    (UI_CompositeVObject* p, const UI_Rectangle& sh, bool mult, UI_ViewID id,
     long s
    )
: UI_PictureView (p, sh, id, s)
{  
    _model = new UI_StringSequence (); 
    selections = new CL_IntegerSet;

    _multiple = mult;

#if defined(__MS_WINDOWS__)
    if ( _style == -1 )
        _style = LISTBOX_STYLE;
    if ( _multiple )
        _style |= LBS_MULTIPLESEL;

#elif defined(__X_MOTIF__)

#endif
}



UI_StringView::UI_StringView
    (UI_CompositeVObject* p, UI_ViewID id, UI_ViewHandle h)
: UI_PictureView (p, id, h)
{
    _model = new UI_StringSequence ();
    selections = new CL_IntegerSet;

    ((UI_StringSequence*) _model)->AddClient (this);
}



UI_StringView::~UI_StringView ()
{
    delete selections;
}

#if defined(__X_MOTIF__)
void UI_StringView::_SetupStyle (void* p, short& argn)
{
    Arg* arg = (Arg*) p;

    UI_SimpleVObject::_SetupStyle (arg, argn);
    // Add more resource specs:
    XtSetArg (arg [ argn ], XmNselectionPolicy,
              _multiple ? XmEXTENDED_SELECT : XmSINGLE_SELECT); argn++;
}
#endif




bool UI_StringView::MakeVisualElement ()
{
#if defined(__MS_WINDOWS__)
    return UI_PictureView::MakeVisualElement();
#elif defined(__X_MOTIF__)

    // This code is copied from that of SimpleVObject, except that we use
    // XmCreateScrolledList instead of XtCreateWidget, because the scroll
    // bar does not seem to be displayed otherwise.
    
    // GNU C seems to have a strange bug, so we work around it. Instead of
    // saying
    //    Widget pw = (Widget) (_parent->ViewHandle());
    // we say
    UI_VisualObject* p = _parent;
    Widget pw = (Widget) p->ViewHandle();

    CL_String instance_name = InstanceName();
    const char* inst_name = instance_name.AsPtr();
    struct _WidgetClassRec *class_name = XName ( );

    Arg arg [20];
    short argn = 0;
    _SetupStyle (arg, argn); // Set up the X resources

    XmString title = XmStringCreate
        ((char *) _title.AsPtr (), XmSTRING_DEFAULT_CHARSET);    
    XtSetArg (arg [argn], XmNlabelString, title); argn++;
    // _xwidget = XtCreateWidget (inst_name, class_name, pw, arg, argn);
    _xwidget = XmCreateScrolledList (pw, (char*) inst_name, arg, argn);
    // XtManageChild (_xwidget);
    // XtSetValues (_xwidget, arg, argn);

    XmStringFree (title);
    _Controller->AddEvent (new UI_Event (Event_ChildCreated, this, _parent));

    return TRUE;
#endif
}



bool UI_StringView::VerticalView () const
{
    return TRUE;
}


short  UI_StringView::PictureHeight () const
{
    return 0;  //for now;
}


short UI_StringView::PictureWidth () const
{
    long width = 0;
    long num = ((UI_StringSequence*) _model)->Size ();
 
   for (long i = 0; i < num; i++) {
        CL_String str = (*(UI_StringSequence*)_model) [i];
        if (str.Length () > width)
            width = str.Length ();
    }
    return width;
}



bool UI_StringView::Select (long n)
{
    if(!(n>=0 && n < ((UI_StringSequence*)_model)->Size()))
        return FALSE;   
#if defined(__MS_WINDOWS__)
    if ( _multiple ){
        DWORD lp;
        lp = n;
        SendMessage (_handle, LB_SETSEL, 1, lp);
    }
    else{
        WORD wp;
        wp = n;
        SendMessage (_handle, LB_SETCURSEL, wp, 0);
    }

#elif defined(__X_MOTIF__)
    XmListSelectPos (_xwidget, n+1, FALSE);

#endif

    selections->Add (n);
    return FALSE; // Return FALSE so that parent is notified by controller
}


                             
bool UI_StringView::UnSelect (long n)
{
    if( !(n >= 0 && n < ((UI_StringSequence*)_model)->Size ()) )
        return FALSE;   

#if defined (__MS_WINDOWS__)
    if ( _multiple ) {
        DWORD lp;
        lp = n;
        SendMessage (_handle, LB_SETSEL, 0, lp);
    }
    else{
        SendMessage (_handle, LB_SETCURSEL, -1, 0);
    }

#elif defined(__X_MOTIF__)
    XmListDeselectPos (_xwidget, n+1);
#endif

    selections->Remove (n);
    return FALSE; // Return FALSE so that parent is notified by controller
}



bool UI_StringView::UnSelect ()
{
    if ( _multiple )
        return FALSE;

#if defined(__MS_WINDOWS__)
    SendMessage (_handle, LB_SETCURSEL, -1, 0);

#elif defined(__X_MOTIF__)
    CL_IntegerSetIterator itr(*selections);

    itr.Reset ();
    if( itr.More () ){
        long n = itr.Next ();
        XmListDeselectPos (_xwidget, n+1);
    }

#endif
    selections->MakeEmpty();
    return FALSE;    // Return FALSE so that parent is notified by controller

}



bool UI_StringView::MultipleSelect ()
{
    return _multiple;
}



void UI_StringView::PictureInserted (long i)
{
    CL_String s = (*(UI_StringSequence*) _model) [i+1];

#if defined(__MS_WINDOWS__)
    SendMessage (_handle, LB_INSERTSTRING, i+1, (long)(const char*)s);

#elif defined(__X_MOTIF__)
    XmString xs;

    char *item = (char *) s.AsPtr ();
    xs = XmStringCreate (item, XmSTRING_DEFAULT_CHARSET);
    XmListAddItem (_xwidget, xs, i+2);
    XmStringFree (xs);
#endif
}



void UI_StringView::PictureRemoved (long i)
{
#if defined(__MS_WINDOWS__)
    SendMessage ((HWND)(long)_handle, LB_DELETESTRING, i, 0L);

#elif defined(__X_MOTIF__)
    XmListDeletePos (_xwidget, i+1 ); 

#endif
}



void UI_StringView::PictureChanged (long i)
{
    CL_String s = (*(UI_StringSequence*)_model)[i];

#if defined(__MS_WINDOWS__)
    SendMessage (_handle, WM_SETREDRAW,  FALSE, 0L);
    SendMessage (_handle, LB_DELETESTRING, i, 0L);
    SendMessage (_handle, LB_INSERTSTRING, i, (long)(const char*)s);
    SendMessage (_handle, WM_SETREDRAW, TRUE, 0L);

#elif defined(__X_MOTIF__)
    XmListDeletePos (_xwidget, i+1);    
    XmString xs;
     
    char *item = (char *)s.AsPtr ();
    xs = XmStringCreate (item, XmSTRING_DEFAULT_CHARSET);
    XmListAddItem (_xwidget, xs, i+1);
    XmStringFree (xs);
#endif
}



void UI_StringView::Initialize ()
{
    UI_SimpleVObject::Initialize ();
    ((UI_StringSequence*) _model)->AddClient (this);

#if defined(__MS_WINDOWS__)
    SendMessage ((HWND)(long)_handle, WM_SETREDRAW   ,FALSE,0L);
    SendMessage ((HWND)(long)_handle, LB_RESETCONTENT,0    ,0 );

    for (long i = 0; i < ((UI_StringSequence*) _model)->Size (); i++){
        CL_String s = (*(UI_StringSequence*) _model) [i];
        SendMessage ((HWND) (long)_handle,
                     LB_ADDSTRING, 0, (long)(const char*)s
                    );
    }
    SendMessage ((HWND)(long)_handle, WM_SETREDRAW, TRUE, 0L);

#elif defined(__X_MOTIF__)
    XtAddCallback (_xwidget, XmNbrowseSelectionCallback, 
                   &UI_StringView::Callback, (XtPointer) this);
    XtAddCallback (_xwidget, XmNsingleSelectionCallback, 
                   &UI_StringView::Callback, (XtPointer) this);
    XtAddCallback (_xwidget, XmNextendedSelectionCallback, 
                   &UI_StringView::Callback, (XtPointer) this);
    XtAddCallback (_xwidget, XmNdefaultActionCallback, 
                   &UI_StringView::Callback, (XtPointer) this);

    long j = ((UI_StringSequence*) _model)->Size ();
    if ( j == 0 ) return;

    for (long i=0; i < j; i++){
        CL_String s = (*(UI_StringSequence*) _model) [i];
        XmString xs;

        xs = XmStringCreate ((char*)s, XmSTRING_DEFAULT_CHARSET); 
        XmListAddItem (_xwidget, xs, 0);
        XmStringFree (xs);
    }
#endif
}



void UI_StringView::Finalize ()
{
    ((UI_StringSequence*) _model)->RemoveClient (this);
    UI_SimpleVObject::Finalize ();
}




bool UI_StringView::Select ()
{
#if defined(__MS_WINDOWS__)
    DWORD count;
    if (_multiple) {  // multiple selections possible
        count = SendMessage (_handle, LB_GETSELCOUNT, 0, 0);
        if ( count > 0 ) {
            int *buf = new int [count]; 
            SendMessage (_handle, LB_GETSELITEMS, count, (long)buf);
            selections->MakeEmpty ();
            for (long i = 0; i < count; i++){
                long n  = buf[i];
                selections->Add (n);
            }
            delete buf;
        }
    }
    else { //single selections only.
        count = SendMessage (_handle, LB_GETCURSEL, 0, 0); 
        selections->MakeEmpty ();
        if ( count != LB_ERR ) { // selection made
            selections->Add (count);
        }
    }

#elif defined(__X_MOTIF__)
    int count;
    int  *list;

    if ( XmListGetSelectedPos (_xwidget, &list, &count) ){
        if ( count > selections->Size () )
            UI_Event *e = new UI_Event (Event_Select, this);
        else if ( count < selections->Size() ) //some string unselected
            UI_Event *e = new UI_Event (Event_UnSelect, this);

        selections->MakeEmpty ();
        for (long i = 0; i < count; i++ ){
            long n  = (list [i]) - 1;
            selections->Add (n);
        }
    }
    else {
        if ( selections->Size () ) {
            selections->MakeEmpty ();
        }
    }

#endif

    return FALSE;
}



#if defined (__X_MOTIF__)

void UI_StringView::Callback (Widget w, void* client, void* call)
{
    UI_StringView* sv = (UI_StringView *) client;
    XmListCallbackStruct* cb = (XmListCallbackStruct*) call;
    UI_Event* e;
    switch (cb->reason) {

    case XmCR_SINGLE_SELECT:
    case XmCR_BROWSE_SELECT:
    case XmCR_MULTIPLE_SELECT:
    case XmCR_EXTENDED_SELECT:
        e = new UI_Event (Event_Select, sv, sv);
        if (e)
            _Controller->AddEvent (e);
        break;

    case XmCR_DEFAULT_ACTION:
        e = new UI_Event (Event_Select, sv, sv);
        if (e) {
            e->curPos = UI_Point (cb->event->xbutton.x, cb->event->xbutton.y);
            _Controller->AddEvent (e);
        }
        break;

    default:
        break;
    }
        
}



struct _WidgetClassRec* UI_StringView::XName () const
{
    return xmListWidgetClass;
}

#endif
