
#ifndef _simplevobject_h_
#define _simplevobject_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




// 
//   A class that represents the behaviour of a group of classes
//   that serve as interactive application control mechanisms. A 
//   SimpleVObject includes in its state a data structure called the {\it
//   model\/} 
//   and a selection mechanism determined by a {\it selection}. The actual 
//   interpretation of model and selection and their management is
//   left to subclasses of the SimpleVObject. The model is not owned by
//   this object but 
//   passed to it at construction by the derived class. The simple object
//   may however modify the
//   model. The parent of a simple object must be a Composite.
// 
//   In order to capture or process events occuring on any of the simple
//   objects, the {\small\tt HandleEvent} method may be overridden as
//   discussed in {\small\tt visualobj.h}. 
// 
//   The model has this object as a dependent and invokes ModelChanged() when
//   it changes.
//
//   NOTE:
//   Any subclass of SimpleVObject that overrides the virtual
//   method Initialize() must call the parent class's Initialize method. 
//   More precisely, the body of the overriding {\small\tt Initialize}
//   method must include the statement
//   \par\begin{verbatim}
//          {\small\tt     UI_SimpleVObject::Initialize();}
//   \end{verbatim}
//
//        as the first statement of the overridden method.
//        Similarly, any subclass that overrides Finalize() must call the
//        parent class's Finalize() method as the last action in the
//        overridden method.


#include "ui/visualob.h"
#include "ui/composit.h"


class UI_SimpleVObject: public UI_VisualObject {

public:

    virtual CL_Object* Selection()    {return Model();};

    virtual bool IsTabStop () const;
    // Are we a tab stop in our parent composite?

    virtual void TabStop (bool);
    // Change our tab-stop status to the given value.
    

    char* MSWindowsName ( ) const;

#if defined (__X_MOTIF__)
    struct _WidgetClassRec* XName ( ) const;

#endif

    void Initialize();

    void Finalize();

    const char* ClassName() const {return "UI_Simple";};

    
protected:

    UI_SimpleVObject (UI_CompositeVObject* parent, UI_ViewID,
                      const UI_Rectangle& r, long style=-1);
    // model owned

    UI_SimpleVObject (UI_CompositeVObject* parent, CL_Object* model,
                      UI_ViewID = -1,
                      const UI_Rectangle& r = UI_Rectangle(),
                      long style = -1);
    // model not owned

    UI_SimpleVObject ( UI_CompositeVObject* parent,
                       UI_ViewID id, UI_ViewHandle h 
                     );
    // For resource-based construction
                     

    ~UI_SimpleVObject(); 

    virtual bool ModelChanged (CL_Object&, long)
        {return Paint();};
    // ModelChanged: invoked by our model when it changes. The default
    // implementation calls Paint().

    bool _FontChanged (CL_Object&, long);
    
    bool MakeVisualElement ();

    bool DestroyVisualElement ();

    void SetModelValue (const CL_Object& value);
    // Set our model to the given value, but don't notify ourselves of the
    // change.

    friend class UI_Controller;


public:

    // ------------- For YACL internal use only --------------

    bool SetFont (UI_Font* font);
    
    bool SetStyleParam();

protected:

    // Instance variables:
    
    bool       _ownModel;
    bool       _isTabStop;
    
};





inline bool UI_SimpleVObject::IsTabStop () const
{
    return _isTabStop;
}



inline void UI_SimpleVObject::TabStop (bool b)
{
    _isTabStop = b ? TRUE : FALSE;
}




#endif
