




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */






#include "base/binding.h"
#include "ui/simple.h"
#include "ui/cntroler.h"


#if defined (__X_MOTIF__)
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#endif


extern FAR char _YACLWindowClassName[];

#if defined(__GNUC__) && __GNUC_MINOR__ >= 6
template class CL_Binding<UI_SimpleVObject>;
#endif


typedef CL_Binding<UI_SimpleVObject> SimpleBind;

UI_SimpleVObject :: UI_SimpleVObject ( UI_CompositeVObject* p, 
                                       UI_ViewID id,
                                       const UI_Rectangle& shape,
                                       long s
                                     ) : UI_VisualObject (p, id, shape, s)
{
   _ownModel = TRUE;
   _model = NULL;
}



UI_SimpleVObject :: UI_SimpleVObject ( UI_CompositeVObject* p, UI_ViewID id,
                                       UI_ViewHandle h
                                     ) : UI_VisualObject (p, id, h)
{
   _ownModel = TRUE;
   _model = NULL;
}



UI_SimpleVObject :: UI_SimpleVObject ( UI_CompositeVObject* p, 
                                       CL_Object* md,
                                       UI_ViewID id,
                                       const UI_Rectangle& r, long s
                                     ) : UI_VisualObject (p, id, r, s)
{
   _ownModel = FALSE;
   _model = md;
}



UI_SimpleVObject :: ~UI_SimpleVObject()
{
    if (_ownModel && _model != NULL)
        delete _model;
}



#include <iostream.h> // DEBUG

bool UI_SimpleVObject::MakeVisualElement ()
{
#if defined(__MS_WINDOWS__)
    short x = _shape.Left();
    short y = _shape.Top ();
    short w = _shape.Width();
    short h = _shape.Height();
    const char* label = (_title.Length() > 0) ? _title.AsPtr() : NULL;
    char* class_name = MSWindowsName();
    HINSTANCE hInst = (HINSTANCE) _Application->ProcessId();
    if (IsTabStop())
        _style |= WS_TABSTOP;
    else
        _style &= ~((long) WS_TABSTOP);
    if (!_visible)
        _style &= ~WS_VISIBLE;
    _handle = CreateWindow (class_name, label, _style, x, y, w, h,
                            _parent->ViewHandle(), _id, (HANDLE) hInst, NULL);
    if (!_handle) {
        CL_Error::Warning
            ("YACL: Simple Object CreateWindow failed:\nClass %s ID %d",
             class_name, _id);
        return FALSE;
    }
    _Controller->AddEvent (new UI_Event (Event_ChildCreated, this, _parent));
    return TRUE;

#elif defined(__X_MOTIF__)

    // GNU C seems to have a strange bug, so we work around it. Instead of
    // saying
    //    Widget pw = (Widget) (_parent->ViewHandle());
    // we say
    UI_VisualObject* p = _parent;
    Widget pw = (Widget) p->ViewHandle();

    CL_String instance_name = InstanceName();
    const char* inst_name = instance_name.AsPtr();
    struct _WidgetClassRec *class_name = XName ( );

    Arg arg [20];
    short argn = 0;
    _SetupStyle (arg, argn); // Set up the X resources

    XmString title = XmStringCreate
        ((char *) _title.AsPtr (), XmSTRING_DEFAULT_CHARSET);    
    XtSetArg (arg [argn], XmNlabelString, title); argn++;
    _xwidget = XtCreateWidget (inst_name, class_name, pw, arg, argn);
    // XtManageChild (_xwidget);
    // XtSetValues (_xwidget, arg, argn);

    XmStringFree (title);
    _Controller->AddEvent (new UI_Event (Event_ChildCreated, this, _parent));

    return TRUE;
#endif
}


void UI_SimpleVObject :: Initialize()
{
    UI_VisualObject :: Initialize ( );
    if ( _model ) {
        SimpleBind b (this, &UI_SimpleVObject::ModelChanged);
        _model->AddDependent (b, 1);
    }
#if defined(__MS_WINDOWS__)
    if (_font) {
        if (_parent && !_parent->CreatedViaResource())
            _font->SelectFor (this);
        SimpleBind b (this, &UI_SimpleVObject::_FontChanged);
        _font->AddDependent (b, 1);
    }
    UI_ResourceHandle h = _font ? _font->Handle() : 0;
    if (h && !_parent->CreatedViaResource()) {
        SendMessage (_handle, WM_SETFONT, h, TRUE);
    }
#endif
}


void UI_SimpleVObject :: Finalize()
{
    UI_VisualObject :: Finalize();
}


void UI_SimpleVObject :: SetModelValue (const CL_Object& value)
{
    if ( !_model )
        return;
    SimpleBind bnd (this, &UI_SimpleVObject::ModelChanged);
    _model->RemoveDependent (bnd);
    *_model = value;
    _model->AddDependent (bnd, 1);
}


bool UI_SimpleVObject :: DestroyVisualElement ()
{
#if defined(__MS_WINDOWS__)

    if (_handle > 0 && !_parent->CreatedViaResource()) {
        DestroyWindow (_handle);
        return TRUE;
    }

#elif defined(__X_MOTIF__)

    if ( _xwidget ) {
        XtUnmanageChild (_xwidget);
        XtDestroyWidget (_xwidget);
        return TRUE;
    }
#endif

    return FALSE;
}



bool UI_SimpleVObject :: _FontChanged (CL_Object&, long)
{
#if defined(__MS_WINDOWS__)
    UI_ResourceHandle h = _font ? _font->Handle() : 0;
    if (h > 0) {
        return SendMessage (_handle, WM_SETFONT, h, TRUE);
    }
    return TRUE;
#endif
}



bool UI_SimpleVObject :: SetFont (UI_Font* fnt)
{
#if defined(__MS_WINDOWS__)
    if (!UI_VisualObject::SetFont (fnt))
        return FALSE;
    UI_ResourceHandle h = _font ? _font->Handle() : 0;
    if (h > 0) {
        return SendMessage (_handle, WM_SETFONT, h, TRUE);
    }
    return TRUE;
#endif
}




char* UI_SimpleVObject :: MSWindowsName ( ) const
{
    return _YACLWindowClassName;
}



#if defined (__X_MOTIF__)
struct _WidgetClassRec * UI_SimpleVObject :: XName ( ) const
{
    return shellWidgetClass;
}
#endif



bool UI_SimpleVObject :: SetStyleParam ( )
{
    // This is used only for resource-based construction
#if defined(__MS_WINDOWS__)
    RECT rec;

    _id = GetWindowWord    (_handle,GWW_ID);  
    _style = GetWindowLong (_handle,GWL_STYLE); 
    _visible = (_style & WS_VISIBLE) ? TRUE : FALSE;
    GetWindowRect (_handle,&rec);
    POINT array[2];
    array[0].x = rec.left;
    array[0].y = rec.top;
    array[1].x = rec.right;
    array[1].y = rec.bottom;
    MapWindowPoints (NULL, _parent->ViewHandle(), array, 2);
    UI_Point org(array[0].x, array[0].y);
    UI_Rectangle shp(org, array[1].x-array[0].x, array[1].y-array[0].y);
    SetShapeRectangle (shp);

#elif defined(__X_MOTIF__)
#endif
    return TRUE;
}



