




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#include "ui/scrolbar.h"
#include "ui/cntroler.h"
#include "ui/interval.h"

#if defined(__MS_WINDOWS__)
#include <windows.h>

#elif defined(__X_MOTIF__)
#include <Xm/ScrollBar.h> 

#endif

#if defined(__GNUC__) && __GNUC_MINOR__ >= 6
template class CL_Binding<UI_ScrollBar>;
#endif


/*------------------ ScrollBar Object ---------------------------*/

typedef CL_Binding<UI_ScrollBar> Bind;

UI_ScrollBar::UI_ScrollBar (UI_CompositeVObject* p,
                            const UI_Rectangle& shape,
                            UI_ViewID id, long bstyle)
:  UI_SimpleVObject (p, id, shape, bstyle), _range (0, 100)
{ 
    _model = new CL_Interval (0,0);
    _ownModel = TRUE;
    Bind bind (this, &UI_ScrollBar::RangeChanged);
    _range.AddDependent (bind, 1); // Second parameter unused
    _lineAmount = 1;
    _pageAmount = 10;
    _smoothScroll = TRUE;
    _vertical = TRUE;
}


UI_ScrollBar::~UI_ScrollBar()
{
}


#if defined (__X_MOTIF__)
struct _WidgetClassRec* UI_ScrollBar::XName () const
{
    return xmScrollBarWidgetClass;
}

#endif 



bool UI_ScrollBar::ModelChanged (CL_Object&, long)
{
#if defined(__MS_WINDOWS__)
    SetScrollPos   (_handle, SB_CTL, ((CL_Interval*) _model)->Low(),
                    TRUE);
#elif defined(__X_MOTIF__)
    Arg args[2];
    CL_Interval& value = *(CL_Interval*) _model;
    XtSetArg    (args[0] , XmNvalue, value.Low());
    XtSetArg    (args[1] , XmNsliderSize, value.High()-value.Low()+1);
    XtSetValues (_xwidget, args, 2);
    XmUpdateDisplay (_xwidget);
#endif
    return TRUE;
}


bool UI_ScrollBar::MakeVisualElement ()
{
    bool b = UI_SimpleVObject::MakeVisualElement ();
#if defined(__X_MOTIF__)
    Arg args[1];
    XtSetArg    (args[0] , XmNorientation,
                 _vertical ? XmVERTICAL : XmHORIZONTAL);
    XtSetValues (_xwidget, args, 1);
#endif
    return b;
}


void UI_ScrollBar::Initialize()
{
    UI_SimpleVObject::Initialize();

#if defined(__MS_WINDOWS__)
    SetScrollRange ((HWND) _handle, SB_CTL, _range.Low(), _range.High(), TRUE);

#elif defined(__X_MOTIF__)

    RangeChanged (*this, 0); // Force an initialization of range
    ModelChanged (*this, 0); // Force initialization of model
    XtAddCallback (_xwidget, XmNdragCallback, 
                   &UI_ScrollBar::ScrollBarCallback, (XtPointer) this);
    XtAddCallback (_xwidget, XmNincrementCallback, 
                   &UI_ScrollBar::ScrollBarCallback, (XtPointer) this);
    XtAddCallback (_xwidget, XmNpageIncrementCallback, 
                   &UI_ScrollBar::ScrollBarCallback, (XtPointer) this);
    XtAddCallback (_xwidget, XmNdecrementCallback, 
                   &UI_ScrollBar::ScrollBarCallback, (XtPointer) this);
    XtAddCallback (_xwidget, XmNpageDecrementCallback, 
                   &UI_ScrollBar::ScrollBarCallback, (XtPointer) this);
    XtAddCallback (_xwidget, XmNtoBottomCallback, 
                   &UI_ScrollBar::ScrollBarCallback, (XtPointer) this);
    XtAddCallback (_xwidget, XmNtoTopCallback, 
                   &UI_ScrollBar::ScrollBarCallback, (XtPointer) this);
    XtAddCallback (_xwidget, XmNvalueChangedCallback, 
                   &UI_ScrollBar::ScrollBarCallback, (XtPointer) this);
#endif
}


#if defined(__X_MOTIF__)
void UI_ScrollBar::ScrollBarCallback (Widget w, void* client, void* call)
{
    UI_ScrollBar* bar = (UI_ScrollBar *) client;
    UI_EventType type;
    XmScrollBarCallbackStruct* cb = (XmScrollBarCallbackStruct*) call;
    switch (cb->reason) {
    case XmCR_DRAG:
        type = Event_Scroll;
        break;
        
    case XmCR_DECREMENT:
        type = Event_ScrollBackwardLine;
        break;
        
    case XmCR_INCREMENT:
        type = Event_ScrollForwardLine;
        break;
        
    case XmCR_PAGE_DECREMENT:
        type = Event_ScrollBackwardPage;
        break;
        
    case XmCR_PAGE_INCREMENT:
        type = Event_ScrollForwardPage;
        break;

    case XmCR_TO_TOP:
        type = Event_ScrollToBegin;
        break;

    case XmCR_TO_BOTTOM:
        type = Event_ScrollToEnd;
        break;

    case XmCR_VALUE_CHANGED:
        type = Event_FinishScroll;
        break;

    default:
        CL_Error::Warning ("UI_ScrollBar callback: unknown reason");
        break;
    };
    int val, slsize, inc, page_inc;
    XmScrollBarGetValues (bar->_xwidget, &val, &slsize, &inc, &page_inc);
    bar->SetModelValue (CL_Interval (val, val+slsize));
    _Controller->AddEvent (new UI_Event (type, bar, bar));
        
}
#endif // __X_MOTIF__


bool UI_ScrollBar::HandleEvent (UI_Event* e)
{
    UI_EventType type = e->Type();
    if (type < Event_Scroll || type > Event_ScrollToPosition) {
        return ProcessEvent (e);
    }

    long pos = ((CL_Interval*) _model)->Low();
    switch (type) {
    case Event_ScrollToBegin:
        pos = _range.Low();
        break;
        
    case Event_ScrollToEnd:
        pos = _range.High();
        break;
        
    case Event_ScrollForwardLine:
        pos = minl (_range.High(), pos + _lineAmount);
        break;
        
    case Event_ScrollBackwardLine:
        pos = maxl (_range.Low(), pos - _lineAmount);
        break;

    case Event_ScrollForwardPage:
        pos = minl (_range.High(), pos + _pageAmount);
        break;
        
    case Event_ScrollBackwardPage:
        pos = minl (_range.High(), pos - _pageAmount);
        break;

    case Event_ScrollToPosition:
    case Event_Scroll:
        pos = e->param;
        break;

    default:
        break;
    }        
#if defined(__MS_WINDOWS__)
    SetModelValue (CL_Interval (pos, pos+1));
    if (type == Event_FinishScroll)
        SetScrollPos (_handle, SB_CTL, pos, TRUE);
#endif
    if (_clientSet.Size () == 0)
        return FALSE;
    if (type != Event_Scroll || _smoothScroll)
        _clientSet.NotifyAll (*this);
    return TRUE;
}


CL_Interval& UI_ScrollBar::Range ()
{
    return _range;
}


bool UI_ScrollBar::RangeChanged (CL_Object&, long)
{
#if defined(__MS_WINDOWS__)
    if (_handle > 0)
        SetScrollRange (_handle, SB_CTL, _range.Low(), _range.High(),
                        TRUE);
#elif defined(__X_MOTIF__)
    if (_xwidget) {
        Arg args[2];

        XtSetArg    (args[0] , XmNminimum, _range.Low  ());
        XtSetArg    (args[1] , XmNmaximum, _range.High ());
        XtSetValues (_xwidget, args, 2);
    }
#endif
    return TRUE;
}






/*---------------------VScrollBar------------------------------------*/

UI_VScrollBar::UI_VScrollBar
    (UI_CompositeVObject* p, const UI_Rectangle& shape,
     UI_ViewID id, long bstyle)
: UI_ScrollBar (p, shape, id, bstyle)
{
#if defined (__MS_WINDOWS__)
    if (_style == -1)
        _style = WS_VISIBLE | SBS_VERT | WS_CHILD;


#endif
}




/*-------------------------HScrollBar----------------------------*/

UI_HScrollBar::UI_HScrollBar
    (UI_CompositeVObject* p, const UI_Rectangle& shape,
     UI_ViewID id, long bstyle)
: UI_ScrollBar (p, shape, id, bstyle)
{
#if defined(__MS_WINDOWS__)
    if (_style == -1)
        _style = WS_VISIBLE | SBS_HORZ | WS_CHILD;
#endif
}

