

#ifndef _rectangle_h_
#define _rectangle_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#include "ui/point.h"
#include "ui/graphic.h"


// This is an abstraction of a rectangle at a given position in
// two-dimensional space.

// A convenient definition of a rectangle
struct UI_RectangleStruct {
    long x, y, w, h;  // h = height, w = width
};


class UI_DrawingSurface;

class UI_Rectangle: public UI_GraphicObject {

public:

    //
    //-------------------Construction------------------
    //
    UI_Rectangle (const UI_Point& origin, long width, long height);
    

    UI_Rectangle (long x, long y, long width, long height);

    UI_Rectangle (const UI_RectangleStruct&);
    
    UI_Rectangle ();

    UI_Rectangle (const UI_Rectangle& );

    ~UI_Rectangle ();

    //
    // --------------------Query-------------------------
    //

    UI_Rectangle BoundingRectangle() const {return *this; };
    
    long TopLeftX () const {return _origin.XCoord();};

    long TopLeftY () const {return _origin.YCoord();};

    long BottomRightX () const {return _origin.XCoord() + _width;};

    long BottomRightY () const {return _origin.YCoord() + _height;};

    long Top () const {return _origin.YCoord();}

    long Left () const {return _origin.XCoord();}

    long Bottom () const {return _origin.YCoord() + _height;}

    long Right () const {return _origin.XCoord() + _width;}
    
    const UI_Point& Origin () const {return _origin;};

    UI_Point TopLeft () const {return _origin;}

    UI_Point BottomRight () const
        {return _origin + UI_Point (_width, _height);};

    UI_Point TopRight () const   {return _origin + UI_Point (_width, 0);};
    
    UI_Point BottomLeft () const {return _origin + UI_Point (0, _height);};
    
    long Height () const;

    long Width () const;

    long Area () const;

    bool Includes (const UI_Point& p) const;

    bool OnBoundary (const UI_Point& p) const;

    bool IntersectsBoundary (const UI_Rectangle& r) const;

    // ------------------------ Geometric operations -----------------


    void Origin  (const UI_Point& o);
    // Set the origin to the given point, thus moving the rectangle.

    void AddToHeight (long increment);
    // Add this value to the height. The parameter may be negative. This
    // method will refuse any change that causes the height to fall below zero.
    
    void AddToWidth (long increment);
    // Add this value to the width. The parameter may be negative. This
    // method will refuse a change that causes the width to fall below zero.
    
    UI_Rectangle operator+  (const UI_Point&) const;

    void operator+= (const UI_Point& p) {*this = *this + p;};

    bool ReshapeTo (const UI_Rectangle& r);

    // ------------------------- Drawing -------------------------------
    
    bool DrawOn (UI_DrawingSurface& sfc,
                 const UI_Point& p = UI_Point(0,0)) const;
    // Override the method inherited from GraphicObject.
    
        
    // ----------------------- Basic operations ------------------
    
    void operator= (const CL_Object& );

    void operator= (const UI_Rectangle& rect);
    
    bool operator== (const CL_Object& r) const;

    bool operator== (const UI_Rectangle& r) const;

    CL_String AsString () const;
    // Return a string that looks like \verb|"(23, 15, 2, 3)"| (for x, y,
    // w, h).
    

protected:
 
    UI_Point _origin; 
    long     _height;
    long     _width;
};



inline bool UI_Rectangle::ReshapeTo (const UI_Rectangle& r)
{
    *this = r;
    return TRUE;
}

#endif
