




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */





#include "ui/rectangl.h"
#include "ui/dwgsurf.h"


//
//------------Constructors--------------------
//

UI_Rectangle::UI_Rectangle(const UI_Point& origin, long width, long height)
{
    _origin = origin;
    if (width < 0) {
        _origin = _origin + UI_Point (width, 0); // Shift origin to left end
        width = -width;
    }
    if (height < 0) {
        _origin = _origin + UI_Point (0, height); 
        height = -height;
    }
    _height = height;
    _width  = width;
}

UI_Rectangle::UI_Rectangle (long x, long y, long width, long height)
{
    _origin = UI_Point (x, y);
    if (width < 0) {
        _origin = _origin + UI_Point (width, 0); // Shift origin to left end
        width = -width;
    }
    if (height < 0) {
        _origin = _origin + UI_Point (0, height); 
        height = -height;
    }
    _height = height;
    _width  = width;
}


UI_Rectangle::UI_Rectangle()
{
   _height = 0;
   _width  = 0;
}


UI_Rectangle::UI_Rectangle (const UI_RectangleStruct& r)
: _origin (r.x, r.y)
{
    _width = r.w;
    _height = r.h;
}


UI_Rectangle::UI_Rectangle(const UI_Rectangle& r)
{
    _origin = r._origin;
    _height = r. _height;
    _width = r._width;

    
}


UI_Rectangle::~UI_Rectangle()
{
}

//
//------------Query and modification--------------
//
    
long UI_Rectangle::Height() const
{
    return _height;
}

long UI_Rectangle::Width() const
{
    return _width;
}

long UI_Rectangle::Area() const
{
    return _height*_width;
}


bool UI_Rectangle::Includes(const UI_Point& p) const
{
    long x, y, x1, x2, y1, y2;
    x = p.XCoord();
    y = p.YCoord();

    x1 = _origin.XCoord();
    y1 = _origin.YCoord();
 
    x2 = x1 + _width;
    y2 = y1 + _height;

    return (x >= x1 && x <= x2 && y >= y1 && y <= y2);
}


UI_Rectangle UI_Rectangle::operator+ (const UI_Point& p) const
{
    UI_Rectangle q (*this);
    q._origin += p;
    return q;
}

//
//----------------Virtual member functions from CL_Object--------
//

void UI_Rectangle::operator= (const CL_Object& r)
{
    if (!IsA (r))
        return;
    *this = (const UI_Rectangle&) r;
}


void UI_Rectangle::operator= (const UI_Rectangle& r)
{
    if (this == &r  || *this == r || !PrepareToChange())
        return;
    _origin = r._origin; 
    _height = r._height;
    _width  = r._width;
    Notify();
}


//
//------------Virtual methods from CL_Object-----------
//

bool UI_Rectangle::operator== (const CL_Object& r) const
{
    if (!IsA (r))
        return FALSE;
    return (*this == (const UI_Rectangle&) r);
}


bool UI_Rectangle::operator== (const UI_Rectangle& r) const
{
    if (_origin != r._origin || _width != r._width || _height != r._height)
        return FALSE;
    return TRUE;
}


CL_String UI_Rectangle::AsString() const
{
    CL_String s;
    s.AssignWithFormat ("(%ld, %ld, %ld, %ld)", _origin.XCoord(),
                        _origin.YCoord(), _width, _height);
    return s;
}


void UI_Rectangle::Origin  (const UI_Point& o)
{
    if (!PrepareToChange())
        return;
    _origin = o;
    Notify();
}



void UI_Rectangle::AddToHeight (long incr)
{
    long new_val = _height + incr;
    if (new_val >= 0) {
        if (!PrepareToChange())
            return;
        _height = new_val;
        Notify();
    }
}



void UI_Rectangle::AddToWidth (long incr)
{
    long new_val = _width + incr;
    if (new_val >= 0) {
        if (!PrepareToChange())
            return;
        _width = new_val;
        Notify();
    }
}



bool UI_Rectangle::DrawOn (UI_DrawingSurface& sfc, const UI_Point& p) const
{
    UI_Rectangle r (*this);
    r += p;
    sfc.DrawRectangle (r);
    return TRUE;
}




bool UI_Rectangle::OnBoundary (const UI_Point& p) const
{
    long px = p.XCoord(), py = p.YCoord();
    long left    = _origin.XCoord();
    long right   = left + _width;
    long top     = _origin.YCoord();
    long bottom  = top + _height;
    return ((px == left || px == right)  && py >= top  && py <= bottom)
               // on left or right side
        || ((py == top || py == bottom)  && px >= left && px <= right);
               // on top or bottom side
}


bool UI_Rectangle::IntersectsBoundary (const UI_Rectangle& r) const
{
    bool b1 = Includes (r.TopLeft()),  b2 = Includes (r.BottomLeft());
    bool b3 = Includes (r.TopRight()), b4 = Includes (r.BottomRight());
    return (b1 || b2 || b3 || b4) && ! (b1 && b2 && b3 && b4);
}
