




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */






#include "ui/pushbtn.h"
#include "ui/cntroler.h"

#if defined (__MS_WINDOWS__)

#include <windows.h>
#define PUSH_BUTTON_STYLE  \
    BS_PUSHBUTTON | WS_CHILD | WS_VISIBLE | WS_TABSTOP

#elif defined (__X_MOTIF__)
#include <X11/Intrinsic.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
 
#endif

UI_PushButton::UI_PushButton (UI_CompositeVObject* parent,
                              const UI_Rectangle& shape,
                              UI_ViewID id, long btn_style)
: UI_Button (parent, shape, id,
#if defined(__MS_WINDOWS__)
             btn_style == -1 ? PUSH_BUTTON_STYLE : btn_style
#else
             btn_style
#endif
             )
{
    _model = &_title;       // Dirty little trick to share the same string
    _ownModel = FALSE;     // between model and title
}



UI_PushButton::UI_PushButton (UI_CompositeVObject* parent,
                              UI_ViewID id, UI_ViewHandle h)
: UI_Button (parent, id, h)
{
    _model = &_title;       // Dirty little trick to share the same string
    _ownModel = FALSE;     // between model and title
}


#if defined (__X_MOTIF__)

struct _WidgetClassRec* UI_PushButton::XName ( ) const 
{
    return xmPushButtonWidgetClass;
}


void UI_PushButton::SelectionCallback (Widget w, void* client,
                                       void* call)
{
    UI_PushButton* btn = (UI_PushButton *) client;
    XmPushButtonCallbackStruct* cb = (XmPushButtonCallbackStruct*) call;
    if (cb->reason == XmCR_ACTIVATE) {
        UI_EventType typ = (cb->click_count == 1)
            ? Event_Select : Event_LButtonDblClk;
        _Controller->AddEvent (new UI_Event (typ, btn, btn));
    }
}

#endif



//
//----------------- Inherited methods ---------------------------
//


bool UI_PushButton::Select ()
{
    return FALSE;
}


bool UI_PushButton::ModelChanged (CL_Object&, long)
{
#if defined(__MS_WINDOWS__)
    if (_handle > 0)
        SendMessage (_handle, WM_SETTEXT, 0, (long)(const char*)_title); 

#elif defined(__X_MOTIF__)

    if (!_xwidget)
        return TRUE;
    Arg arg [2];
    short argn = 0;

    XmString label;

    label = XmStringCreate ((char *) ( (CL_String *)_model )->AsPtr (), 
                            XmSTRING_DEFAULT_CHARSET 
                            );    
    
    XtSetArg (arg [argn], XmNlabelString, label); argn++;
    XtSetValues (_xwidget, arg, argn);

    XmUpdateDisplay (_xwidget);
    XmStringFree (label);
#endif

    return TRUE;
}



#if defined(__X_MOTIF__)
void UI_PushButton::_SetupStyle (void* p, short& argn)
{
    Arg* arg = (Arg*) p;
    UI_SimpleVObject::_SetupStyle (arg, argn);
    // Add another resource spec:
    XtSetArg (arg [argn], XmNrecomputeSize, FALSE); argn++;
}
#endif


bool UI_PushButton::MakeVisualElement ()
{
    bool b = UI_SimpleVObject::MakeVisualElement ();
#if defined(__X_MOTIF__)
    XtAddCallback (_xwidget, XmNactivateCallback, 
                   &UI_PushButton::SelectionCallback, (XtPointer) this);
#endif
    return b;
}

