




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */





#include "ui/point.h"


//
//------------------Construction-----------------------------
//


UI_Point::UI_Point(long px,long py)
{
    x = px;
    y = py;
}


UI_Point::UI_Point(const UI_Point& p)
{
    x = p.x;
    y = p.y;
}


UI_Point UI_Point::operator+ (const UI_Point& p) const
{
    UI_Point q (p);
    q.x += x;
    q.y += y;
    return q;
}



//
//-----------Other member Functions--------------------------
//

void UI_Point::operator= (const CL_Object& p) 
{
    if (!IsA (p))
        return;
    *this = (const UI_Point&) p; // The op= does the notification
}


void UI_Point::operator= (const UI_Point& q)
{
    if (*this == q || !PrepareToChange())
        return;
    x = q.x;
    y = q.y;
    Notify ();
}


//
//---------------Virtual member functions from CL_Object-------
//

bool UI_Point::operator== (const CL_Object& p) const
{
    if (!IsA (p))
        return FALSE;
    register const UI_Point& q = (const UI_Point&) p;
    if (q.x != x || q.y != y)
        return FALSE;
    return TRUE;
}


bool UI_Point::operator== (const UI_Point& q) const
{
    if (q.x != x || q.y != y)
        return FALSE;
    return TRUE;
}





//
//---------------Virtual member functions from CL_Object----------
//

// bool UI_Point::operator< (const CL_Object& p) const
// {
//     if (!IsA (p))
//         return (this < &p ? -1 : 1);
//     if(x < ((const UI_Point&)p).x) return TRUE;
//     if(x == ((const UI_Point&)p).x && y < ((const UI_Point&)p).y)
//          return TRUE;
// 
//     return FALSE;
// }

CL_String UI_Point::AsString() const
{
    CL_String s;
    s.AssignWithFormat ("(%ld, %ld)", x, y);
    return s;
}



void  UI_Point::AddToX (long value)
{
    if (!PrepareToChange())
        return;
    x += value;
    Notify ();
}

void  UI_Point::AddToY (long value)
{
    if (!PrepareToChange())
        return;
    y += value;
    Notify ();
}

