



#ifndef _objstore_h_ /* Tue Nov 15 09:20:16 1994 */
#define _objstore_h_


// The storage facility for graphic objects.


#include "base/map.h"
#include "base/objset.h"

#include "ui/point.h"
#include "ui/graphic.h"

#include "defs.h"

class ObjectStore {

public:
    ObjectStore();
    
    ~ObjectStore();

    ObjectId    Add     (GR_ShapeEnum type, const UI_Point& origin);
    // Add a new object of given type, with origin at the given point, and
    // return its object id.

    bool        Remove  (ObjectId id);
    // Remove the object with given id.

    UI_GraphicObject* ObjectWithId (ObjectId id) const;
    
    UI_GraphicObject* ObjectAt (const UI_Point& p);
    // Return the object (if any) whose boundary includes the point p.
    // Return NULL if no such object.

    CL_ObjectSet AllObjects () const;
    // Return a set of pointers to the contained graphic objects.

protected:

    // For now, the implementation uses a simple map.
    CL_IntPtrMap  _objects;
    ObjectId      _nextId;
    
};


#endif /* _objstore_h_ */
