

#ifndef _monthcal_h_ /* Thu Dec 30 15:50:13 1993 */
#define _monthcal_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */





// This is a simple visual object that has a date as its model, and displays
// the month of that date in its view.

#include "base/date.h"
#include "ui/simple.h"

class UI_MonthCalendar: public UI_SimpleVObject {

public:
    UI_MonthCalendar (UI_CompositeVObject* parent, UI_ViewID id,
                      const UI_Rectangle& shape,
                      const CL_Date& date = CL_Date());

    void AdvanceMonth ();

    void PreviousMonth();
    

protected:
    bool LButtonPress(const UI_Point& curPos, bool shift, bool ctrl);

    bool Paint ();

    // Virtual methods for child classes:
    
    virtual void ClickOnDay (short day) {};

    virtual void DoubleClickOnDay (short day) {};

    CL_Date::MonthEnum _month;
    short _year;

private:
    short _cellWidth;
    short _cellHeight;
    short _charWidth;
    short _charHeight;
    short _dayOfFirst;  // What day of week is the first of the displayed
                        // month ?
    short _daysInMonth; // Number of days in the displayed month
};

#endif /* _calendar_h_ */
