

#ifndef _menu_h_ /* Mon Sep 20 21:20:32 1993 */
#define _menu_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */





// A Menu  is thought of  as  a labeled tree,   each of whose  nodes is a
// MenuItem object, and the label  of a given node  is the handle of  the
// corresponding MenuItem object. Thus we require that  the labels of the
// MenuItem objects are  all distinct. The  root of the  tree is  a dummy
// node.  (This formulation allows direct use  of CL_Tree.) Each MenuItem
// object is (derived  from) a  VisualObject,  and therefore supports  an
// event-handling protocol. In particular, it  displays a picture in  its
// view area, which most often is a simple text string, and it provides a
// "highlighting" capability for what it displays.
//
// The    MenuItem responds to     the  GetFocus,  Select and   LoseFocus
// events.  Its response to the GetFocus  event  (the WM_INITMENU message
// under Windows)  is to  highlight  its view, and notifying  any clients
// that might be interested in that event. Similarly, its response to the
// LoseFocus event is to notify any clients interested in the event.  Its
// response to  the Select event  depends on whether it is  a leaf in the
// tree or not.  If it is not a leaf in the tree, it displays the submenu
// associated with it.  If  it is a leaf,  it simply notifies any clients
// interested in that event.
//
// Since every simple visual object must contain  a model, we use a string as
// model for the  MenuItem. This model is the  value displayed by default
// in  the MenuItem's  view. (Custom  MenuItem   objects that draw  fancy
// graphics  in  their  view might   or might not   use  this string.) An
// assignment to this model changes the picture drawn in the view.
//
// The  Menu class simply functions as  a container for MenuItem objects,
// and provides convenience functions  for accessing MenuItems.
//
// The MenuBar and PopupMenu classes are derived from the Menu class, and
// are simply  two different ways  of representing the "main" menu, i.e.,
// the children of the root of the menu tree.
//
// The abstraction of the menu represented by the UI_Menu class is the
// following. The Menu is thought of as a container for MenuItem
// objects. Thus all the contained MenuItems must have
// distinct Id's. Note that this view "linearizes" the traditional
// tree-structured view of a menu in which the children of the root are the
// main menu items, and their children are submenu items.
//
// The root uses an id of 0, so all menu items must have distinct id's that
// are greater than 0.

#include "base/tree.h"
#include "base/clntset.h"

#include "ui/simple.h"




class UI_MenuItem;
class UI_PopupMenu;
struct UI_MenuItemDescriptor;


class UI_Menu: public UI_VisualObject {

public:

    UI_MenuItem* operator[] (UI_ViewID id);
    // Return a pointer to the menu item with the given id. The returned
    // object remains owned by the Menu, and may not be destroyed by the
    // caller. This method returns NULL if no such id exists in the menu.
    
    char* MSWindowsName () const { return "menu";};

    const char* ClassName     () const { return "UI_Menu";};

protected:

    UI_Menu  (UI_MenuItemDescriptor* item);

    ~UI_Menu ();


    void _BuildMenuSubtree (UI_MenuItemDescriptor* items, UI_ViewID id);

    bool _DeleteItem (CL_Object&, long);
    
    bool _CreateVisualElement (CL_Object&, long);
    // Create the visual aspect of the menu.

    bool HandleEvent (UI_Event* e);

    bool DestroyVisualElement ();

    CL_IntegerTree _menuTree;
    UI_MenuItem*   _focusItem;

#if defined (__MS_WINDOWS__)
    CL_IntPtrMap   _popupMenuMap;

#endif

#if defined(__X_MOTIF__)
    void SetMenuItemLabel (UI_MenuItem*);

#endif
};


class UI_MenuItem: public UI_SimpleVObject {

public:
    enum State {
        Enabled,
        Disabled,
        Grayed,
        Checked,
        Unchecked
    };

    enum MenuEvent { Highlighted = 0, UnHighlighted, Selected };

    bool AddClient (const CL_AbstractBinding& bind, long code, MenuEvent
                    event);
    // Add a client to this MenuItem, with the given binding and
    // parameter, for the given event.
    
    bool SetState (State new_state);
    
    // Overridden inherited methods:

    bool Enable ();

    bool Disable ();
    
        
    CL_Object* Model() {return &_title;};
    // Return reference to the string label - the default model.

    UI_ViewHandle ViewHandle () const;

    char* MSWindowsName() const {return "menuitem";}; 

    const char* ClassName() const { return "UI_MenuItem";}; 

protected:

    friend class UI_Menu;
    friend class UI_MenuBar;
    friend class UI_PopupMenu;
    UI_MenuItem (UI_Menu* container, const char* label,
                 State state, UI_ViewID id);

    ~UI_MenuItem();

    bool Paint();

    bool MakeVisualElement ();

    bool DestroyVisualElement ();
    
    bool GetFocus ();

    bool LoseFocus ();

    bool Select ();
    
    // 
    // Instance variables
    // 

    // The default model is a label string and stored in the inherited
    // variable 'title'. If a specialized menuitem is derived, then an
    // appropriate (CL_Object) 'model' instance variable needs to be
    // added.

    State            _state;
    short            _position;
    CL_ClientSet     _clients[3];  // For the three kinds of client events
    UI_Menu&         _container;   // The menu object of which we are a
                                   // part
    
private:
#if defined(__MS_WINDOWS__)
    UI_ViewHandle    _parentHandle;

#elif defined (__X_MOTIF__)

    struct _WidgetRec* _xitemw;
    static void GetFocusCallback  (struct _WidgetRec*, void *, void *);

    static void LoseFocusCallback (struct _WidgetRec*, void *, void *);
    
    static void SelectionCallback (struct _WidgetRec*, void *, void *);
    
#endif

};




#define UIMenu_Separator  "---"

struct UI_MenuItemDescriptor {
    char*                  label;     // Set this field to UIMenu_Separator
                                      // for a separator; the remaining fields
                                      // are ignored for separators
    UI_MenuItemDescriptor* submenu;
    UI_ViewID              id;
    UI_MenuItem::State     state;
};




class UI_MenuBar: public UI_Menu {

public:

    UI_MenuBar (UI_MenuItemDescriptor* item );

    ~UI_MenuBar(){};

    bool Intialize ();
    
    char* MSWindowsName() const {return "menubar";};

    const char* ClassName() const { return "UI_MenuBar";};

protected:
    bool MakeVisualElement ();

};


class UI_PopupMenu: public UI_Menu {

public:

    UI_PopupMenu (UI_MenuItemDescriptor* item);
    //  Construct a popup menu

    ~UI_PopupMenu ();

    char* MSWindowsName () const {return "menupopup";};

    const char* ClassName () const { return "UI_MenuPopup";};


protected:
    bool MakeVisualElement ();

};


#endif



