

#include "ui/lineseg.h"
#include "ui/dwgsurf.h"

UI_LineSegment::UI_LineSegment (const UI_Point& p1, const UI_Point& p2)
: _p1 (p1), _p2(p2)
{
}


UI_LineSegment::UI_LineSegment ()
{
}


bool UI_LineSegment::Intersects (const UI_LineSegment& l) const
{
    // Finish this.
    return TRUE;
}


bool UI_LineSegment::DrawOn (UI_DrawingSurface& sfc, const UI_Point& p)
    const
{
    UI_Point pos = sfc.PenPosition ();
    sfc.MovePenTo  (p + _p1);
    sfc.DrawLineTo (p + _p2);
    sfc.MovePenTo  (pos);
    return TRUE;
}



bool UI_LineSegment::ReshapeTo (const UI_Rectangle& r)
{
    if (!PrepareToChange())
        return FALSE;
    _p1 = r.TopLeft();
    _p2 = r.BottomRight();
    Notify ();
    return TRUE;
}


void UI_LineSegment::operator= (const CL_Object& o)
{
    if (o.IsA (*this))
        *this = (const UI_LineSegment&) o;
}


UI_LineSegment& UI_LineSegment::operator= (const UI_LineSegment& o)
{
    if (PrepareToChange()) {
        _p1 = o._p1;
        _p2 = o._p2;
        Notify();
    }
    return *this;
}


bool UI_LineSegment::OnBoundary (const UI_Point& p) const
{
    long x  = p.XCoord();
    long y  = p.YCoord();
    long x1 = _p1.XCoord();
    long y1 = _p1.YCoord();
    long x2 = _p2.XCoord();
    long y2 = _p2.YCoord();
    return (x-x1) * (y2-y1) == (x2-x1) * (y-y1);
    // This test avoids the inaccuracies of division.
}


UI_Rectangle UI_LineSegment::BoundingRectangle() const
{
    long x1 = _p1.XCoord();
    long y1 = _p1.YCoord();
    long x2 = _p2.XCoord();
    long y2 = _p2.YCoord();
    if (x2 > x1) {
        if (y2 > y1)
            return UI_Rectangle (_p1, x2-x1, y2-y1); // Quadrant 1
        else
            return UI_Rectangle (UI_Point (x1, y2), x2-x1, y2-y1); 
                                                 //Quadrant 4
    }
    else {
        if (y2 > y1)
            return UI_Rectangle (UI_Point (x2, y1), x2-x1, y2-y1);
        else
            return UI_Rectangle (_p2, x2-x1, y2-y1);
    }
}




bool UI_LineSegment::IntersectsBoundary (const UI_Rectangle& r) const
{
    return (r.Includes (_p1) ^ r.Includes (_p2));
}

            

