




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#include "ui/label.h"
#include "ui/cntroler.h"

#if defined(__MS_WINDOWS__)
#include <windows.h>

#elif defined(__X_MOTIF__)
#include <Xm/Label.h>
#include <Xm/Xm.h>
#endif


#if defined(__MS_WINDOWS__)
#define LABEL_STYLE WS_VISIBLE  | WS_CHILD

static ulong WindowsStyle (UI_TextStyle style)
{
    switch (style) {
    case UIText_Left:
        return SS_LEFT;
        
    case UIText_Center:
        return SS_CENTER;
        
    case UIText_Right:
        return SS_RIGHT;

    default:
        return 0;
    }
}

#elif defined(__X_MOTIF__)

static uchar XMotifStyle (UI_TextStyle style)
{
    switch (style) {
    case UIText_Left:
        return XmALIGNMENT_BEGINNING;
        
    case UIText_Center:
        return XmALIGNMENT_CENTER;
        
    case UIText_Right:
        return XmALIGNMENT_END;

    default:
        return 0;
    }
}
#endif


UI_Label::UI_Label ( UI_CompositeVObject* parent, 
                         const UI_Rectangle& r, 
                         UI_ViewID id,
                         long s
                       ) : UI_SimpleVObject (parent, id, r,
#if defined(__MS_WINDOWS__)
                    s == -1 ? LABEL_STYLE : s
#else
                    s
#endif
                    )
{
    _model = &_title;
    _ownModel = FALSE; // So that we don't attempt to delete the title
    _textStyle = UIText_Left;
#if defined(__MS_WINDOWS__)
    _style |= WindowsStyle (_textStyle);
#endif
}



UI_Label :: UI_Label ( UI_CompositeVObject* parent, UI_ViewID id,
                           UI_ViewHandle h 
                         ) : UI_SimpleVObject (parent, id, h)
{
    _model    = &_title;
    _ownModel = FALSE;
}


UI_Label :: UI_Label ( UI_CompositeVObject* parent, CL_String* msg,
                           const UI_Rectangle& r, UI_ViewID id, long s
                         ) : UI_SimpleVObject (parent, msg, id, r,
#if defined(__MS_WINDOWS__)
                    s == -1 ? LABEL_STYLE : s
#else
                    s
#endif
                    )
{
    _textStyle = UIText_Left;
#if defined(__MS_WINDOWS__)
    _style |= WindowsStyle (_textStyle);
#endif
}


#if defined(__X_MOTIF__)
struct _WidgetClassRec * UI_Label :: XName ( ) const
{
    return xmLabelWidgetClass;
}

void UI_Label::_SetupStyle (void* p, short& argn)
{
    Arg* arg = (Arg*) p;

    UI_SimpleVObject::_SetupStyle (arg, argn);
    // Add another resource spec:
    XtSetArg (arg [argn], XmNrecomputeSize, FALSE); argn++;
    XtSetArg (arg [argn], XmNalignment, XMotifStyle (_textStyle)); argn++;
}

#endif



void UI_Label :: Initialize ( )
{
    UI_SimpleVObject :: Initialize ( );
    CL_String& p = *(CL_String *) _model;
    if (p.Size () <= 0 )
        return;
#if defined(__MS_WINDOWS__)
    SendMessage (_handle, WM_SETTEXT, 0, (long) p.AsPtr());   
#elif defined(__X_MOTIF__)
    Arg arg[1];
    XmString xmlabel;
    char *label = (char *) p.AsPtr ( );
    xmlabel = XmStringCreateLtoR ( label, XmSTRING_DEFAULT_CHARSET );
    XtSetArg (arg[0], XmNlabelString, xmlabel);
    XtSetValues (_xwidget, arg, 1);
    XmStringFree (xmlabel);
#endif
}


        
bool UI_Label :: ModelChanged ( CL_Object&, long )
{    
#if defined(__MS_WINDOWS__)
    if ( _handle > 0 )
        SendMessage (_handle, WM_SETTEXT, 0,
                     (long) ((CL_String*) _model)->AsPtr() );   

#elif defined(__X_MOTIF__)
    if (!_xwidget)
        return TRUE;
    Arg arg[1];
    XmString label;
    label = XmStringCreateLtoR ((char *) ( (CL_String *)_model )->AsPtr (), 
                                XmSTRING_DEFAULT_CHARSET 
                                );    
    XtSetArg    (arg[0], XmNlabelString, label);
    XtSetValues (_xwidget, arg, 1);

    XmUpdateDisplay (_xwidget);
    XmStringFree (label);
#endif

    return TRUE;
}




bool UI_Label::SetTextStyle (UI_TextStyle style)
{
    if (style != UIText_Left && style != UIText_Center && style !=
        UIText_Right)
        return FALSE;
    _textStyle = style;
#if defined(__MS_WINDOWS__)
    if (_handle <= 0)
        return TRUE;
    long new_style =  GetWindowLong (_handle, GWL_STYLE) &
        ~(ES_LEFT | ES_CENTER | ES_RIGHT);
    new_style |= WindowsStyle (_textStyle);
    SetWindowLong (_handle, GWL_STYLE, new_style);
    SetWindowPos  (_handle, NULL, 0, 0, 0, 0, SWP_SHOWWINDOW | 
                   SWP_NOSIZE | SWP_NOMOVE | 
                   SWP_NOACTIVATE | SWP_NOZORDER); // Force re-draw
    return TRUE;
#elif defined(__X_MOTIF__)
    if (!_xwidget)
        return TRUE;
    Arg arg[1];
    XtSetArg (arg[0], XmNalignment, XMotifStyle (_textStyle));
    XtSetValues (_xwidget, arg, 1);
    XmUpdateDisplay (_xwidget);
    return TRUE;
#endif
        
}


UI_TextStyle UI_Label::TextStyle() const
{
    return _textStyle;
}


