
#ifndef _interval_h_
#define _interval_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#include "base/map.h"
#include "base/binding.h"


//  The Interval represents a range of integers, including both
//  endpoints (i.e., a ``closed'' interval). It is used as model for
//  scroll bars.


class CL_Interval: public CL_Object {

public:

    CL_Interval (long from, long to);
    // Construct an interval of the given range.

    CL_Interval ();
    // Construct an interval from -1 to -1.

    CL_Interval (const CL_Interval&);
    // Copy constructor.

    long Low () const;
    // Return the low value of the interval.

    void Low (long value);
    // Set the low value of the interval. If the given value exceeds our
    // high value, the low value will be set to our high value.

    long High () const;
    // Return the high value of the interval.

    void High (long value);
    // Set the high value of the interval. If the given value is less than our
    // low value, the high value will be set to our low value.

    long Length () const {return High() - Low() + 1;};
    // Return the length of th einterval, including both end points.

    bool operator== (const CL_Object& ) const;
    // Override the operator inherited from {\small\tt CL_Object}.
    
    void operator= (const CL_Interval& ) ;
    // Assign the given interval to this one.
    
    void operator= (const CL_Object& o)
        {*this = (const CL_Interval&) o;};

    void operator= (const CL_String&)
        {NotImplemented ("operator= (CL_String)");};

    CL_Object* Clone () const;

    const char* ClassName() const {return "CL_Interval";};

    CL_String AsString () const;
    

protected:

    long _low;
    long _hi;
};



inline long CL_Interval::Low () const
{
    return _low;
}


inline long CL_Interval::High () const
{
    return _hi;
}


inline void CL_Interval::Low (long v)
{
    _low = minl (_hi, v);
}


inline void CL_Interval::High (long v)
{
    _hi = maxl (_low, v);
}


inline CL_Object* CL_Interval::Clone () const
{
    return new CL_Interval (*this);
}

    

#endif

