#ifndef _font_h_
#define _font_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



// Authors:   M. A. Sridhar
//            N. Bhowmik




// The Font class represents a single font of the underlying windowing
// system, together with point size, type style and other attributes.
// NOT YET AVAILABLE UNDER X/MOTIF!

#include "ui/dsplrsrc.h"


#if defined(__MS_WINDOWS__)
#define OEMRESOURCE
#include <windows.h>
#endif

class UI_VisualObject;


class UI_Font: public UI_DisplayResource {

public:

    UI_Font ();
    // Create the platform's default font.

    UI_Font (const CL_String& typeface,
             short ptSize,
             bool italic = FALSE, bool underline = FALSE,
             bool boldFace = FALSE, bool strikeOut = FALSE);
    // Create a font with the given attributes.
    
    UI_Font (const UI_Font& );
    // Copy constructor.

    ~UI_Font ();
    // Destructor.

    void SelectFor (UI_VisualObject* v);
    // [Internal use only]
    // Select this font for use with the given visual object.

    long Height () const;
    // Return the height of each character, in pixels.

    long Width  () const;
    // Return the maximum width of a character, in pixels.
    
    short PointSize();
    // Return the point size of this font.

    CL_String TypeFace();
    // Return the name of the type face.

    bool Italic();
    // Return whether this is an italic font.

    bool Underline();
    // Return whether this font has the underline attribute.

    bool BoldFace();
    // Return whether this is a boldface font.

    bool StrikeOut();
    // Return whether this font has the strike-out attribute.


    void PointSize (short ptSize);
    // Set the point size of this font to the given size.

    void TypeFace  (const char* new_type_face);
    // Set the type face name of this font.

    void Italic(bool );
    // Set the italic attribute for this font.

    void Underline(bool );
    // Set the underline attribute for this font.

    void BoldFace(bool );
    // Set the boldface attribute for this font.

    void StrikeOut(bool );
    // Set the strike-out attribute for this font.

    const char* ClassName() const { return "UI_Font";};
    // Override the method inherited from {\small\tt CL_Object}.

     
protected:

    void    _Setup();

    UI_VisualObject* _client;
    short ptSize;
    CL_String typeFace;

    bool italic;
    bool underline;
    bool boldface;
    bool strikeout;
    
#if defined(__MS_WINDOWS__)
    LOGFONT lf;
#elif defined(__X_MOTIF__)
     XFontStruct xfont;
#endif

#ifdef  __MS_WINDOWS__
private:
    bool _stockFont;
    void _GetFontData (HANDLE hDC);
    // [MS-Windows-specific method]

#endif
};

#endif

