




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#include "ui/font.h"
#include "ui/visualob.h"
#include "ui/dsplsurf.h"

#if defined(__MS_WINDOWS__)
#include <windows.h>
#endif


UI_Font::UI_Font ()
: UI_DisplayResource (NULL)
{
#ifdef __MS_WINDOWS__
    _handle = GetStockObject (SYSTEM_FONT);
    _stockFont = TRUE;
    typeFace = "";
    ptSize = 0;
    italic = FALSE;
    underline = FALSE;
    boldface = FALSE;
    strikeout = FALSE;
    _client = NULL;
#endif
}

UI_Font::UI_Font (const CL_String& typeface,
                  short pts, bool itl,
                  bool undrl,bool bl, bool strk)
: UI_DisplayResource (NULL)
{   
    typeFace = typeface;
    ptSize = pts;
    italic = itl;
    underline = undrl;
    boldface = bl;
    strikeout = strk;
    _client = NULL;
#ifdef __MS_WINDOWS__
    _stockFont = FALSE;
#endif
}

UI_Font::UI_Font (const UI_Font& f)
: UI_DisplayResource (f._clientCtxt)
{
    typeFace = f.typeFace;
    ptSize = f.ptSize;
    italic = f.italic;
    underline = f.underline;
    boldface = f.boldface;
    strikeout = f.strikeout;
    _client = NULL;
    _handle = 0;
#ifdef __MS_WINDOWS__
    _stockFont = f._stockFont;
#endif
}

UI_Font::~UI_Font()
{
#if defined(__MS_WINDOWS__)
    if (_handle && !_stockFont)
        DeleteObject((HANDLE) _handle);
#elif defined(__X_MOTIF__)
#endif
}


void UI_Font::SelectFor (UI_VisualObject* v)
{
    _client = v;
    if (v) {
#if defined (__MS_WINDOWS__)
        HANDLE h = v->ViewHandle();
        if (_stockFont && h) {
            HANDLE hDC = GetDC (h);
            if (hDC) {
                _GetFontData (hDC);
                ReleaseDC (h, hDC);
            }
        }
        else if (!_handle)
            _Setup ();
#endif
    }
}



long UI_Font::Height () const
{
#if defined(__MS_WINDOWS__)
    return lf.lfHeight;
#endif
}

long UI_Font::Width () const
{
#if defined(__MS_WINDOWS__)
    return lf.lfWidth;
#endif
}

void UI_Font::PointSize (short sz)
{
    if (!PrepareToChange())
        return;
    ptSize = sz;
    _handle = 0;
    _Setup ();
    Notify();
}


void UI_Font::TypeFace (const char* str)
{
    if (!PrepareToChange())
        return;
    typeFace = str;
    _handle = 0;
    _Setup ();
#ifdef __MS_WINDOWS__
    _stockFont = FALSE;
#endif
    Notify();
}

void UI_Font::Italic(bool val)
{
    if (!PrepareToChange())
        return;
    italic = val;
    _handle = 0;
    _Setup ();
    Notify();
}

void UI_Font::Underline(bool val)
{
    if (!PrepareToChange())
        return;
    underline = val;
    _handle = 0;
    Notify();
}

void UI_Font::BoldFace(bool val)
{
    if (!PrepareToChange())
        return;
    boldface = val;
    _handle = 0;
    _Setup ();
    Notify();
}

void UI_Font::StrikeOut(bool val)
{
    if (!PrepareToChange())
        return;
    strikeout = val;
    _handle = 0;
    _Setup ();
    Notify();
}

short UI_Font::PointSize()
{
    return ptSize;
}

CL_String UI_Font::TypeFace()
{
    return typeFace;
}

bool UI_Font::Italic()
{
    return italic;
}

bool UI_Font::Underline()
{
     return underline;
}

bool UI_Font::BoldFace()
{
    return boldface;
}

bool UI_Font::StrikeOut()
{
    return strikeout;
}






void  UI_Font::_Setup ()
{
#if defined(__MS_WINDOWS__)
    long pixels_per_inch = 0;
    UI_ResourceHandle dev_ctxt;
    bool tmp = FALSE;
    if (_clientCtxt)
        dev_ctxt = _clientCtxt->Handle();
    else {
        UI_ViewHandle h = 0;
        if (_client && (h = _client->ViewHandle()) != 0)
            dev_ctxt = GetDC (h);
        else
            dev_ctxt = CreateDC ("DISPLAY", NULL, NULL, NULL);
        if (dev_ctxt <= 0)
            return;
        tmp = TRUE;
    }
    if (_handle && !_stockFont)
        DeleteObject (_handle);
    pixels_per_inch = GetDeviceCaps (dev_ctxt, LOGPIXELSY);
    lf.lfHeight =  (pixels_per_inch * ptSize)/72;
    lf.lfWidth = 0;
    lf.lfEscapement = 0;
    lf.lfOrientation = 0;
    lf.lfWeight = boldface?FW_BOLD:FW_NORMAL;
    lf.lfItalic = italic;
    lf.lfUnderline = underline;
    lf.lfStrikeOut = strikeout;
    lf.lfCharSet = ANSI_CHARSET;
    lf.lfOutPrecision = OUT_DEFAULT_PRECIS;
    lf.lfClipPrecision = CLIP_DEFAULT_PRECIS;
    lf.lfQuality = DEFAULT_QUALITY;
    lf.lfPitchAndFamily = DEFAULT_PITCH |FF_DONTCARE;
    for (short i =0; i < typeFace.Length() && i < LF_FACESIZE-1;i++)
        lf.lfFaceName[i] = typeFace[i];  
    lf.lfFaceName[i] = '\0';
    _handle = (UI_ResourceHandle) CreateFontIndirect(&lf);
    _GetFontData (dev_ctxt);
    if (tmp)
        DeleteObject (dev_ctxt);
#endif
}


#if defined (__MS_WINDOWS__)
void UI_Font::_GetFontData (HANDLE dev_ctxt)
{
    if (!dev_ctxt)
        return;
    TEXTMETRIC tm;
    HANDLE old_font = SelectObject (dev_ctxt, _handle);
    long pixels_per_inch = GetDeviceCaps (dev_ctxt, LOGPIXELSY);
    if (!pixels_per_inch)
        return;
    GetTextMetrics (dev_ctxt, &tm);
    lf.lfHeight = tm.tmHeight;
    if (!ptSize)
        ptSize = (72*(long)tm.tmHeight)/((long) pixels_per_inch);

    lf.lfWidth = tm.tmAveCharWidth;
    lf.lfWeight = tm.tmWeight;
    lf.lfItalic = tm.tmItalic;
    lf.lfUnderline = tm.tmUnderlined;
    lf.lfStrikeOut = tm.tmStruckOut;
    lf.lfCharSet = tm.tmCharSet;
    lf.lfPitchAndFamily = tm.tmPitchAndFamily;
    GetTextFace (dev_ctxt, LF_FACESIZE-1, (char *)lf.lfFaceName);
    SelectObject (dev_ctxt, old_font);
    italic = lf.lfItalic;
    underline = lf.lfUnderline;
    boldface = (lf.lfWeight == FW_BOLD);
    strikeout = lf.lfStrikeOut;
    typeFace = lf.lfFaceName;
}
#endif




