

#ifndef _editor_h_ /* Sun Oct 30 17:02:50 1994 */
#define _editor_h_


#include "base/map.h"
#include "base/objset.h"

#include "ui/ui.h"


enum GR_ShapeEnum {GR_None = 0, GR_Rectangle, GR_Ellipse, GR_Circle, GR_Line,
                   GR_PolyLine, GR_LeftArrow, GR_RightArrow,
                   GR_DoubleArrow, GR_Text};

enum GR_OperationsEnum {GOP_Move, GOP_Resize, GOP_Delete, GOP_Rotate};


typedef long ObjectId;

class GraphicEditor {

public:

    GraphicEditor ();
    
    enum GR_EditMode {Mode_Edit, Mode_Create};
    
    GR_EditMode CurrentMode ();
    // Return the current user choice.

    void SetCurrentMode (GR_EditMode e);
    
    ObjectId    Add     (GR_ShapeEnum type, const UI_Point& p);
    // Add a new object of given type, with origin at the given point, and
    // return its object id.

    bool        Remove  (ObjectId id);
    // Remove the object with given id.

    UI_GraphicObject* ObjectAt (const UI_Point& p);
    // Return the object (if any) whose boundary includes the point p.
    // Return NULL if no such object.

    CL_ObjectSet AllObjects () const;
    // Return a set of pointers to the contained graphic objects.
    
protected:
    CL_IntPtrMap  _objects;
    ObjectId      _nextId;
    GR_EditMode   _mode;
};



inline GraphicEditor::GR_EditMode GraphicEditor::CurrentMode ()
{
    return _mode;
}

inline void GraphicEditor::SetCurrentMode (GraphicEditor::GR_EditMode m)
{
    _mode = m;
}


    
#endif /* _editor_h_ */
