

#include "editor.h"

const short HIT_SIZE = 3; // When testing whether a mouse click hits an
                          // object, we use a 3x3 rectangle

GraphicEditor::GraphicEditor ()
{
    _nextId = 0;
}

ObjectId    GraphicEditor::Add     (GR_ShapeEnum type, const UI_Point& p)
{
    switch (type) {
    case GR_Rectangle:
        _objects.Add (_nextId, new UI_Rectangle (p, 0, 0));
        return _nextId++;

    case GR_Ellipse:
        _objects.Add (_nextId, new UI_Ellipse (0, 0, p));
        return _nextId++;

    case GR_Line:
        _objects.Add (_nextId, new UI_LineSegment (p, p));
        return _nextId++;

    default:
        return 0;
    }
}



bool        GraphicEditor::Remove  (ObjectId id)
{
    UI_GraphicObject* p = (UI_GraphicObject*) _objects[id];
    if (p) {
        _objects.Remove (id);
        delete p;
        return TRUE;
    }
    return FALSE;
}



UI_GraphicObject* GraphicEditor::ObjectAt (const UI_Point& p)
{
    CL_IntPtrMapIterator itr (_objects);
    UI_Rectangle r (p, HIT_SIZE, HIT_SIZE);
    for (itr.Reset(); itr.More(); ) {
        CL_IntPtrAssoc assoc = itr.Next();
        UI_GraphicObject* obj = (UI_GraphicObject*) assoc.value;
        if (obj && obj->IntersectsBoundary (r))
            return obj;
    }
    return NULL;
}


CL_ObjectSet GraphicEditor::AllObjects () const
{
    CL_IntPtrMapIterator itr (_objects);
    CL_ObjectSet s;
    for (itr.Reset(); itr.More(); ) {
        CL_IntPtrAssoc assoc = itr.Next();
        s.Add (assoc.value);
    }
    return s;
}

