

#ifndef _dwgsurf_h_ /* Thu Sep 29 11:34:19 1994 */
#define _dwgsurf_h_




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



// This is DrawingSurface, and abstract class representing a surface that
// offers the capabilities of drawing on it.

// Author: M. A. Sridhar


#include "base/object.h"

#include "ui/rectangl.h"
#include "ui/font.h"
#include "ui/pen.h"
#include "ui/brush.h"
#include "ui/simple.h"
#include "ui/colormap.h"

#if defined(__MS_WINDOWS__)
typedef  long UI_DwgSurfHandle;

#elif defined(__X_MOTIF__)
struct _XGC;
typedef struct _XGC* UI_DwgSurfHandle;

#endif


class UI_DrawingSurface: public CL_Object {

public:

    UI_DrawingSurface (UI_VisualObject *v);

    // 
    // Query:
    //     

    // Pen, Font and Brush  are resources
    // maintained by this object. These may be accessed and modified 
    // via the following reference methods.

    virtual UI_Font& Font();
    // Return (a reference to) the font used by this surface. The return
    // value can be modified by the Font methods.

    virtual UI_Pen&  Pen();
    // Return (a reference to) the pen used by this surface. The return
    // value can be modified by the Pen methods.


    virtual UI_Brush& Brush();
    // Return (a reference to) the background brush used by this surface.
    // The return value can be modified by the Brush methods.

    
    virtual UI_Rectangle DrawingArea() = 0;
    // Returns the rectangle enclosing the drawing surface.

    virtual UI_Point PenPosition() = 0;
    // Returns the current pen position.

    UI_VisualObject& Client () const;

    UI_ColorMap& ColorMap ();
    
    // 
    // Draw  operations:
    // 


    virtual void ClearDisplay();
    // Paints client surface with current background color.

    virtual void ColorDisplay (const UI_Color& c);
    // Paint client rectangle with specified color.

    virtual void ColorRectangle (const UI_Rectangle& r, const UI_Color& cs);
    // Convenience function to color the interior of the given rectangle.
    
    virtual bool InvertRectangle (const UI_Rectangle&);
    // Reverse the forground and background in the given rectangle. Return
    // TRUE on success, FALSE on failure.

    //    virtual bool FrameRectangle (const UI_Rectangle&);
    // Draw a frame around the given rectangle. Return TRUE on success,
    // FALSE on failure.
    
    virtual void DrawRectangle (const UI_Rectangle& rect, bool fill = FALSE);
    // Draw a rectangle using the current pen. If the second parameter is
    // TRUE, then fill the interior with the current brush.
                
    virtual void DrawEllipse (const UI_Rectangle& rect, bool fill = FALSE);
    // Draw an ellipse with the given bounding rectangle, using the
    // current pen. If the second parameter is 
    // TRUE, then fill the interior with the current brush. (If the
    // "rectangle" happens to be a square, then a circle is drawn.)
                
    virtual bool  MovePenTo (const UI_Point& p) = 0;
    // Move the pen to the given point. If the latter is outside the bounds
    // of the client area, no move is made.

    virtual bool DrawLineTo (const UI_Point& p) = 0;
    // Draw a line from the current position to p, using our pen.
    // PenPosition is updated to p after draw. No drawing is done if p is
    // beyond bounds. 

    // For the following drawing methods, if no starting point is
    // specified then the figure is drawn at the current pen position.

    virtual void DrawClosedFigure (UI_Point pointArray[], short numPoints,
                                   bool fill = FALSE);
    // Draw a closed figure by connecting the points in the array with
    // line segments, in the order of occurrence of the points. If the
    // last parameter is TRUE,  fill with 
    // The first point in the array is taken as the starting point.

    virtual void DrawFigure (UI_Point pointArray[], short numPoints);
    // Draw a figure by connecting the points in the array with
    // line segments, in the order of occurrence of the points. 
    // The first point in the array is taken as the starting point.

    

    

    // /**** void DrawBitMap(UI_BitMap ,UI_Point start=NULL); ****/
 
     
    // 
    // Text operations:
    // 


    virtual void WriteText (const CL_String& str);
    // Write out the text. Does not change pen position.

    virtual void WriteText (const CL_String& str, const UI_Rectangle&
                            text_rect,
                            UI_TextStyle style = UIText_Left);

    
    virtual short TextWidth (const CL_String& s) const;
    // Return the width (in pixels) of the text string s if it were drawn
    // on this DisplaySurface using its current font.

    const char* ClassName () const {return "UI_DrawingSurface";};

protected:
    UI_Pen*          _pen;       // These must be set up by the derived class.
    UI_Font*         _font;
    UI_Brush*        _brush;
    UI_ColorMap*     _colorMap;
    UI_DwgSurfHandle _handle;
    UI_VisualObject& _client;
 
public:

    UI_DwgSurfHandle Handle() const;
    // [For YACL internal use only]

};



inline void UI_DrawingSurface::ColorDisplay (const UI_Color& c)
{
    ColorRectangle (DrawingArea (), c);
}


inline UI_DwgSurfHandle UI_DrawingSurface::Handle () const
{
    return _handle;
}


inline UI_Font& UI_DrawingSurface::Font ()
{
    return *_font;
}

inline UI_Pen& UI_DrawingSurface::Pen ()
{
    return *_pen;
}

inline UI_Brush& UI_DrawingSurface::Brush ()
{
    return *_brush;
}



inline UI_VisualObject& UI_DrawingSurface::Client () const
{
    return _client;
}

inline UI_ColorMap& UI_DrawingSurface::ColorMap ()
{
    return *_colorMap;
}
 
 
#endif /* _dwgsurf_h_ */
