




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#include "ui/dwgsurf.h"

#if defined(__MS_WINDOWS__)

#include <windows.h>
static HRGN getRectRgnMS (const UI_Rectangle& r);
static HRGN getPolyRgnMS (UI_Point par[], short numpts);
// static HRGN getOvalRgnMS (const UI_Rectangle& r);
static RECT __MakeMSRect (const UI_Rectangle& r);

#endif

UI_DrawingSurface::UI_DrawingSurface (UI_VisualObject *v)
: _client (*v)
{
    _colorMap = NULL;
    _pen      = NULL;
    _font     = NULL;
    _brush    = NULL;
}



void UI_DrawingSurface::ClearDisplay ()
{
#if defined(__MS_WINDOWS__)
    HANDLE hbr = CreateSolidBrush (_client.Background().NativeForm());
    HANDLE old = SelectObject (_handle, hbr);
    RECT rect = __MakeMSRect (DrawingArea());
    FillRect (_handle, &rect, hbr);
    if (old) 
        SelectObject (_handle, old);
    DeleteObject (hbr);
    
#endif
}



void UI_DrawingSurface::ColorRectangle (const UI_Rectangle& r,
                                        const UI_Color& cs)
{
#if defined(__MS_WINDOWS__)
    HBRUSH hbr = CreateSolidBrush (cs.NativeForm ());
    HBRUSH old = SelectObject (_handle, hbr);
    HRGN   hregion = getRectRgnMS (r);
    PaintRgn(_handle, hregion);
    SelectObject (_handle, old);
    DeleteObject (hbr);
    DeleteObject (hregion);
    
#endif 
}



void UI_DrawingSurface::DrawEllipse (const UI_Rectangle& r, bool fill)
{
#if defined(__MS_WINDOWS__)
    HBRUSH hbr, old;
    if (fill) {
        old = SelectObject (_handle, _brush->Handle());
    }
    else {
        hbr   = GetStockObject (HOLLOW_BRUSH);
        old   = SelectObject (_handle, hbr);
    }
    Ellipse (_handle, r.TopLeftX (), r.TopLeftY (),
             r.BottomRightX (),      r.BottomRightY ()
            );
    SelectObject (_handle, old);
#endif 
}



void UI_DrawingSurface::DrawClosedFigure
     (UI_Point point[], short num_pts, bool fill)
{
    DrawFigure (point, num_pts);
    _pen->DrawLineTo (point[0]);
    if (fill) {
#if defined(__MS_WINDOWS__)
         HRGN h = getPolyRgnMS (point, num_pts);
         FillRgn (_handle, h, _brush->Handle());
         DeleteObject (h);
#elif defined(__X_MOTIF__)
#endif
     }
}




void UI_DrawingSurface::DrawFigure (UI_Point point[], short num_pts)
{
#if defined(__MS_WINDOWS__)
    _pen->MoveTo (point[0]);
    for (short i = 1; i < num_pts; i++)
        _pen->DrawLineTo (point[i]);
#endif
}



void UI_DrawingSurface::DrawRectangle (const UI_Rectangle& r, bool fill)
{
#if defined(__MS_WINDOWS__)
    HBRUSH hbr, old;
    if (fill) {
        old = SelectObject (_handle, _brush->Handle());
    }
    else {
        hbr   = GetStockObject (HOLLOW_BRUSH);
        old   = SelectObject (_handle, hbr);
    }
    Rectangle (_handle, r.TopLeftX (), r.TopLeftY (),
               r.BottomRightX (),      r.BottomRightY ()
              );
    SelectObject (_handle, old);
#endif
}



bool UI_DrawingSurface::InvertRectangle (const UI_Rectangle& r)
{
#if defined(__MS_WINDOWS__)
    RECT rect = __MakeMSRect (r);
    InvertRect (_handle, &rect);
    return TRUE;
    
#elif defined(__X_MOTIF__)
    NotImplemented ("InvertRectangle");
    return TRUE;
    
#endif
}


// bool UI_DrawingSurface::FrameRectangle (const UI_Rectangle& r)
// {
// #if defined(__MS_WINDOWS__)
//     RECT rect = __MakeMSRect (r);
//     HANDLE brush = CreateSolidBrush (0x0); // Black brush
//     if (brush) {
//         FrameRect (_handle, &rect, brush);
//         DeleteObject (brush);
//     }
//     return TRUE;
//     
// #elif defined(__X_MOTIF__)
//     NotImplemented ("FrameRectangle");
//     return TRUE;
//     
// #endif
// }



void UI_DrawingSurface::WriteText (const CL_String& str)
{
#if defined(__MS_WINDOWS__)
    if (_handle <= 0)
        return;
    UI_Point p = _pen->Position();
    TextOut (_handle, p.XCoord(), p.YCoord(),
             str.AsPtr(), str.Length());
    
#elif defined (__X_MOTIF__)
    NotImplemented ("WriteText");
    
#endif
}




void UI_DrawingSurface::WriteText (const CL_String& str,
                                   const UI_Rectangle& tRect,
                                   UI_TextStyle tStyle)
{
    UI_Point p = tRect.Origin();
    _pen->MoveTo (p);

#if defined(__MS_WINDOWS__)
    long style;
    TEXTMETRIC tm;
    RECT rect = __MakeMSRect (tRect);
    GetTextMetrics (_handle, &tm);
    style = (tStyle == UIText_Left) ? DT_LEFT : (tStyle == UIText_Center ?
                                                 DT_CENTER : DT_RIGHT);
    DrawText(_handle, (const char*)str, str.Length(), &rect, style);
    
#elif defined (__X_MOTIF__)
    NotImplemented ("WriteText");
    
#endif
}




short UI_DrawingSurface::TextWidth (const CL_String& s) const
{
#if defined (__MS_WINDOWS__)
    return GetTextExtent (_handle, s.AsPtr(), s.Size());
    
#elif defined (__X_MOTIF__)
    NotImplemented ("TextWidth");
    
#endif
}




#if defined(__MS_WINDOWS__)

static RECT __MakeMSRect (const UI_Rectangle& r)
{
    RECT rect;
    rect.left = r.Left ();  
    rect.top  = r.Top ();
    rect.right = r.Right(); // Should take care of the
                                        // off-by-one definition of MS Win
    rect.bottom = r.Bottom();
    return rect;
}


HRGN getRectRgnMS (const UI_Rectangle& r)
{
    int x1,y1,x2,y2;
    x1 = r.TopLeftX();
    y1 = r.TopLeftY();
    x2 = x1 + r.Width();
    y2 = y1 + r.Height(); 
    return CreateRectRgn(x1,y1,x2,y2);
}

HRGN getPolyRgnMS (UI_Point p[],short numpts)
{
    HRGN h;
    POINT  *msp;

    msp = new POINT[numpts];

    for(short i = 0; i<numpts;i++){
        msp[i].x = p[i].XCoord();
        msp[i].y = p[i].YCoord();
    }
    h = CreatePolygonRgn(msp, numpts, WINDING);
    delete msp;
    return h;

}


// HRGN getOvalRgnMS (const UI_Rectangle& r)
// {
//     return CreateEllipticRgn (r.Left(), r.Top(), r.Right(), r.Bottom());
// }

#endif    
