#ifndef _dsplsurf_h_
#define _dsplsurf_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



// Authors:   M. A. Sridhar
//            N. Bhowmik


// THIS CLASS IS NOT YET SUPPORTED UNDER X/MOTIF

// A DisplaySurface is an encapsulation of a region on the screen that
// provides drawing operations. This region must be associated with the
// window of the  'client display' - a VisualObject that is
// specified during construction. The DisplaySurface inherits its abstract
// behavior from the DrawingSurface, and overrides appropriate methods to
// provide drawing facilities on a screen.
// Each DisplaySurface object maintains default Font,
// Brush and Pen objects.  It is important that a
// display surface not be kept open for very long.




#include "ui/dwgsurf.h"

class UI_VisualObject;

class UI_DisplaySurface: public UI_DrawingSurface {


public:

    UI_Rectangle DrawingArea();
    // Returns the clients drawing surface.

    UI_Point PenPosition();
    // Returns the current pen position.


    // ------------------------ Graphic modes ----------------------
    enum GraphicsMode {
        GMode_Clear = 0,        //
        GMode_And,
        GMode_AndReverse,
        GMode_Copy,
        GMode_AndInverted,
        GMode_NoOp,
        GMode_Xor,
        GMode_Or,
        GMode_Nor,
        GMode_Equiv,
        GMode_Invert,
        GMode_OrReverse,
        GMode_CopyInverted,
        GMode_OrInverted,
        GMode_Nand,
        GMode_Set
    };

    virtual GraphicsMode Mode () const;
    // Return the current graphics mode.

    virtual void Mode (GraphicsMode mode);
    // Set the current graphics mode.
    
    // 
    // Draw  operations:
    // 


    void ClearDisplay();
    // Paints client surface with current background color.


    void ColorRectangle (const UI_Rectangle& r, const UI_Color& cs);

    
    bool InvertRectangle (const UI_Rectangle&);
    // Reverse the forground and background in the given rectangle. Return
    // TRUE on success, FALSE on failure.

    //    bool FrameRectangle (const UI_Rectangle&);
    // Draw a frame around the given rectangle. Return TRUE on success,
    // FALSE on failure.
    
    void DrawRectangle (const UI_Rectangle& rect, bool fill = FALSE);
    // Draw a rectangle using the current pen. If the second parameter is
    // TRUE, then fill the interior with the current brush.
                
    void DrawEllipse (const UI_Rectangle& rect, bool fill = FALSE);
    // Draw an ellipse with the given bounding rectangle, using the
    // current pen. If the second parameter is 
    // TRUE, then fill the interior with the current brush. (If the
    // "rectangle" happens to be a square, then a circle is drawn.)
                
    bool  MovePenTo (const UI_Point& p);
    // Move the pen to the given point. If the latter is outside the bounds
    // of the client area, no move is made.

    bool DrawLineTo (const UI_Point& p);
    // Draw a line from the current position to p, using our pen.
    // PenPosition is updated to p after draw. No drawing is done if p is
    // beyond bounds. 

    // For the following drawing methods, if no starting point is
    // specified then the figure is drawn at the current pen position.


    void DrawClosedFigure (UI_Point pointArray[], short numPoints,
                           bool fill = FALSE);
    // Draw a closed figure by connecting the points in the array with
    // line segments, in the order of occurrence of the points. If the
    // last parameter is TRUE,  fill with 
    // The first point in the array is taken as the starting point.


    void DrawFigure (UI_Point* pointarray, short numPoints);
    // Draw a figure by connecting the points in the array with
    // line segments, in the order of occurrence of the points. 
    // The first point in the array is taken as the starting point.

    

    // /**** void DrawBitMap(UI_BitMap ,UI_Point start=NULL); ****/
 
     
    // 
    // Text operations:
    // 

    void WriteText (const CL_String& str);
    // Write out the text. Does not change pen position.

    void WriteText (const CL_String& str, const UI_Rectangle& text_rect,
                    UI_TextStyle style = UIText_Left);

    
    virtual short TextWidth (const CL_String& s) const;
    // Return the width (in pixels) of the text string s if it were drawn
    // on this DisplaySurface using its current font.

protected:

    UI_DisplaySurface  (UI_VisualObject* o);

    ~UI_DisplaySurface ();

    void _Init ();

    void SetFont (UI_Font*);
    // SetFont: called only by UI_VisualObject and no one else!
    
    friend class UI_VisualObject;


    

protected:
    
    bool             _ownFont;


private:
    bool _FontWillChange (CL_Object&, long);

    bool _FontChanged    (CL_Object&, long);

};




inline bool  UI_DisplaySurface::MovePenTo (const UI_Point& p)
{
    return _pen->MoveTo (p);
}


inline bool UI_DisplaySurface::DrawLineTo (const UI_Point& p)
{
    return _pen->DrawLineTo (p);
}



#endif

