




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */





#include "ui/dsplsurf.h"
#include "ui/visualob.h"
#include "ui/color.h"

#if defined(__MS_WINDOWS__)
#include <windows.h>
static int __drawMode [] = {
    R2_BLACK,          //  GMode_Clear = 0
    R2_MASKPEN,        //  GMode_And
    R2_MASKNOTPEN,     //  GMode_AndReverse
    R2_COPYPEN,        //  GMode_Copy
    R2_MASKPENNOT,     //  GMode_AndInverted
    R2_NOP,            //  GMode_NoOp
    R2_XORPEN,         //  GMode_Xor
    R2_MERGEPEN,       //  GMode_Or
    R2_NOTMERGEPEN,    //  GMode_Nor
    R2_NOTXORPEN,      //  GMode_Equiv
    R2_NOT,            //  GMode_Invert
    R2_MERGENOTPEN,    //  GMode_OrReverse
    R2_NOTCOPYPEN,     //  GMode_CopyInverted
    R2_MERGEPENNOT,    //  GMode_OrInverted
    R2_NOTMASKPEN,     //  GMode_Nand
    R2_WHITE           //  GMode_Set
};

#elif defined(__X_MOTIF__)

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>

static int __drawMode [] = {
    GXclear,                // 0 
    GXand,                  // src AND dst
    GXandReverse,           // src AND NOT dst
    GXcopy,                 // src 
    GXandInverted,          // NOT src AND dst 
    GXnoop,                 // dst
    GXxor,                  // src XOR dst
    GXor,                   // src OR dst
    GXnor,                  // NOT src AND NOT dst
    GXequiv,                // NOT src XOR dst
    GXinvert,               // NOT dst
    GXorReverse,            // src OR NOT dst
    GXcopyInverted,         // NOT src
    GXorInverted,           // NOT src OR dst
    GXnand,                 // NOT src OR NOT dst
    GXset                   // 1
}; 

#endif


#if defined(__GNUC__) && __GNUC_MINOR__ >= 6
template class CL_Binding<UI_DisplaySurface>;
#endif




UI_DisplaySurface::UI_DisplaySurface (UI_VisualObject* v):
                   UI_DrawingSurface (v)
{
    _Init ();
    _ownFont = FALSE;
}


void UI_DisplaySurface::_Init ()
{
    _font = NULL;

#if defined(__MS_WINDOWS__)
    _handle = GetDC (_client.ViewHandle ());

#elif defined(__X_MOTIF__)
    XGCValues xvalues;
    Display   *dpy   = XtDisplay (_client); 

    _handle = XCreateGC (dpy, XtWindow (_client), 0, &xvalues);

#endif

    _brush  = new UI_Brush (this, UIColor_White, UIBrush_Solid);
    _pen    = new UI_Pen   (this);
    //    _colorMap = new UI_ColorMap (*this);
}



typedef CL_Binding<UI_DisplaySurface> DSBind;

void UI_DisplaySurface::SetFont (UI_Font* fnt)
{
    if (fnt && fnt != _font) {
        DSBind pre  (this, &UI_DisplaySurface::_FontWillChange);
        fnt->AddPreChangeDependent (pre, 1);
        DSBind post (this, &UI_DisplaySurface::_FontChanged);
        fnt->AddDependent (post, 1);
        if (_font) {
            _font->RemoveDependent (post);
            _font->RemovePreChangeDependent (pre);
        }
        _font = fnt;

#if defined (__MS_WINDOWS__)
        SelectObject (_handle, _font->Handle());
#endif
    }
        // XSetFont(dpy,_handle,_font->Handle());
}



bool UI_DisplaySurface::_FontWillChange (CL_Object&, long)
{
#if defined (__MS_WINDOWS__)
    SelectObject (_handle, GetStockObject (SYSTEM_FONT));

#elif defined (__X_MOTIF__)

#endif
    return TRUE;
}


bool UI_DisplaySurface::_FontChanged (CL_Object& o, long)
{
#if defined (__MS_WINDOWS__)
    SelectObject (_handle, ((UI_Font&) o).Handle ());

#elif defined (__X_MOTIF__)

#endif

    return TRUE;
}





UI_DisplaySurface::~UI_DisplaySurface()
{
    if (_pen)
        delete _pen;
    if (_font && _ownFont)
        delete _font;
    if (_brush)
        delete _brush;
    if (_colorMap)
        delete _colorMap;
#if defined(__MS_WINDOWS__)
    ReleaseDC (_client.ViewHandle (), _handle);

#elif defined(__X_MOTIF__)
    XFreeGC (XtDisplay (_client), _handle);

#endif
}




UI_Rectangle UI_DisplaySurface::DrawingArea ()
{
	UI_Rectangle r (_client.ClientArea ());
	long w = r.Width  ();
	long h = r.Height ();
	return UI_Rectangle (0, 0, w, h);
}



UI_Point UI_DisplaySurface::PenPosition ()
{
    return _pen->Position ();
}



UI_DisplaySurface::GraphicsMode UI_DisplaySurface::Mode () const
{
#if defined(__MS_WINDOWS__)
    int mode = GetROP2 (_handle);

#elif defined(__X_MOTIF__)
   XGCValues xvalues;

   XGetGCValues (XtDisplay (_client), _handle, GCFunction, &xvalues);
   int mode = xvalues.function;

#endif
    for (short i = 0; i < sizeof (__drawMode)/sizeof (int); i++) {
        if (mode == __drawMode [i])
            return (GraphicsMode) i;
    }
    // Something wrong: it's not in the table!
    return (GraphicsMode) 0;
}



void UI_DisplaySurface::Mode (GraphicsMode mode)
{
#if defined(__MS_WINDOWS__)
    SetROP2 (_handle, __drawMode [mode]);

#elif defined (__X_MOTIF__)
    XGCValues xvalues;

    xvalues.function   = __drawMode [mode];
    XChangeGC (XtDisplay (_client), _handle, GCFunction, &xvalues);
     
#endif
}




void UI_DisplaySurface::ClearDisplay ()
{
#if defined(__MS_WINDOWS__)
    UI_DrawingSurface::ClearDisplay();

#elif defined(__X_MOTIF__)
    UI_BrushPattern old = _brush->Pattern ();

    _brush->Pattern (UIBrush_Solid);
    ColorRectangle    (_client.ClientArea(), _client.Background ());
    _brush->Pattern (old);

#endif

}



void UI_DisplaySurface::ColorRectangle (const UI_Rectangle& r,
                                        const UI_Color& cs)
{
#if defined(__MS_WINDOWS__)
    UI_DrawingSurface::ColorRectangle (r, cs);

#elif defined(__X_MOTIF__)
    Display *dpy = XtDisplay (_client);
    
    _client.Foreground ((UI_Color &) cs);
    XFillRectangle (dpy, XtWindow (_client), _handle,
                    r.Origin ().XCoord (), r.Origin ().YCoord (),
                    r.Width (), r.Height ());

#endif 
}



void UI_DisplaySurface::DrawEllipse (const UI_Rectangle& r, bool fill)
{
#if defined(__MS_WINDOWS__)
    UI_DrawingSurface::DrawEllipse (r, fill);

#elif defined(__X_MOTIF__)
    Display *dpy = XtDisplay (_client);

    XDrawArc (dpy, XtWindow (_client), _handle,
              r.Origin().XCoord (), r.Origin().YCoord (), r.Width (),
              r.Height (), 0, 64*360);

    if (fill)
        XFillArc (dpy, XtWindow (_client), _handle,  r.Origin ().XCoord (),
                  r.Origin ().YCoord (), r.Width (), r.Height (), 0, 64*360);

#endif
}



void UI_DisplaySurface::DrawClosedFigure
    (UI_Point parr[], short numpts, bool fill)
{
#if defined(__MS_WINDOWS__)
    UI_DrawingSurface::DrawClosedFigure (parr, numpts, fill);

#elif defined(__X_MOTIF__)
    Display *dpy = XtDisplay (_client);
    DrawFigure (parr, numpts);
    _pen->DrawLineTo (parr [0]);
    if (fill) {
        XPoint* xp = new XPoint [numpts];
        for (long i = 0; i < numpts; i++) {
            xp [i].x = parr [i].XCoord ();
            xp [i].y = parr [i].YCoord ();
	}
        XFillPolygon (dpy, XtWindow (_client), _handle, xp, numpts,
                      Complex, CoordModeOrigin);
        delete [] xp;
    }
#endif
}



void UI_DisplaySurface::DrawFigure (UI_Point parr[], short numpts)
{
#if defined(__MS_WINDOWS__)
    UI_DrawingSurface::DrawFigure (parr, numpts);

#elif defined(__X_MOTIF__)
    Display *dpy = XtDisplay (_client);
    _pen->MoveTo (parr [0]);
    for (long i = 1; i < numpts; i++) {
        _pen->DrawLineTo (parr [i]);
        _pen->MoveTo (parr [i]);
    }
#endif
}




void UI_DisplaySurface::DrawRectangle (const UI_Rectangle& r, bool fill)
{
#if defined(__MS_WINDOWS__)
    UI_DrawingSurface::DrawRectangle (r, fill);

#elif defined(__X_MOTIF__)
    UI_Point p[4], o;

    o = r.Origin ();
    UI_Point p1 (o.XCoord (), o.YCoord ());
    UI_Point p2 (o.XCoord (), o.YCoord () + r.Height ());
    UI_Point p3 (o.XCoord () + r.Width (), o.YCoord () + r.Height ());
    UI_Point p4 (o.XCoord () + r.Width (), o.YCoord ());
  
    p[0] = p1;
    p[1] = p2;
    p[2] = p3;
    p[3] = p4; 
    DrawClosedFigure (p, 4);

#endif
}



bool UI_DisplaySurface::InvertRectangle (const UI_Rectangle& r)
{
#if defined(__MS_WINDOWS__)
    return UI_DrawingSurface::InvertRectangle (r);

#elif defined(__X_MOTIF__)
    NotImplemented ("InvertRectangle");
    return TRUE;

#endif
    
}


// bool UI_DisplaySurface::FrameRectangle (const UI_Rectangle& r)
// {
// #if defined(__MS_WINDOWS__)
//     return UI_DrawingSurface::FrameRectangle (r);
// 
// #elif defined(__X_MOTIF__)
//     NotImplemented ("FrameRectangle");
//     return TRUE;
// 
// #endif
// }



void UI_DisplaySurface::WriteText (const CL_String& str)
{
#if defined(__MS_WINDOWS__)
    UI_DrawingSurface::WriteText (str);

#elif defined(__X_MOTIF__)
    NotImplemented ("WriteText");

#endif
}




void UI_DisplaySurface::WriteText (const CL_String& str,
                                   const UI_Rectangle& tRect,
                                   UI_TextStyle tStyle)
{
    UI_Point p = tRect.Origin();
    _pen->MoveTo (p);

#if defined (__MS_WINDOWS__)
    UI_DrawingSurface::WriteText (str, tRect, tStyle);

#elif defined(__X_MOTIF__)    
    Display* dpy = XtDisplay (_client);

    XDrawString (dpy, XtWindow (_client), _handle, p.XCoord (),
                 p.YCoord (), (const char*) str, str.Length ());

#endif

}



short UI_DisplaySurface::TextWidth (const CL_String& s) const
{

#if defined(__MS_WINDOWS__)
    return UI_DrawingSurface::TextWidth (s);

#elif defined (__X_MOTIF__)
    NotImplemented ("TextWidth");
    return 0;

#endif
}
