#include "base/date.h"
#include "base/defs.h"
#include "base/string.h"

#include <stdio.h>
#include <stdlib.h>


main ()
{
    int year, month, day;
    CL_Date d1;
    CL_String string;

    d1 = "MARCH 13,1993";
    printf ("Date is %s\n", d1.AsString().AsPtr());
    d1 = "12-MaR-92";
    printf ("Date is %s\n", d1.AsString().AsPtr());
    d1 = "12/17/92";
    printf ("Date is %s\n", d1.AsString().AsPtr());
    // exit (0);

    
    printf("*****************Print Options ***********\n");
    printf("Date d1 : %s \n", (const char*) d1.PrintString(Date_American));

    CL_Date aDate (1901, 12, 31);
    printf ("12/31/1901: %s\n", (const char*)
            aDate.PrintString (Date_American));
    CL_Date aDate2 (1901, 12, 30);
    printf ("12/30/1901: %s\n", (const char*)
            aDate2.PrintString (Date_American));
    CL_Date aDate3 (1999, 4, 27);
    printf ("2/29/1901: %s\n", (const char*) (CL_Date(1901, 3, 29)).PrintString
            (Date_European) );
    printf ("2/29/1904: %s\n", (const char*) (CL_Date(1904, 2, 29)).PrintString
            (Date_European) );
    printf ("2/29/1908: %s\n", (const char*) (CL_Date(1908, 2, 29)).PrintString
            (Date_European) );
    printf ("2/29/1912: %s\n", (const char*) (CL_Date(1912, 2, 29)).PrintString
            (Date_European) );

    CL_Date d4(1992, 1, 1);
    printf ("1/1/1992: %s\n", (const char*) d4.PrintString (Date_American));
    CL_Date d5(1999, 4, 25);    CL_Date d2(1904, 2, 29);
    string = d2.PrintString(Date_Terse);
    printf("Date d2 : %s \n", (const char*) string);
    CL_Date d3 = d2;
    string = d3.PrintString(Date_Numbers);
    printf("Date d3 : %s \n", (const char*) string);
    CL_Date d6, d7;
    CL_Date d8(1901, "January", 2);
    CL_Date d9(1992, 12, 29);
    string = d9.PrintString();
    printf("Date d9 : %s \n", (const char*) string);

    CL_Date d10, d11;


    string = d4.PrintString(Date_European);
    printf("Date d4 : %s \n", (const char*) string);
    string = d5.PrintString(Date_American);
    printf("Date d5 : %s \n", (const char*) string);
    string = d6.PrintString();
    printf("Date d6 : %s \n", (const char*) string);
    string = d7.PrintString();
    printf("Date d7 : %s \n", (const char*) string);
    string = d8.PrintString();
    printf("Date d8 : %s \n", (const char*) string);
    
    printf("\n ***********COMPARISION   OPERATIONS***********\n");
    if (d1 > d2) printf("d1 > d2\n");
    if (d1 == d2) printf("d1 == d2\n");
    if (d3 == d2) printf("d3 == d2\n");
    if (d1 < d2) printf("d1 < d2\n");
    if (d2 < d1 ) printf("d2 < d1\n");
    if (d1 != d2) printf("d1 != d2\n");
    if (d3 >= d2) printf("d3 >= d2\n");
    if (d3 <= d2) printf("d3 <= d2\n");


    printf("\n ***********ASSIGNMENT    OPERATIONS***********\n");
    d7 = d2;
    printf("----------------------------------------\n");
    printf("AFTER DOING d7 = d2\n");
    string = d7.PrintString();
    printf("Date d7 : %s \n", (const char*) string);
    printf("----------------------------------------\n");
    string = d2.PrintString();
    printf("Date d2 : %s \n", (const char*) string);

    CL_Date d12(1992, 12, 31);
    CL_Date d13(1992, 1,  1);
    printf("\n ***********CONCATENATION OPERATIONS***********\n");
    string = d12.PrintString();
    printf("\nDate d12 : %s \n", (const char*) string);
    string = d13.PrintString();
    printf("\nDate d13 : %s \n\n", (const char*) string);

    d12 = d12 + 5;
    printf("-----------d12 = d12 + 5------------------\n");
    string = d12.PrintString();
    printf("Date d12 : %s \n", (const char*) string);

    d13 = d13 - 5;
    printf("-----------d13 = d13 - 5------------------\n");
    string = d13.PrintString();
    printf("Date d13 : %s \n", (const char*) string);

    d1 += 14;
    printf("-----------d1 += 14 ---------------------\n");
    string = d1.PrintString();
    printf("Date d1 : %s \n", (const char*) string);
    d1 -= 14;
    printf("-----------d1 -= 14 ---------------------\n");
    string = d1.PrintString();
    printf("Date d1 : %s \n", (const char*) string);
    

    printf("-----------d9 - d4 ---------------------\n");
    printf("Difference Days : %ld \n", (d9 - d4));


    printf("-----------d4 - d9 ---------------------\n");
    printf("Difference Days : %ld \n", (d4 - d9));

    printf("-----------d4 - d4 ---------------------\n");
    printf("Difference Days : %ld \n", (d4 - d4));

    if (d8.IsLeapYear()) printf("%d is a leap Year\n",d8.Year());
    else printf("%d is not a leap Year\n",d8.Year());
    if (d9.IsLeapYear()) printf("%d is a leap Year\n",d9.Year());
    else printf("%d is not a leap Year\n",d8.Year());

    printf("d9 Year is %d\n", d9.Year());
    printf("d9 Month is %d\n", d9.Month());
    printf("d9 Day is %d\n",d9.Day());
    printf("d9 Month name is %s\n", (const char*)(d9.MonthName(d9.Month())));
    printf("d9 Day name is %s\n", (const char*)(d9.DayName(d9.DayOfWeek())));

    printf("\n ***********Next and Previous OPERATIONS***********\n");
    d10 = d9.PreviousWeekday( CL_String("Monday"));
    printf("Previous Monday From d9: \n");
    printf("\td10 Year is %d\n", d10.Year());
    printf("\td10 Month is %d\n", d10.Month());
    printf("\td10 Day is %d\n",d10.Day());
    printf("\td10 Month name is %s\n",(const char*)(d10.MonthName(d10.Month())));
    printf("\td10 Day name is %s\n",(const char*)(d10.DayName(d10.DayOfWeek())));

    d11 = d9.NextWeekday( CL_String("Monday"));
    printf("\nNext Monday From d9: \n");
    printf("\td11 Year is %d\n", d11.Year());
    printf("\td11 Month is %d\n", d11.Month());
    printf("\td11 Day is %d\n",d11.Day());
    printf("\td11 Month name is %s\n",(const char*)(d11.MonthName(d11.Month())));
    printf("\td11 Day name is %s\n",(const char*)(d11.DayName(d11.DayOfWeek())));

    
    printf("\n ***********Next and Previous OPERATIONS***********\n");
    printf("\n ***********Note the  Year ************************\n");
    printf("d5 Year is %d\n", d5.Year());
    printf("d5 Month is %d\n", d5.Month());
    printf("d5 Day is %d\n",d5.Day());
    printf("d5 Month name is %s\n", (const char*)(d5.MonthName(d5.Month())));
    printf("d5 Day name is %s\n", (const char*)(d5.DayName(d5.DayOfWeek())));

    d10 = d5.PreviousWeekday( CL_String("Monday"));
    printf("Previous Monday From d5: \n");
    printf("\td10 Year is %d\n", d10.Year());
    printf("\td10 Month is %d\n", d10.Month());
    printf("\td10 Day is %d\n",d10.Day());
    printf("\td10 Month name is %s\n",(const char*)(d10.MonthName(d10.Month())));
    printf("\td10 Day name is %s\n",(const char*)(d10.DayName(d10.DayOfWeek())));

    d11 = d5.NextWeekday( CL_String("Monday"));
    printf("\nNext Monday From d5: \n");
    printf("\td11 Year is %d\n", d11.Year());
    printf("\td11 Month is %d\n", d11.Month());
    printf("\td11 Day is %d\n",d11.Day());
    printf("\td11 Month name is %s\n",(const char*)(d11.MonthName(d11.Month())));
    printf("\td11 Day name is %s\n",(const char*)(d11.DayName(d11.DayOfWeek())));
    
printf("\n\nENTER DATE INPUT: ONLY +/- NUMBERS AND NOT CHARACTERS\n");
printf("ENTER INVALID NUMERICAL DATE TO QUIT\n");
while (1)
    {
    printf("Enter year, month, day: ");
    if (scanf("%d %d %d",&year, &month, &day) != 3)
        {
        printf("\nInvalid Input\n");
        exit(0);
        }
    CL_Date d5(year, month, day);  
    string = d5.PrintString(Date_American);
    printf("Date d5 : %s \n", (const char*) string);
    printf("d5 Month name is %s\n", (const char*)(d5.MonthName(d5.Month())));
    printf("d5 Day name is %s\n", (const char*)(d5.DayName(d5.DayOfWeek())));
    }

    
}
