




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#include "ui/composit.h"
#include "ui/cntroler.h"
#include "ui/pushbtn.h"
#include "ui/toglbtn.h"
#include "ui/xrtglbtn.h"
#include "ui/stred.h"
#include "ui/dialog.h"

#include "ui/label.h"
#include "ui/btngroup.h"
#include "ui/strview.h"
#include "ui/scrolbar.h"
#include "ui/menu.h"


extern FAR char _YACLWindowClassName[];

#if defined(__MS_WINDOWS__)

BOOL CALLBACK _export EnumCallback (HWND hwnd, LPARAM param);


#elif defined(__X_MOTIF__)
#include <Xm/BulletinB.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#include <Xm/Protocols.h>
#include <Xm/AtomMgr.h>
#include <Xm/MwmUtil.h>
#endif




// ---------------------- UI_CompositeVObject code --------------------

UI_CompositeVObject :: UI_CompositeVObject 
     ( UI_CompositeVObject* parent, UI_ViewDescriptor* vd, bool sticky,
       const UI_Rectangle& shape, long id, long st 
     )
: UI_VisualObject(parent, id, shape, st)
{
    _menuBar       = NULL;
    _stickToParent = sticky;
    _currentChild  = -1;
    _model         = new CL_IntPtrMap;
    
#if defined(__MS_WINDOWS__)
    _currentGroup = NULL;
    if (parent == NULL) {
        // Set the style of the root window
        if (st == -1)
            _style = WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN | WS_VISIBLE |
                WS_CAPTION;
    }
    else {
        // Non-root window
        if (st == -1)
            _style = sticky ? (WS_CHILD | WS_BORDER | WS_VISIBLE)
                : (WS_OVERLAPPEDWINDOW | WS_VISIBLE | WS_CLIPCHILDREN);
    }
    _titleBarShown = _style & WS_CAPTION;
#endif

    if (vd) {
        for (short i = 0; vd[i].type != View_None; i++) {
            if ( !CreateChild (vd[i]) )
                break;
        }
    }
}



UI_CompositeVObject::UI_CompositeVObject
  (UI_CompositeVObject* parent, const char *rsrc, UI_ViewID id)
: UI_VisualObject (parent, id)
{
    _menuBar       = NULL;
    _stickToParent = FALSE;
    _currentChild  = -1;
    _model         = new CL_IntPtrMap;

#if defined(__MS_WINDOWS__)
    _currentGroup = NULL;
    _rname = rsrc;
#endif

}


CL_Object* UI_CompositeVObject::Model ()
{
    // Update all the models. This is needed so that the component objects
    // can update their model values from the underlying window system.
    CL_IntPtrMap& model_map = *(CL_IntPtrMap*) _model;
    CL_IntPtrMapIterator itr (_objMap);
    CL_IntPtrAssoc assoc;
    for (itr.Reset(); itr.More(); ) {
        assoc = itr.Next ();
        if (!model_map.IncludesKey (assoc.key)) {
            // Something wrong: howl
            CL_Error::Warning ("UI_CompositeVObject::Model: internal "
                               "error: id %ld not in map", assoc.key);
        }
        else
            model_map[assoc.key] = ((UI_VisualObject*) _objMap[assoc.key])
                ->Model();
    }
    return _model;
}



bool UI_CompositeVObject::MakeVisualElement ()
{

#ifdef __MS_WINDOWS__
    long x,y,w,h;

    x = _shape.Origin().XCoord();
    y = _shape.Origin().YCoord();
    w = _shape.Width();
    h = _shape.Height();
    // Create a generic window
    HANDLE hInst = _Application->ProcessId();
    if( _rname.Length() ) {
        if ( _parent !=NULL )
            _handle = CreateDialogParam
                (hInst, (const char*) _rname, _parent->_handle,
                 (FARPROC) YACLDialogProc, 0L);
        else
            _handle = CreateDialogParam
                (hInst, _rname.AsPtr(), NULL, (FARPROC) YACLDialogProc, 0L);
        _style = GetWindowLong (_handle, GWL_STYLE);
        _visible = (_style & WS_VISIBLE) ? TRUE : FALSE;
    }
    else {
        if (_parent != NULL &&  _stickToParent)
            _style |= WS_CHILD;
        char* class_name = MSWindowsName();
        RECT rect;
        rect.left    = x;
        rect.top     = y;
        rect.right   = x + w;
        rect.bottom  = y + h;
        AdjustWindowRect (&rect, _style, FALSE);
        if (!_visible)
            _style &= ~WS_VISIBLE;
        _handle = CreateWindow
            (class_name, _title.AsPtr(), _style,
             rect.left, rect.top, rect.right-rect.left, rect.bottom-rect.top,
             (HANDLE) (_parent ? _parent->_handle : NULL), NULL,
             (HANDLE) hInst, NULL);
    }
    if (!_handle) {
        CL_Error::Warning ("Window creation failed: id %ld class %s",
                           ViewID(), ClassName());
        return FALSE;
    }

#elif defined(__X_MOTIF__)
    CL_String xname (InstanceName ());
    Arg args [9];
    short argn = 0;
    _SetupStyle (args, argn);

    struct _WidgetClassRec  *wname = XName ();
    if ( wname == NULL )
        wname = xmBulletinBoardWidgetClass;
    if (!_parent && !_shell)
        CL_Error::Fatal ("Root Window Not Created");

    Widget real_parent = _parent && _stickToParent
        ? _parent->_xwidget : _shell;
    if (!_parent || _stickToParent)
        _popup  = NULL;
    if (!_parent) { // Creating the root window
        _xwidget = XtCreateManagedWidget
            ((const char*) xname, wname, real_parent, args, argn);
        if (! XtIsRealized (_shell) )
            XtRealizeWidget (_shell);
    }
    else if (_stickToParent) { // Creating a non-root sticky child
        _xwidget = XtCreateWidget
            ((const char*) xname, wname, real_parent, args, argn);
    }
    else {
        XtSetArg (args [argn], XmNtitle, (char*) _title.AsPtr()); argn++;
        // Set the title of the shell widget
        XtSetArg (args [argn], XmNdeleteResponse, XmDO_NOTHING); argn++;
        // Do not destroy the shell widget in response to user
        // requests; the library will take care of it.
        
        _popup = XtCreatePopupShell ((const char*) xname,
                                     vendorShellWidgetClass,
                                     _parent->_xwidget,
                                     args, argn);
        _xwidget = XtCreateManagedWidget
            ("Child", wname, _popup, args, 2);
        XtPopup (_popup, XtGrabNone);
    };

#endif
    return TRUE;
}


bool UI_CompositeVObject::DestroyVisualElement ()
{
    DestroyDisplaySurface ();

#if defined (__MS_WINDOWS__)
    if (_handle > 0) {
        DestroyWindow (_handle);
        return TRUE;
    }
    return FALSE;

#elif defined(__X_MOTIF__)
    if( _xwidget !=NULL )
        XtDestroyWidget (_xwidget);
    if (_popup)
        XtPopdown (_popup);
#endif

}

    


UI_VisualObject* UI_CompositeVObject::CreateChild (const UI_ViewDescriptor& vd)
{
    if (_objMap.IncludesKey (vd.id) ) {
        CL_Error::Warning ("YACL: Duplicate child id %ld for composite",
                           vd.id);
        return NULL;
    }
    UI_VisualObject* p;
    UI_Rectangle shape (vd.shape.x, vd.shape.y, vd.shape.w,
                        vd.shape.h);
    switch (vd.type) {

    case View_ButtonGroup:
        p = new UI_ButtonGroup (this, shape, vd.enclosed, vd.id);
        p->Title () = vd.msg;
        if (vd.enclosed) {
            for (short i = 0; vd.enclosed [i].type != View_None; i++) 
                ((UI_ButtonGroup*) p)->Add (vd.enclosed[i].id);
        }
        break;

    case View_PushButton: {
        p = new UI_PushButton (this, shape, vd.id);    
        p->Title()= vd.msg;
        break;
        }

    case View_ToggleButton: {
        p = new UI_ToggleButton (this, shape, vd.id);  
        p->Title() = vd.msg;
        break; 
        }

    case View_ExOrToggleButton: {
        p = new UI_ExOrToggleButton (this, shape, vd.id);  
        p->Title() = vd.msg;
        break; 
        }
      
    case View_Label: {
        p = new UI_Label (this, shape, vd.id);
        *(CL_String*) (((UI_Label*) p)->Model ()) = vd.msg;
        break;
        }
    case View_StringEditor: {
        p = new UI_StringEditor (this, shape, vd.id);
        *(CL_String*) (((UI_SimpleVObject*) p)->Model ()) = vd.msg;
        break;
        }

    case View_TextView:
        break;

    case View_StringView: {
        p = new UI_StringView (this, shape, FALSE, vd.id);
        break;
        }
    
    case View_HScrollBar: {
        p = new UI_HScrollBar (this, shape, vd.id);
        break;
        }
    
    case View_VScrollBar: {
        p = new UI_VScrollBar (this, shape, vd.id);
        break;
        }

    case View_MultiSelectStringView: {
        p = new UI_StringView (this, shape, TRUE, vd.id);
        break;
        }

    case View_Composite: {
        p = new UI_CompositeVObject (this, vd.enclosed, TRUE, shape,
                                     vd.id);
        break;
        }

    default:
        p = NULL;
        break;
    } // end of switch

//     if (p && !vd.initially_visible)
//         p->MakeInvisible();
    if ( p && vd.type != View_Composite ) {
        UI_ViewID id = p->ViewID();

        if (id > 0 && id <= 32767) {
            _objMap.Add (id, p);
            ((CL_IntPtrMap*) _model)->Add (id, p->Model());
            if (vd.type != View_ButtonGroup)
                ((UI_SimpleVObject*) p)->TabStop (vd.tab_stop);
            if (vd.tab_stop)
                _tabSequence.Add (vd.id);
        }
    }
    return p;
}




UI_CompositeVObject::~UI_CompositeVObject()
{
}



void UI_CompositeVObject::MakeVisible ()
{
    UI_VisualObject::MakeVisible();
    if (!ViewHandle())
        return;
    UI_CompositeIterator itr (*this);
    itr.Reset();
    do {
        UI_VisualObject* v = itr.Next();
    if (!v) break;
        v->MakeVisible();
    } while (1);
}


void UI_CompositeVObject::MakeInvisible ()
{
    if (!ViewHandle()) {
        UI_VisualObject::MakeInvisible();
        return;
    }
    UI_CompositeIterator itr (*this);
    itr.Reset();
    do {
        UI_VisualObject* v = itr.Next();
    if (!v) break;
        v->MakeInvisible();
    } while (1);
    UI_VisualObject::MakeInvisible();
}


bool UI_CompositeVObject::Enable ()
{
    UI_VisualObject::Enable();
    UI_CompositeIterator itr (*this);
    itr.Reset();
    do {
        UI_VisualObject* v = itr.Next();
    if (!v) break;
        v->Enable();
    } while (1);
    return TRUE; // ??
}


bool UI_CompositeVObject::Disable ()
{
    UI_CompositeIterator itr (*this);
    itr.Reset();
    do {
        UI_VisualObject* v = itr.Next();
    if (!v) break;
        v->Disable();
    } while (1);
    return UI_VisualObject::Disable();
}




void UI_CompositeVObject::ShowTitleBar ()
{
#if defined(__MS_WINDOWS__)
    if (!_stickToParent) {
        long l = GetWindowLong (_handle, GWL_STYLE);
        SetWindowLong (_handle, GWL_STYLE, l | WS_CAPTION);
        SetWindowPos  (_handle, NULL, 0, 0, 0, 0, SWP_FRAMECHANGED | 
                       SWP_NOSIZE | SWP_NOMOVE | 
                       SWP_NOACTIVATE | SWP_NOZORDER); // Force re-draw
        _titleBarShown = TRUE;
    }
#elif defined(__X_MOTIF__)
    if (!_stickToParent) {
        Arg arg[1];
        XtSetArg (arg[0], XtNtransient, FALSE);
        XtSetValues (XtParent (_xwidget), arg, 1);
    }
#endif
}


void UI_CompositeVObject::HideTitleBar ()
{
#if defined(__MS_WINDOWS__)
    if (!_stickToParent) {
        long l = GetWindowLong (_handle, GWL_STYLE);
        SetWindowLong (_handle, GWL_STYLE, l & ~WS_CAPTION);
        SetWindowPos  (_handle, NULL, 0, 0, 0, 0, SWP_FRAMECHANGED | 
                       SWP_NOSIZE | SWP_NOMOVE | 
                       SWP_NOACTIVATE | SWP_NOZORDER); // Force re-draw
        _titleBarShown = FALSE;
    }
#elif defined(__X_MOTIF__)
    if (!_stickToParent) {
        Arg arg[1];
        XtSetArg (arg[0], XtNtransient, FALSE);
        XtSetValues (XtParent (_xwidget), arg, 1);
    }
#endif
}


bool UI_CompositeVObject::IsTitleBarShown ()
{
    return !_stickToParent && _titleBarShown;
}








void UI_CompositeVObject::Initialize()
{
    UI_VisualObject::Initialize ();

#if defined(__MS_WINDOWS__)
    if ( _menuBar && _menuBar->ViewHandle() > 0 )
        DrawMenuBar ( _menuBar->ViewHandle() );
    if(_rname.Size() > 0  && _handle)
        EnumChildWindows (_handle, (FARPROC) EnumCallback, (long) this);

#elif defined(__X_MOTIF__)

    Arg args [2];
    XmString xmtitle;

    xmtitle = XmStringCreate ((char*)_title.AsPtr(), XmSTRING_DEFAULT_CHARSET);

    XtSetArg    (args [0], XmNdialogTitle, xmtitle);
    XtSetArg    (args [1], XmNlabelString, xmtitle);
    XtSetValues (_xwidget, args, 2);

    XmStringFree (xmtitle); // No leaks allowed
    if (!_parent || !_stickToParent) {
        Atom a = XmInternAtom (XtDisplay(_shell), "WM_DELETE_WINDOW",
                               FALSE);
        XmAddWMProtocolCallback
            (XtParent (_xwidget), a,
             (XtCallbackProc)  &UI_CompositeVObject::DeleteWindowCallback,
             (XtPointer) this);
    }
#endif
    if (!_visible)
        MakeInvisible();
}


#if defined (__X_MOTIF__)
void UI_CompositeVObject::DeleteWindowCallback
    (Widget w, void* client, void* call)
{
    UI_CompositeVObject* v = (UI_CompositeVObject*) client;
    v->_Controller->AddEvent (new UI_Event (Event_Finalize, v, v));
}
#endif




//
//------------------Composite Methods------------------------------
//

UI_VisualObject* UI_CompositeVObject::RemoveChild (UI_ViewID h)
{
    UI_VisualObject* view = (UI_VisualObject*) _objMap[h];
    if (view) {
        _objMap.Remove (h);
        short index = _tabSequence.LinearSearch (h);
        if (index >= 0)
            _tabSequence.Remove (index);
    }
    return view;
}



UI_VisualObject& UI_CompositeVObject::operator[] (UI_ViewID h)
{
    UI_VisualObject* o = (UI_VisualObject*)_objMap[h];
    if (!o) {
        CL_Error::Warning ("YACL: UI_Composite::op[]: invalid id %ld", h);
        return *this;
    }
    return *o;
}



bool UI_CompositeVObject::Contains(UI_ViewID id)
{
    if(_objMap.IncludesKey(id))
        return TRUE;
    return FALSE;
}



long UI_CompositeVObject::ChildCount ()
{
    return _objMap.Size();
}




bool UI_CompositeVObject::HandleChildEvent (UI_Event* e)
{
    if (e->Type() == Event_LButtonRelease) {
        short index = _tabSequence.LinearSearch (e->Origin()->ViewID());
        if (index >= 0)
            _currentChild = index;
    }
    return FALSE;
}

//
//---------------------Inherited Methods---------------------------
//


bool UI_CompositeVObject::HandleEvent (UI_Event* e)
{
    if (e->Destination() == this && e->Type() == Event_ChildCreated) {
     // A new child is now visible
        if (_currentChild == -1) {
	    // First time we're called after construction
	    short index = _tabSequence.LinearSearch (e->Origin()->ViewID());
	    if (index >= 0) {
                _currentChild = index;
#if defined(__MS_WINDOWS__)
                SetFocus (e->Origin()->ViewHandle());
#endif
            }
	 }
         return FALSE;
     }
     return ProcessEvent(e);
}






char* UI_CompositeVObject::MSWindowsName () const
{
    return _YACLWindowClassName;
}


#if defined (__X_MOTIF__)

struct _WidgetClassRec *UI_CompositeVObject::XName () const
{
    return xmBulletinBoardWidgetClass;
}

#endif


#if defined(__MS_WINDOWS__)

BOOL CALLBACK _export EnumCallback (HWND hwnd, LPARAM param)
{
    if (!hwnd)
        return FALSE;
    char buffer[30];
    if ((GetClassName (hwnd, buffer, 30)) == 0)
        return FALSE;
    ((UI_CompositeVObject*) param)->CreateResourceChild (hwnd, buffer);
    return TRUE;
}

#endif




bool UI_CompositeVObject::CreateResourceChild
    (UI_ViewHandle hndl, const CL_String& ctrl_name)
{
#if defined(__MS_WINDOWS__)

    long n;
    n = GetWindowTextLength (hndl);
    char* buf = "";
    CL_String mdl;   
    if (n) {
        buf = new char[n+1];
        GetWindowText (hndl,buf,n+1);
        mdl = buf;
        delete buf;
    }
  
    //Begin construction:

    UI_ViewID id = GetWindowWord (hndl, GWW_ID);
    CL_String name = ctrl_name.InLowerCase ();
    long ctrl_style = GetWindowLong (hndl, GWL_STYLE);
    if (ctrl_style & WS_TABSTOP)
        _tabSequence.Add (id);
    if (name == "button") {
        long style_bits = 0xff; // Depends on Windows 3.1!!
        long style = ctrl_style & style_bits;
        if (style == BS_GROUPBOX) {
            UI_ButtonGroup* v = new UI_ButtonGroup (this, id, hndl);
            _currentGroup = (ctrl_style & WS_GROUP) ? v : NULL;
            v->Title () = mdl; 
            initSimple (v);
        }
        else if (style == BS_AUTOCHECKBOX || style == BS_CHECKBOX) {
            UI_ToggleButton* v = new UI_ToggleButton (this, id, hndl);    
            v->Title () = mdl; 
            initSimple (v);
            if (_currentGroup) {
                if (_currentGroup->ClientArea().Includes
                    (v->ClientArea().Origin()))
                    _currentGroup->Add (v->ViewID());
                else
                    _currentGroup = NULL;
            }
        }
        else if (style == BS_AUTORADIOBUTTON || style == BS_RADIOBUTTON) {
            UI_ExOrToggleButton* v = new UI_ExOrToggleButton (this, id, hndl);
            v->Title() = mdl; 
            initSimple (v);
            if (_currentGroup) {
                if (_currentGroup->ClientArea().Includes
                    (v->ClientArea().Origin()))
                    _currentGroup->Add (v->ViewID());
                else
                    _currentGroup = NULL;
            }
        }
        else {
            // Must be a push button
            UI_PushButton *v;
            v = new UI_PushButton (this, id, hndl);
            v->Title() = mdl; 
            initSimple (v);
        } 
    }
    else if (name == "static") {
        UI_Label* v = new UI_Label (this, id, hndl);
        *((CL_String*) v->Model ()) = mdl; 
        initSimple (v);
    }
    else if (name == "edit") {
        UI_StringEditor *v;
        v = new UI_StringEditor (this, id, hndl);
        *((CL_String*) v->Model ()) = mdl; 
        initSimple (v);
    }
    else if (name == "listbox") {
        UI_StringView *v;
        v = new UI_StringView (this, id, hndl);    
        initSimple (v);
    }
#elif defined(__X_MOTIF__)
#endif
    return TRUE;
}


void UI_CompositeVObject::initSimple (UI_VisualObject* s)
{
    if (s) {
        ((UI_SimpleVObject*) s)->SetStyleParam();
        _Controller->Register (s, this);
        UI_ViewID id = s->ViewID();
        if (id > 0 && id <= 32767) {
            _objMap.Add (id, s);
            ((CL_IntPtrMap*) _model)->Add (id, s->Model());
        }
    }
}







bool UI_CompositeVObject::UseMenuBar  (UI_MenuBar* menu)
{
    _menuBar = menu;
    _Controller->DispatchPendingEvents ();

#if defined(__MS_WINDOWS__)
    UI_ViewHandle hmenu = menu ? menu->ViewHandle() : 0;
    SetMenu (_handle, hmenu);
    //    DrawMenuBar (_handle);
    return TRUE;

#endif
}

    

// Return the menu used by this composite. Return NULL if there is no
// associated menu.
UI_MenuBar* UI_CompositeVObject::MenuBar () const
{
    return _menuBar;
}



bool UI_CompositeVObject::TabHit (UI_Event& e)
{
    short n = _tabSequence.Size();
    if (n <= 0)
        return TRUE;
    short incr = (e._shiftKey) ? -1 : +1;
    _currentChild = (_currentChild + incr) % n;
    if (_currentChild < 0)
        _currentChild += n;
    UI_VisualObject* v = (UI_VisualObject*)
        _objMap[_tabSequence[_currentChild]];
#if defined (__MS_WINDOWS__)
    if (v)
        SetFocus (v->ViewHandle());
#endif
    return TRUE;
}



bool UI_CompositeVObject::GetFocus ()
{
    UI_VisualObject* v = NULL;
    register long n = _tabSequence.Size();
    if (n) {
        if (_currentChild == -1 || _currentChild >= n)
            _currentChild = 0;
        v = (UI_VisualObject*) _objMap[_tabSequence[_currentChild]];
    }
#if defined (__MS_WINDOWS__)
    if (v)
        SetFocus (v->ViewHandle());
#endif
    return FALSE;
}



void UI_CompositeVObject::AddChild (UI_VisualObject* child)
{
    // Called from child->UI_VisualObject::Initialize
    if (!child)
        return;
    UI_ViewID id = child->ViewID();
    if (id > 0 && _objMap.Add (id, child)) {
        CL_IntPtrMap& modelMap = *(CL_IntPtrMap*) _model;
        modelMap.Add (id, child->Model());
    }
}



bool UI_CompositeVObject::SetFont (UI_Font* font)
{
    if (!UI_VisualObject::SetFont (font))
        return FALSE;
    CL_IntPtrMapIterator itr (_objMap);
    CL_IntPtrAssoc assoc;
    for (itr.Reset (); itr.More (); ) {
        assoc = itr.Next();
        ((UI_VisualObject*) assoc.value)->SetFont(font);
    }
    return TRUE;
}











bool UI_CompositeVObject::_ShapeRectChanged (CL_Object& o, long v)
{
#if defined(__MS_WINDOWS__)
    return UI_VisualObject::_ShapeRectChanged (o, v);
#elif defined (__X_MOTIF__)
    if (!_xwidget || _stickToParent)
        return UI_VisualObject::_ShapeRectChanged (o, v);
    // Need to do this only for non-sticky children under X: they have a
    // dialog shell, and its shape must be changed, not that of the
    // Composite.
    Arg arg[4];
    short argn = 0;
    long x = _shape.Origin().XCoord();
    long y = _shape.Origin().YCoord();
    long w = _shape.Width();
    long h = _shape.Height();
    XtSetArg (arg [ argn ], XtNx,     x); argn++;
    XtSetArg (arg [ argn ], XtNy,     y); argn++;
    XtSetArg (arg [ argn ], XtNheight,h); argn++;
    XtSetArg (arg [ argn ], XtNwidth, w); argn++;
    XtSetValues (XtParent (_xwidget), arg, argn);
    return TRUE;
#endif
    
}


bool UI_CompositeVObject::_TitleChanged (CL_Object& o, long v)
{
#if defined(__MS_WINDOWS__)
    return UI_VisualObject::_TitleChanged (o, v);
#endif

#if defined(__X_MOTIF__)
    if (!_xwidget || _stickToParent)
        return UI_VisualObject::_TitleChanged (o, v);
    // Need to do this only for non-sticky children under X: they have a
    // dialog shell, and its title must be changed, not that of the
    // Composite.
    XtVaSetValues (XtParent (_xwidget), XmNtitle,
                   (char*) _title.AsPtr(), NULL);
    return TRUE;
#endif
}



UI_CompositeIterator::UI_CompositeIterator (UI_CompositeVObject& v)
{
    CL_IntegerTreeNode* node = UI_CompositeVObject::_Controller->ViewTree()
        ->Node ((long) v.ViewHandle());
    _index = 0;
    if (node)
        _seq = node->Children();
    else {
        CL_Error::Warning ("UI_CompositeIterator constructor: "
                           "uninitialized Composite");
        _seq.ChangeSize(0);
    }
}


void UI_CompositeIterator::Reset ()
{
    _index = 0;
}


UI_VisualObject* UI_CompositeIterator::Next ()
{
    if (_index < _seq.Size())
        return (UI_VisualObject*) _seq[_index++];
    return NULL;
}

