


#ifndef _canvas_h_ /* Fri Oct 28 11:54:57 1994 */
#define _canvas_h_


#include "ui/composit.h"

#include "defs.h"

class Canvas: public UI_CompositeVObject {

public:
    Canvas (UI_CompositeVObject* parent, UI_Rectangle shape);

    void SetCurrentShape (GR_ShapeEnum shape) {_shape = shape;};

    void SetFill (bool f) {_fill = f;};

    void SetMode (GR_EditMode m) {_mode = m;}
    
protected:
    void Initialize();
    void Finalize();
    bool ButtonDown (const UI_Point&, UI_MouseButton, bool, bool);
    bool MouseMove  (const UI_Point&);
    bool ButtonUp   (const UI_Point&, UI_MouseButton);

    bool DoubleClick   (const UI_Point&, UI_MouseButton);

    UI_Rectangle          _oldRect;
    bool                  _inDrag;
    UI_Point              _startPt;
    UI_Point              _origin;

    UI_GraphicObject*     _currentObj;
    
    GR_EditMode   _mode;
    GR_ShapeEnum  _shape;
    bool          _fill;
    
};

#endif /* _canvas_h_ */
