
#ifndef _button_h_
#define _button_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



// Authors:   M. A. Sridhar
//            N. Bhowmik


#include "ui/simple.h"



// A Button is an object that reflects a boolean state, and responds to
// mouse and keyboard events by changing that state. Specializations of
// the Button, i.e., the PushButton, ToggleButton and ExOrToggleButton,
// provide particular interpretations of the state change behavior.  The
// Button should be viewed as an abstract class and should not be
// instantiated.


class UI_Button: public UI_SimpleVObject {

public:
    char* MSWindowsName() const;

#if defined (__X_MOTIF__)
    struct _WidgetClassRec* XName () const;

#endif

    const char* ClassName() const {return "UI_Button";};

protected:
    
    UI_Button (UI_CompositeVObject* parent,  
               const UI_Rectangle& shape, UI_ViewID id = -1,
               long style = -1); 
    
    
    UI_Button (UI_CompositeVObject* parent, CL_Integer* model, 
               const UI_Rectangle& shape, UI_ViewID id = -1,
               long style = -1); 

    // For resource-based construction:
    UI_Button (UI_CompositeVObject* parent, UI_ViewID id,
               UI_ViewHandle handle);  

    
};


#endif 
