




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#include "ui/button.h"
#include "ui/cntroler.h"


#if defined(__MS_WINDOWS__)
#include <windows.h>

#elif defined(__X_MOTIF__)
#include <X11/Intrinsic.h>

#endif



//------------------------------------------------------
//                    -CLASS BUTTON-
//------------------------------------------------------

UI_Button::UI_Button (UI_CompositeVObject* parent, const UI_Rectangle& rec,
                      UI_ViewID id, long bstyle
                     )
: UI_SimpleVObject (parent,id,rec,bstyle)
{
}


UI_Button::UI_Button (UI_CompositeVObject* parent, UI_ViewID id,
                      UI_ViewHandle handle)
: UI_SimpleVObject (parent, id, handle)
{
}


UI_Button::UI_Button (UI_CompositeVObject* parent, CL_Integer* lbl,
                      const UI_Rectangle& rec, long id, long s)
: UI_SimpleVObject (parent, lbl, id, rec, s)
{
}


char* UI_Button::MSWindowsName () const
{
    return "button";
}


#if defined (__X_MOTIF__)

struct _WidgetClassRec* UI_Button::XName () const
{
    CL_Error::Warning ("Specific instance of %s needs to be constructed", 
                        ClassName ()
                      );
    return NULL;
}

#endif
