




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#include "ui/btngroup.h"
#include "ui/cntroler.h"
#include "ui/simple.h"

#if defined (__MS_WINDOWS__)
#include <windows.h>

#if defined(__BORLANDC__)
#define DEFAULT_STYLE BS_GROUPBOX | WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN
#else
#define DEFAULT_STYLE BS_GROUPBOX | WS_CHILD | WS_VISIBLE
#endif


#elif defined (__X_MOTIF__)
#include <Xm/RowColumn.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#endif

UI_ButtonGroup::UI_ButtonGroup
    (UI_CompositeVObject* parent, 
     const UI_Rectangle& r, UI_ViewDescriptor* vd, UI_ViewID id, long style
    )
: UI_CompositeVObject (parent,
#if defined(__MS_WINDOWS__)
                       NULL,
#else
                       vd,
#endif
                       TRUE, r, id, style)
{
#ifdef __MS_WINDOWS__
    if (style == -1)
        _style = DEFAULT_STYLE;
    // Unfortunately we have to hack this so that the buttons, which should be
    // children of the  ButtonGroup in the view tree, are  children
    // of the parent Composite in the case of the Windows platform. Otherwise
    // Windows doesn't like it.
    if (vd) {
        long x = r.Origin().XCoord();
        long y = r.Origin().YCoord();
        for (short i = 0; vd[i].type != View_None; i++) {
            UI_ViewDescriptor desc = vd[i];
            desc.shape.x += x;
            desc.shape.y += y;
            UI_VisualObject* p = parent->CreateChild (desc);
            if (i == 0 && p) // Another hack
                p->SetStyle (p->Style() | WS_GROUP);
            _buttons.Add (desc.id);
        }
    }
#endif
    _model = new CL_IntegerSet;
}



// For resource-based construction (only under MS-Windows):

UI_ButtonGroup::UI_ButtonGroup
    (UI_CompositeVObject* parent, UI_ViewID id, UI_ViewHandle h)
: UI_CompositeVObject (parent, (UI_ViewDescriptor*) NULL)
{
    _id = id;
#if defined(__MS_WINDOWS__)
    _handle = h;
#endif
    _model = new CL_IntegerSet;
}




// Return our model, which is really a CL_IntegerSet

CL_Object* UI_ButtonGroup::Model ()
{
    CL_IntegerSet* set = (CL_IntegerSet *) _model;

    set->MakeEmpty();
    CL_IntegerSetIterator itr (_buttons);

    for (itr.Reset(); itr.More(); ) {
        UI_ViewID id = itr.Next();
#if defined(__MS_WINDOWS__)
        // Again, another hack for Windows
        CL_Integer* data = (CL_Integer*)
            (((UI_SimpleVObject&) (*_parent) [id]).Model());
#else
        CL_Integer* data = (CL_Integer*)
            (((UI_SimpleVObject&) (*this) [id]).Model());
#endif
        if (data->Value())
            set->Add (id);
    }
    return _model;
}



// Add a new button id to the group. Returns TRUE if successful, FALSE
// if there was already a button with the given id in the group, or on
// memory allocation failure.

bool UI_ButtonGroup::Add (UI_ViewID id)
{
    return _buttons.Add (id);
}


// Remove a button from the group. Returns TRUE if successful, FALSE
// if either no such button was in the group, or memory allocation failed.

bool UI_ButtonGroup::Remove (UI_ViewID id)
{
    return _buttons.Remove (id);
}


UI_VisualObject& UI_ButtonGroup::operator[] (UI_ViewID id)
{
#if defined(__MS_WINDOWS__)
    // Under windows, the buttons are actually children of this object's
    // parent, so:
    return _parent->operator[] (id);
#else
    return UI_CompositeVObject::operator[] (id);
#endif
}


#if defined (__X_MOTIF__)
// The X-Widget corresponding to a group Box.

struct _WidgetClassRec* UI_ButtonGroup::XName ( ) const
{
     return xmRowColumnWidgetClass;
}

#endif



UI_ButtonGroup::~UI_ButtonGroup ()
{
    delete _model;
}



#if defined(__MS_WINDOWS__)
typedef  long FAR PASCAL _export (*WinProc) (HWND, unsigned, WORD,
                                                    LONG);
WinProc RealBtnGroupProc = (WinProc) 0;

long FAR PASCAL _export BtnGroupProc (HWND hwnd, unsigned msg,
                                      WORD wParam, LONG lp)
{
    if (msg != WM_ERASEBKGND)
        return (*RealBtnGroupProc) (hwnd, msg, wParam, lp);
    PAINTSTRUCT ps;
    HANDLE  hBrush = GetClassWord (hwnd, GCW_HBRBACKGROUND);
    if (!hBrush)
        hBrush = CreateSolidBrush (GetSysColor(COLOR_WINDOW));
    HDC hDC = BeginPaint (hwnd, (LPPAINTSTRUCT)&ps);
    FillRect (hDC, (LPRECT)&ps.rcPaint, hBrush);
    InvalidateRect (hwnd, (LPRECT)&ps.rcPaint, 0);
    EndPaint (hwnd, (LPPAINTSTRUCT)&ps);
    return 0;
}

#endif


bool UI_ButtonGroup::MakeVisualElement ()
{
#if defined(__MS_WINDOWS__)
    if (!UI_CompositeVObject::MakeVisualElement())
        return FALSE;
    // This hack is needed to ensure that group boxes get correctly
    // repainted under Windows:
    if (_parent->CreatedViaResource())
        return TRUE;
    RealBtnGroupProc = (WinProc) SetWindowLong (_handle, GWL_WNDPROC,
                                                (long) BtnGroupProc);
    return TRUE;
#elif defined(__X_MOTIF__)
    // GNU C seems to have a strange bug, so we work around it. Instead of
    // saying
    //    Widget pw = (Widget) (_parent->ViewHandle());
    // we say
    UI_VisualObject* p = _parent;
    Widget pw = (Widget) p->ViewHandle();

    // First, we'll create a Frame widget
    CL_String instance_name = InstanceName();
    CL_String frame_name    = instance_name  + "_frame";

    Arg arg [20];
    short argn = 0;
    _SetupStyle (arg, argn); // Set up the X resources
    XtSetArg (arg[argn ], XmNshadowType, XmSHADOW_ETCHED_OUT); argn++;
    _frameWidget = XtCreateWidget (frame_name.AsPtr(), xmFrameWidgetClass,
                                   pw, arg, argn);

    // Next, create a label child of the frame
    CL_String label_name = instance_name + "_label";
    argn = 0;
    XmString title = XmStringCreate
        ((char *) _title.AsPtr (), XmSTRING_DEFAULT_CHARSET);    
    XtSetArg (arg [argn], XmNlabelString, title); argn++;
    XtSetArg (arg [argn], XmNchildType, XmFRAME_TITLE_CHILD); argn++;
    _frameLabel = XtCreateWidget
        (label_name.AsPtr(), xmLabelWidgetClass, _frameWidget, arg, argn);

    // Finally, create the row-column widget
    const char* inst_name = instance_name.AsPtr();
    struct _WidgetClassRec *class_name = XName ( );
//    _xwidget = XtVaCreateWidget (inst_name, class_name, _frameWidget,
//                                  XmNpacking, XmPACK_NONE, NULL);
    _xwidget = XtCreateWidget (inst_name, class_name, _frameWidget, NULL, 0);
    // Don't need to realize _xwidget -- it's done by the Controller.
    
    // Clean up
    XtRealizeWidget (_frameWidget);
    XmStringFree (title);
    _Controller->AddEvent (new UI_Event (Event_ChildCreated, this, _parent));

    return TRUE;
#endif
}


void UI_ButtonGroup::Initialize ()
{
    UI_CompositeVObject::Initialize ();
#if defined(__X_MOTIF__)
    if (_visible) {
        XtManageChild (_frameWidget);
        XtManageChild (_frameLabel);
    }
#endif
}


void UI_ButtonGroup::MakeInvisible ()
{
    UI_CompositeVObject::MakeInvisible ();
#if defined(__X_MOTIF__)
    if (_frameWidget)   // We've been created
        XtUnmanageChild (_frameWidget);
#endif
}


void UI_ButtonGroup::MakeVisible ()
{
    UI_CompositeVObject::MakeVisible ();
#if defined(__X_MOTIF__)
    if (_frameWidget) {   // We've been created
        XtManageChild (_frameWidget);
        XtManageChild (_frameLabel);
    }
#endif
}


bool UI_ButtonGroup::Paint ()
{
#ifdef __MS_WINDOWS__
//     RECT rect;
//     rect.top    = _shape.Origin().YCoord();
//     rect.left   = _shape.Origin().XCoord();
//     rect.right  = _shape.Width () + rect.left;
//     rect.bottom = _shape.Height() + rect.top;
// 
//     /* if (GetUpdateRect (_handle, &rect, FALSE)) */ {
//         HBRUSH hBrush = CreateSolidBrush (GetSysColor (COLOR_WINDOW));
//         HDC hDC = GetDC (_handle);
//         FillRect (hDC, &rect, hBrush);
//         ReleaseDC (_handle, hDC);
//         DeleteObject (hBrush);
//     }
#endif
    return TRUE;
}

void UI_ButtonGroup::Finalize ()
{
#if defined(__MS_WINDOWS__)
        // Again, another hack for Windows
    CL_IntegerSetIterator itr (_buttons);
    for (itr.Reset(); itr.More(); ) {
        UI_ViewID id = itr.Next();
        _parent->RemoveChild (id);
    }
#endif
    UI_CompositeVObject::Finalize ();
}

char* UI_ButtonGroup::MSWindowsName() const
{
#if defined(__BORLANDC__)
    // return "BorShade";
    return "button";
#else
    return "button";
#endif
}
