#ifndef _brush_h_
#define _brush_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



// Authors: M. A. Sridhar
//          N. Bhowmik


#include "ui/dsplrsrc.h"
#include "ui/color.h"


// A Brush is an object used to draw patterns and colors on a
// DisplaySurface. This object only maintains attributes of the brush; the
// actual drawing is done by the DisplaySurface object.





enum UI_BrushPattern   {
    UIBrush_Hatched, UIBrush_Hollow, UIBrush_Solid
};



class UI_Brush: public UI_DisplayResource {

public:
    UI_Brush (UI_DisplaySurface* ctxt, UI_Color color,
              UI_BrushPattern pattern);
    // Construct a brush with given color and pattern, for the given
    // display surface.

    UI_Brush (const UI_Brush&);
    // Copy constructor.

    ~UI_Brush ();
    // Destructor.

    void Pattern (UI_BrushPattern p);
    // Set the brush pattern.

    UI_BrushPattern Pattern ();
    // Return the brush pattern.

    const char* ClassName() const {return "UI_Brush";};
    // Override the inherited {\small\tt CL_Object}'s method.

protected:

    UI_Color          _color;
    UI_BrushPattern   _pattern;

    void              _Setup();

};

#endif

