

#include "ui/ui.h"
#include "box.h"
#include "ids.h"




static char* cities[] = {
    "Chicago",
    "Bombay",
    "New York",
    "Binghamton",
    "Los Angeles",
    "Copenhagen",
    "Amsterdam",
    "Berlin",
    "London",
    "Bangalore",
    "Beijing",
    "Columbia",
    "Atlanta",
    0
};


Box::Box (UI_CompositeVObject* parent, const UI_Rectangle& shape)
: UI_CompositeVObject (parent, NULL, TRUE, shape,  -1)
{
    UI_Label* msg = new UI_Label (this, UI_Rectangle (10, 10, 350, 20));
    msg->Font().PointSize (9);
    msg->Font().TypeFace ("MS Sans Serif");
    *(msg->Model()) = CL_String ("Two StringView objects "
                                 "with the same model:");
    
    strseq = new UI_StringSequence;
    for (short i = 0; cities[i] != 0; i++)
        strseq->Add (cities[i]);

    UI_StringView* v1 = new UI_StringView
        (this, strseq, UI_Rectangle (40,  50, 150, 175),
         FALSE, ID_SINGLE_VIEW);
    UI_StringView* v2 = new UI_StringView
        (this, strseq, UI_Rectangle (200, 50, 150, 175),
         TRUE,  ID_MULT_VIEW);
    UI_Font& font1 (v1->Font());
    font1.TypeFace ("MS Sans Serif");
    font1.BoldFace (TRUE);
    font1.PointSize (9);

    UI_Font& font2 (v2->Font());
    font2.TypeFace ("MS Sans Serif");
    font2.BoldFace (TRUE);
    font2.PointSize (9);
}


Box::~Box()
{
    delete strseq;
}


bool Box::HandleChildEvent(UI_Event* e)
{
    if(e->Origin()->ViewID() == ID_SINGLE_VIEW && e->Type() == Event_Select) {
        CL_IntegerSet* indx = (CL_IntegerSet*)
            ((UI_StringView*) e->Origin())->Selection();
        if (indx->Includes(2)) {
           UI_StringSequence *str = (UI_StringSequence*)
               ((UI_StringView*) e->Origin())->Model();
           str->Remove (2);
        }
        else if (indx->Size() > 0) {
            long l = indx->ItemWithRank (0);
            if ((*strseq)[l] == "Copenhagen")
                strseq->Insert ("Click here", l);
            else if ((*strseq)[l] == "Click here")
                (*strseq)[l] = "Don't click";
            else if ((*strseq)[l] == "Don't click")
                (*strseq)[l] = "Click here";
        }
	return TRUE;   
    }
    return FALSE;
}

