

#ifndef _bitmap_h_ /* Wed Mar 23 12:51:01 1994 */
#define _bitmap_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



// Author: M. A. Sridhar


#include "ui/dsplsurf.h"
#include "ui/graphic.h"

// This class is just the beginning of an encapsulation of bitmaps. It is
// nowhere near complete. IT IS NOT YET SUPPORTED UNDER X/MOTIF.

class UI_BitMap: public UI_GraphicObject {

public:

    UI_BitMap ();
    
    UI_BitMap (const char* name);
    
    ~UI_BitMap ();
    
    long BitsPerPixel () const;

    long Height () const;

    long Width  () const;

    UI_Rectangle Shape () const;
    // Return the shape of the bitmap as a rectangle. The origin of the
    // returned rectangle will be (0,0).

    UI_Rectangle BoundingRectangle() const {return Shape();};
    
    bool OnBoundary (const UI_Point& p) const {return Shape().OnBoundary(p);};

    bool Includes (const UI_Point& p) const {return Shape().Includes (p);};

    // UI_Color& operator[] (short i, short j);

    bool DrawOn   (UI_DrawingSurface& s,
                   const UI_Point& p = UI_Point (0, 0)) const;

    void CopyFrom (UI_DisplaySurface& s, const UI_Rectangle& r);
    // Does not yet work correctly under Windows.


protected:
    long _width;
    long _height;
    long _bitsPerPixel;
    
#if defined(__MS_WINDOWS__)
    UI_ViewHandle _handle;
#endif
};





inline long UI_BitMap::BitsPerPixel () const
{
    return _bitsPerPixel;
}

inline long UI_BitMap::Height () const
{
    return _height;
}

inline long UI_BitMap::Width  () const
{
    return _width;
}



inline UI_Rectangle UI_BitMap::Shape () const
{
    return UI_Rectangle (0, 0, _width, _height);
}




#endif /* _bitmap_h_ */
