/*=========================================================================*/
/*  iolib.c   -- library of i/o functions for use from Turbo C             */
/*=========================================================================*/
/* function prototypes */

char *strdel(char st[],int start,int count);/* delete substring from string */
int nonblank (char *st);                    /* return true if st not blank */
void stub(void);                            /* make sound to signify stub */
void binit(int buff);                       /* initialize video buffers */
void savescreen(int i);                     /* save screen to buff i */
void restorescreen(int i);                  /* restore screen from buff i */
void copyscreen(int i,int j);               /* copy buff i to buff j */
void bclear(int b);                         /* clear buff b */
void bwrite(int b,int x,int y,char st[]);   /* write st to buff b at x,y */
void border(int color);                     /* set border color */
void pad(char st[],int len);                /* pad a string to length len */
void trim(char st[]);                       /* trim off trailing blanks */
void lcase(char st[]);                      /* convert string to l.case */
int getstring(int x,int y,int *c,           /* wordStar-like string input */
   char st[],int len);                      /*    routine */
int getint(int x,int y,int *i,int w);       /* integer input routine */
int getachar(int x,int y,char *ch);         /* char input routine */

/* iolib definitions and declarations */
#define TRUE  1
#define FALSE 0

typedef unsigned char vscreen[4000];
typedef vscreen  *vptr;

extern vptr     sbuff[5];           /* screen buffers */
extern char     monochrome;         /* mono flag */
extern char     insert;             /* insert/overwrite flag */
extern int      insertx,inserty;    /* location of insert/overwrite message */
extern int      colx,coly;          /* location of column info, if present */
extern int      trimblanks;         /* make true for getstring to trim blanks */
extern int      colons;             /* make true for getstring to use colons */
extern int      nobeep;             /* make true to suppress end-field beep */
extern int      bfore,bback;        /* buffer foreground, background colors */
extern char     initialized;        /* buffer initialization flag */
